/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.controller;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.editors.graphical.AbstractGraphicalEditor;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphEngineReferenceModel;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorActionController;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorArb;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorGraphComponent;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorModelMxEventListener;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorMouseHandler;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorMxGraph;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorMxKeyboardHandler;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorObjectActionListener;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorReadOnlyModeActionController;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorSelectionMxEventListener;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineAction;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModelObserver;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineUtils;
import oracle.dbtools.util.credential.GraphicalEditorControllerInterface;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;

public class GraphicalEditorController
implements GraphicalEditorControllerInterface {
    public static final String NODE = "Context.NODE";
    public static final String GE_TYPE = "GraphicalEditorController.type";
    public static final String GE_ADDED = "GraphicalEditorController.added";
    public static final String GE_DELETED = "GraphicalEditorController.deleted";
    public static final Float GRAPHICAL_EDITOR_MENU_SECTION_ID = Float.valueOf(11.0f);
    public static final Float GRAPHICAL_EDITOR_TOOLBAR_SECTION_ID = Float.valueOf(10.0f);
    GraphicalEditorObjectActionListener graphicalEditorObjectActionListener = new GraphicalEditorObjectActionListener(this);
    GraphicalEditorReadOnlyModeActionController readOnlyModeActionController = new GraphicalEditorReadOnlyModeActionController();
    Map<GraphEngineAction, IdeAction> actionIdeActionMap = new HashMap<GraphEngineAction, IdeAction>();
    static IDEContextMenuListener contextMenuListener = new IDEContextMenuListener();
    private mxGraph jGraphXModel;
    private mxGraphComponent jGraphXComponent;
    private mxIGraphLayout jGraphXLayout;
    private mxEventSource.mxIEventListener jGraphModelXListener = new GraphicalEditorModelMxEventListener(this);
    private mxEventSource.mxIEventListener jGraphSelectionXListener = new GraphicalEditorSelectionMxEventListener(this);
    private GraphEngineModel graphEngineModel;
    private GraphEngineReferenceModel graphEngineReferenceModel = new GraphEngineReferenceModel();
    private GraphEngineModelObserver graphEngineObserver = new GraphEngineObserver();
    private GraphicalEditorMouseHandler graphicalEditorMouseHandler = new GraphicalEditorMouseHandler(this);
    private List<GraphEngineObject> graphEngineSelection = new Vector<GraphEngineObject>();
    private List<Object> jGraphXSelection = new Vector<Object>();
    private AbstractGraphicalEditor editor;
    private DBObject rootDBObject;
    private boolean panning = false;
    private boolean readOnly = true;
    private boolean autoLayout = true;
    private MouseEvent lastPopupEvent = null;
    private MnemonicSolver mnemonicSolver = new MnemonicSolver();

    public GraphicalEditorController(AbstractGraphicalEditor abstractGraphicalEditor) {
        this.editor = abstractGraphicalEditor;
        if (abstractGraphicalEditor.getContext() != null && abstractGraphicalEditor.getContext().getNode() != null) {
            Node node = abstractGraphicalEditor.getContext().getNode();
            this.rootDBObject = node instanceof IViewerNode ? ((IViewerNode)node).getDBObject() : new DBObject((Element)abstractGraphicalEditor.getContext().getNode());
            abstractGraphicalEditor.getContext().setProperty("ObjectAction.DBOBJECT", (Object)this.rootDBObject);
        }
        mxConstants.DEFAULT_HOTSPOT = 0.5;
        mxConstants.MIN_HOTSPOT_SIZE = 16;
        this.jGraphXModel = new GraphicalEditorMxGraph(this);
        this.jGraphXComponent = new GraphicalEditorGraphComponent(this, this.jGraphXModel);
        new GraphicalEditorMxKeyboardHandler(this, this.jGraphXComponent);
        this.jGraphXComponent.setCenterZoom(true);
        this.jGraphXModel.addListener(null, this.jGraphModelXListener);
        this.jGraphXModel.getSelectionModel().addListener(null, this.jGraphSelectionXListener);
        this.jGraphXComponent.getGraphControl().addMouseListener((MouseListener)this.graphicalEditorMouseHandler);
        this.jGraphXComponent.addMouseWheelListener((MouseWheelListener)this.graphicalEditorMouseHandler);
        this.jGraphXLayout = new mxHierarchicalLayout(this.jGraphXModel);
        ObjectActionController.addListener((IObjectActionListener)this.graphicalEditorObjectActionListener);
    }

    public void close() {
        this.jGraphXModel.removeListener(this.jGraphModelXListener);
        this.jGraphXModel.getSelectionModel().removeListener(this.jGraphSelectionXListener);
        this.jGraphXComponent.getGraphControl().removeMouseListener((MouseListener)this.graphicalEditorMouseHandler);
        this.jGraphXComponent.removeMouseWheelListener((MouseWheelListener)this.graphicalEditorMouseHandler);
        ObjectActionController.removeListener((IObjectActionListener)this.graphicalEditorObjectActionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(GraphEngineModel graphEngineModel) {
        if (this.graphEngineModel != null) {
            this.graphEngineModel.removeObserver(this.graphEngineObserver);
            this.graphEngineModel = null;
        }
        this.jGraphXModel.removeListener(this.jGraphModelXListener);
        try {
            this.jGraphXModel.removeCells(this.jGraphXModel.getChildCells(this.jGraphXModel.getDefaultParent()));
            this.graphEngineReferenceModel.clear();
            this.jGraphXComponent.putClientProperty((Object)"ToolTipText", null);
            this.jGraphXComponent.getGraphControl().putClientProperty((Object)"ToolTipText", null);
        }
        finally {
            this.jGraphXModel.addListener(null, this.jGraphModelXListener);
        }
        this.graphEngineModel = graphEngineModel;
        if (this.graphEngineModel != null) {
            this.graphEngineReferenceModel.associate(this.jGraphXModel.getDefaultParent(), graphEngineModel.getGraph());
            this.loadModel(graphEngineModel.getGraph());
            graphEngineModel.addObserver(this.graphEngineObserver);
            this.jGraphXComponent.putClientProperty((Object)"ToolTipText", (Object)graphEngineModel.getDefinitions().getRootDefinition().getToolTip());
            this.jGraphXComponent.getGraphControl().putClientProperty((Object)"ToolTipText", (Object)graphEngineModel.getDefinitions().getRootDefinition().getToolTip());
        }
    }

    public GraphEngineModel getModel() {
        return this.graphEngineModel;
    }

    public boolean importElement(Element element, Object object, Point2D point2D) {
        List<GraphEngineObject> list;
        Point2D.Double double_;
        GraphEngineObject graphEngineObject = null;
        boolean bl = true;
        element = this.getDatabaseNode(element);
        if (object != null) {
            graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
        }
        List<GraphEngineObject> list2 = null;
        if (graphEngineObject != null) {
            if (this.isReadOnly()) {
                return false;
            }
            if (graphEngineObject.getType().getExternalDropAction() == null) {
                Point2D.Double double_2 = double_ = point2D == null ? new Point2D.Double(64.0, 64.0) : new Point2D.Double(point2D.getX() + 64.0, point2D.getY() + 64.0);
                while (this.getJGraphXComponent().getCellAt((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY()) != null) {
                    ((Point2D)double_).setLocation(((Point2D)double_).getX() + 32.0, ((Point2D)double_).getY() + 32.0);
                }
                list2 = this.graphEngineModel.importElement(element, double_);
                if (list2 != null && list2.size() > 0) {
                    bl = this.graphEngineModel.drop(graphEngineObject, list2.toArray(new GraphEngineObject[list2.size()]));
                }
            }
        } else {
            Point2D.Double double_3 = double_ = point2D == null ? new Point2D.Double(16.0, 128.0) : new Point2D.Double(point2D.getX(), point2D.getY());
            while (this.getJGraphXComponent().getCellAt((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY()) != null) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX() + 32.0, ((Point2D)double_).getY() + 32.0);
            }
            list2 = this.graphEngineModel.importElement(element, double_);
        }
        double_ = element;
        if (list2.size() > 0) {
            double_ = this.getDatabaseNode((GraphEngineObject)list2.get(0));
        }
        if ((list = this.graphEngineReferenceModel.getReferencedLocals((Element)double_)) == null) {
            List<GraphEngineObject> list3 = this.graphEngineReferenceModel.add((Element)double_, list2);
        }
        return list2 != null && list2.size() > 0 && bl;
    }

    public boolean addNode(String string, String string2) {
        boolean bl = false;
        String string3 = this.rootDBObject.getConnectionName();
        if (string != null && string2 != null) {
            String string4 = null;
            if (string2 != null) {
                Point2D point2D;
                if (string2.contains(".")) {
                    string4 = string2.substring(0, string2.indexOf(46));
                    string2 = string2.substring(string2.indexOf(46) + 1);
                } else {
                    string4 = this.rootDBObject.getSchemaName();
                }
                URL uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string3, null, (String)string4, (String)string), (String)string2);
                DatabaseNode databaseNode = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                if (databaseNode == null) {
                    uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string3, null, (String)string4, (String)string), (String)string2);
                    databaseNode = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                }
                Point2D point2D2 = point2D = this.lastPopupEvent == null ? new Point2D.Double(10.0, 10.0) : this.lastPopupEvent.getPoint();
                if (databaseNode != null) {
                    bl = this.importElement((Element)databaseNode, null, point2D);
                }
            }
        }
        if (this.isAutoLayout()) {
            this.layout();
        }
        return bl;
    }

    public boolean importContextNode(Context context, Object object, Point2D point2D) {
        boolean bl = true;
        point2D = point2D != null ? new Point2D.Double(point2D.getX(), point2D.getY()) : new Point2D.Double(10.0, 10.0);
        if (context.containsProperty(NODE)) {
            Node node = (Node)context.getProperty(NODE);
            node = this.getDatabaseNode((Element)node);
            bl &= this.importElement((Element)node, object, point2D);
            this.graphEngineReferenceModel.setEditorElement((Element)node);
        }
        if (this.isAutoLayout()) {
            this.layout();
        }
        return bl;
    }

    public boolean importContextSelection(Context context, Object object, Point2D point2D) {
        Element[] elementArray;
        boolean bl = true;
        point2D = point2D != null ? new Point2D.Double(point2D.getX(), point2D.getY()) : new Point2D.Double(10.0, 10.0);
        for (Element element : elementArray = context.getSelection()) {
            String string = this.getElementType(element);
            GraphEngineNodeType graphEngineNodeType = this.graphEngineModel.getDefinitions().getNodeDefinitions().get(string);
            if (graphEngineNodeType == null || !graphEngineNodeType.isAllowDrop()) continue;
            bl &= this.importElement(element, object, point2D);
            if (point2D == null) continue;
            point2D.setLocation(point2D.getX() + 32.0, point2D.getY() + 32.0);
        }
        if (this.isAutoLayout()) {
            this.layout();
        }
        return bl;
    }

    public mxGraph getJGraphXModel() {
        return this.jGraphXModel;
    }

    public mxGraphComponent getJGraphXComponent() {
        return this.jGraphXComponent;
    }

    public String isValidEdge(Object object, Object object2, Object object3) {
        GraphEngineObject graphEngineObject;
        GraphEngineEdge graphEngineEdge = null;
        GraphEngineNode graphEngineNode = null;
        GraphEngineNode graphEngineNode2 = null;
        if (this.isReadOnly()) {
            return "";
        }
        if (object != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object)) instanceof GraphEngineEdge) {
            graphEngineEdge = (GraphEngineEdge)graphEngineObject;
        }
        if (object2 != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object2)) instanceof GraphEngineNode) {
            graphEngineNode = (GraphEngineNode)graphEngineObject;
        }
        if (object3 != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object3)) instanceof GraphEngineNode) {
            graphEngineNode2 = (GraphEngineNode)graphEngineObject;
        }
        if (graphEngineNode != null && graphEngineNode2 != null) {
            if (graphEngineEdge != null) {
                return this.graphEngineModel.canMoveEdge(graphEngineEdge, graphEngineNode, graphEngineNode2);
            }
            return this.graphEngineModel.canCreateEdge(graphEngineNode, graphEngineNode2);
        }
        return "";
    }

    public String moveEdge(Object object, Object object2, Object object3) {
        try {
            GraphEngineObject graphEngineObject;
            GraphEngineEdge graphEngineEdge = null;
            GraphEngineNode graphEngineNode = null;
            GraphEngineNode graphEngineNode2 = null;
            if (object != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object)) instanceof GraphEngineEdge) {
                graphEngineEdge = (GraphEngineEdge)graphEngineObject;
            }
            if (object2 != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object2)) instanceof GraphEngineNode) {
                graphEngineNode = (GraphEngineNode)graphEngineObject;
            }
            if (object3 != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object3)) instanceof GraphEngineNode) {
                graphEngineNode2 = (GraphEngineNode)graphEngineObject;
            }
            if (graphEngineNode != null && graphEngineNode2 != null) {
                this.graphEngineModel.moveEdge(graphEngineEdge, graphEngineNode, graphEngineNode2);
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public void createEdge(Object object, Object object2, MouseEvent mouseEvent) {
        block12: {
            try {
                GraphEngineObject graphEngineObject;
                GraphEngineNode graphEngineNode = null;
                GraphEngineNode graphEngineNode2 = null;
                if (object != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object)) instanceof GraphEngineNode) {
                    graphEngineNode = (GraphEngineNode)graphEngineObject;
                }
                if (object2 != null && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object2)) instanceof GraphEngineNode) {
                    graphEngineNode2 = (GraphEngineNode)graphEngineObject;
                }
                if (this.isReadOnly() || this.graphEngineModel.canCreateEdge(graphEngineNode, graphEngineNode2) != null) break block12;
                List<GraphEngineEdgeType> list = this.graphEngineModel.getEdgeTypes(graphEngineNode, graphEngineNode2);
                GraphEngineEdgeType graphEngineEdgeType = null;
                if (list == null) break block12;
                switch (list.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        graphEngineEdgeType = list.get(0);
                        break;
                    }
                    default: {
                        final HashMap<String, GraphEngineEdgeType> hashMap = new HashMap<String, GraphEngineEdgeType>();
                        final GraphEngineNode graphEngineNode3 = graphEngineNode;
                        final GraphEngineNode graphEngineNode4 = graphEngineNode2;
                        ResourceBundle resourceBundle = this.graphEngineModel.getResourceBundle();
                        JMenu jMenu = new JMenu();
                        for (int i = 0; i < list.size(); ++i) {
                            String string;
                            GraphEngineEdgeType graphEngineEdgeType2 = list.get(i);
                            String string2 = string = graphEngineEdgeType2.getTypeId();
                            try {
                                string2 = resourceBundle.getString(string + "_CREATE_EDGE");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            hashMap.put(string2, graphEngineEdgeType2);
                            AbstractAction abstractAction = new AbstractAction(string2){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    System.out.println("Create Edge " + actionEvent.getActionCommand());
                                    GraphEngineEdgeType graphEngineEdgeType = (GraphEngineEdgeType)hashMap.get(actionEvent.getActionCommand());
                                    if (graphEngineEdgeType != null) {
                                        GraphicalEditorController.this.graphEngineModel.createEdge(graphEngineEdgeType, graphEngineNode3, graphEngineNode4);
                                    }
                                }
                            };
                            jMenu.add(abstractAction);
                        }
                        jMenu.getPopupMenu().show((Component)this.jGraphXComponent, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
                if (graphEngineEdgeType != null) {
                    this.graphEngineModel.createEdge(graphEngineEdgeType, graphEngineNode, graphEngineNode2);
                }
            }
            catch (Exception exception) {
                mouseEvent.getSource();
            }
        }
    }

    private void loadModel(GraphEngineGraph graphEngineGraph) {
        for (GraphEngineNode graphEngineObject : graphEngineGraph.getNodes()) {
            this.addNodeToJGraphX(graphEngineObject);
        }
        for (GraphEngineEdge graphEngineEdge : graphEngineGraph.getEdges()) {
            this.addEdgeToJGraphX(graphEngineEdge);
        }
    }

    private void addNodeToJGraphX(GraphEngineNode graphEngineNode) {
        GraphEngineNodeType graphEngineNodeType = graphEngineNode.getType();
        Point2D point2D = graphEngineNode.getLocation();
        Object object = this.jGraphXModel.getDefaultParent();
        if (graphEngineNode.getParent() != null) {
            object = this.graphEngineReferenceModel.getLocalToJGraphXMap(graphEngineNode.getParent());
        }
        if (point2D == null) {
            point2D = this.lastPopupEvent != null ? this.lastPopupEvent.getPoint() : new Point2D.Double(64.0, 64.0);
        }
        if (graphEngineNodeType != null) {
            Object object2 = this.jGraphXModel.insertVertex(object, graphEngineNode.getId(), (Object)graphEngineNode.getLabel(), point2D.getX(), point2D.getY(), graphEngineNodeType.getSize().getWidth(), graphEngineNodeType.getSize().getHeight(), graphEngineNodeType.getStyle());
            this.graphEngineReferenceModel.associate(object2, graphEngineNode);
        }
    }

    private void removeNodeFromJGraphX(GraphEngineNode graphEngineNode) {
        Object[] objectArray;
        Object object = this.graphEngineReferenceModel.getLocalToJGraphXMap(graphEngineNode);
        if (object != null && (objectArray = this.jGraphXModel.removeCells(new Object[]{object})) != null) {
            for (Object object2 : objectArray) {
                this.graphEngineReferenceModel.removeAssociation(object2);
            }
        }
    }

    private void addEdgeToJGraphX(GraphEngineEdge graphEngineEdge) {
        GraphEngineEdgeType graphEngineEdgeType = graphEngineEdge.getType();
        Object object = this.jGraphXModel.getDefaultParent();
        Object object2 = this.graphEngineReferenceModel.getLocalToJGraphXMap(graphEngineEdge.getSource());
        Object object3 = this.graphEngineReferenceModel.getLocalToJGraphXMap(graphEngineEdge.getTarget());
        if (graphEngineEdge.getParent() != null) {
            object = this.graphEngineReferenceModel.getLocalToJGraphXMap(graphEngineEdge.getParent());
        }
        if (graphEngineEdgeType != null && object != null && object2 != null && object3 != null) {
            Object object4 = this.jGraphXModel.insertEdge(object, graphEngineEdge.getId(), (Object)graphEngineEdge.getLabel(), object2, object3, graphEngineEdge.getStyle() != null ? graphEngineEdge.getStyle() : graphEngineEdgeType.getStyle());
            this.graphEngineReferenceModel.associate(object4, graphEngineEdge);
        }
    }

    private void removeEdgeFromJGraphX(GraphEngineEdge graphEngineEdge) {
        Object[] objectArray;
        Object object = this.graphEngineReferenceModel.getLocalToJGraphXMap(graphEngineEdge);
        if (object != null && (objectArray = this.jGraphXModel.removeCells(new Object[]{object})) != null) {
            for (Object object2 : objectArray) {
                this.graphEngineReferenceModel.removeAssociation(object2);
            }
        }
    }

    public void moved(Object object, Point2D point2D) {
        GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
        if (graphEngineObject != null) {
            graphEngineObject.setLocation(point2D);
        }
    }

    public void jGraphXObjectRemoved(Object object) {
        GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
        if (graphEngineObject != null) {
            if (graphEngineObject instanceof GraphEngineNode) {
                this.graphEngineModel.getGraph().remove((GraphEngineNode)graphEngineObject);
            } else if (graphEngineObject instanceof GraphEngineEdge) {
                this.graphEngineModel.getGraph().remove((GraphEngineEdge)graphEngineObject);
            }
            this.graphEngineReferenceModel.removeAssociation(graphEngineObject);
        }
    }

    public void ideObjectRemoved(Element element) {
        List<GraphEngineObject> list = this.graphEngineReferenceModel.remove(element);
        if (list != null) {
            for (GraphEngineObject graphEngineObject : list) {
                if (graphEngineObject instanceof GraphEngineGraph) continue;
                if (graphEngineObject instanceof GraphEngineNode) {
                    this.graphEngineModel.getGraph().remove((GraphEngineNode)graphEngineObject);
                    continue;
                }
                if (!(graphEngineObject instanceof GraphEngineEdge)) continue;
                this.graphEngineModel.getGraph().remove((GraphEngineEdge)graphEngineObject);
            }
        }
    }

    public void ideObjectReload(Element element) {
        Point2D point2D = null;
        if (element != null) {
            List<GraphEngineObject> list = this.getModel().isClearAllOnReload() ? new ArrayList<GraphEngineObject>(this.graphEngineReferenceModel.getLocals()) : this.graphEngineReferenceModel.remove(element);
            if (list != null) {
                for (GraphEngineObject graphEngineObject : list) {
                    if (!(graphEngineObject instanceof GraphEngineEdge)) continue;
                    this.graphEngineModel.getGraph().remove((GraphEngineEdge)graphEngineObject);
                }
                for (GraphEngineObject graphEngineObject : list) {
                    if (!(graphEngineObject instanceof GraphEngineNode)) continue;
                    if (point2D == null) {
                        point2D = graphEngineObject.getLocation();
                    }
                    this.graphEngineModel.getGraph().remove((GraphEngineNode)graphEngineObject);
                }
            }
            Object object = null;
            object = this.getModel().isEditor() ? this.graphEngineReferenceModel.getEditorElement() : element;
            if (object != null) {
                this.graphEngineReferenceModel.remove((Element)object);
                this.importElement(element, null, point2D);
            }
            if (this.isAutoLayout()) {
                this.layout();
            }
        }
    }

    public void ideObjectReloadParent(Element element) {
        List<Object> list = null;
        if (this.getModel().isEditor()) {
            list = new Vector();
            list.add(this.graphEngineReferenceModel.getEditorElement());
        } else {
            list = this.graphEngineReferenceModel.getElements();
        }
        for (Element element2 : list) {
            this.ideObjectReload(element2);
        }
    }

    void selectionChanged(List<Object> list, List<Object> list2) {
        if (list2 != null) {
            for (Object object : list2) {
                int n;
                if (object == null || (n = this.jGraphXSelection.indexOf(object)) < 0) continue;
                this.jGraphXSelection.remove(n);
                this.graphEngineSelection.remove(n);
            }
        }
        if (list != null) {
            for (Object e : list) {
                if (e == null) continue;
                GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(e);
                this.jGraphXSelection.add(e);
                this.graphEngineSelection.add(graphEngineObject);
            }
        }
        Vector vector = new Vector();
        for (GraphEngineObject graphEngineObject : this.graphEngineSelection) {
            Element element;
            if (graphEngineObject == null || (element = this.getDatabaseNode(graphEngineObject)) == null || vector.contains(element)) continue;
            vector.add(element);
        }
        this.editor.getToolbar();
        this.editor.scheduleUpdateSelection();
    }

    public Element getDatabaseNode(GraphEngineObject graphEngineObject) {
        Element element = graphEngineObject.getElement();
        if (!(graphEngineObject == null || element != null && element instanceof DatabaseNode)) {
            String string = this.rootDBObject.getSchemaName();
            String string2 = graphEngineObject.getId();
            if (string2.contains(".")) {
                string = string2.substring(0, string2.indexOf(46));
                string2 = string2.substring(string2.indexOf(46) + 1);
            }
            if ((element = XMLGraphEngineUtils.getDatabaseNode(this.rootDBObject.getConnectionName(), graphEngineObject.getType().getTypeId(), string, string2)) != null) {
                graphEngineObject.setElement(element);
            }
        }
        return element;
    }

    public Element getDatabaseNode(Element element) {
        if (element != null && element instanceof IViewerNode) {
            IViewerNode iViewerNode = (IViewerNode)element;
            DBObject dBObject = iViewerNode.getDBObject();
            String string = dBObject.getConnectionName();
            String string2 = dBObject.getSchemaName();
            String string3 = dBObject.getObjectName();
            String string4 = dBObject.getObjectType();
            DatabaseNode databaseNode = XMLGraphEngineUtils.getDatabaseNode(string, string4, string2, string3);
            if (databaseNode != null) {
                element = databaseNode;
            } else {
                Element element2 = dBObject.getElement();
                if (element2 != null) {
                    element = element2;
                }
            }
        }
        return element;
    }

    public String getElementType(Element element) {
        String string = null;
        if (element != null) {
            if (element instanceof IViewerNode) {
                IViewerNode iViewerNode = (IViewerNode)element;
                string = iViewerNode.getDBObject().getObjectType();
            } else if (element instanceof DBObjectTypeNode) {
                DBObjectTypeNode dBObjectTypeNode = (DBObjectTypeNode)element;
                string = dBObjectTypeNode.getObjectType();
            }
        }
        return string;
    }

    public Element[] getSelection() {
        Vector<Element> vector = new Vector<Element>();
        for (GraphEngineObject graphEngineObject : this.graphEngineSelection) {
            Element element = this.getDatabaseNode(graphEngineObject);
            if (element == null || vector.contains(element)) continue;
            vector.add(element);
        }
        Element[] elementArray = vector.toArray(new Element[vector.size()]);
        return elementArray;
    }

    public GraphEngineObject getModelObject(Object object) {
        GraphEngineObject graphEngineObject = null;
        if (object != null) {
            graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
        }
        return graphEngineObject;
    }

    public Object[] getSelectedCells() {
        Vector<Object> vector = new Vector<Object>();
        for (GraphEngineObject graphEngineObject : this.graphEngineSelection) {
            Object object = this.graphEngineReferenceModel.getLocalToJGraphXMap(graphEngineObject);
            if (object == null || vector.contains(object)) continue;
            vector.add(object);
        }
        Object[] objectArray = vector.toArray(new Object[vector.size()]);
        return objectArray;
    }

    public JPopupMenu getContextMenu() {
        JPopupMenu jPopupMenu = null;
        if (this.editor.getContext().getNode() instanceof IViewerNode) {
            DBObject dBObject = ((IViewerNode)this.editor.getContext().getNode()).getDBObject();
            jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(dBObject);
            this.mnemonicSolver.clear();
            for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
                Component component = jPopupMenu.getComponent(i);
                if (!(component instanceof JMenuItem)) continue;
                JMenuItem jMenuItem = (JMenuItem)component;
                jMenuItem.putClientProperty("ObjectAction.DBOBJECT", dBObject);
                this.mnemonicSolver.addMenuLabel(jMenuItem, false);
            }
            this.mnemonicSolver.solve();
        }
        return jPopupMenu;
    }

    public Action getDropActions(Object object) {
        IdeAction ideAction;
        block21: {
            ideAction = null;
            if (object == null) {
                return null;
            }
            try {
                GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
                Context context = this.editor.getContext();
                GraphEngineType graphEngineType = graphEngineObject.getType();
                if (graphEngineType == null) break block21;
                List<GraphEngineAction> list = graphEngineType.getPopupActions();
                ResourceBundle resourceBundle = this.graphEngineModel.getResourceBundle();
                for (GraphEngineAction graphEngineAction : list) {
                    String string;
                    if (this.isReadOnly() && !graphEngineAction.isAllowedWhenReadOnly() || (string = graphEngineAction.getId()) == null || !string.equals("DROP")) continue;
                    String string2 = graphEngineAction.getTitle();
                    String string3 = null;
                    if (string2 != null) {
                        if (resourceBundle != null) {
                            try {
                                string3 = resourceBundle.getString(graphEngineAction.getTitle());
                            }
                            catch (MissingResourceException missingResourceException) {
                                string3 = null;
                            }
                        }
                        if (string3 == null) {
                            try {
                                string3 = GraphicalEditorArb.get(string2);
                            }
                            catch (MissingResourceException missingResourceException) {
                                string3 = null;
                            }
                            if (string3 == null) {
                                string3 = string2;
                            }
                        }
                    }
                    IdeAction ideAction2 = null;
                    ideAction2 = this.actionIdeActionMap.get(graphEngineAction);
                    if (ideAction2 == null) {
                        GraphicalEditorActionController graphicalEditorActionController;
                        ImageIcon imageIcon;
                        try {
                            imageIcon = new ImageIcon(this.getClass().getResource(graphEngineAction.getIcon()));
                        }
                        catch (Throwable throwable) {
                            imageIcon = null;
                        }
                        ideAction2 = IdeAction.findOrCreate((int)graphEngineAction.getActionID(), null, (String)StringUtils.stripMnemonic((String)string3), null, (Integer)StringUtils.getMnemonicKeyCode((String)string3), (Icon)imageIcon, (Object)resourceBundle, (boolean)true).newLocalAction((View)this.editor);
                        if (graphEngineAction.getControllerClassName() == null) {
                            graphicalEditorActionController = new GraphicalEditorActionController(graphEngineAction);
                        } else {
                            try {
                                Object[] objectArray;
                                Constructor<?> constructor;
                                Class<?> clazz = Class.forName(graphEngineAction.getControllerClassName());
                                try {
                                    constructor = clazz.getConstructor(GraphEngineAction.class);
                                    objectArray = new Object[]{graphEngineAction};
                                }
                                catch (Exception exception) {
                                    constructor = clazz.getConstructor(new Class[0]);
                                    objectArray = null;
                                }
                                graphicalEditorActionController = (Controller)constructor.newInstance(objectArray);
                            }
                            catch (Exception exception) {
                                graphicalEditorActionController = new GraphicalEditorActionController(graphEngineAction);
                            }
                        }
                        ideAction2.addController((Controller)graphicalEditorActionController);
                    }
                    ideAction = ideAction2;
                    this.editor.setContext(context);
                    ideAction2.updateAction(this.editor.getContext());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ideAction;
    }

    public Action getOpenActions(Object object) {
        IdeAction ideAction;
        block21: {
            ideAction = null;
            if (object == null) {
                return null;
            }
            try {
                GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
                GraphEngineType graphEngineType = graphEngineObject.getType();
                if (graphEngineType == null) break block21;
                List<GraphEngineAction> list = graphEngineType.getPopupActions();
                ResourceBundle resourceBundle = this.graphEngineModel.getResourceBundle();
                for (GraphEngineAction graphEngineAction : list) {
                    String string;
                    if (this.isReadOnly() && !graphEngineAction.isAllowedWhenReadOnly() || (string = graphEngineAction.getId()) == null || !string.equals("Open")) continue;
                    String string2 = graphEngineAction.getTitle();
                    String string3 = null;
                    if (string2 != null) {
                        if (resourceBundle != null) {
                            try {
                                string3 = resourceBundle.getString(graphEngineAction.getTitle());
                            }
                            catch (MissingResourceException missingResourceException) {
                                string3 = null;
                            }
                        }
                        if (string3 == null) {
                            try {
                                string3 = GraphicalEditorArb.get(string2);
                            }
                            catch (MissingResourceException missingResourceException) {
                                string3 = null;
                            }
                            if (string3 == null) {
                                string3 = string2;
                            }
                        }
                    }
                    IdeAction ideAction2 = null;
                    ideAction2 = this.actionIdeActionMap.get(graphEngineAction);
                    if (ideAction2 == null) {
                        GraphicalEditorActionController graphicalEditorActionController;
                        ImageIcon imageIcon;
                        try {
                            imageIcon = new ImageIcon(this.getClass().getResource(graphEngineAction.getIcon()));
                        }
                        catch (Throwable throwable) {
                            imageIcon = null;
                        }
                        ideAction2 = IdeAction.findOrCreate((int)graphEngineAction.getActionID(), null, (String)StringUtils.stripMnemonic((String)string3), null, (Integer)StringUtils.getMnemonicKeyCode((String)string3), (Icon)imageIcon, (Object)resourceBundle, (boolean)true).newLocalAction((View)this.editor);
                        if (graphEngineAction.getControllerClassName() == null) {
                            graphicalEditorActionController = new GraphicalEditorActionController(graphEngineAction);
                        } else {
                            try {
                                Object[] objectArray;
                                Constructor<?> constructor;
                                Class<?> clazz = Class.forName(graphEngineAction.getControllerClassName());
                                try {
                                    constructor = clazz.getConstructor(GraphEngineAction.class);
                                    objectArray = new Object[]{graphEngineAction};
                                }
                                catch (Exception exception) {
                                    constructor = clazz.getConstructor(new Class[0]);
                                    objectArray = null;
                                }
                                graphicalEditorActionController = (Controller)constructor.newInstance(objectArray);
                            }
                            catch (Exception exception) {
                                graphicalEditorActionController = new GraphicalEditorActionController(graphEngineAction);
                            }
                        }
                        ideAction2.addController((Controller)graphicalEditorActionController);
                    }
                    ideAction = ideAction2;
                    ideAction2.updateAction(this.editor.getContext());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ideAction;
    }

    public List<Action> getPopupActions(Object object) {
        Vector<Action> vector = new Vector<Action>();
        try {
            IdeAction missingResourceException;
            Object object2;
            Object object3;
            Object object4;
            GraphEngineObject graphEngineObject = object != null ? this.graphEngineReferenceModel.getJGraphXToLocalMap(object) : this.graphEngineModel.getGraph();
            GraphEngineType graphEngineType = graphEngineObject.getType();
            if (graphEngineType != null) {
                List<GraphEngineAction> list = graphEngineType.getPopupActions();
                object4 = this.graphEngineModel.getResourceBundle();
                for (GraphEngineAction object5 : list) {
                    if (this.isReadOnly() && !object5.isAllowedWhenReadOnly()) continue;
                    object3 = object5.getTitle();
                    object2 = null;
                    if (object3 != null) {
                        if (object4 != null) {
                            try {
                                object2 = ((ResourceBundle)object4).getString(object5.getTitle());
                            }
                            catch (MissingResourceException missingResourceException2) {
                                object2 = null;
                            }
                        }
                        if (object2 == null) {
                            try {
                                object2 = GraphicalEditorArb.get((String)object3);
                            }
                            catch (MissingResourceException missingResourceException3) {
                                object2 = null;
                            }
                            if (object2 == null) {
                                object2 = object3;
                            }
                        }
                    }
                    missingResourceException = null;
                    missingResourceException = this.actionIdeActionMap.get(object5);
                    if (missingResourceException == null) {
                        GraphicalEditorActionController graphicalEditorActionController;
                        ImageIcon imageIcon;
                        try {
                            imageIcon = new ImageIcon(this.getClass().getResource(object5.getIcon()));
                        }
                        catch (Throwable throwable) {
                            imageIcon = null;
                        }
                        missingResourceException = IdeAction.findOrCreate((int)object5.getActionID(), null, (String)StringUtils.stripMnemonic((String)object2), null, (Integer)StringUtils.getMnemonicKeyCode((String)object2), (Icon)imageIcon, (Object)object4, (boolean)true).newLocalAction((View)this.editor);
                        if (object5.getControllerClassName() == null) {
                            graphicalEditorActionController = new GraphicalEditorActionController(object5);
                        } else {
                            try {
                                Object[] objectArray;
                                Constructor<?> constructor;
                                Class<?> clazz = Class.forName(object5.getControllerClassName());
                                try {
                                    constructor = clazz.getConstructor(GraphEngineAction.class);
                                    objectArray = new Object[]{object5};
                                }
                                catch (Exception exception) {
                                    constructor = clazz.getConstructor(new Class[0]);
                                    objectArray = null;
                                }
                                graphicalEditorActionController = (Controller)constructor.newInstance(objectArray);
                            }
                            catch (Exception exception) {
                                graphicalEditorActionController = new GraphicalEditorActionController(object5);
                            }
                        }
                        missingResourceException.addController((Controller)graphicalEditorActionController);
                    }
                    vector.add((Action)missingResourceException);
                    missingResourceException.updateAction(this.editor.getContext());
                }
            }
            if (object == null) {
                boolean bl = false;
                if (vector.size() > 0) {
                    bl = true;
                }
                if ((object4 = this.getContextMenu()) != null && ((Container)object4).getComponentCount() > 0) {
                    for (int i = 0; i < ((Container)object4).getComponentCount(); ++i) {
                        Component component = ((Container)object4).getComponent(i);
                        if (!(component instanceof JMenuItem)) continue;
                        object3 = (JMenuItem)component;
                        object2 = ((AbstractButton)object3).getAction();
                        if (object2 instanceof IdeAction) {
                            missingResourceException = (IdeAction)object2;
                            if (missingResourceException.getValue("Name").equals("Scheduler Design Editor")) continue;
                            if (object2.isEnabled()) {
                                missingResourceException.updateAction(this.editor.getContext());
                            }
                        }
                        if (!object2.isEnabled() || this.isReadOnly()) continue;
                        if (bl) {
                            bl = false;
                            vector.add(null);
                        }
                        vector.add((Action)object2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePopup(Object object, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = null;
        this.lastPopupEvent = mouseEvent;
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        try {
            JPopupMenu jPopupMenu2 = new JPopupMenu();
            waitCursor.show();
            this.updateContextForMenuShow(this.editor.getContext(), this.editor.getContextMenu());
            try {
                if (!this.isReadOnly() && (jPopupMenu = this.getContextMenuFor(this.editor.getContext(), this.editor.getContextMenu())) != null && jPopupMenu.getSubElements().length > 0) {
                    int n = jPopupMenu.getComponentCount();
                    while (jPopupMenu.getComponentCount() > 0) {
                        Component component = jPopupMenu.getComponent(0);
                        jPopupMenu2.add(component);
                    }
                    if (n > 0) {
                        jPopupMenu2.addSeparator();
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            List<Action> list = this.getPopupActions(object);
            if (list.size() > 0) {
                boolean bl = false;
                for (Action action : list) {
                    if (action == null) {
                        if (!bl) continue;
                        jPopupMenu2.addSeparator();
                        bl = false;
                        continue;
                    }
                    jPopupMenu2.add(action);
                    bl = true;
                }
            }
            if (jPopupMenu2.getComponentCount() > 0) {
                this.mnemonicSolver.clear();
                this.mnemonicSolver.addMenuLabels(jPopupMenu2);
                this.mnemonicSolver.solve();
                jPopupMenu2.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
        }
        finally {
            waitCursor.hide();
        }
    }

    protected void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() < 0) {
            this.getJGraphXComponent().zoomIn();
        } else {
            this.getJGraphXComponent().zoomOut();
        }
    }

    public void setJGraphXLayout(mxIGraphLayout mxIGraphLayout2) {
        this.jGraphXLayout = mxIGraphLayout2;
    }

    public mxIGraphLayout getJGraphXLayout() {
        return this.jGraphXLayout;
    }

    public boolean isValidExternalDropTarget(Object object) {
        try {
            GraphEngineObject graphEngineObject;
            if (!this.isReadOnly() && (graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object)) != null) {
                GraphEngineType graphEngineType = graphEngineObject.getType();
                return graphEngineType.isExternalDropAllowed();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public boolean isValidDropTarget(Object object, Object[] objectArray) {
        try {
            if (this.isReadOnly()) {
                return false;
            }
            GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
            if (graphEngineObject != null) {
                GraphEngineType[] graphEngineTypeArray = new GraphEngineType[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (object2 == null) {
                        return false;
                    }
                    GraphEngineObject graphEngineObject2 = this.graphEngineReferenceModel.getJGraphXToLocalMap(object2);
                    if (graphEngineObject2 == null) {
                        return false;
                    }
                    graphEngineTypeArray[i] = graphEngineObject2.getType();
                }
                GraphEngineType graphEngineType = graphEngineObject.getType();
                return graphEngineType == null ? false : graphEngineType.canAcceptDrop(graphEngineTypeArray);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public boolean dropCellsOnTarget(Object object, Object[] objectArray) {
        try {
            GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
            if (graphEngineObject != null) {
                GraphEngineObject[] graphEngineObjectArray = new GraphEngineObject[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = objectArray[i];
                    if (object2 == null) {
                        return false;
                    }
                    GraphEngineObject graphEngineObject2 = this.graphEngineReferenceModel.getJGraphXToLocalMap(object2);
                    if (graphEngineObject2 == null) {
                        return false;
                    }
                    graphEngineObjectArray[i] = graphEngineObject2;
                }
                return this.graphEngineModel.drop(graphEngineObject, graphEngineObjectArray);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    void openEditor(Object object) {
        try {
            GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
            if (graphEngineObject != null) {
                this.graphEngineModel.edit(graphEngineObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPanning(boolean bl) {
        this.panning = bl;
    }

    public boolean isPanning() {
        return this.panning;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getToolTipFor(Object object) {
        String string = null;
        GraphEngineObject graphEngineObject = this.graphEngineReferenceModel.getJGraphXToLocalMap(object);
        if (graphEngineObject != null) {
            string = graphEngineObject.getToolTip();
        }
        return string;
    }

    public void layout() {
        Object[] objectArray;
        this.getJGraphXLayout().execute(this.getJGraphXModel().getDefaultParent());
        for (Object object : objectArray = this.getJGraphXModel().getChildCells(this.getJGraphXModel().getDefaultParent())) {
            mxGeometry mxGeometry2 = this.getJGraphXModel().getCellGeometry(object);
            if (!this.getJGraphXModel().getModel().isVertex(object) || mxGeometry2 == null) continue;
            this.moved(object, new Point2D.Double(mxGeometry2.getX(), mxGeometry2.getY()));
        }
    }

    public void refresh() {
        Point2D.Double double_ = new Point2D.Double(10.0, 10.0);
        List<Element> list = this.graphEngineReferenceModel.getElements();
        this.clearAll();
        for (Element element : list) {
            String string = this.getElementType(element);
            GraphEngineNodeType graphEngineNodeType = this.graphEngineModel.getDefinitions().getNodeDefinitions().get(string);
            this.importElement(element, null, double_);
            if (double_ == null) continue;
            ((Point2D)double_).setLocation(((Point2D)double_).getX() + 32.0, ((Point2D)double_).getY() + 32.0);
        }
        if (this.isAutoLayout()) {
            this.layout();
        }
    }

    public Controller getReadOnlyModeActionController() {
        return this.readOnlyModeActionController;
    }

    private void updateMenu(JPopupMenu jPopupMenu, Context context) {
        int n = jPopupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jPopupMenu.getComponent(i);
            if (component instanceof JMenu) {
                this.updateMenu(((JMenu)component).getPopupMenu(), context);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            IdeAction ideAction = (IdeAction)((JMenuItem)component).getAction();
            ideAction.updateAction(context);
        }
    }

    public JPopupMenu getContextMenuFor(Context context, ContextMenu contextMenu) {
        JPopupMenu jPopupMenu = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof ObjectNode) {
            context.getView().getGUI().requestFocusInWindow();
            DBObject dBObject = new DBObject(elementArray[0]);
            jPopupMenu = XMLBasedObjectAction.getInstance().getMenu(dBObject);
            XMLBasedObjectAction.getInstance().checkActionVersions(dBObject, false);
            if (jPopupMenu.getComponentCount() > 0) {
                context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
                this.updateMenu(jPopupMenu, context);
                contextMenu.sortContainer((Container)jPopupMenu);
            }
        }
        return jPopupMenu;
    }

    private void updateContextForMenuShow(Context context, ContextMenu contextMenu) {
        int n;
        Action[] actionArray;
        Toolbar toolbar;
        if (context != null) {
            context.getElement();
        }
        Float f = GRAPHICAL_EDITOR_TOOLBAR_SECTION_ID;
        try {
            toolbar = this.editor.getToolbar();
            if (toolbar != null && toolbar.getActions() != null && toolbar.getActions().length > 0) {
                actionArray = toolbar.getActions();
                for (n = actionArray.length - 1; n >= 0; --n) {
                    Action action = actionArray[n];
                    JMenuItem object = new JMenuItem(action);
                    object.putClientProperty("menu-section-id", f);
                    if (contextMenu == null) continue;
                    contextMenu.add((Component)object);
                }
                if (contextMenu != null) {
                    contextMenu.addSeparator();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            f = GRAPHICAL_EDITOR_MENU_SECTION_ID;
            toolbar = null;
            actionArray = this.getPopupActions(toolbar);
            if (actionArray.size() > 0) {
                n = 0;
                for (Action action : actionArray) {
                    if (action == null) {
                        if (n == 0) continue;
                        if (contextMenu != null) {
                            contextMenu.addSeparator();
                        }
                        f = Float.valueOf(f.floatValue() + 1.0f);
                        n = 0;
                        continue;
                    }
                    JMenuItem jMenuItem = new JMenuItem(action);
                    jMenuItem.putClientProperty("menu-section-id", f);
                    if (contextMenu != null) {
                        contextMenu.add((Component)jMenuItem);
                    }
                    n = 1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoLayout(boolean bl) {
        this.autoLayout = bl;
    }

    public boolean isAutoLayout() {
        return this.autoLayout;
    }

    public void clearAll() {
        GraphEngineGraph graphEngineGraph = this.getModel().getGraph();
        if (graphEngineGraph != null) {
            Vector<GraphEngineNode> vector = new Vector<GraphEngineNode>(graphEngineGraph.getChildNodes());
            for (GraphEngineNode graphEngineNode : vector) {
                graphEngineGraph.remove(graphEngineNode);
            }
        }
        this.graphEngineReferenceModel.clear();
    }

    static {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)contextMenuListener);
    }

    private static class IDEContextMenuListener
    implements ContextMenuListener {
        private IDEContextMenuListener() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            View view = context.getView();
            if (view instanceof AbstractGraphicalEditor) {
                GraphicalEditorController graphicalEditorController = ((AbstractGraphicalEditor)view).getGraphicalEditorController();
                graphicalEditorController.updateContextForMenuShow(contextMenu.getContext(), contextMenu);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class GraphEngineObserver
    implements GraphEngineModelObserver {
        private GraphEngineObserver() {
        }

        @Override
        public void nodeAdded(GraphEngineNode graphEngineNode) {
            GraphicalEditorController.this.addNodeToJGraphX(graphEngineNode);
        }

        @Override
        public void nodeUpdated(GraphEngineNode graphEngineNode) {
        }

        @Override
        public void nodeRemoved(GraphEngineNode graphEngineNode) {
            GraphicalEditorController.this.removeNodeFromJGraphX(graphEngineNode);
        }

        @Override
        public void edgeAdded(GraphEngineEdge graphEngineEdge) {
            GraphicalEditorController.this.addEdgeToJGraphX(graphEngineEdge);
        }

        @Override
        public void edgeUpdated(GraphEngineEdge graphEngineEdge) {
        }

        @Override
        public void edgeRemoved(GraphEngineEdge graphEngineEdge) {
            GraphicalEditorController.this.removeEdgeFromJGraphX(graphEngineEdge);
        }
    }
}

