/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import com.mxgraph.util.mxConstants;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorArb;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineAction;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDrop;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineResultSetValueProcessor;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineDrop;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineEdgeGenerator;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineNodeGenerator;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineObjectAction;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineSqlAction;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineType;
import oracle.ide.net.JarUtil;
import oracle.javatools.util.Version;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GraphEngineXML {
    protected Logger logger = Logger.getLogger(GraphEngineXML.class.getName());
    private Document _document;
    private DOMParser parser;
    private static Map<String, ObjectQueries> queriesCache = new HashMap<String, ObjectQueries>();

    public void resetParser() {
        if (this.parser == null) {
            this.parser = new DOMParser();
        } else {
            this.parser.reset();
        }
        this.parser.setPreserveWhitespace(false);
    }

    public GraphEngineModel processXML(InputStream inputStream, URL uRL) throws Exception {
        String string = JarUtil.getJarEntry((URL)uRL);
        if (string != null && !string.startsWith("/")) {
            string = "/" + string;
        }
        return this.processXML(inputStream);
    }

    public GraphEngineModel processXML(InputStream inputStream) throws Exception {
        this.resetParser();
        this.parser.parse(inputStream);
        inputStream.close();
        this._document = this.parser.getDocument();
        return this.processDocument(this._document);
    }

    public GraphEngineModel processDocument(Document document) throws Exception {
        XMLGraphEngineModel xMLGraphEngineModel = new XMLGraphEngineModel();
        this._document = document;
        Node node = XMLHelper.getChildNode((Node)this._document, (String)"grapheditor");
        String string = XMLHelper.getAttributeNode((Node)node, (String)"name");
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"rsbundle");
        String string3 = XMLHelper.getAttributeNode((Node)node, (String)"enablePin");
        String string4 = XMLHelper.getAttributeNode((Node)node, (String)"clearAllOnReload");
        String string5 = XMLHelper.getAttributeNode((Node)node, (String)"editor");
        xMLGraphEngineModel.setName(string);
        xMLGraphEngineModel.setResourceBundle(string2);
        xMLGraphEngineModel.setEnablePin(string3 != null && Boolean.valueOf(string3) != false);
        xMLGraphEngineModel.setClearAllOnReload(string4 != null && Boolean.valueOf(string4) != false);
        xMLGraphEngineModel.setEditor(string5 != null && Boolean.valueOf(string5) != false);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("definitions")) {
                xMLGraphEngineModel.setDefinitions(this.processDefinitions(xMLGraphEngineModel, node2));
                continue;
            }
            if (node2.getNodeName().equals("data")) {
                xMLGraphEngineModel.setGraph(this.processGraph(xMLGraphEngineModel, node2));
                continue;
            }
            this.processNode(node2);
        }
        return xMLGraphEngineModel;
    }

    public String getModelName(URL uRL) throws Exception {
        InputStream inputStream = uRL.openStream();
        this.resetParser();
        this.parser.parse(inputStream);
        inputStream.close();
        this._document = this.parser.getDocument();
        Node node = XMLHelper.getChildNode((Node)this._document, (String)"grapheditor");
        String string = XMLHelper.getAttributeNode((Node)node, (String)"name");
        return string;
    }

    public Document getDocument() {
        return this._document;
    }

    protected GraphEngineDefinitions processDefinitions(GraphEngineModel graphEngineModel, Node node) {
        XMLGraphEngineDefinitions xMLGraphEngineDefinitions = new XMLGraphEngineDefinitions(graphEngineModel);
        GraphEngineNodeType graphEngineNodeType = this.processNodeType(xMLGraphEngineDefinitions, node);
        xMLGraphEngineDefinitions.setRootDefinition(graphEngineNodeType);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("nodegen")) {
                xMLGraphEngineDefinitions.addNodeGenerator(this.processNodeGenerator(xMLGraphEngineDefinitions, node2));
                continue;
            }
            if (node2.getNodeName().equals("edgegen")) {
                xMLGraphEngineDefinitions.addEdgeGenerator(this.processEdgeGenerator(xMLGraphEngineDefinitions, node2));
                continue;
            }
            if (node2.getNodeName().equals("nodetype")) {
                xMLGraphEngineDefinitions.addNodeType(this.processNodeType(xMLGraphEngineDefinitions, node2));
                continue;
            }
            if (node2.getNodeName().equals("edgetype")) {
                xMLGraphEngineDefinitions.addEdgeType(this.processEdgeType(xMLGraphEngineDefinitions, node2));
                continue;
            }
            if (node2.getNodeName().equals("layout")) {
                xMLGraphEngineDefinitions.setLayout(this.processLayout(node2));
                continue;
            }
            this.processNode(node2);
        }
        return xMLGraphEngineDefinitions;
    }

    protected GraphEngineGraph processGraph(GraphEngineModel graphEngineModel, Node node) {
        XMLGraphEngineGraph xMLGraphEngineGraph = new XMLGraphEngineGraph(graphEngineModel);
        xMLGraphEngineGraph.setNodeType(graphEngineModel.getDefinitions().getRootDefinition());
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("node")) {
                xMLGraphEngineGraph.add(this.processNode(xMLGraphEngineGraph, node2));
                continue;
            }
            if (node2.getNodeName().equals("edge")) {
                xMLGraphEngineGraph.add(this.processEdge(xMLGraphEngineGraph, node2));
                continue;
            }
            this.processNode(node2);
        }
        return xMLGraphEngineGraph;
    }

    protected void processNode(Node node) {
        String string = "";
        String string2 = "";
        if (node.getNodeName().equalsIgnoreCase("#comment")) {
            return;
        }
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            string = node.getNodeName() + string2 + string;
            string2 = ".";
        }
    }

    protected GraphEngineNodeType processNodeType(XMLGraphEngineDefinitions xMLGraphEngineDefinitions, Node node) {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        XMLGraphEngineNodeType xMLGraphEngineNodeType = new XMLGraphEngineNodeType(xMLGraphEngineDefinitions);
        xMLGraphEngineNodeType.setTypeId(XMLHelper.getAttributeNode((Node)node, (String)"id"));
        String string5 = XMLHelper.getAttributeNode((Node)node, (String)"displaytype");
        String string6 = XMLHelper.getAttributeNode((Node)node, (String)"allowDrop");
        if (string6 != null) {
            xMLGraphEngineNodeType.setAllowDrop(Boolean.valueOf(string6));
        }
        if ((string2 = XMLHelper.getNodeValue((Node)node, (String)"style")) != null && string2.length() == 0) {
            string2 = null;
        }
        if (string5 != null && string5.equalsIgnoreCase("icon")) {
            string = XMLHelper.getNodeValue((Node)node, (String)"icon");
            string2 = mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";" + mxConstants.STYLE_IMAGE + "=" + string;
        }
        if ((string3 = XMLHelper.getAttributeNode((Node)node, (String)"minVersion")) != null) {
            xMLGraphEngineNodeType.setMinVersion(new Version(string3));
        }
        if ((string4 = XMLHelper.getAttributeNode((Node)node, (String)"maxVersion")) != null) {
            xMLGraphEngineNodeType.setMaxVersion(new Version(string4));
        }
        xMLGraphEngineNodeType.setStyle(string2);
        string = XMLHelper.getAttributeNode((Node)node, (String)"tooltip");
        xMLGraphEngineNodeType.setToolTip(this.getString(xMLGraphEngineDefinitions.getModel().getResourceBundle(), string, new Object[0]));
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            List<Object> list;
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("action")) {
                xMLGraphEngineNodeType.addAction(this.processAction(xMLGraphEngineNodeType, node2));
                continue;
            }
            if (node2.getNodeName().equals("actions")) {
                list = this.processActions(xMLGraphEngineNodeType, node2);
                for (Object object : list) {
                    xMLGraphEngineNodeType.addAction((GraphEngineAction)object);
                }
                continue;
            }
            if (node2.getNodeName().equals("popups")) {
                list = this.processActions(xMLGraphEngineNodeType, node2);
                for (Object object : list) {
                    xMLGraphEngineNodeType.addPopupAction((GraphEngineAction)object);
                }
                continue;
            }
            if (node2.getNodeName().equals("drops")) {
                list = this.processDrops(xMLGraphEngineNodeType, node2);
                for (Object object : list) {
                    xMLGraphEngineNodeType.addDropAction((GraphEngineDrop)object);
                }
                continue;
            }
            if (!node2.getNodeName().equals("externaldrop")) continue;
            xMLGraphEngineNodeType.setExternalDropAllowed(true);
            xMLGraphEngineNodeType.setExternalDropAction(this.processExternalDrop(xMLGraphEngineNodeType, node2));
        }
        return xMLGraphEngineNodeType;
    }

    protected List<GraphEngineAction> processActions(XMLGraphEngineType xMLGraphEngineType, Node node) {
        Vector<GraphEngineAction> vector = new Vector<GraphEngineAction>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("action")) {
                vector.add(this.processAction(xMLGraphEngineType, node2));
                continue;
            }
            if (!node2.getNodeName().equals("item")) continue;
            vector.add(this.processItem(xMLGraphEngineType, node2));
        }
        return vector;
    }

    protected List<GraphEngineDrop> processDrops(XMLGraphEngineType xMLGraphEngineType, Node node) {
        Vector<GraphEngineDrop> vector = new Vector<GraphEngineDrop>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("drop")) continue;
            XMLGraphEngineDrop xMLGraphEngineDrop = new XMLGraphEngineDrop(xMLGraphEngineType);
            xMLGraphEngineDrop.setDropSourceTypeId(XMLHelper.getAttributeNode((Node)node2, (String)"type"));
            xMLGraphEngineDrop.setAction(this.processAction(xMLGraphEngineType, XMLHelper.getChildNode((Node)node2, (String)"action")));
            vector.add(xMLGraphEngineDrop);
        }
        return vector;
    }

    protected GraphEngineEdgeType processEdgeType(XMLGraphEngineDefinitions xMLGraphEngineDefinitions, Node node) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = null;
        String string3 = null;
        XMLGraphEngineEdgeType xMLGraphEngineEdgeType = new XMLGraphEngineEdgeType(xMLGraphEngineDefinitions);
        xMLGraphEngineEdgeType.setTypeId(XMLHelper.getAttributeNode((Node)node, (String)"id"));
        xMLGraphEngineEdgeType.setSourceType(XMLHelper.getAttributeNode((Node)node, (String)"source"));
        xMLGraphEngineEdgeType.setTargetType(XMLHelper.getAttributeNode((Node)node, (String)"target"));
        String string4 = XMLHelper.getAttributeNode((Node)node, (String)"directed");
        String string5 = XMLHelper.getAttributeNode((Node)node, (String)"loadSource");
        String string6 = XMLHelper.getAttributeNode((Node)node, (String)"loadTarget");
        String string7 = XMLHelper.getAttributeNode((Node)node, (String)"createReversed");
        string = XMLHelper.getNodeValue((Node)node, (String)"style");
        string2 = XMLHelper.getAttributeNode((Node)node, (String)"minVersion");
        string3 = XMLHelper.getAttributeNode((Node)node, (String)"maxVersion");
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string != null) {
            xMLGraphEngineEdgeType.setStyle(string);
        }
        if (string4 != null) {
            bl = string4.equalsIgnoreCase("true");
        }
        if (string5 != null) {
            bl2 = string5.equalsIgnoreCase("true");
        }
        if (string6 != null) {
            bl3 = string6.equalsIgnoreCase("true");
        }
        if (string7 != null) {
            bl4 = string7.equalsIgnoreCase("true");
        }
        if (string2 != null) {
            xMLGraphEngineEdgeType.setMinVersion(new Version(string2));
        }
        if (string3 != null) {
            xMLGraphEngineEdgeType.setMaxVersion(new Version(string3));
        }
        xMLGraphEngineEdgeType.setDirected(bl);
        xMLGraphEngineEdgeType.setLoadSource(bl2);
        xMLGraphEngineEdgeType.setLoadTarget(bl3);
        xMLGraphEngineEdgeType.setCreateReversed(bl4);
        String string8 = XMLHelper.getAttributeNode((Node)node, (String)"tooltip");
        xMLGraphEngineEdgeType.setToolTip(this.getString(xMLGraphEngineDefinitions.getModel().getResourceBundle(), string8, new Object[0]));
        String string9 = XMLHelper.getAttributeNode((Node)node, (String)"displaytype");
        if (string9 != null) {
            // empty if block
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            List<GraphEngineAction> list;
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("action")) {
                xMLGraphEngineEdgeType.addAction(this.processAction(xMLGraphEngineEdgeType, node2));
                continue;
            }
            if (node2.getNodeName().equals("actions")) {
                list = this.processActions(xMLGraphEngineEdgeType, node2);
                for (GraphEngineAction graphEngineAction : list) {
                    xMLGraphEngineEdgeType.addAction(graphEngineAction);
                }
                continue;
            }
            if (node2.getNodeName().equals("popups")) {
                list = this.processActions(xMLGraphEngineEdgeType, node2);
                for (GraphEngineAction graphEngineAction : list) {
                    xMLGraphEngineEdgeType.addPopupAction(graphEngineAction);
                }
                continue;
            }
            if (!node2.getNodeName().equals("item")) continue;
            xMLGraphEngineEdgeType.addAction(this.processAction(xMLGraphEngineEdgeType, node2));
        }
        return xMLGraphEngineEdgeType;
    }

    protected Object processLayout(Node node) {
        return null;
    }

    protected GraphEngineNode processNode(GraphEngineGraph graphEngineGraph, Node node) {
        return null;
    }

    protected GraphEngineNode processEdge(GraphEngineGraph graphEngineGraph, Node node) {
        return null;
    }

    protected ObjectQueries processQueries(Node node) {
        if (node instanceof XMLNode) {
            ObjectQueries objectQueries;
            XMLNode xMLNode = (XMLNode)node;
            String string = XMLHelper.getAttributeNode((Node)xMLNode, (String)"id");
            if (string != null) {
                objectQueries = queriesCache.get(string);
                if (objectQueries == null) {
                    objectQueries = new ObjectQueries(xMLNode);
                    queriesCache.put(string, objectQueries);
                }
            } else {
                objectQueries = new ObjectQueries(xMLNode);
            }
            return objectQueries;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GraphEngineNodeGenerator processNodeGenerator(GraphEngineDefinitions graphEngineDefinitions, Node node) {
        XMLGraphEngineNodeGenerator xMLGraphEngineNodeGenerator;
        GraphEngineNodeGenerator graphEngineNodeGenerator = null;
        String string = XMLHelper.getAttributeNode((Node)node, (String)"class");
        if (string != null) {
            try {
                graphEngineNodeGenerator = (GraphEngineNodeGenerator)this.getObject(Class.forName(string), node, GraphEngineGraph.class, graphEngineDefinitions);
            }
            catch (Exception exception) {
                return null;
            }
        }
        graphEngineNodeGenerator = xMLGraphEngineNodeGenerator = new XMLGraphEngineNodeGenerator(graphEngineDefinitions);
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"id");
        xMLGraphEngineNodeGenerator.setObjectType(string2);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("queries")) {
                xMLGraphEngineNodeGenerator.setQueries(this.processQueries(node2));
                continue;
            }
            this.processNode(node2);
        }
        return graphEngineNodeGenerator;
    }

    protected GraphEngineAction processAction(XMLGraphEngineType xMLGraphEngineType, Node node) {
        GraphEngineAction graphEngineAction = null;
        String string = XMLHelper.getAttributeNode((Node)node, (String)"className");
        if (string != null) {
            try {
                graphEngineAction = (GraphEngineAction)this.getObject(Class.forName(string), node, GraphEngineType.class, xMLGraphEngineType);
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            Node node2;
            XMLGraphEngineSqlAction xMLGraphEngineSqlAction;
            graphEngineAction = xMLGraphEngineSqlAction = new XMLGraphEngineSqlAction(xMLGraphEngineType);
            String string2 = XMLHelper.getAttributeNode((Node)node, (String)"id");
            String string3 = XMLHelper.getAttributeNode((Node)node, (String)"actionID");
            String string4 = XMLHelper.getAttributeNode((Node)node, (String)"controllerClass");
            String string5 = XMLHelper.getNodeValue((Node)node, (String)"confirmmsg");
            String string6 = XMLHelper.getNodeValue((Node)node, (String)"helpid");
            String string7 = XMLHelper.getAttributeNode((Node)node, (String)"reload");
            String string8 = XMLHelper.getAttributeNode((Node)node, (String)"delete");
            String string9 = XMLHelper.getAttributeNode((Node)node, (String)"allowedWhenReadOnly");
            String string10 = XMLHelper.getNodeValue((Node)node, (String)"sql");
            String string11 = null;
            String string12 = XMLHelper.getNodeValue((Node)node, (String)"title");
            String string13 = XMLHelper.getNodeValue((Node)node, (String)"icon");
            String string14 = XMLHelper.getAttributeNode((Node)node, (String)"templateName");
            String string15 = node.getNodeName();
            if (string3 == null) {
                string3 = xMLGraphEngineType.getTypeId() + "." + string2;
            }
            if ((node2 = XMLHelper.getChildNode((Node)node, (String)"sql")) != null) {
                string11 = XMLHelper.getAttributeNode((Node)node2, (String)"template");
            }
            if (string10 != null && string10.length() > 0 && string12 != null && string12.length() > 0) {
                System.out.println("SCHEDULERGE_" + string12 + "(OBJECT, SOURCE, TARGET, NEWSOURCE, NEWTARGET) ::= <<");
                System.out.println(string10);
                System.out.println(">>\n");
            }
            xMLGraphEngineSqlAction.setId(string2);
            xMLGraphEngineSqlAction.setActionIDName(string3);
            xMLGraphEngineSqlAction.setSql(string10);
            xMLGraphEngineSqlAction.setTemplateName(string11);
            xMLGraphEngineSqlAction.setIcon(string13);
            xMLGraphEngineSqlAction.setControllerClassName(string4);
            xMLGraphEngineSqlAction.setConfirmMsg(string5);
            xMLGraphEngineSqlAction.setHelpId(string6);
            xMLGraphEngineSqlAction.setReload(string7 == null ? false : string7.equalsIgnoreCase("true"));
            xMLGraphEngineSqlAction.setDelete(string8 == null ? false : string8.equalsIgnoreCase("true"));
            xMLGraphEngineSqlAction.setAllowedWhenReadOnly(string9 == null ? false : string9.equalsIgnoreCase("true"));
            xMLGraphEngineSqlAction.setTitle(string12);
            xMLGraphEngineSqlAction.setItem(string15.equalsIgnoreCase("item"));
        }
        return graphEngineAction;
    }

    protected GraphEngineAction processItem(XMLGraphEngineType xMLGraphEngineType, Node node) {
        ObjectAction objectAction = new ObjectAction(MetaXMLReference.createXMLReference((Node)node, (ClassLoader)this.getClass().getClassLoader()));
        return new XMLGraphEngineObjectAction(xMLGraphEngineType, objectAction);
    }

    protected <T> T getObject(Class<T> clazz, Node node, Class clazz2, Object object) {
        T t = null;
        try {
            Constructor<T> constructor;
            Object[] objectArray = new Object[]{object, node};
            try {
                constructor = clazz.getConstructor(clazz2, Node.class);
                objectArray = new Object[]{object, node};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = clazz.getConstructor(Node.class);
                    objectArray = new Object[]{node};
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    constructor = clazz.getConstructor(new Class[0]);
                    objectArray = null;
                }
                objectArray = null;
            }
            t = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            t = null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GraphEngineEdgeGenerator processEdgeGenerator(XMLGraphEngineDefinitions xMLGraphEngineDefinitions, Node node) {
        XMLGraphEngineEdgeGenerator xMLGraphEngineEdgeGenerator;
        GraphEngineEdgeGenerator graphEngineEdgeGenerator = null;
        String string = XMLHelper.getAttributeNode((Node)node, (String)"className");
        if (string != null) {
            try {
                graphEngineEdgeGenerator = (GraphEngineEdgeGenerator)this.getObject(Class.forName(string), node, GraphEngineGraph.class, xMLGraphEngineDefinitions);
            }
            catch (Exception exception) {
                return null;
            }
        }
        graphEngineEdgeGenerator = xMLGraphEngineEdgeGenerator = new XMLGraphEngineEdgeGenerator(xMLGraphEngineDefinitions);
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"id");
        String string3 = XMLHelper.getAttributeNode((Node)node, (String)"columnNameValueProcessor");
        GraphEngineResultSetValueProcessor graphEngineResultSetValueProcessor = null;
        xMLGraphEngineEdgeGenerator.setObjectType(string2);
        xMLGraphEngineEdgeGenerator.setEdgeType(xMLGraphEngineDefinitions.getEdgeDefinition(string2));
        if (string3 != null) {
            try {
                graphEngineResultSetValueProcessor = (GraphEngineResultSetValueProcessor)this.getObject(Class.forName(string3), node, GraphEngineEdgeGenerator.class, xMLGraphEngineEdgeGenerator);
            }
            catch (Exception exception) {
                return null;
            }
        }
        xMLGraphEngineEdgeGenerator.setColumnNameValueProcessor(graphEngineResultSetValueProcessor);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string4 = XMLHelper.getAttributeNode((Node)node2, (String)"direction");
            if (string4 == null) continue;
            string2 = XMLHelper.getAttributeNode((Node)node2, (String)"id");
            if (node2.getNodeName().equals("queries")) {
                if (string4.equalsIgnoreCase("inbound")) {
                    xMLGraphEngineEdgeGenerator.setInboundQueries(this.processQueries(node2));
                    continue;
                }
                xMLGraphEngineEdgeGenerator.setOutboundQueries(this.processQueries(node2));
                continue;
            }
            this.processNode(node2);
        }
        return graphEngineEdgeGenerator;
    }

    protected GraphEngineAction processExternalDrop(XMLGraphEngineNodeType xMLGraphEngineNodeType, Node node) {
        GraphEngineAction graphEngineAction = null;
        Node node2 = XMLHelper.getChildNode((Node)node, (String)"action");
        if (node2 != null) {
            graphEngineAction = this.processAction(xMLGraphEngineNodeType, node2);
        }
        return graphEngineAction;
    }

    protected String getString(ResourceBundle resourceBundle, String string, Object ... objectArray) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (string2 == null && (string2 = GraphicalEditorArb.get(string)).equals('!' + string + '!')) {
            string2 = string;
        }
        string2 = MessageFormat.format(string2, objectArray);
        return string2;
    }
}

