/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;

public class EnableAction
extends ActionDialog {
    private static final String ENABLED = "enabled";
    private static final String OWNER = "owner";
    private static final String NAME = "name";
    String owner = null;
    String name = null;
    boolean enabled = false;

    public EnableAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getTitle() {
        return SchedulerArb.getString("ENABLE_DISABLE_DIALOG_TITLE");
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Cloneable cloneable;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        String string;
        String string2;
        try {
            string2 = this.getObjectName();
        }
        catch (Exception exception) {
            string2 = "null";
        }
        try {
            string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            string = "null";
        }
        if (Connections.getInstance().lock(connection)) {
            booleanCheckBoxActionControl = null;
            try {
                ResultSet resultSet;
                cloneable = new HashMap<String, String>();
                ((HashMap)cloneable).put("OBJECT_NAME", string2);
                ((HashMap)cloneable).put("OBJECT_OWNER", string);
                this.owner = string;
                this.name = string2;
                this.enabled = false;
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string3 = this.getQuery(connection, this.getArgs());
                if (string3 != null) {
                    booleanCheckBoxActionControl = dBUtil.executeOracleQuery(string3, (Map)((Object)cloneable));
                }
                if (booleanCheckBoxActionControl != null && (resultSet = booleanCheckBoxActionControl.getResultSet()).next()) {
                    String string4 = resultSet.getString("ENABLED").toLowerCase();
                    this.enabled = string4 == null ? false : Boolean.valueOf(string4);
                    this.owner = resultSet.getString("OWNER");
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (booleanCheckBoxActionControl != null) {
                    booleanCheckBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        booleanCheckBoxActionControl = null;
        booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("CHAINPANEL_ENABLED_LABEL"), this.enabled);
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(booleanCheckBoxActionControl);
        return cloneable;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get(OWNER);
        String string3 = values.get(NAME);
        String string4 = values.get(ENABLED);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put(OWNER, this.owner);
        treeMap.put(NAME, this.name);
        treeMap.put(ENABLED, string4 == null ? false : Boolean.valueOf(string4));
        TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
        treeMap2.put(OWNER, EnableAction.equals(string2, this.owner) == false);
        treeMap2.put(NAME, EnableAction.equals(string3, this.name) == false);
        TreeMap<String, Object> treeMap3 = new TreeMap<String, Object>();
        treeMap3.put("model", treeMap);
        treeMap3.put("changes", treeMap2);
        String string5 = null;
        string5 = dBMSSchedulerCodeGenerator.generate(string, "ENABLE_DISABLE", treeMap3);
        return string5;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    public void launch() {
        try {
            super.launch();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

