/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.chain;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.Version;

public class ChainCreateAction
extends ActionDialogBase {
    public static final String OWNER = "owner";
    public static final String NAME = "name";
    public static final String COMMENTS = "comments";
    public static final String ENABLED = "enabled";
    boolean showOwner = false;
    String owner = null;
    String chain_name = null;
    String comments = null;
    boolean enabled = true;
    ActionControl ownerCtl = null;
    ActionControl nameCtl = null;
    ActionControl commentsCtl = null;
    ActionControl enabledCtl = null;

    public ChainCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getTitle() {
        return SchedulerArb.getString("CHAINCREATEDIALOG_TITLE");
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected List<ActionControl> createControls(Connection var1_1) {
        var2_2 = this.getOperation();
        try {
            var3_3 = this.getObjectName();
        }
        catch (Exception var5_4) {
            var3_3 = "null";
        }
        try {
            var4_7 = this.getDBObjectSchemaName();
            if (var4_7 == null) {
                var4_7 = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception var5_5) {
            var4_7 = "null";
        }
        if (var2_2 != Operation.CREATE_NEW) {
            if (Connections.getInstance().lock(var1_1)) {
                var5_6 = null;
                try {
                    var6_8 = new HashMap<String, String>();
                    var6_8.put("OBJECT_NAME", var3_3);
                    var6_8.put("OBJECT_OWNER", var4_7);
                    var7_10 = DBUtil.getInstance((Connection)var1_1);
                    var7_10.setRaiseError(true);
                    var5_6 = var7_10.executeOracleQuery(this.getQuery(var1_1, "CHAIN_DATA"), var6_8);
                    if (var5_6 == null || !(var8_11 = var5_6.getResultSet()).next()) ** GOTO lbl43
                    this.owner = var8_11.getString("OWNER");
                    this.chain_name = var8_11.getString("CHAIN_NAME");
                    this.comments = var8_11.getString("COMMENTS");
                    var9_12 = var8_11.getString("ENABLED").toLowerCase();
                    this.enabled = var9_12 == null ? false : Boolean.valueOf(var9_12);
                }
                catch (Exception var6_9) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var6_9.getStackTrace()[0].toString(), var6_9);
                }
                finally {
                    if (var5_6 != null) {
                        var5_6.close();
                    }
                    Connections.getInstance().unlock(var1_1);
                }
            }
        } else {
            this.owner = var4_7;
        }
lbl43:
        // 5 sources

        switch (1.$SwitchMap$oracle$dbtools$scheduler$panels$chain$ChainCreateAction$Operation[var2_2.ordinal()]) {
            case 1: {
                this.ownerCtl = new TextBoxActionControl("owner", SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), this.owner);
                this.ownerCtl.setEditable(false);
                this.nameCtl = new TextBoxActionControl("name", SchedulerArb.getString("CHAINPANEL_NAME_LABEL"), this.chain_name);
                this.nameCtl.setEditable(false);
                this.commentsCtl = new TextBoxActionControl("comments", SchedulerArb.getString("CHAINPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl("enabled", SchedulerArb.getString("CHAINPANEL_ENABLED_LABEL"), this.enabled, false);
                break;
            }
            case 2: {
                this.ownerCtl = new SqlComboBoxActionControl("owner", SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), var1_1, this.getQuery(var1_1, "SCHEMAS_LIST"), null, this.owner);
                this.nameCtl = new TextBoxActionControl("name", SchedulerArb.getString("CHAINPANEL_NAME_LABEL"), "");
                this.commentsCtl = new TextBoxActionControl("comments", SchedulerArb.getString("CHAINPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl("enabled", SchedulerArb.getString("CHAINPANEL_ENABLED_LABEL"), this.enabled, false);
                break;
            }
            case 3: {
                this.ownerCtl = new SqlComboBoxActionControl("owner", SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), var1_1, this.getQuery(var1_1, "SCHEMAS_LIST"), null, this.owner);
                this.nameCtl = new TextBoxActionControl("name", SchedulerArb.getString("CHAINPANEL_NAME_LABEL"), this.chain_name);
                this.commentsCtl = new TextBoxActionControl("comments", SchedulerArb.getString("CHAINPANEL_DESC_LABEL"), this.comments);
                this.enabledCtl = new BooleanCheckBoxActionControl("enabled", SchedulerArb.getString("CHAINPANEL_ENABLED_LABEL"), this.enabled, false);
            }
        }
        var5_6 = new ArrayList();
        if (this.showOwner) {
            var5_6.add(this.ownerCtl);
        } else {
            this.ownerCtl = new TextBoxActionControl("owner", SchedulerArb.getString("CHAINPANEL_SCHEMA_LABEL"), this.owner);
        }
        var5_6.add(this.nameCtl);
        var5_6.add(this.enabledCtl);
        var5_6.add(this.commentsCtl);
        return var5_6;
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = this.ownerCtl.getValue().get();
        String string3 = values.get(NAME);
        String string4 = values.get(COMMENTS);
        String string5 = values.get(ENABLED);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string2 != null) {
            string2 = string2.trim();
            object = new IdentifierImpl(string2);
            string2 = ((IdentifierImpl)object).getId();
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string3 != null) {
            string3 = string3.trim();
            object = new IdentifierImpl(string3);
            string3 = ((IdentifierImpl)object).getId();
        }
        object = new TreeMap();
        object.put(OWNER, string2);
        object.put(NAME, string3);
        object.put(COMMENTS, string4);
        object.put(ENABLED, string5 == null ? false : Boolean.valueOf(string5));
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(OWNER, ChainCreateAction.equals(string2, this.owner) == false);
        treeMap.put(NAME, ChainCreateAction.equals(string3, this.chain_name) == false);
        treeMap.put(COMMENTS, ChainCreateAction.equals(string4, this.comments) == false);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", object);
        treeMap2.put("changes", treeMap);
        String string6 = null;
        switch (operation) {
            case UPDATE: {
                string6 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_UPDATE", treeMap2);
                break;
            }
            case CREATE_LIKE: {
                string6 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_CREATE", treeMap2);
                break;
            }
            case CREATE_NEW: {
                string6 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_CREATE", treeMap2);
            }
        }
        return string6;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHCHAIN";
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newChainDialog_html");
    }

    protected boolean isCloseOnError() {
        return false;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10.2");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return ChainCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(ChainCreateAction.this.getDBObject().getDBVersion(), "CHAIN_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = ChainCreateAction.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("CHAIN_NAME");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    resultSetWrapper.close();
                }
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

