/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;

public abstract class ProgramPropertyPanelDBQuery
extends DatabaseQueryTask<Boolean> {
    protected String connectionName;
    protected String objectName;
    protected String objectOwner;
    protected String taskName;
    protected String query;

    public ProgramPropertyPanelDBQuery(String string, String string2, String string3, String string4, String string5, String string6) {
        super(DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_OPEN"), IRaptorTaskRunMode.IDE_STATUSBAR, false, false, true);
        this.connectionName = string;
        this.objectName = string2;
        this.objectOwner = string4;
        this.taskName = string5;
        this.query = string6;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getQuery() {
        return this.taskName;
    }

    protected Boolean doWork() throws TaskException {
        return this.doWorkQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doWorkQuery() throws TaskException {
        block12: {
            Connection connection;
            try {
                connection = DBUtil.getConnectionResolver().getConnection(this.getConnectionName());
            }
            catch (Exception exception) {
                return Boolean.FALSE;
            }
            DBUtil.getConnectionResolver().lock(connection);
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (this.objectName != null) {
                    hashMap.put("PROGRAM_NAME", this.objectName);
                }
                if (this.objectOwner != null) {
                    hashMap.put("OWNER", this.objectOwner);
                }
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.query, hashMap);
                if (resultSetWrapper == null) break block12;
                try {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.processRS(resultSet);
                }
                finally {
                    resultSetWrapper.close();
                }
            }
            catch (Throwable throwable) {
                throw new TaskException(throwable);
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
        }
        return Boolean.TRUE;
    }

    public abstract void processRS(ResultSet var1) throws SQLException;
}

