/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.window;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.IntervalActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.IdSqlComboBoxActionControl;
import oracle.dbtools.scheduler.panels.common.ActionDialogBase;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenActionControl;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;

public class WindowCreateAction
extends ActionDialogBase {
    public static final String ENABLED = "enabled";
    public static final String NAME = "window_name";
    public static final String RESOURCEPLAN = "resource_plan";
    public static final String DURATION = "duration";
    public static final String WINDOW_PRIORITY = "window_priority";
    public static final String WINDOW_WHEN = "window_when";
    public static final String COMMENTS = "comments";
    public static final String START_DATE = "start_date";
    public static final String END_DATE = "end_date";
    public static final String REPEAT_INTERVAL = "repeat_interval";
    public static final String SCHEDULESPEC = "schedule_spec";
    String window_name = null;
    String comments = null;
    String resourceplanValue = null;
    OraINTERVALDS durationValue = null;
    String windowPriorityValue = "LOW";
    Boolean enabled = true;
    ActionControl windowPriorityCtl;
    ActionControl durationCtl;
    ActionControl enabledCtl = null;
    ActionControl nameCtl = null;
    ActionControl commentsCtl = null;
    IdSqlComboBoxActionControl resourcePlanCtl = null;
    ScheduleWhenActionControl whenCtl = null;
    ScheduleWhenModel whenModel = null;

    public WindowCreateAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getTitle() {
        return SchedulerArb.getString("WINDOW_CREATE_TITLE");
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHWINDOW";
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    protected String getActionQuery(Connection connection, String string) {
        return Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)string);
    }

    private String getStringFromRS(OracleResultSet oracleResultSet, String string) {
        try {
            return oracleResultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private OraINTERVALDS getIntervalFromRS(OracleResultSet oracleResultSet, String string) {
        try {
            INTERVALDS iNTERVALDS = oracleResultSet.getINTERVALDS(string);
            String string2 = iNTERVALDS.stringValue();
            OraINTERVALDS oraINTERVALDS = OraINTERVALDS.getInstance((INTERVALDS)iNTERVALDS);
            string2 = oraINTERVALDS.toString();
            return oraINTERVALDS;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        String string;
        Operation operation = this.getOperation();
        this.whenModel = new ScheduleWhenModel();
        if (operation != Operation.CREATE_NEW) {
            String string2 = this.getObjectName();
            if (Connections.getInstance().lock(connection)) {
                string = null;
                try {
                    OracleResultSet oracleResultSet;
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_NAME", string2);
                    String string3 = this.getActionQuery(connection, "getWindowData");
                    string = object.executeOracleQuery(string3, hashMap);
                    if (string != null && (oracleResultSet = (OracleResultSet)string.getResultSet()).next()) {
                        this.window_name = this.getStringFromRS(oracleResultSet, "WINDOW_NAME");
                        this.comments = this.getStringFromRS(oracleResultSet, "COMMENTS");
                        this.resourceplanValue = this.getStringFromRS(oracleResultSet, "RESOURCE_PLAN");
                        this.durationValue = this.getIntervalFromRS(oracleResultSet, "DURATION");
                        this.windowPriorityValue = this.getStringFromRS(oracleResultSet, "WINDOW_PRIORITY");
                        this.enabled = Boolean.valueOf(oracleResultSet.getString("ENABLED"));
                        this.whenModel.initPropertiesFromRS(oracleResultSet, connection);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (string != null) {
                        string.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        this.nameCtl = new TextBoxActionControl(NAME, SchedulerArb.getString("WINDOW_WINDOW_NAME_LABEL"), this.window_name);
        if (operation == Operation.UPDATE) {
            this.nameCtl.setEditable(false);
        }
        this.commentsCtl = new TextBoxActionControl(COMMENTS, SchedulerArb.getString("WINDOW_COMMENTS_LABEL"), this.comments);
        string = this.getActionQuery(connection, "getResourcePlans");
        this.resourcePlanCtl = new IdSqlComboBoxActionControl(RESOURCEPLAN, SchedulerArb.getString("WINDOW_RESOURCE_PLAN_LABEL"), connection, string, null, "", true, false);
        this.resourcePlanCtl.setSelected(this.resourceplanValue);
        this.whenCtl = new ScheduleWhenActionControl(WINDOW_WHEN, null, CardLayoutPanel.Type.PLAIN, SchedulerArb.getString("WINDOW_WHEN_LABEL"), ScheduleWhenActionControl.FCOTarget.WINDOW, connection);
        this.whenModel.doInitialize();
        this.whenCtl.setModel(this.whenModel);
        this.durationCtl = new IntervalActionControl(DURATION, SchedulerArb.getString("WINDOW_DURATION_LABEL"), this.durationValue, true, false);
        this.windowPriorityCtl = new ComboBoxActionControl(WINDOW_PRIORITY, SchedulerArb.getString("WINDOW_PRIORITY_LABEL"), new String[]{"LOW", "HIGH"}, this.windowPriorityValue);
        this.enabledCtl = new BooleanCheckBoxActionControl(ENABLED, SchedulerArb.getString("WINDOW_ENABLED_LABEL"), this.enabled.booleanValue(), false);
        object = new ArrayList();
        ((ArrayList)object).add(this.nameCtl);
        ((ArrayList)object).add(this.enabledCtl);
        ((ArrayList)object).add(this.commentsCtl);
        ((ArrayList)object).add(this.resourcePlanCtl);
        ((ArrayList)object).add(this.durationCtl);
        ((ArrayList)object).add(this.windowPriorityCtl);
        ((ArrayList)object).add(this.whenCtl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = WindowCreateAction.checkNull(new IdentifierImpl(values.get(NAME)).getId(true));
        boolean bl = new Boolean(values.get(ENABLED));
        String string3 = WindowCreateAction.checkNull(values.get(RESOURCEPLAN));
        String string4 = WindowCreateAction.checkNull(values.get(DURATION));
        String string5 = WindowCreateAction.checkNull(values.get(WINDOW_PRIORITY));
        String string6 = WindowCreateAction.checkNull(values.get(COMMENTS));
        String string7 = WindowCreateAction.checkNull(values.get(WINDOW_WHEN, ScheduleWhenModel.Property.START_DATE.getValueName()));
        String string8 = WindowCreateAction.checkNull(values.get(WINDOW_WHEN, ScheduleWhenModel.Property.REPEAT_INTERVAL.getValueName()));
        String string9 = WindowCreateAction.checkNull(values.get(WINDOW_WHEN, ScheduleWhenModel.Property.END_DATE.getValueName()));
        String string10 = WindowCreateAction.checkNull(values.get(WINDOW_WHEN, ScheduleWhenModel.SCHEDULE_SPEC));
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put(NAME, string2);
        treeMap.put(ENABLED, bl);
        treeMap.put(RESOURCEPLAN, string3);
        treeMap.put(DURATION, string4);
        treeMap.put(WINDOW_PRIORITY, string5);
        if (string6 != null) {
            treeMap.put(COMMENTS, string6.replaceAll("'", "''"));
        }
        treeMap.put(END_DATE, string9);
        treeMap.put(START_DATE, string7);
        treeMap.put(REPEAT_INTERVAL, string8);
        treeMap.put(SCHEDULESPEC, string10);
        TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
        TreeMap<String, Boolean> treeMap3 = new TreeMap<String, Boolean>();
        if (operation != Operation.CREATE_NEW) {
            treeMap2.put(ENABLED, WindowCreateAction.equals(bl, this.enabled) == false);
            treeMap2.put(RESOURCEPLAN, WindowCreateAction.equals(this.stripQuotes(string3), this.resourceplanValue) == false);
            treeMap2.put(DURATION, WindowCreateAction.equals(string4, this.durationValue) == false);
            treeMap2.put(WINDOW_PRIORITY, WindowCreateAction.equals(string5, this.windowPriorityValue) == false);
            treeMap2.put(COMMENTS, WindowCreateAction.equals(string6, this.comments) == false);
            this.whenModel.getChanges(treeMap2);
            this.whenModel.getIsNull(treeMap3);
        }
        TreeMap<String, Object> treeMap4 = new TreeMap<String, Object>();
        treeMap4.put("model", treeMap);
        treeMap4.put("changes", treeMap2);
        treeMap4.put("isnull", treeMap3);
        String string11 = null;
        switch (operation) {
            case UPDATE: {
                string11 = dBMSSchedulerCodeGenerator.generate(string, "WINDOW_UPDATE", treeMap4);
                break;
            }
            case CREATE_LIKE: {
                if (string10 == null) {
                    string11 = dBMSSchedulerCodeGenerator.generate(string, "CREATE_WINDOW_BASIC", treeMap4);
                    break;
                }
                string11 = dBMSSchedulerCodeGenerator.generate(string, "CREATE_WINDOW_SCHEDULE", treeMap4);
                break;
            }
            case CREATE_NEW: {
                string11 = string10 == null ? dBMSSchedulerCodeGenerator.generate(string, "CREATE_WINDOW_BASIC", treeMap4) : dBMSSchedulerCodeGenerator.generate(string, "CREATE_WINDOW_SCHEDULE", treeMap4);
            }
        }
        return string11;
    }

    private String stripQuotes(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    private static String checkNull(String string) {
        String string2 = string;
        if (string != null) {
            if (string.trim().length() == 0 || string.trim().equalsIgnoreCase("null") || string.trim().equalsIgnoreCase("\"null\"")) {
                return null;
            }
            if (string.equals("\"\"")) {
                return null;
            }
        }
        return string2;
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return Boolean.TRUE;
        }
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    protected boolean isCloseOnError() {
        return false;
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10.1");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        Operation operation = this.getOperation();
        if (operation == Operation.CREATE_NEW) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newWindowDialog_html");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_updateWindowDialog_html");
        }
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return WindowCreateAction.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(WindowCreateAction.this.getDBObject().getDBVersion(), "WINDOW_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector;
            block9: {
                vector = new Vector<String>();
                Connection connection = WindowCreateAction.this.getDBObject().getConnection();
                DBUtil.getConnectionResolver().lock(connection);
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(), null);
                    if (resultSetWrapper == null) break block9;
                    try {
                        ResultSet resultSet = resultSetWrapper.getResultSet();
                        while (resultSet.next()) {
                            String string = resultSet.getString("OWNER") + "." + resultSet.getString("WINDOW_NAME");
                            vector.add(string);
                        }
                    }
                    finally {
                        resultSetWrapper.close();
                    }
                }
                catch (Throwable throwable) {
                    throw new TaskException(throwable);
                }
                finally {
                    DBUtil.getConnectionResolver().unlock(connection);
                }
            }
            return vector;
        }
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

