/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.wizards.job;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.actions.ActionValues;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_AdvancedProperties;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_Destination;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_EditProperties;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_JobArguments;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_Notification;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobScriptGenerator;
import oracle.dbtools.scheduler.wizards.AbstractModelObject;
import oracle.dbtools.scheduler.wizards.TaskResult;
import oracle.javatools.db.DBException;

public class JobWizardModel
extends AbstractModelObject {
    private final NewJobModel jobModel;
    private final ArrayList<ActionDialogTab> tabs;
    private final NewJobCreateActionDialogTab_EditProperties editTab;
    private final NewJobCreateActionDialogTab_Destination destinationTab;
    private final NewJobCreateActionDialogTab_JobArguments jobArgumentsTab;
    private final NewJobCreateActionDialogTab_Notification notificationTab;
    private final NewJobCreateActionDialogTab_AdvancedProperties advancedPropertiesTab;
    JDialog dialog;
    ActionControl editPanel;
    ActionControl destinationPanel;
    ActionControl jobArgumentsPanel;
    ActionControl notificationPanel;
    ActionControl advancedPropertiesPanel;
    private boolean initialized = false;
    private ScriptProcessor _scriptProcessor;
    private boolean _processScriptCancelled = false;

    public JobWizardModel(NewJobModel newJobModel) {
        this.jobModel = newJobModel;
        this.tabs = new ArrayList();
        this.editTab = new NewJobCreateActionDialogTab_EditProperties(null, null, newJobModel);
        this.tabs.add(this.editTab);
        if (newJobModel.FeatureMin111()) {
            this.destinationTab = new NewJobCreateActionDialogTab_Destination("job_destination_panel", null, newJobModel);
            this.tabs.add(this.destinationTab);
        } else {
            this.destinationTab = null;
        }
        this.jobArgumentsTab = new NewJobCreateActionDialogTab_JobArguments("job_arguments_panel", null, newJobModel);
        this.tabs.add(this.jobArgumentsTab);
        if (newJobModel.FeatureMin112()) {
            this.notificationTab = new NewJobCreateActionDialogTab_Notification("job_email_notification_panel", null, newJobModel);
            this.tabs.add(this.notificationTab);
        } else {
            this.notificationTab = null;
        }
        this.advancedPropertiesTab = new NewJobCreateActionDialogTab_AdvancedProperties("job_advanced_properties_panel", null, newJobModel);
        this.tabs.add(this.advancedPropertiesTab);
        this.editPanel = null;
        this.destinationPanel = null;
        this.jobArgumentsPanel = null;
        this.notificationPanel = null;
        this.advancedPropertiesPanel = null;
        this.dialog = null;
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }

    public void setConnection(Connection connection) {
        this.jobModel.setConnection(connection);
    }

    public Connection getConnection() {
        return this.jobModel.getConnection();
    }

    public NewJobModel getJobModel() {
        return this.jobModel;
    }

    public void cancelProcessScript() {
        this._processScriptCancelled = true;
    }

    public void processScript(String string, TaskResult taskResult) {
        boolean bl = false;
        String string2 = null;
        Throwable throwable = null;
        this._processScriptCancelled = false;
        try {
            String string3 = this.jobModel.getDBObject().getConnectionName();
            Connection connection = Connections.getInstance().getConnection(string3);
            Properties properties = Connections.getInstance().getConnectionInfo(string3);
            ScriptProcessor scriptProcessor = this.getScriptProcessor();
            scriptProcessor.processScript((ScriptProcessorContext)new ScriptProcessorContextImpl(this.dialog, connection, string3, properties, string, this.getScript()));
            string2 = UiResources.getString((String)"SQL_SUCCESS");
            bl = true;
        }
        catch (DBException dBException) {
            string2 = UiResources.getString((String)"ACCESS_ERROR");
            throwable = dBException;
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        catch (Exception exception) {
            string2 = UiResources.getString((String)"SQL_FAILURE");
            throwable = exception;
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        taskResult.setStatus(bl);
        taskResult.setMessage(string2);
        taskResult.setException((Exception)throwable);
    }

    public String getScript() {
        return new NewJobScriptGenerator(this.jobModel).getScript(this.getValue());
    }

    public String getSummary() {
        return new NewJobScriptGenerator(this.jobModel).getSummary(this.getValue());
    }

    protected ScriptProcessor getScriptProcessor() {
        if (this._scriptProcessor == null) {
            this._scriptProcessor = this.createScriptProcessor();
        }
        return this._scriptProcessor;
    }

    protected ScriptProcessor createScriptProcessor() {
        return new SQLScriptProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (!this.initialized) {
            try {
                this.editTab.initialize(this.getConnection());
                this.editPanel = this.editTab.getControl();
                if (this.destinationTab != null) {
                    this.destinationTab.initialize(this.getConnection());
                    this.destinationPanel = this.destinationTab.getControl();
                    this.editTab.addListener(this.destinationTab);
                }
                if (this.jobArgumentsTab != null) {
                    this.jobArgumentsTab.initialize(this.getConnection());
                    this.jobArgumentsPanel = this.jobArgumentsTab.getControl();
                    this.editTab.addListener(this.jobArgumentsTab);
                }
                if (this.notificationTab != null) {
                    this.notificationTab.initialize(this.getConnection());
                    this.notificationPanel = this.notificationTab.getControl();
                    this.editTab.addListener(this.notificationTab);
                }
                if (this.advancedPropertiesTab != null) {
                    this.advancedPropertiesTab.initialize(this.getConnection());
                    this.advancedPropertiesPanel = this.advancedPropertiesTab.getControl();
                    this.editTab.addListener(this.advancedPropertiesTab);
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    public Values getValue() {
        return new Values();
    }

    protected String getScriptProcessorParameter(String string) {
        return null;
    }

    class ScriptProcessorContextImpl
    implements ScriptProcessorContext {
        private Component _parent;
        private Connection _connection;
        private String _cName;
        private Properties _connectionProperties;
        private String _actionTitle;
        private String _script;

        ScriptProcessorContextImpl(Component component, Connection connection, String string, Properties properties, String string2, String string3) {
            this._parent = component;
            this._connection = connection;
            this._cName = string;
            this._connectionProperties = properties;
            this._actionTitle = string2;
            this._script = string3;
        }

        public Component getParent() {
            return this._parent;
        }

        public String getConnectionName() {
            return this._cName;
        }

        public Connection getConnection() {
            return this._connection;
        }

        public Properties getConnectionProperties() {
            return this._connectionProperties;
        }

        public String getActionTitle() {
            return this._actionTitle;
        }

        public String getScript() {
            return this._script;
        }

        public String getParameter(String string) {
            return JobWizardModel.this.getScriptProcessorParameter(string);
        }
    }

    public class Values
    extends ActionValues<ActionValuesLookup> {
        Values() {
            for (ActionDialogTab actionDialogTab : JobWizardModel.this.tabs) {
                String string = actionDialogTab.getName();
                ActionDialog.Lookup lookup = actionDialogTab.getLookup();
                if (string == null) {
                    this._lookup = lookup;
                    continue;
                }
                this._tabLookupMap.put(actionDialogTab.getName(), lookup);
            }
        }
    }
}

