/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.QueryResult;
import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexFileQueryHandler
extends QueryHandler {
    private URL _url;
    private View _view;
    private char[] _alphabet;
    private long[] _alphaOffsets;
    private long _eowOffset;
    private long _fsOffset;
    private String _productTitle;
    private int _version;
    private String _encoding;
    private boolean _fileCase;
    private boolean _scoreAvailable;
    private boolean _positionsAvailable;
    private boolean _titlesAvailable;
    private String _rootPath;
    private String _sourceIdentifier;
    private ResultObjectContainerType _defaultContainerType = ResultObjectContainerType.LINKED_HASH_MAP;
    private final ResultObjectMap _emptyResultObjectMap = new ResultObjectEmptyMap();
    private boolean _stopSearch = false;
    private boolean _needToParseHeader = true;
    private static final int VERSION_10 = 10;
    private static final int VERSION_11 = 11;
    private static final int VERSION_20 = 20;
    private static final int VERSION_21 = 21;
    static final String INDEX_VERSION = "OIN-INDEX-VERSION";
    static final String CHARACTER_SET = "CHARACTER-SET";
    static final String PRODUCT_TITLE = "PRODUCT-TITLE";
    static final String CASESENSITIVE = "CASESENSITIVE";
    static final String TITLES = "TITLES";
    static final String BLOCK_SIZE = "BLOCK-SIZE";
    static final String SCORES = "SCORES";
    static final String POSITIONS = "POSITIONS";
    static final String ROOT_PATH = "ROOTPATH";
    static final String TRUE = "TRUE";

    public static IndexFileQueryHandler getInstance(View view, String string, URL uRL) {
        IndexFileQueryHandler indexFileQueryHandler = null;
        try {
            indexFileQueryHandler = new IndexFileQueryHandler(view, string, uRL);
            return indexFileQueryHandler;
        }
        catch (Exception exception) {
            System.out.println("Invalid IDX file URL.  IOException when accessing " + uRL.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public URL getIndexFileUrl() {
        return this._url;
    }

    @Override
    public void stopSearch() {
        this._stopSearch = true;
    }

    @Override
    public boolean supportsCaseSensitiveSearches() {
        return true;
    }

    @Override
    public Set getSupportedSources() {
        if (this._sourceIdentifier == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(this._sourceIdentifier);
    }

    public String productTitle() {
        return this._productTitle;
    }

    @Override
    public synchronized List executeQuery(String[] stringArray, boolean bl, boolean bl2, Set set) throws SearchException {
        this._stopSearch = false;
        this._checkSources(set);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        ResultObjectMap resultObjectMap = null;
        try {
            resultObjectMap = this._executeStringQuery(stringArray, bl, bl2);
        }
        catch (SearchInterruptedError searchInterruptedError) {
            return Collections.EMPTY_LIST;
        }
        if (resultObjectMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResultObject> arrayList = resultObjectMap.toList();
        if (this._scoreAvailable && !arrayList.isEmpty()) {
            IndexFileQueryHandler._quickSort(arrayList, 0, arrayList.size() - 1);
        }
        return arrayList;
    }

    @Override
    public synchronized List executeQuery(SearchExpression searchExpression, Set set) throws SearchException {
        this._stopSearch = false;
        this._checkSources(set);
        if (this._needToParseHeader) {
            this._parseHeader();
        }
        ResultObjectMap resultObjectMap = null;
        try {
            resultObjectMap = this._executeBooleanQuery(searchExpression);
        }
        catch (SearchInterruptedError searchInterruptedError) {
            return Collections.EMPTY_LIST;
        }
        if (resultObjectMap.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResultObject> arrayList = resultObjectMap.toList();
        if (this._scoreAvailable && !arrayList.isEmpty()) {
            IndexFileQueryHandler._quickSort(arrayList, 0, arrayList.size() - 1);
        }
        return arrayList;
    }

    private void _checkSources(Set set) throws SearchException {
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                if (string.equals(this._sourceIdentifier)) continue;
                throw new SearchException("IndexFileQueryHandler: " + this._url + "\n" + "Called with unsupported source: " + string);
            }
        }
    }

    private void _checkStopSearch() {
        if (this._stopSearch) {
            throw new SearchInterruptedError("Search Interrupted");
        }
    }

    private ResultObjectMap _executeStringQuery(String[] stringArray, boolean bl, boolean bl2) throws SearchException {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return this._emptyResultObjectMap;
        }
        List<StringQuery> list = this._processQueryWords(stringArray);
        Iterator<StringQuery> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return this._emptyResultObjectMap;
        }
        StringQuery stringQuery = iterator.next();
        ResultObjectMap resultObjectMap = this._processSingleStringQuery(stringQuery, bl, !this._fileCase || bl2);
        int n2 = n = bl ? 1 : 2;
        while (iterator.hasNext()) {
            stringQuery = iterator.next();
            ResultObjectMap resultObjectMap2 = this._processSingleStringQuery(stringQuery, bl, !this._fileCase || bl2);
            this._combineResults(resultObjectMap, resultObjectMap2, n);
        }
        return resultObjectMap;
    }

    private ResultObjectMap _processSingleStringQuery(StringQuery stringQuery, boolean bl, boolean bl2) throws SearchException {
        InputStream inputStream = null;
        try {
            inputStream = this._openInputStream(this._url);
        }
        catch (Exception exception) {
            this._closeInputStream(inputStream);
            this._throwSearchException(exception);
        }
        InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream);
        if (stringQuery.isWildcardQuery()) {
            stringQuery.removeWildcardRedundancies();
        }
        String[] stringArray = stringQuery.getSortedUniqueWordsAsArray();
        LinkedList<IndexWord> linkedList = new LinkedList<IndexWord>();
        int n = 0;
        try {
            n = this._findMatchingIndexWords(inputStreamWrapper, stringArray, bl, bl2, linkedList);
        }
        catch (Exception exception) {
            this._closeInputStream(inputStream);
            this._throwSearchException(exception);
        }
        if (n == 0 || bl && n < stringArray.length) {
            this._closeInputStream(inputStream);
            return this._emptyResultObjectMap;
        }
        ResultObjectMap resultObjectMap = null;
        try {
            resultObjectMap = this._getResults(inputStreamWrapper, linkedList, stringArray, bl);
        }
        catch (Exception exception) {
            this._closeInputStream(inputStream);
            this._throwSearchException(exception);
        }
        if (stringQuery.isExactPhraseQuery()) {
            this._doExactPhraseMatching(resultObjectMap, stringQuery);
        } else {
            this._adjustScoresUsingPositionData(resultObjectMap);
        }
        if (resultObjectMap.isEmpty()) {
            this._closeInputStream(inputStream);
            return resultObjectMap;
        }
        try {
            inputStreamWrapper.skipToOffset(this._fsOffset);
            this._readFileNames(inputStreamWrapper, resultObjectMap, null);
        }
        catch (Exception exception) {
            this._closeInputStream(inputStream);
            this._throwSearchException(exception);
        }
        this._closeInputStream(inputStream);
        return resultObjectMap;
    }

    private int _findMatchingIndexWords(InputStreamWrapper inputStreamWrapper, String[] stringArray, boolean bl, boolean bl2, List<IndexWord> list) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[1000];
        byte[] byArray2 = this._version < 20 ? new byte[512] : new byte[255];
        boolean[] blArray = new boolean[stringArray.length];
        blArray[0] = false;
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(stringArray.length);
        int n4 = stringArray[0].charAt(0);
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            blArray[n2] = false;
            n = stringArray[n2].charAt(0);
            if (n == n4) continue;
            arrayList.add(n2);
            n4 = n;
        }
        arrayList.add(stringArray.length);
        n2 = bl2 ? 1 : 2;
        for (n = 0; n < n2; ++n) {
            int n5 = 0;
            for (Integer n6 : arrayList) {
                char c = !bl2 && n == 0 ? Character.toUpperCase(stringArray[n5].charAt(0)) : stringArray[n5].charAt(0);
                int n7 = this._getAlphabetIndex(c);
                if (n7 == -1) {
                    if (bl) {
                        if (n2 == 1) {
                            return n3;
                        }
                        if (n == n2 - 1) {
                            for (int i = n5; i < n6; ++i) {
                                if (blArray[i]) continue;
                                return n3;
                            }
                        }
                    }
                    n5 = n6;
                    continue;
                }
                long l = this._alphaOffsets[n7];
                if (inputStreamWrapper.getPosition() > l) {
                    n5 = n6;
                    continue;
                }
                long l2 = n7 == this._alphabet.length - 1 ? this._eowOffset : this._alphaOffsets[n7 + 1];
                inputStreamWrapper.skipToOffset(l);
                int n8 = (int)(l2 - l);
                int n9 = 0;
                boolean bl3 = false;
                while (!bl3) {
                    int n10;
                    int n11;
                    int n12 = byArray.length - n9;
                    if (n8 <= n12) {
                        n11 = n8;
                        bl3 = true;
                    } else {
                        n11 = n12;
                        n8 -= n11;
                    }
                    inputStreamWrapper.read(byArray, n9, n11);
                    n11 += n9;
                    int n13 = 0;
                    int n14 = 0;
                    String string = null;
                    String string2 = null;
                    while (n5 < n6) {
                        int n15;
                        n10 = 0;
                        n14 = n13;
                        if (this._version < 20) {
                            n15 = 1;
                            do {
                                if (n13 >= n11) {
                                    n15 = 0;
                                    break;
                                }
                                byArray2[n10++] = byArray[n13++];
                            } while (byArray2[n10 - 1] != 32);
                            if (n15 == 0) break;
                            string = new String(byArray2, 0, n10 - 1);
                        } else {
                            if (n13 >= n11) break;
                            if ((n15 = byArray[n13++]) < 0) {
                                n15 = 256 + n15;
                            }
                            boolean bl4 = true;
                            while (n15 != 0) {
                                if (n13 >= n11) {
                                    bl4 = false;
                                    break;
                                }
                                byArray2[n10++] = byArray[n13++];
                                --n15;
                            }
                            if (!bl4) break;
                            try {
                                string = new String(byArray2, 0, n10, this._encoding);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                string = new String(byArray2, 0, n10);
                            }
                        }
                        if (n13 + 3 >= n11) break;
                        if (!bl2) {
                            string2 = string.toLowerCase();
                        }
                        long l3 = -1L;
                        for (int i = n5; i < n6; ++i) {
                            int n16 = this._searchWordCompareToIndexWord(stringArray[i], string, string2);
                            if (n16 < 0) {
                                if (i == n5) {
                                    ++n5;
                                }
                                if (!bl || n != n2 - 1 || blArray[i]) continue;
                                return n3;
                            }
                            if (n16 != 0) continue;
                            if (l3 == -1L) {
                                l3 = 0L;
                                for (int j = 0; j < 4; ++j) {
                                    int n17 = byArray[n13 + j];
                                    if (n17 < 0) {
                                        n17 = 256 + n17;
                                    }
                                    l3 |= (long)(n17 << 8 * (3 - j));
                                }
                            }
                            if (!blArray[i]) {
                                blArray[i] = true;
                                ++n3;
                            }
                            list.add(new IndexWord(l3, (byte)i));
                        }
                        n13 += 4;
                    }
                    if (n5 == n6 || bl3) break;
                    n10 = 0;
                    while (n14 < n11) {
                        byArray[n10] = byArray[n14++];
                        ++n10;
                    }
                    n9 = n10;
                }
                this._checkStopSearch();
                n5 = n6;
            }
        }
        return n3;
    }

    private void _throwSearchException(Exception exception) throws SearchException {
        throw new SearchException("IndexFileQueryHandler: " + this._url + "\n" + "Error encountered executing search: " + exception.getMessage(), exception);
    }

    private void _closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int _searchWordCompareToIndexWord(String string, String string2, String string3) {
        int n;
        Character c;
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        int n6 = n4 = n5 < (n3 = string2.length()) ? n5 : n3;
        if (string3 == null) {
            int n7;
            Character c2;
            int n8;
            for (n8 = 1; n8 < n4 && (c2 = Character.valueOf(string.charAt(n8))).charValue() != '*'; ++n8) {
                n7 = c2.compareTo(Character.valueOf(string2.charAt(n8)));
                if (n7 == 0) continue;
                return n7;
            }
            if (n8 == n4) {
                if (n3 >= n5) {
                    return n5 - n3;
                }
                if (string.charAt(n8) != '*') {
                    return 1;
                }
            }
            if ((n7 = n5 - ++n8) == 0) {
                return 0;
            }
            if (n3 >= n5 - 1) {
                --n3;
                --n5;
                int n9 = 0;
                while (n9 < n7) {
                    c2 = Character.valueOf(string.charAt(n5));
                    if (!c2.equals(Character.valueOf(string2.charAt(n3)))) {
                        return 1;
                    }
                    ++n9;
                    --n3;
                    --n5;
                }
                return 0;
            }
            return 1;
        }
        boolean bl = true;
        int n10 = 0;
        for (n2 = 1; n2 < n4 && (c = Character.valueOf(string.charAt(n2))).charValue() != '*'; ++n2) {
            if (n10 == 0) {
                n10 = c.compareTo(Character.valueOf(string2.charAt(n2)));
            }
            if (bl = c.equals(Character.valueOf(string3.charAt(n2)))) continue;
            return n10;
        }
        if (n2 == n4) {
            if (n3 == n5) {
                return 0;
            }
            if (n3 > n5) {
                return n10 != 0 ? n10 : -1;
            }
            if (string.charAt(n2) != '*') {
                return n10 != 0 ? n10 : 1;
            }
        }
        if ((n = n5 - ++n2) == 0) {
            return 0;
        }
        if (n3 >= n5 - 1) {
            --n3;
            --n5;
            int n11 = 0;
            while (n11 < n) {
                c = Character.valueOf(string.charAt(n5));
                if (!c.equals(Character.valueOf(string3.charAt(n3)))) {
                    return n10 != 0 ? n10 : 1;
                }
                ++n11;
                --n3;
                --n5;
            }
            return 0;
        }
        return n10 != 0 ? n10 : 1;
    }

    private void _adjustScoresUsingPositionData(ResultObjectMap resultObjectMap) throws SearchException {
        if (this._positionsAvailable && !resultObjectMap.isEmpty()) {
            for (ResultObject resultObject : resultObjectMap) {
                LinkedHashMap<String, List<int[]>> linkedHashMap = resultObject.getPositionDataMap();
                if (linkedHashMap != null && linkedHashMap.size() > 1) {
                    int n = 0;
                    int[] nArray = new int[resultObject.getTotalPositionCount()];
                    for (String string : linkedHashMap.keySet()) {
                        for (int[] nArray2 : linkedHashMap.get(string)) {
                            if (nArray2.length <= 0) continue;
                            System.arraycopy(nArray2, 0, nArray, n, nArray2.length);
                            n += nArray2.length;
                        }
                    }
                    if (nArray.length > 0) {
                        double d = 0.0;
                        Arrays.sort(nArray);
                        int n2 = 0;
                        block8: for (int i = 1; i < nArray.length; ++i) {
                            int n3 = nArray[i] - nArray[i - 1];
                            switch (n3) {
                                case 1: {
                                    d = d + 4.0 + 1.5 * (double)n2;
                                    if (nArray[i] < 25) {
                                        d = nArray[i] < 10 ? (nArray[i] < 5 ? d + 15.0 + (double)(5 * n2) : d + 10.0 + (double)(5 * n2)) : (d += 5.0);
                                    }
                                    ++n2;
                                    continue block8;
                                }
                                case 2: {
                                    n2 = 0;
                                    d += 2.0;
                                    if (nArray[i] >= 25) continue block8;
                                    if (nArray[i] < 10) {
                                        if (nArray[i] < 5) {
                                            d += 10.0;
                                            continue block8;
                                        }
                                        d += 7.0;
                                        continue block8;
                                    }
                                    d += 3.0;
                                    continue block8;
                                }
                                case 3: {
                                    n2 = 0;
                                    d += 0.75;
                                    continue block8;
                                }
                                default: {
                                    n2 = 0;
                                }
                            }
                        }
                        resultObject.setHitNumber(resultObject.getHitNumber() + (int)d);
                    }
                }
                this._checkStopSearch();
            }
        }
    }

    private void _doExactPhraseMatching(ResultObjectMap resultObjectMap, StringQuery stringQuery) throws SearchException {
        if (this._positionsAvailable && !resultObjectMap.isEmpty()) {
            String[] stringArray = stringQuery.getExactPhraseWordsAsArray();
            for (ResultObject resultObject : resultObjectMap) {
                LinkedHashMap<String, List<int[]>> linkedHashMap = resultObject.getPositionDataMap();
                if (linkedHashMap != null && resultObject.getTotalPositionCount() > 0) {
                    Set<String> set = linkedHashMap.keySet();
                    if (set.size() == stringQuery.getSortedUniqueWords().size()) {
                        int n;
                        int n2;
                        int n3 = 0;
                        int[] nArray = new int[resultObject.getTotalPositionCount()];
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            for (int[] nArray2 : linkedHashMap.get(stringArray[n2])) {
                                if (nArray2.length <= 0) continue;
                                for (n = 0; n < nArray2.length; ++n) {
                                    if (n3 == nArray.length) {
                                        int[] nArray3 = new int[nArray.length + (nArray2.length - n)];
                                        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                                        nArray = nArray3;
                                    }
                                    nArray[n3] = nArray2[n] - n2;
                                    ++n3;
                                }
                            }
                        }
                        Arrays.sort(nArray);
                        n2 = 1;
                        int n4 = 0;
                        int n5 = 0;
                        for (n = 1; n < nArray.length; ++n) {
                            if (nArray[n] == nArray[n - 1]) {
                                if (++n2 != stringArray.length) continue;
                                ++n4;
                                if (nArray[n] >= 25) continue;
                                if (nArray[n] < 10) {
                                    if (nArray[n] < 5) {
                                        n5 += 20;
                                        continue;
                                    }
                                    n5 += 15;
                                    continue;
                                }
                                n5 += 10;
                                continue;
                            }
                            n2 = 1;
                        }
                        if (n4 > 0) {
                            double d = (double)resultObject.getHitNumber() * 0.25 + (double)(n4 * stringArray.length * 5) + (double)n5;
                            resultObject.setHitNumber((int)Math.round(d));
                        } else {
                            resultObject.useful = false;
                        }
                    } else {
                        resultObject.useful = false;
                    }
                }
                this._checkStopSearch();
            }
            this._filterResults(resultObjectMap);
        }
    }

    private ResultObjectMap _executeBooleanQuery(SearchExpression searchExpression) throws SearchException {
        ResultObjectMap resultObjectMap;
        ResultObjectMap resultObjectMap2;
        if (searchExpression.getOperator() == 0) {
            return this._executeStringQuery(searchExpression.getData(), true, searchExpression.isCaseSensitive());
        }
        SearchExpression searchExpression2 = searchExpression.getExpression1();
        ResultObjectMap resultObjectMap3 = resultObjectMap2 = searchExpression2 != null ? this._executeBooleanQuery(searchExpression2) : this._emptyResultObjectMap;
        if (resultObjectMap2.isEmpty() && searchExpression.getOperator() == 4) {
            return this._emptyResultObjectMap;
        }
        if (searchExpression.getOperator() == 3) {
            return this._evaluateNOT(resultObjectMap2);
        }
        SearchExpression searchExpression3 = searchExpression.getExpression2();
        ResultObjectMap resultObjectMap4 = resultObjectMap = searchExpression3 != null ? this._executeBooleanQuery(searchExpression3) : this._emptyResultObjectMap;
        if (resultObjectMap.isEmpty() && searchExpression.getOperator() == 1 && searchExpression3 instanceof StringExpression) {
            List<StringQuery> list;
            StringExpression stringExpression = (StringExpression)searchExpression3;
            String[] stringArray = stringExpression.getData();
            if (stringArray != null && (list = this._processQueryWords(stringArray)).isEmpty()) {
                return resultObjectMap2;
            }
            return this._emptyResultObjectMap;
        }
        if (resultObjectMap2.isEmpty() && searchExpression.getOperator() == 1 && searchExpression2 instanceof StringExpression) {
            List<StringQuery> list;
            StringExpression stringExpression = (StringExpression)searchExpression2;
            String[] stringArray = stringExpression.getData();
            if (stringArray != null && (list = this._processQueryWords(stringArray)).isEmpty()) {
                return resultObjectMap;
            }
            return this._emptyResultObjectMap;
        }
        return this._combineResults(resultObjectMap2, resultObjectMap, searchExpression.getOperator());
    }

    @Deprecated
    public List<ResultObject> combineResultsLists(List<ResultObject> list, List<ResultObject> list2, int n) {
        if (n == 1) {
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>();
            block0: for (ResultObject resultObject : list) {
                for (ResultObject resultObject2 : list2) {
                    if (resultObject.fileno != resultObject2.fileno) continue;
                    arrayList.add(resultObject);
                    resultObject.setHitNumber(resultObject.getHitNumber() + resultObject2.getHitNumber());
                    resultObject.addPositionData(resultObject2.getPositionDataMap());
                    continue block0;
                }
            }
            return arrayList;
        }
        if (n == 2) {
            if (list.isEmpty()) {
                return list2;
            }
            if (list2.isEmpty()) {
                return list;
            }
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>(list.size() + list2.size());
            arrayList.addAll(list);
            for (ResultObject resultObject : list2) {
                boolean bl = false;
                for (ResultObject resultObject3 : list) {
                    if (resultObject.fileno != resultObject3.fileno) continue;
                    bl = true;
                    resultObject3.setHitNumber(resultObject3.getHitNumber() + resultObject.getHitNumber());
                    resultObject3.addPositionData(resultObject.getPositionDataMap());
                    break;
                }
                if (bl) continue;
                arrayList.add(resultObject);
            }
            return arrayList;
        }
        if (n == 4) {
            if (list2.isEmpty()) {
                return list;
            }
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>(list.size());
            for (ResultObject resultObject : list) {
                boolean bl = false;
                for (ResultObject resultObject4 : list2) {
                    if (resultObject.fileno != resultObject4.fileno) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(resultObject);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private String _bytesToString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this._encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    private IndexFileQueryHandler(View view, String string, URL uRL) {
        this._url = uRL;
        this._view = view;
        String string2 = this._view.getTitle();
        this._sourceIdentifier = string2 != null && string2.length() > 0 ? string2 : null;
    }

    private InputStream _openInputStream(URL uRL) throws IOException {
        InputStream inputStream = null;
        if (uRL.getProtocol().equals("file")) {
            try {
                inputStream = new FileInputStream(uRL.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    private void _handleCorruptIndexFile(String string) throws SearchException {
        throw new SearchException("IndexFileQueryHandler:  " + this._url + "\n" + "Corrupt IDX File Encountered:  " + string);
    }

    private void _parseHeader() throws SearchException {
        this._needToParseHeader = false;
        InputStream inputStream = null;
        try {
            inputStream = this._openInputStream(this._url);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream);
            String string = inputStreamWrapper.readLine();
            if (!string.startsWith(INDEX_VERSION)) {
                this._handleCorruptIndexFile("Missing Index Version");
            }
            if (string.equals("OIN-INDEX-VERSION 1.0")) {
                this._version = 10;
            } else if (string.equals("OIN-INDEX-VERSION 1.1")) {
                this._version = 11;
            } else if (string.equals("OIN-INDEX-VERSION 2.0")) {
                this._version = 20;
            } else if (string.equals("OIN-INDEX-VERSION 2.1")) {
                this._version = 21;
            } else {
                this._handleCorruptIndexFile("Unsupported Index Version");
            }
            string = inputStreamWrapper.readLine();
            if (this._version >= 20) {
                this._encoding = string.substring(CHARACTER_SET.length() + 1);
            }
            if (!(string = inputStreamWrapper.readLine()).startsWith(PRODUCT_TITLE)) {
                this._handleCorruptIndexFile("Missing Product Title");
            }
            this._productTitle = string.substring(PRODUCT_TITLE.length() + 1);
            string = inputStreamWrapper.readLine();
            if (!string.startsWith(TITLES)) {
                this._handleCorruptIndexFile("Missing Titles Marker");
            }
            this._titlesAvailable = string.endsWith(TRUE);
            string = inputStreamWrapper.readLine();
            if (!string.startsWith(CASESENSITIVE)) {
                this._handleCorruptIndexFile("Missing Case Sensitive Marker");
            }
            this._fileCase = string.endsWith(TRUE);
            inputStreamWrapper.readLine();
            if (this._version > 10) {
                string = inputStreamWrapper.readLine();
                if (!string.startsWith(SCORES)) {
                    this._handleCorruptIndexFile("Missing Scores Marker");
                }
                this._scoreAvailable = string.endsWith(TRUE);
            }
            if (this._version >= 21) {
                string = inputStreamWrapper.readLine();
                if (!string.startsWith(POSITIONS)) {
                    this._handleCorruptIndexFile("Missing Positions Marker");
                }
                this._positionsAvailable = string.endsWith(TRUE);
            }
            if (!(string = inputStreamWrapper.readLine()).startsWith(ROOT_PATH)) {
                this._handleCorruptIndexFile("Missing Root Path");
            }
            this._rootPath = string.substring(ROOT_PATH.length() + 1);
            int n = inputStreamWrapper.readUb2();
            this._alphabet = new char[n];
            this._alphaOffsets = new long[n];
            byte[] byArray = new byte[16];
            for (int i = 0; i < n; ++i) {
                if (this._version < 20) {
                    this._alphabet[i] = (char)inputStreamWrapper.readUb1();
                } else {
                    int n2 = inputStreamWrapper.readUb1();
                    if (n2 > 16) {
                        throw new SearchException("IndexFileQueryHandler:  " + this._url + "\n" + "Oracle Help Indexer does not support " + "encodings requiring more than 16 bytes " + "to specify a character.  This IDX file" + "may be corrupt.");
                    }
                    for (int j = 0; j < n2; ++j) {
                        byArray[j] = (byte)inputStreamWrapper.readUb1();
                    }
                    String string2 = new String(byArray, 0, n2, this._encoding);
                    this._alphabet[i] = string2.charAt(0);
                }
                this._alphaOffsets[i] = inputStreamWrapper.readUb4();
            }
            this._eowOffset = inputStreamWrapper.readUb4();
            this._fsOffset = inputStreamWrapper.readUb4();
        }
        catch (IOException iOException) {
            throw new SearchException("Error encountered parsing IDX file header:  " + this._url + iOException.getMessage(), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private int _getAlphabetIndex(char c) {
        for (int i = 0; i < this._alphabet.length; ++i) {
            if (this._alphabet[i] != c) continue;
            return i;
        }
        return -1;
    }

    private void _readFileIndicesDoUnion(InputStreamWrapper inputStreamWrapper, ResultObjectMap resultObjectMap, String[] stringArray, int[] nArray) throws IOException {
        int n;
        int n2 = 0;
        int[] nArray2 = null;
        while ((n = inputStreamWrapper.readUb2()) != 65535) {
            ResultObject resultObject;
            if (this._scoreAvailable) {
                n2 = inputStreamWrapper.readUb1();
            }
            if (this._positionsAvailable) {
                nArray2 = this._readPositionData(inputStreamWrapper);
            }
            if ((resultObject = resultObjectMap.get(n)) == null) {
                resultObject = new ResultObject();
                resultObject.view = this._view;
                resultObject.fileno = n;
                resultObjectMap.put(resultObject);
            }
            for (int n3 : nArray) {
                resultObject.setHitNumber(resultObject.getHitNumber() + n2);
                resultObject.addPositionData(stringArray[n3], nArray2);
            }
        }
    }

    private ResultObjectMap _getResults(InputStreamWrapper inputStreamWrapper, List<IndexWord> list, String[] stringArray, boolean bl) throws IOException {
        Object object;
        ResultObjectMap resultObjectMap = this._createResultObjectMap();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            object = list.get(i);
            inputStreamWrapper.skipToOffset(((IndexWord)object).offset);
            for (n2 = i + 1; n2 < n && list.get((int)n2).offset == ((IndexWord)object).offset; ++n2) {
            }
            int n3 = n2 - i;
            int[] nArray = new int[n3];
            int n4 = 0;
            int n5 = i;
            while (n5 < n2) {
                nArray[n4] = list.get((int)n5).searchWordIndex;
                ++n5;
                ++n4;
            }
            this._readFileIndicesDoUnion(inputStreamWrapper, resultObjectMap, stringArray, nArray);
            i = n2 - 1;
            this._checkStopSearch();
        }
        if (!bl || stringArray.length == 1) {
            return resultObjectMap;
        }
        Iterator<ResultObject> iterator = resultObjectMap.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((ResultObject)object).getPositionDataMap().size() >= stringArray.length) continue;
            iterator.remove();
        }
        return resultObjectMap;
    }

    private ResultObjectMap _combineResults(ResultObjectMap resultObjectMap, ResultObjectMap resultObjectMap2, int n) {
        switch (n) {
            case 1: {
                return this._combineResultsDoIntersection(resultObjectMap, resultObjectMap2);
            }
            case 2: {
                return this._combineResultsDoUnion(resultObjectMap, resultObjectMap2);
            }
            case 4: {
                return this._combineResultsDoDifference(resultObjectMap, resultObjectMap2);
            }
        }
        return this._emptyResultObjectMap;
    }

    private ResultObjectMap _combineResultsDoIntersection(ResultObjectMap resultObjectMap, ResultObjectMap resultObjectMap2) {
        Iterator<ResultObject> iterator = resultObjectMap.iterator();
        while (iterator.hasNext()) {
            iterator.next().useful = false;
        }
        for (ResultObject resultObject : resultObjectMap2) {
            ResultObject resultObject2 = resultObjectMap.get(resultObject.fileno);
            if (resultObject2 == null) continue;
            resultObject2.setHitNumber(resultObject2.getHitNumber() + resultObject.getHitNumber());
            resultObject2.addPositionData(resultObject.getPositionDataMap());
            resultObject2.useful = true;
        }
        this._filterResults(resultObjectMap);
        return resultObjectMap;
    }

    private ResultObjectMap _combineResultsDoUnion(ResultObjectMap resultObjectMap, ResultObjectMap resultObjectMap2) {
        for (ResultObject resultObject : resultObjectMap2) {
            ResultObject resultObject2 = resultObjectMap.get(resultObject.fileno);
            if (resultObject2 != null) {
                resultObject2.setHitNumber(resultObject2.getHitNumber() + resultObject.getHitNumber());
                resultObject2.addPositionData(resultObject.getPositionDataMap());
                continue;
            }
            resultObjectMap.put(resultObject);
        }
        return resultObjectMap;
    }

    private ResultObjectMap _combineResultsDoDifference(ResultObjectMap resultObjectMap, ResultObjectMap resultObjectMap2) {
        for (ResultObject resultObject : resultObjectMap2) {
            ResultObject resultObject2 = resultObjectMap.get(resultObject.fileno);
            if (resultObject2 == null) continue;
            resultObject2.useful = false;
        }
        this._filterResults(resultObjectMap);
        return resultObjectMap;
    }

    private void _readFileNames(InputStreamWrapper inputStreamWrapper, ResultObjectMap resultObjectMap, byte[] byArray) throws IOException {
        if (byArray == null) {
            byArray = new byte[255];
        }
        int n = inputStreamWrapper.readUb2();
        for (int i = 0; i < n; ++i) {
            int n2 = inputStreamWrapper.readUb1();
            inputStreamWrapper.read(byArray, 0, n2);
            ResultObject resultObject = resultObjectMap.get(i);
            if (resultObject != null) {
                resultObject.view = this._view;
                resultObject.urlName = this._version < 20 ? new String(byArray, 0, n2) : this._bytesToString(byArray, 0, n2);
            }
            if (this._titlesAvailable) {
                n2 = inputStreamWrapper.readUb1();
                inputStreamWrapper.read(byArray, 0, n2);
                if (resultObject != null) {
                    resultObject.label = this._version < 20 ? new String(byArray, 0, n2) : this._bytesToString(byArray, 0, n2);
                }
            }
            if (i % 20 != 0) continue;
            this._checkStopSearch();
        }
    }

    private ResultObjectMap _evaluateNOT(ResultObjectMap resultObjectMap) throws SearchException {
        ResultObjectMap resultObjectMap2 = null;
        byte[] byArray = new byte[256];
        InputStream inputStream = null;
        try {
            inputStream = this._openInputStream(this._url);
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(inputStream);
            inputStreamWrapper.skipToOffset(this._fsOffset);
            int n = inputStreamWrapper.readUb2();
            int n2 = resultObjectMap.size();
            if (n2 >= n) {
                ResultObjectMap resultObjectMap3 = this._emptyResultObjectMap;
                return resultObjectMap3;
            }
            resultObjectMap2 = this._createResultObjectMap();
            for (int i = 0; i < n; ++i) {
                int n3 = inputStreamWrapper.readUb1();
                inputStreamWrapper.read(byArray, 0, n3);
                ResultObject resultObject = resultObjectMap.get(i);
                ResultObject resultObject2 = null;
                if (resultObject == null) {
                    resultObject2 = new ResultObject();
                    resultObject2.fileno = i;
                    resultObject2.view = this._view;
                    String string = resultObject2.urlName = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
                }
                if (this._titlesAvailable) {
                    n3 = inputStreamWrapper.readUb1();
                    inputStreamWrapper.read(byArray, 0, n3);
                    if (resultObject2 != null) {
                        String string = resultObject2.label = this._version < 20 ? new String(byArray, 0, n3) : this._bytesToString(byArray, 0, n3);
                    }
                }
                if (resultObject2 == null) continue;
                resultObjectMap2.put(resultObject2);
            }
        }
        catch (Exception exception) {
            throw new SearchException("Error encountered executing NOT boolean search: " + exception.getMessage(), exception);
        }
        finally {
            try {
                inputStream.close();
                inputStream = null;
            }
            catch (Exception exception) {}
        }
        return resultObjectMap2;
    }

    private void _filterResults(ResultObjectMap resultObjectMap) {
        Iterator<ResultObject> iterator = resultObjectMap.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().useful) continue;
            iterator.remove();
        }
    }

    private List<StringQuery> _processQueryWords(String[] stringArray) {
        ArrayList<StringQuery> arrayList = new ArrayList<StringQuery>();
        StringQuery stringQuery = new StringQuery(false);
        StringQuery stringQuery2 = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if (string == null || string.length() <= 0) continue;
            if (!this._fileCase) {
                string = string.toLowerCase();
            }
            if (string.length() > 1) {
                if (stringQuery2 != null) {
                    stringQuery2.addWord(string);
                    continue;
                }
                stringQuery.addWord(string);
                continue;
            }
            if ('\"' != string.charAt(0)) continue;
            if (stringQuery2 == null) {
                stringQuery2 = new StringQuery(true);
                continue;
            }
            if (stringQuery2.getExactPhraseWords().size() > 1) {
                arrayList.add(stringQuery2);
            } else {
                stringQuery.addWords(stringQuery2.getSortedUniqueWords());
            }
            stringQuery2 = null;
        }
        if (stringQuery2 != null) {
            if (stringQuery2.getExactPhraseWords().size() > 1) {
                arrayList.add(stringQuery2);
            } else {
                stringQuery.addWords(stringQuery2.getSortedUniqueWords());
            }
        }
        if (stringQuery.getSortedUniqueWords().size() > 0) {
            arrayList.add(stringQuery);
        }
        return arrayList;
    }

    private int _readVariableLengthInteger(InputStreamWrapper inputStreamWrapper) throws IOException {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            byte by = inputStreamWrapper.readRawByte();
            n = n << 7 | by & 0x7F;
            if ((by & 0xFFFFFF80) != 0) continue;
            return n;
        }
        throw new IOException("IDX file contained corrupted variable length integer");
    }

    private int[] _readPositionData(InputStreamWrapper inputStreamWrapper) throws IOException {
        int n = this._readVariableLengthInteger(inputStreamWrapper);
        if (n > 500) {
            throw new IOException("IDX file contained corrupted position count");
        }
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this._readVariableLengthInteger(inputStreamWrapper) + n2;
            n2 = nArray[i];
        }
        return nArray;
    }

    private static void _quickSort(List list, int n, int n2) {
        if (n2 > n) {
            int n3 = ((ResultObject)list.get(n2)).getHitNumber();
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (((ResultObject)list.get(++n4)).getHitNumber() > n3) {
                    continue;
                }
                while (((ResultObject)list.get(--n5)).getHitNumber() < n3 && n5 > 0) {
                }
                if (n4 >= n5) break;
                IndexFileQueryHandler._swapObject(list, n4, n5);
            }
            IndexFileQueryHandler._swapObject(list, n4, n2);
            IndexFileQueryHandler._quickSort(list, n, n4 - 1);
            IndexFileQueryHandler._quickSort(list, n4 + 1, n2);
        }
    }

    private static void _swapObject(List list, int n, int n2) {
        ResultObject resultObject = (ResultObject)list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, resultObject);
    }

    private ResultObjectMap _createResultObjectMap() {
        return this._createResultObjectMap(this._defaultContainerType);
    }

    private ResultObjectMap _createResultObjectMap(ResultObjectContainerType resultObjectContainerType) {
        switch (resultObjectContainerType) {
            case TREE_MAP: {
                return new ResultObjectTreeMap();
            }
            case LINKED_HASH_MAP: {
                return new ResultObjectLinkedHashMap();
            }
        }
        return this._emptyResultObjectMap;
    }

    private class SearchInterruptedError
    extends Error {
        public SearchInterruptedError(String string) {
            super(string);
        }
    }

    private class IndexWord {
        public long offset;
        public byte searchWordIndex;

        public IndexWord(long l, byte by) {
            this.offset = l;
            this.searchWordIndex = by;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringQuery {
        private TreeSet<String> _sortedUniqueWords = new TreeSet();
        private ArrayList<String> _exactPhrase = null;
        private boolean _isWildcardQuery = false;

        public StringQuery(boolean bl) {
            if (bl) {
                this._exactPhrase = new ArrayList();
            }
        }

        public Set<String> getSortedUniqueWords() {
            return this._sortedUniqueWords;
        }

        public String[] getSortedUniqueWordsAsArray() {
            return this._sortedUniqueWords.toArray(new String[0]);
        }

        public List<String> getExactPhraseWords() {
            return this._exactPhrase;
        }

        public String[] getExactPhraseWordsAsArray() {
            return this._exactPhrase.toArray(new String[0]);
        }

        public boolean isExactPhraseQuery() {
            return this._exactPhrase != null;
        }

        public boolean isWildcardQuery() {
            return this._isWildcardQuery;
        }

        public void addWord(String string) {
            if (this._sortedUniqueWords.size() == 127) {
                return;
            }
            int n = string.indexOf(42);
            if (this._exactPhrase != null) {
                if (n != -1) {
                    string = string.substring(0, n) + string.substring(n + 1);
                }
                this._exactPhrase.add(string);
            } else if (n != -1) {
                this._isWildcardQuery = true;
            }
            this._sortedUniqueWords.add(string);
        }

        public void addWords(Collection<String> collection) {
            if (collection != null) {
                for (String string : collection) {
                    this.addWord(string);
                }
            }
        }

        public void removeWildcardRedundancies() {
            if (this._exactPhrase != null) {
                return;
            }
            boolean bl = false;
            String[] stringArray = this._sortedUniqueWords.toArray(new String[0]);
            block0: for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string = stringArray[i];
                if (string == null || (n = string.indexOf(42)) == -1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (string3.length() == 0 && i - 1 >= 0 && string2.equals(stringArray[i - 1])) {
                    stringArray[i - 1] = null;
                    bl = true;
                }
                for (int j = i + 1; j < stringArray.length; ++j) {
                    String string4 = stringArray[j];
                    if (string4 == null) continue;
                    if (!string4.startsWith(string2)) continue block0;
                    if (!string4.endsWith(string3) || string4.lastIndexOf(string3) < string2.length()) continue;
                    stringArray[j] = null;
                    bl = true;
                }
            }
            if (!bl) {
                return;
            }
            this._sortedUniqueWords.clear();
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                this._sortedUniqueWords.add(string2);
            }
        }
    }

    private class InputStreamWrapper {
        private InputStream _inStream;
        private long _pos;

        public InputStreamWrapper(InputStream inputStream) {
            this._inStream = inputStream;
            this._pos = 0L;
        }

        public long readUb4() throws IOException {
            long l = 0L;
            l = (long)this.readUb1() << 24 | (long)this.readUb1() << 16 | (long)this.readUb1() << 8 | (long)this.readUb1();
            return l;
        }

        public int readUb2() throws IOException {
            int n = this.readUb1() << 8 | this.readUb1();
            return n;
        }

        public int readUb1() throws IOException {
            int n = this._inStream.read();
            if (n < 0) {
                n += 256;
            }
            ++this._pos;
            return n;
        }

        public byte readRawByte() throws IOException {
            byte[] byArray = new byte[1];
            this._inStream.read(byArray, 0, 1);
            ++this._pos;
            return byArray[0];
        }

        public void skipToOffset(long l) throws IOException {
            long l2 = l - this._pos;
            while (l2 > 0L) {
                long l3 = this._inStream.skip(l2);
                if (l3 != -1L) {
                    l2 -= l3;
                    this._pos += l3;
                    continue;
                }
                throw new IOException("IndexFileQueryHandler attempting to skip past end of file: " + IndexFileQueryHandler.this._url);
            }
        }

        public String readLine() throws IOException {
            char c;
            int n = 40;
            StringBuffer stringBuffer = new StringBuffer(n);
            while ((c = (char)this._inStream.read()) != '\n') {
                if (stringBuffer.length() == n) {
                    stringBuffer.setLength(n += 40);
                }
                stringBuffer.append(c);
                ++this._pos;
            }
            ++this._pos;
            return stringBuffer.toString();
        }

        public void read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 != n2) {
                int n4 = this._inStream.read(byArray, n + n3, n2 - n3);
                if (n4 == -1) {
                    throw new IOException();
                }
                n3 += n4;
                this._pos += (long)n4;
            }
        }

        public long getPosition() {
            return this._pos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultObjectEmptyMap
    implements ResultObjectMap {
        private ResultObjectEmptyMap() {
        }

        @Override
        public ResultObject get(int n) {
            return null;
        }

        @Override
        public void put(ResultObject resultObject) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ArrayList<ResultObject> toList() {
            return (ArrayList)Collections.EMPTY_LIST;
        }

        @Override
        public Iterator<ResultObject> iterator() {
            return Collections.EMPTY_LIST.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultObjectLinkedHashMap
    implements ResultObjectMap {
        private LinkedHashMap<Integer, List<ResultObject>> _map = new LinkedHashMap(32);
        private int _size = 0;

        @Override
        public ResultObject get(int n) {
            List<ResultObject> list = this._map.get(n);
            if (list == null) {
                return null;
            }
            for (ResultObject resultObject : list) {
                if (resultObject.fileno != n) continue;
                return resultObject;
            }
            return null;
        }

        @Override
        public void put(ResultObject resultObject) {
            List<ResultObject> list = this._map.get(resultObject.fileno);
            if (list == null) {
                list = new LinkedList<ResultObject>();
                this._map.put(resultObject.fileno, list);
            }
            list.add(resultObject);
            ++this._size;
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public ArrayList<ResultObject> toList() {
            if (this._map.isEmpty()) {
                return (ArrayList)Collections.EMPTY_LIST;
            }
            ArrayList<ResultObject> arrayList = new ArrayList<ResultObject>(this._size);
            Iterator<List<ResultObject>> iterator = this._map.values().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll((Collection<ResultObject>)iterator.next());
            }
            return arrayList;
        }

        @Override
        public Iterator<ResultObject> iterator() {
            return new LinkedHashMapIterator(this._map);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LinkedHashMapIterator
        implements Iterator<ResultObject> {
            private Iterator<List<ResultObject>> _mapIter;
            private Iterator<ResultObject> _listIter;
            private List<ResultObject> _list;
            private boolean _needNextList = true;

            LinkedHashMapIterator(LinkedHashMap<Integer, List<ResultObject>> linkedHashMap) {
                this._mapIter = linkedHashMap.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this._needNextList) {
                    this._getNextList();
                }
                return this._listIter != null;
            }

            @Override
            public ResultObject next() {
                if (this._needNextList) {
                    this._getNextList();
                }
                ResultObject resultObject = this._listIter.next();
                if (!this._listIter.hasNext()) {
                    this._needNextList = true;
                }
                return resultObject;
            }

            @Override
            public void remove() {
                this._listIter.remove();
                --ResultObjectLinkedHashMap.this._size;
                if (this._list.isEmpty()) {
                    this._mapIter.remove();
                }
            }

            private void _getNextList() {
                if (this._mapIter.hasNext()) {
                    this._list = this._mapIter.next();
                    this._listIter = this._list.iterator();
                } else {
                    this._listIter = null;
                }
                this._needNextList = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultObjectTreeMap
    implements ResultObjectMap {
        private TreeMap<Integer, ResultObject> _map = new TreeMap();

        @Override
        public ResultObject get(int n) {
            return this._map.get(n);
        }

        @Override
        public void put(ResultObject resultObject) {
            this._map.put(resultObject.fileno, resultObject);
        }

        @Override
        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        @Override
        public int size() {
            return this._map.size();
        }

        @Override
        public ArrayList<ResultObject> toList() {
            if (this._map.isEmpty()) {
                return (ArrayList)Collections.EMPTY_LIST;
            }
            return new ArrayList<ResultObject>(this._map.values());
        }

        @Override
        public Iterator<ResultObject> iterator() {
            return this._map.values().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ResultObjectMap
    extends Iterable<ResultObject> {
        public ResultObject get(int var1);

        public void put(ResultObject var1);

        public boolean isEmpty();

        public int size();

        public ArrayList<ResultObject> toList();

        @Override
        public Iterator<ResultObject> iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResultObjectContainerType {
        TREE_MAP,
        LINKED_HASH_MAP,
        INVALID_TYPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultObject
    implements QueryResult {
        public int fileno = -1;
        public String urlName = null;
        public String label = null;
        public boolean useful = true;
        public View view = null;
        private int _hitNumber = 0;
        private LinkedHashMap<String, List<int[]>> _wordToPositionData = null;
        private int _totalPositionCount = 0;

        private ResultObject() {
        }

        @Override
        public Topic getResultTopic() {
            SimpleURLTarget simpleURLTarget = new SimpleURLTarget(this.view, this.urlName);
            SimpleTopic simpleTopic = new SimpleTopic(this.label, simpleURLTarget);
            return simpleTopic;
        }

        @Override
        public int getResultScore() {
            return this._hitNumber;
        }

        @Override
        public String getResultSource() {
            return IndexFileQueryHandler.this._sourceIdentifier;
        }

        public int getHitNumber() {
            return this._hitNumber;
        }

        public void setHitNumber(int n) {
            this._hitNumber = n;
        }

        public LinkedHashMap<String, List<int[]>> getPositionDataMap() {
            return this._wordToPositionData;
        }

        public int getTotalPositionCount() {
            return this._totalPositionCount;
        }

        public void addPositionData(String string, int[] nArray) {
            if (this._wordToPositionData == null) {
                this._wordToPositionData = new LinkedHashMap(5);
            }
            if (nArray == null) {
                this._wordToPositionData.put(string, null);
                return;
            }
            List<int[]> list = this._wordToPositionData.get(string);
            if (list == null) {
                list = new ArrayList<int[]>(1);
                this._wordToPositionData.put(string, list);
            }
            this._totalPositionCount += nArray.length;
            list.add(nArray);
        }

        public void addPositionData(LinkedHashMap<String, List<int[]>> linkedHashMap) {
            if (linkedHashMap == null) {
                return;
            }
            for (String string : linkedHashMap.keySet()) {
                List<int[]> list = linkedHashMap.get(string);
                for (int[] nArray : list) {
                    this.addPositionData(string, nArray);
                }
            }
        }
    }
}

