/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Canonicalizer {
    private static char _sSeparator = System.getProperty("file.separator").charAt(0);
    private static final String _CONFIG_URL_REGEX = "\\{%.*\\}";
    private static final Logger _LOGGER = Logger.getLogger(Canonicalizer.class.getName(), "oracle.help.share.resource.LoggerBundle");

    private Canonicalizer() {
    }

    public static String fixPathname(String string) {
        char c = string.charAt(string.length() - 1);
        if (c == '/' || c == _sSeparator) {
            return string;
        }
        string = string + _sSeparator;
        return string;
    }

    public static String fixSeparators(String string) {
        if (string != null) {
            int n = string.length();
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            for (int i = 0; i < n; ++i) {
                if (cArray[i] != '\\') continue;
                cArray[i] = 47;
            }
            return new String(cArray);
        }
        return "";
    }

    public static String appendFileToPath(String string, String string2) {
        char c;
        String string3 = Canonicalizer.fixSeparators(string);
        String string4 = Canonicalizer.fixSeparators(string2);
        if (string3.length() > 0 && (c = string3.charAt(string3.length() - 1)) != '/') {
            string3 = string3 + '/';
        }
        if (string4.length() > 0 && (c = string4.charAt(0)) == '/') {
            string4 = string4.substring(1);
        }
        return string3 + string4;
    }

    public static URL getAbsoluteURL(String string, String string2) throws MalformedURLException {
        URL uRL = null;
        if (string2 != null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (string != null) {
                    try {
                        uRL = new URL(Canonicalizer.appendFileToPath(string, string2));
                    }
                    catch (MalformedURLException malformedURLException2) {
                        throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve URL " + malformedURLException2.getMessage());
                    }
                }
                throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve URL " + malformedURLException.getMessage());
            }
        } else {
            throw new MalformedURLException("Canonicalizer.getAbsoluteURL: cannot resolve NULL URL ");
        }
        return uRL;
    }

    public static String resolveConfigURLLocation(String string) {
        String string2 = string;
        try {
            Pattern pattern = Pattern.compile(_CONFIG_URL_REGEX);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string3 = matcher.group();
                String string4 = System.getProperty(string3 = string3.substring(2, string3.length() - 1));
                if (string4 == null) continue;
                string2 = string2.replaceFirst(_CONFIG_URL_REGEX, Matcher.quoteReplacement(string4));
            }
            string2 = Canonicalizer.fixSeparators(string2);
        }
        catch (Throwable throwable) {
            _LOGGER.log(Level.WARNING, "Unexpected exception encountered when processing file location", throwable);
            string2 = string;
        }
        return string2;
    }
}

