/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class XMLIndexEngine
extends DataEngine {
    private Book _book;
    private static final String TAG_INDEX = "index";
    private static final String TAG_INDEXITEM = "indexitem";
    private static final String TAG_INDEXENTRY = "indexentry";
    private static final String PROP_ID = "target";
    private static final String PROP_TEXT = "text";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        Object object = null;
        try {
            object = this.createDataObject(view, string, bufferedReader);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        this._book = null;
        if (view != null) {
            this._book = view.getBook();
        }
        TopicTree topicTree = new TopicTree(this._book, string);
        TopicTreeNode topicTreeNode = topicTree.getRoot();
        Parser parser = ParserFactory.createParser(bufferedReader, string);
        XMLNode xMLNode = parser.getRoot();
        this._handleIndex(view, xMLNode.getFirstChild(), topicTreeNode);
        return topicTree;
    }

    private void _handleIndex(View view, XMLNode xMLNode, TopicTreeNode topicTreeNode) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_INDEX)) {
            throw new XMLParseException("Toplevel tag is not Index: " + xMLNode.getTokenValue());
        }
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            this._handleIndexItem(view, xMLNode, topicTreeNode, false);
        }
    }

    private void _handleIndexItem(View view, XMLNode xMLNode, TopicTreeNode topicTreeNode, boolean bl) throws XMLParseException {
        Object object;
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_INDEXITEM)) {
            throw new XMLParseException("Tag is not Indexitem: " + xMLNode.getTokenValue());
        }
        String string = xMLNode.getTokenProperty(PROP_ID);
        SimpleTopic simpleTopic = new SimpleTopic(xMLNode.getTokenProperty(PROP_TEXT));
        if (string != null) {
            object = new IndirectTarget(this._book, string);
            simpleTopic.setTarget((Target)object);
        }
        object = new KeywordTopicTreeNode(view, simpleTopic);
        topicTreeNode.addChild((TopicTreeNode)object);
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_INDEXITEM)) {
                this._handleIndexItem(view, xMLNode, (TopicTreeNode)object, true);
                continue;
            }
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_INDEXENTRY)) {
                this._handleIndexEntry(view, xMLNode, (KeywordTopicTreeNode)object);
                continue;
            }
            throw new XMLParseException("Unknown node in indexitem: " + xMLNode.getTokenValue());
        }
    }

    private void _handleIndexEntry(View view, XMLNode xMLNode, KeywordTopicTreeNode keywordTopicTreeNode) throws XMLParseException {
        Object object;
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_INDEXENTRY)) {
            throw new XMLParseException("Tag is not Indexentry: " + xMLNode.getTokenValue());
        }
        String string = xMLNode.getTokenProperty(PROP_ID);
        SimpleTopic simpleTopic = new SimpleTopic(xMLNode.getTokenProperty(PROP_TEXT));
        if (string != null) {
            object = new IndirectTarget(this._book, string);
            simpleTopic.setTarget((Target)object);
        }
        object = new KeywordTopicTreeNode(view, simpleTopic);
        keywordTopicTreeNode.addEntry((KeywordTopicTreeNode)object);
    }
}

