/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.log;

import java.awt.Component;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.AbstractLogManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogRecognizer;
import oracle.ide.log.LogWindow;
import oracle.ide.log.MessagePage;
import oracle.ide.log.QueuedLoggingHandler;
import oracle.ide.net.URLChooser;
import oracle.ide.resource.LogArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideimpl.log.LogWindowImpl;
import oracle.ideimpl.log.TabbedPage;

public class TabbedLogManager
extends AbstractLogManager
implements Addin {
    private LogPage _msgPage;
    private LogWindowImpl _logWindow;
    private TabbedPage _tabbedPage = new TabbedPage();
    private Thread _logPollerThread;

    public TabbedLogManager() {
        LogManager.setLogManager((LogManager)this);
        this.initialize();
        this.getMsgPage();
    }

    public void addPage(LogPage page) {
        this.getTabbedPage().addPage(page);
        super.addPage(page);
    }

    public void removePage(LogPage page) {
        if (this._tabbedPage != null) {
            this.closePage(page);
        }
    }

    public LogPage getMsgPage() {
        if (this._msgPage == null) {
            this._msgPage = new MessagePage();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    CustomTabPage tabPage = TabbedLogManager.this._tabbedPage.getTabPageForLogPage(TabbedLogManager.this._msgPage);
                    if (tabPage != null) {
                        tabPage.setCloseable(false);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        return this._msgPage;
    }

    public LogWindow getLogWindow() {
        return this.getLogWindowImpl();
    }

    protected LogWindowImpl getLogWindowImpl() {
        if (this._logWindow == null) {
            this._logWindow = new LogWindowImpl((LogPage)this._tabbedPage);
            this.installMouseListener((LogPage)this._tabbedPage);
        }
        return this._logWindow;
    }

    public boolean isLogVisible() {
        if (this._logWindow == null) {
            return false;
        }
        return this._logWindow.isVisible();
    }

    public void showLog() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DockUtil.showDockableWindow((DockableView)TabbedLogManager.this.getLogWindowImpl());
                LogPage logPage = TabbedLogManager.this.getSelectedPage();
                if (logPage != null) {
                    GraphicsUtils.focusComponentOrChild((Component)logPage.getLogPageView().getGUI(), (boolean)true);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void hideLog() {
        if (this._logWindow != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DockUtil.hideDockableWindow((DockableView)TabbedLogManager.this.getLogWindowImpl());
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public void toggleLog(Context context) {
        DockUtil.smartToggleDockableWindow((DockableView)this.getLogWindowImpl(), (Context)context);
    }

    public void initialize() {
        IdeAction showDropdownAction = IdeAction.find((int)EditorManager.SHOW_DROPDOWN_CMD_ID);
        showDropdownAction.addController((Controller)this);
        this.startJavaLogging();
    }

    private QueuedLoggingHandler findQueuedLoggingHandler() {
        QueuedLoggingHandler qlh = null;
        Filter consoleFilter = null;
        Logger root = Logger.getLogger("");
        for (Handler handler : root.getHandlers()) {
            if (handler instanceof QueuedLoggingHandler) {
                qlh = (QueuedLoggingHandler)handler;
                continue;
            }
            if (consoleFilter != null || !ConsoleHandler.class.equals(handler.getClass())) continue;
            consoleFilter = handler.getFilter();
        }
        if (qlh == null) {
            qlh = new QueuedLoggingHandler();
            root.addHandler((Handler)qlh);
        }
        if (qlh.getFilter() == null) {
            qlh.setFilter(consoleFilter);
        }
        return qlh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopJavaLogging() {
        try {
            this._logPollerThread.interrupt();
        }
        catch (Exception exception) {
        }
        finally {
            this._logPollerThread = null;
        }
    }

    public void startJavaLogging() {
        final QueuedLoggingHandler qlh = this.findQueuedLoggingHandler();
        if (qlh == null) {
            return;
        }
        LogRecord record = qlh.poll();
        while (record != null) {
            this.getMsgPage().log((Object)qlh.getFormatter().format(record));
            record = qlh.poll();
        }
        Runnable poller = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            LogRecord logRecord;
                            if ((logRecord = qlh.take()) == null || logRecord.getMessage() == null) {
                                continue;
                            }
                            TabbedLogManager.this.getMsgPage().log((Object)qlh.getFormatter().format(logRecord));
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        continue;
                    }
                    break;
                }
            }
        };
        this._logPollerThread = new Thread(poller, "Log Poller");
        this._logPollerThread.setPriority(1);
        this._logPollerThread.start();
    }

    public int getPageCount() {
        if (this._tabbedPage != null) {
            return this._tabbedPage.getPageCount();
        }
        return 0;
    }

    public LogPage[] getPages() {
        if (this._tabbedPage == null) {
            return new LogPage[0];
        }
        return this._tabbedPage.getPages();
    }

    public LogPage getSelectedPage() {
        if (this.getPageCount() > 0) {
            return this._tabbedPage.getSelectedPage();
        }
        return null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == CLEAR_LOG_CMD_ID) {
            LogPage page = this._tabbedPage.getSelectedPage();
            if (page != null) {
                page.clearAll();
            }
            return true;
        }
        if (cmdId == CLOSE_LOG_CMD_ID) {
            if (context != null && context.getView() instanceof LogPage) {
                this.closePage((LogPage)context.getView());
            } else {
                this.closePage(this._tabbedPage.getSelectedPage());
            }
            return true;
        }
        if (cmdId == CLOSE_OTHER_LOGS_CMD_ID) {
            this.removeAll(this._tabbedPage.getSelectedPage());
            return true;
        }
        if (cmdId == CLOSE_ALL_LOGS_CMD_ID) {
            this.removeAll(null);
            return true;
        }
        if (cmdId == 30 || cmdId == 31) {
            return true;
        }
        if (cmdId == 70) {
            this._tabbedPage.navigateLeft();
            return true;
        }
        if (cmdId == 71) {
            this._tabbedPage.navigateRight();
            return true;
        }
        if (cmdId == EditorManager.SHOW_DROPDOWN_CMD_ID) {
            if (context != null && context.getView() instanceof LogPage) {
                this._tabbedPage.displayDropDownMenu();
                return true;
            }
        } else {
            if (cmdId == OPEN_FILE_CMD_ID) {
                this.openPageFromFile();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == CLOSE_OTHER_LOGS_CMD_ID) {
            boolean enabled = false;
            if (this._tabbedPage.getPageCount() > 1) {
                enabled = true;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == CLOSE_LOG_CMD_ID) {
            if (this.getSelectedPage() == this.getMsgPage()) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
            return true;
        }
        if (cmdId == 30 || cmdId == 31) {
            action.setEnabled(false);
            return true;
        }
        if (cmdId == OPEN_FILE_CMD_ID) {
            List recognizerList = this.getLogRecognizers();
            if (recognizerList.size() > 0) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == CLEAR_LOG_CMD_ID) {
            JComponent jcomp;
            Component comp;
            View view;
            LogPage page = this._tabbedPage.getSelectedPage();
            boolean enable = false;
            boolean handled = false;
            if (page != null && (view = page.getLogPageView()) != null && (comp = view.getGUI()) != null && (jcomp = GraphicsUtils.getFocusableComponentOrChild((Component)comp, (boolean)true)) != null) {
                if (jcomp instanceof JTextComponent) {
                    handled = true;
                    JTextComponent textComp = (JTextComponent)jcomp;
                    Document document = textComp.getDocument();
                    if (document != null && document.getLength() > 0) {
                        enable = true;
                    }
                } else if (jcomp instanceof JTree) {
                    Object root;
                    handled = true;
                    JTree tree = (JTree)jcomp;
                    TreeModel tmodel = tree.getModel();
                    if (tmodel != null && (root = tmodel.getRoot()) != null && tmodel.getChildCount(tmodel.getRoot()) > 0) {
                        enable = true;
                    }
                }
            }
            if (handled) {
                action.setEnabled(enable);
            }
            return handled;
        }
        return false;
    }

    protected Context getContext(EventObject event) {
        return this.getTabbedPage().getContext(event);
    }

    protected TabbedPage getTabbedPage() {
        this.getLogWindowImpl();
        return this._tabbedPage;
    }

    private void removeAll(LogPage skipPage) {
        if (this._tabbedPage == null) {
            return;
        }
        LogPage[] pages = this._tabbedPage.getPages();
        for (int i = 0; i < pages.length; ++i) {
            LogPage page = pages[i];
            if (page == skipPage || page == this.getMsgPage()) continue;
            this.closePage(page);
        }
        IdeUtil.tryToRestoreFocus(skipPage != null ? skipPage.getLogPageView().getGUI() : null);
    }

    private void closePage(LogPage page) {
        if (page != this.getMsgPage()) {
            this._tabbedPage.removePage(page);
            super.removePage(page);
            page.getLogPageView().close();
        }
    }

    private void openPageFromFile() {
        URL fileToOpen = null;
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.clearChooseableURLFilters();
        List recognizerList = this.getLogRecognizers();
        int size = recognizerList.size();
        for (int i = 0; i < size; ++i) {
            LogRecognizer recognizer = (LogRecognizer)recognizerList.get(i);
            chooser.addChooseableURLFilter(recognizer.getFilter());
        }
        if (chooser.showOpenDialog((Component)Ide.getMainWindow()) != 0) {
            return;
        }
        fileToOpen = chooser.getSelectedURL();
        LogRecognizer recognizerToUse = null;
        Class dataClass = null;
        for (int i = 0; i < size; ++i) {
            LogRecognizer recognizer = (LogRecognizer)recognizerList.get(i);
            dataClass = recognizer.recognize(fileToOpen);
            if (dataClass == null) continue;
            recognizerToUse = recognizer;
            break;
        }
        if (recognizerToUse != null) {
            try {
                LogPage page = recognizerToUse.create(fileToOpen, dataClass);
                page.getLogPageView().show();
            }
            catch (Exception e) {
                this.showErrorDialog(LogArb.getString((int)34), LogArb.getString((int)33));
                e.printStackTrace();
            }
        } else {
            this.showErrorDialog(LogArb.getString((int)32), LogArb.getString((int)33));
        }
    }

    private void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
    }
}

