/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClassFactoryImpl;
import org.netbeans.libs.git.GitClientCallback;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitRebaseResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevertResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.JGitCredentialsProvider;
import org.netbeans.libs.git.jgit.JGitRepository;
import org.netbeans.libs.git.jgit.commands.AddCommand;
import org.netbeans.libs.git.jgit.commands.BlameCommand;
import org.netbeans.libs.git.jgit.commands.CatCommand;
import org.netbeans.libs.git.jgit.commands.CheckoutIndexCommand;
import org.netbeans.libs.git.jgit.commands.CheckoutRevisionCommand;
import org.netbeans.libs.git.jgit.commands.CleanCommand;
import org.netbeans.libs.git.jgit.commands.CommitCommand;
import org.netbeans.libs.git.jgit.commands.CompareCommand;
import org.netbeans.libs.git.jgit.commands.ConflictCommand;
import org.netbeans.libs.git.jgit.commands.CopyCommand;
import org.netbeans.libs.git.jgit.commands.CreateBranchCommand;
import org.netbeans.libs.git.jgit.commands.CreateTagCommand;
import org.netbeans.libs.git.jgit.commands.DeleteBranchCommand;
import org.netbeans.libs.git.jgit.commands.DeleteTagCommand;
import org.netbeans.libs.git.jgit.commands.ExportCommitCommand;
import org.netbeans.libs.git.jgit.commands.ExportDiffCommand;
import org.netbeans.libs.git.jgit.commands.FetchCommand;
import org.netbeans.libs.git.jgit.commands.GetCommonAncestorCommand;
import org.netbeans.libs.git.jgit.commands.GetPreviousCommitCommand;
import org.netbeans.libs.git.jgit.commands.GetRemotesCommand;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.IgnoreCommand;
import org.netbeans.libs.git.jgit.commands.InitRepositoryCommand;
import org.netbeans.libs.git.jgit.commands.ListBranchCommand;
import org.netbeans.libs.git.jgit.commands.ListModifiedIndexEntriesCommand;
import org.netbeans.libs.git.jgit.commands.ListRemoteBranchesCommand;
import org.netbeans.libs.git.jgit.commands.ListRemoteTagsCommand;
import org.netbeans.libs.git.jgit.commands.ListTagCommand;
import org.netbeans.libs.git.jgit.commands.LogCommand;
import org.netbeans.libs.git.jgit.commands.MergeCommand;
import org.netbeans.libs.git.jgit.commands.PullCommand;
import org.netbeans.libs.git.jgit.commands.PushCommand;
import org.netbeans.libs.git.jgit.commands.RebaseCommand;
import org.netbeans.libs.git.jgit.commands.RemoveCommand;
import org.netbeans.libs.git.jgit.commands.RemoveRemoteCommand;
import org.netbeans.libs.git.jgit.commands.RenameCommand;
import org.netbeans.libs.git.jgit.commands.ResetCommand;
import org.netbeans.libs.git.jgit.commands.RevertCommand;
import org.netbeans.libs.git.jgit.commands.SetRemoteCommand;
import org.netbeans.libs.git.jgit.commands.StatusCommand;
import org.netbeans.libs.git.jgit.commands.UnignoreCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.RevisionInfoListener;
import org.netbeans.libs.git.progress.StatusListener;

public final class GitClient {
    private final DelegateListener delegateListener;
    private GitClassFactory gitFactory;
    private final JGitRepository gitRepository;
    private final Set<NotificationListener> listeners;
    private JGitCredentialsProvider credentialsProvider;

    GitClient(JGitRepository gitRepository) throws GitException {
        this.gitRepository = gitRepository;
        this.listeners = new HashSet<NotificationListener>();
        this.delegateListener = new DelegateListener();
        gitRepository.increaseClientUsage();
    }

    public void add(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        AddCommand cmd = new AddCommand(repository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener) {
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    public GitBlameResult blame(File file, String revision, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        BlameCommand cmd = new BlameCommand(repository, this.getClassFactory(), file, revision, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public boolean catFile(File file, String revision, OutputStream out, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        CatCommand cmd = new CatCommand(repository, this.getClassFactory(), file, revision, out, monitor);
        cmd.execute();
        return cmd.foundInRevision();
    }

    public boolean catIndexEntry(File file, int stage, OutputStream out, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CatCommand cmd = new CatCommand(repository, this.getClassFactory(), file, stage, out, monitor);
        cmd.execute();
        return cmd.foundInRevision();
    }

    public void checkout(File[] roots, String revision, boolean recursively, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        GitCommand cmd;
        Repository repository = this.gitRepository.getRepository();
        if (revision != null) {
            cmd = new ResetCommand(repository, this.getClassFactory(), revision, roots, recursively, monitor, this.delegateListener);
            cmd.execute();
        }
        if (!monitor.isCanceled()) {
            cmd = new CheckoutIndexCommand(repository, this.getClassFactory(), roots, recursively, monitor, this.delegateListener);
            cmd.execute();
        }
    }

    public void checkoutRevision(String revision, boolean failOnConflict, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        if (!failOnConflict) {
            throw new IllegalArgumentException("Currently unsupported. failOnConflict must be set to true. JGit lib is buggy.");
        }
        Repository repository = this.gitRepository.getRepository();
        CheckoutRevisionCommand cmd = new CheckoutRevisionCommand(repository, this.getClassFactory(), revision, failOnConflict, monitor, this.delegateListener);
        cmd.execute();
    }

    public void clean(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CleanCommand cmd = new CleanCommand(repository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
    }

    public GitRevisionInfo commit(File[] roots, String commitMessage, GitUser author, GitUser commiter, ProgressMonitor monitor) throws GitException {
        return this.commit(roots, commitMessage, author, commiter, false, monitor);
    }

    public GitRevisionInfo commit(File[] roots, String commitMessage, GitUser author, GitUser commiter, boolean amend, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CommitCommand cmd = new CommitCommand(repository, this.getClassFactory(), roots, commitMessage, author, commiter, amend, monitor);
        cmd.execute();
        return cmd.revision;
    }

    public void copyAfter(File source, File target, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CopyCommand cmd = new CopyCommand(repository, this.getClassFactory(), source, target, monitor, this.delegateListener);
        cmd.execute();
    }

    public GitBranch createBranch(String branchName, String revision, ProgressMonitor monitor) throws GitException {
        CreateBranchCommand cmd = new CreateBranchCommand(this.gitRepository.getRepository(), this.getClassFactory(), branchName, revision, monitor);
        cmd.execute();
        return cmd.getBranch();
    }

    public GitTag createTag(String tagName, String taggedObject, String message, boolean signed, boolean forceUpdate, ProgressMonitor monitor) throws GitException {
        CreateTagCommand cmd = new CreateTagCommand(this.gitRepository.getRepository(), this.getClassFactory(), tagName, taggedObject, message, signed, forceUpdate, monitor);
        cmd.execute();
        return cmd.getTag();
    }

    public void deleteBranch(String branchName, boolean forceDeleteUnmerged, ProgressMonitor monitor) throws GitException.NotMergedException, GitException {
        DeleteBranchCommand cmd = new DeleteBranchCommand(this.gitRepository.getRepository(), this.getClassFactory(), branchName, forceDeleteUnmerged, monitor);
        cmd.execute();
    }

    public void deleteTag(String tagName, ProgressMonitor monitor) throws GitException {
        DeleteTagCommand cmd = new DeleteTagCommand(this.gitRepository.getRepository(), this.getClassFactory(), tagName, monitor);
        cmd.execute();
    }

    public void exportCommit(String commit, OutputStream out, ProgressMonitor monitor) throws GitException {
        ExportCommitCommand cmd = new ExportCommitCommand(this.gitRepository.getRepository(), this.getClassFactory(), commit, out, monitor, this.delegateListener);
        cmd.execute();
    }

    public void exportDiff(File[] roots, DiffMode mode, OutputStream out, ProgressMonitor monitor) throws GitException {
        ExportDiffCommand cmd = new ExportDiffCommand(this.gitRepository.getRepository(), this.getClassFactory(), roots, mode, out, monitor, this.delegateListener);
        cmd.execute();
    }

    public Map<String, GitTransportUpdate> fetch(String remote, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        FetchCommand cmd = new FetchCommand(this.gitRepository.getRepository(), this.getClassFactory(), remote, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getUpdates();
    }

    public Map<String, GitTransportUpdate> fetch(String remote, List<String> fetchRefSpecifications, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        FetchCommand cmd = new FetchCommand(this.gitRepository.getRepository(), this.getClassFactory(), remote, fetchRefSpecifications, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getUpdates();
    }

    public Map<String, GitBranch> getBranches(boolean all, ProgressMonitor monitor) throws GitException {
        ListBranchCommand cmd = new ListBranchCommand(this.gitRepository.getRepository(), this.getClassFactory(), all, monitor);
        cmd.execute();
        return cmd.getBranches();
    }

    public Map<String, GitTag> getTags(ProgressMonitor monitor, boolean allTags) throws GitException {
        ListTagCommand cmd = new ListTagCommand(this.gitRepository.getRepository(), this.getClassFactory(), allTags, monitor);
        cmd.execute();
        return cmd.getTags();
    }

    public GitRevisionInfo getCommonAncestor(String[] revisions, ProgressMonitor monitor) throws GitException {
        GetCommonAncestorCommand cmd = new GetCommonAncestorCommand(this.gitRepository.getRepository(), this.getClassFactory(), revisions, monitor);
        cmd.execute();
        return cmd.getRevision();
    }

    public GitRevisionInfo getPreviousRevision(File file, String revision, ProgressMonitor monitor) throws GitException {
        GetPreviousCommitCommand cmd = new GetPreviousCommitCommand(this.gitRepository.getRepository(), this.getClassFactory(), file, revision, monitor);
        cmd.execute();
        return cmd.getRevision();
    }

    public Map<File, GitStatus> getConflicts(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        ConflictCommand cmd = new ConflictCommand(repository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getStatuses();
    }

    public Map<File, GitStatus> getStatus(File[] roots, ProgressMonitor monitor) throws GitException {
        return this.getStatus(roots, "HEAD", monitor);
    }

    public Map<File, GitStatus> getStatus(File[] roots, String revision, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        StatusCommand cmd = new StatusCommand(repository, revision == null ? "HEAD" : revision, roots, this.getClassFactory(), monitor, this.delegateListener);
        cmd.execute();
        return cmd.getStatuses();
    }

    public Map<File, GitRevisionInfo.GitFileInfo> getStatus(File[] roots, String revisionFirst, String revisionSecond, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        CompareCommand cmd = new CompareCommand(repository, revisionFirst, revisionSecond, roots, this.getClassFactory(), monitor);
        cmd.execute();
        return cmd.getFileDifferences();
    }

    public GitRemoteConfig getRemote(String remoteName, ProgressMonitor monitor) throws GitException {
        return this.getRemotes(monitor).get(remoteName);
    }

    public Map<String, GitRemoteConfig> getRemotes(ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        GetRemotesCommand cmd = new GetRemotesCommand(repository, this.getClassFactory(), monitor);
        cmd.execute();
        return cmd.getRemotes();
    }

    public GitRepositoryState getRepositoryState(ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RepositoryState state = repository.getRepositoryState();
        return GitRepositoryState.getStateFor(state);
    }

    public GitUser getUser() throws GitException {
        return this.getClassFactory().createUser(new PersonIdent(this.gitRepository.getRepository()));
    }

    public File[] ignore(File[] files, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        IgnoreCommand cmd = new IgnoreCommand(repository, this.getClassFactory(), files, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getModifiedIgnoreFiles();
    }

    public void init(ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        InitRepositoryCommand cmd = new InitRepositoryCommand(repository, this.getClassFactory(), monitor);
        cmd.execute();
    }

    public File[] listModifiedIndexEntries(File[] roots, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        ListModifiedIndexEntriesCommand cmd = new ListModifiedIndexEntriesCommand(repository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getFiles();
    }

    public Map<String, GitBranch> listRemoteBranches(String remoteRepositoryUrl, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        Repository repository = this.gitRepository.getRepository();
        ListRemoteBranchesCommand cmd = new ListRemoteBranchesCommand(repository, this.getClassFactory(), remoteRepositoryUrl, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getBranches();
    }

    public Map<String, String> listRemoteTags(String remoteRepositoryUrl, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        Repository repository = this.gitRepository.getRepository();
        ListRemoteTagsCommand cmd = new ListRemoteTagsCommand(repository, this.getClassFactory(), remoteRepositoryUrl, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getTags();
    }

    public GitRevisionInfo log(String revision, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        LogCommand cmd = new LogCommand(repository, this.getClassFactory(), revision, monitor, (RevisionInfoListener)this.delegateListener);
        cmd.execute();
        GitRevisionInfo[] revisions = cmd.getRevisions();
        return revisions.length == 0 ? null : revisions[0];
    }

    public GitRevisionInfo[] log(SearchCriteria searchCriteria, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        LogCommand cmd = new LogCommand(repository, this.getClassFactory(), searchCriteria, monitor, (RevisionInfoListener)this.delegateListener);
        cmd.execute();
        return cmd.getRevisions();
    }

    public GitMergeResult merge(String revision, ProgressMonitor monitor) throws GitException.CheckoutConflictException, GitException {
        Repository repository = this.gitRepository.getRepository();
        MergeCommand cmd = new MergeCommand(repository, this.getClassFactory(), revision, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public GitPullResult pull(String remote, List<String> fetchRefSpecifications, String branchToMerge, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException.CheckoutConflictException, GitException.MissingObjectException, GitException {
        PullCommand cmd = new PullCommand(this.gitRepository.getRepository(), this.getClassFactory(), remote, fetchRefSpecifications, branchToMerge, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getResult();
    }

    public GitPushResult push(String remote, List<String> pushRefSpecifications, List<String> fetchRefSpecifications, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        PushCommand cmd = new PushCommand(this.gitRepository.getRepository(), this.getClassFactory(), remote, pushRefSpecifications, fetchRefSpecifications, monitor);
        cmd.setCredentialsProvider(this.credentialsProvider);
        cmd.execute();
        return cmd.getResult();
    }

    public GitRebaseResult rebase(RebaseOperationType operation, String revision, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RebaseCommand cmd = new RebaseCommand(repository, this.getClassFactory(), revision, operation, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public void release() {
        this.gitRepository.decreaseClientUsage();
    }

    public void remove(File[] roots, boolean cached, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RemoveCommand cmd = new RemoveCommand(repository, this.getClassFactory(), roots, cached, monitor, this.delegateListener);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener) {
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public void removeRemote(String remote, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RemoveRemoteCommand cmd = new RemoveRemoteCommand(repository, this.getClassFactory(), remote, monitor);
        cmd.execute();
    }

    public void rename(File source, File target, boolean after, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        RenameCommand cmd = new RenameCommand(repository, this.getClassFactory(), source, target, after, monitor, this.delegateListener);
        cmd.execute();
    }

    public void reset(File[] roots, String revision, boolean recursively, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        ResetCommand cmd = new ResetCommand(repository, this.getClassFactory(), revision, roots, recursively, monitor, this.delegateListener);
        cmd.execute();
    }

    public void reset(String revision, ResetType resetType, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        Repository repository = this.gitRepository.getRepository();
        ResetCommand cmd = new ResetCommand(repository, this.getClassFactory(), revision, resetType, monitor, this.delegateListener);
        cmd.execute();
    }

    public GitRevertResult revert(String revision, String commitMessage, boolean commit, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException.CheckoutConflictException, GitException {
        Repository repository = this.gitRepository.getRepository();
        RevertCommand cmd = new RevertCommand(repository, this.getClassFactory(), revision, commitMessage, commit, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public void setCallback(GitClientCallback callback) {
        this.credentialsProvider = callback == null ? null : new JGitCredentialsProvider(callback);
    }

    public void setRemote(GitRemoteConfig remoteConfig, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        SetRemoteCommand cmd = new SetRemoteCommand(repository, this.getClassFactory(), remoteConfig, monitor);
        cmd.execute();
    }

    public File[] unignore(File[] files, ProgressMonitor monitor) throws GitException {
        Repository repository = this.gitRepository.getRepository();
        UnignoreCommand cmd = new UnignoreCommand(repository, this.getClassFactory(), files, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getModifiedIgnoreFiles();
    }

    private GitClassFactory getClassFactory() {
        if (this.gitFactory == null) {
            this.gitFactory = GitClassFactoryImpl.getInstance();
        }
        return this.gitFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFile(File file, String relativePathToRoot) {
        LinkedList<NotificationListener> lists;
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof FileListener)) continue;
            ((FileListener)list).notifyFile(file, relativePathToRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatus(GitStatus status) {
        LinkedList<NotificationListener> lists;
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof StatusListener)) continue;
            ((StatusListener)list).notifyStatus(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRevisionInfo(GitRevisionInfo info) {
        LinkedList<NotificationListener> lists;
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof RevisionInfoListener)) continue;
            ((RevisionInfoListener)list).notifyRevisionInfo(info);
        }
    }

    private class DelegateListener
    implements StatusListener,
    FileListener,
    RevisionInfoListener {
        private DelegateListener() {
        }

        @Override
        public void notifyStatus(GitStatus status) {
            GitClient.this.notifyStatus(status);
        }

        @Override
        public void notifyFile(File file, String relativePathToRoot) {
            GitClient.this.notifyFile(file, relativePathToRoot);
        }

        @Override
        public void notifyRevisionInfo(GitRevisionInfo revisionInfo) {
            GitClient.this.notifyRevisionInfo(revisionInfo);
        }
    }

    public static enum DiffMode {
        HEAD_VS_INDEX,
        HEAD_VS_WORKINGTREE,
        INDEX_VS_WORKINGTREE;

    }

    public static enum RebaseOperationType {
        BEGIN,
        CONTINUE{

            public String toString() {
                return "--continue";
            }
        }
        ,
        SKIP{

            public String toString() {
                return "--skip";
            }
        }
        ,
        ABORT{

            public String toString() {
                return "--abort";
            }
        };

    }

    public static enum ResetType {
        SOFT{

            public String toString() {
                return "--soft";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "--mixed";
            }
        }
        ,
        HARD{

            public String toString() {
                return "--hard";
            }
        };

    }
}

