/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.RebaseResult;

public final class GitRebaseResult {
    private final RebaseStatus rebaseStatus;
    private final List<File> conflicts;
    private final List<File> failures;
    private final String currentHead;
    private final String currentCommit;

    GitRebaseResult(RebaseResult result, List<File> rebaseConflicts, List<File> failures, String currentHead) {
        this.rebaseStatus = GitRebaseResult.parseRebaseStatus(result.getStatus());
        this.currentHead = currentHead;
        this.currentCommit = result.getCurrentCommit() == null ? null : result.getCurrentCommit().getId().getName();
        this.conflicts = rebaseConflicts;
        this.failures = failures;
    }

    public RebaseStatus getRebaseStatus() {
        return this.rebaseStatus;
    }

    public String getCurrentHead() {
        return this.currentHead;
    }

    public String getCurrentCommit() {
        return this.currentCommit;
    }

    public Collection<File> getConflicts() {
        return this.conflicts;
    }

    public Collection<File> getFailures() {
        return this.failures;
    }

    static RebaseStatus parseRebaseStatus(RebaseResult.Status rebaseStatus) {
        return RebaseStatus.valueOf(rebaseStatus.name());
    }

    public static enum RebaseStatus {
        OK{

            @Override
            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        ABORTED{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        STOPPED{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        FAILED{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        CONFLICTS{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        }
        ,
        UP_TO_DATE{

            @Override
            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        FAST_FORWARD{

            @Override
            public boolean isSuccessful() {
                return true;
            }
        }
        ,
        NOTHING_TO_COMMIT{

            @Override
            public boolean isSuccessful() {
                return false;
            }
        };


        public abstract boolean isSuccessful();
    }
}

