/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import org.eclipse.jgit.diff.DiffEntry;
import org.netbeans.libs.git.GitConflictDescriptor;

public final class GitStatus {
    private final File file;
    private final String relativePath;
    private final boolean tracked;
    private GitConflictDescriptor conflictDescriptor;
    private Status statusHeadIndex;
    private Status statusIndexWC;
    private Status statusHeadWC;
    private boolean isFolder;
    private DiffEntry diffEntry;
    private final String workTreePath;

    GitStatus(String workTreePath, File file, String relativePath, boolean tracked) {
        this.workTreePath = workTreePath;
        this.file = file;
        this.relativePath = relativePath;
        this.tracked = tracked;
    }

    public File getFile() {
        return this.file;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Status getStatusHeadIndex() {
        return this.statusHeadIndex;
    }

    public Status getStatusIndexWC() {
        return this.statusIndexWC;
    }

    public Status getStatusHeadWC() {
        return this.statusHeadWC;
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public boolean isConflict() {
        return this.conflictDescriptor != null;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isCopied() {
        return this.diffEntry != null && this.diffEntry.getChangeType().equals((Object)DiffEntry.ChangeType.COPY);
    }

    public boolean isRenamed() {
        return this.diffEntry != null && this.diffEntry.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME);
    }

    public File getOldPath() {
        if (this.isRenamed() || this.isCopied()) {
            return new File(this.workTreePath + File.separator + this.diffEntry.getOldPath());
        }
        return null;
    }

    public GitConflictDescriptor getConflictDescriptor() {
        return this.conflictDescriptor;
    }

    void setDiffEntry(DiffEntry diffEntry) {
        this.diffEntry = diffEntry;
    }

    void setConflictDescriptor(GitConflictDescriptor conflictDescriptor) {
        this.conflictDescriptor = conflictDescriptor;
    }

    void setFolder(boolean isFolder) {
        this.isFolder = isFolder;
    }

    void setStatusHeadIndex(Status statusHeadIndex) {
        this.statusHeadIndex = statusHeadIndex;
    }

    void setStatusHeadWC(Status statusHeadWC) {
        this.statusHeadWC = statusHeadWC;
    }

    void setStatusIndexWC(Status statusIndexWC) {
        this.statusIndexWC = statusIndexWC;
    }

    public static enum Status {
        STATUS_ADDED,
        STATUS_REMOVED,
        STATUS_NORMAL,
        STATUS_MODIFIED,
        STATUS_IGNORED;

    }
}

