/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.text.MessageFormat;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.progress.ProgressMonitor;

public abstract class GitCommand {
    private final Repository repository;
    private final ProgressMonitor monitor;
    protected static final String EMPTY_ROOTS = Utils.getBundle(GitCommand.class).getString("MSG_Error_NoFiles");
    private final GitClassFactory gitFactory;

    protected GitCommand(Repository repository, GitClassFactory gitFactory, ProgressMonitor monitor) {
        this.repository = repository;
        this.gitFactory = gitFactory;
        this.monitor = monitor;
    }

    public final void execute() throws GitException {
        if (this.prepareCommand()) {
            try {
                this.monitor.started(this.getCommandDescription());
                this.run();
            }
            catch (RuntimeException ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Unknown repository format")) {
                    throw new GitException("It seems the config file for repository at [" + this.repository.getWorkTree() + "] is corrupted.\nEnsure it's valid.", ex);
                }
                throw ex;
            }
            finally {
                this.monitor.finished();
            }
        }
    }

    protected abstract void run() throws GitException;

    protected boolean prepareCommand() throws GitException {
        boolean repositoryExists = this.repository.getDirectory().exists();
        if (!repositoryExists) {
            String message = MessageFormat.format(Utils.getBundle(GitCommand.class).getString("MSG_Error_RepositoryDoesNotExist"), this.repository.getWorkTree());
            this.monitor.preparationsFailed(message);
            throw new GitException(message);
        }
        return repositoryExists;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected abstract String getCommandDescription();

    protected final GitClassFactory getClassFactory() {
        return this.gitFactory;
    }
}

