/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class MergeCommand
extends GitCommand {
    private final String revision;
    private GitMergeResult result;
    private String commitMessage;

    public MergeCommand(Repository repository, GitClassFactory gitFactory, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.revision = revision;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.MergeCommand command = new Git(repository).merge();
        Ref ref = null;
        try {
            ref = repository.getRef(this.revision);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        if (ref == null) {
            command.include((AnyObjectId)Utils.findCommit(repository, this.revision));
        } else {
            String msg = this.commitMessage;
            if (msg == null) {
                msg = Utils.getRefName(ref);
            }
            command.include(msg, (AnyObjectId)ref.getTarget().getObjectId());
        }
        command.setStrategy((MergeStrategy)MergeStrategy.RESOLVE);
        try {
            this.result = this.getClassFactory().createMergeResult(command.call(), repository.getWorkTree());
        }
        catch (CheckoutConflictException ex) {
            this.parseConflicts(ex);
        }
        catch (JGitInternalException ex) {
            if (ex.getCause() instanceof org.eclipse.jgit.errors.CheckoutConflictException) {
                this.parseConflicts(ex.getCause());
            }
            throw new GitException(ex);
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git merge " + this.revision;
    }

    public GitMergeResult getResult() {
        return this.result;
    }

    void setCommitMessage(String message) {
        if (message != null) {
            message = message.replace("\n", "").replace("\r", "");
        }
        this.commitMessage = message;
    }

    private void parseConflicts(Throwable original) throws GitException.CheckoutConflictException, GitException {
        String[] lines = original.getMessage().split("\n");
        if (lines.length > 1) {
            throw new GitException.CheckoutConflictException(Arrays.copyOfRange(lines, 1, lines.length), original);
        }
        throw new GitException(original);
    }
}

