/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.utils.CheckoutIndex;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ResetCommand
extends GitCommand {
    private final File[] roots;
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final String revisionStr;
    private final GitClient.ResetType resetType;
    private final boolean moveHead;
    private final boolean recursively;

    public ResetCommand(Repository repository, GitClassFactory gitFactory, String revision, File[] roots, boolean recursively, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.listener = listener;
        this.monitor = monitor;
        this.revisionStr = revision;
        this.resetType = GitClient.ResetType.MIXED;
        this.recursively = recursively;
        this.moveHead = false;
    }

    public ResetCommand(Repository repository, GitClassFactory gitFactory, String revision, GitClient.ResetType resetType, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = new File[0];
        this.listener = listener;
        this.monitor = monitor;
        this.revisionStr = revision;
        this.resetType = resetType;
        this.recursively = true;
        this.moveHead = true;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git reset ");
        if (this.moveHead) {
            sb.append(this.resetType.toString()).append(" ").append(this.revisionStr);
        } else {
            sb.append(this.revisionStr);
            for (File root : this.roots) {
                sb.append(" ").append(root.getAbsolutePath());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        RevCommit commit = Utils.findCommit(repository, this.revisionStr);
        try {
            boolean started = false;
            boolean finished = false;
            DirCache backup = repository.readDirCache();
            try {
                try {
                    DirCache cache = repository.lockDirCache();
                    started = true;
                    try {
                        if (!this.resetType.equals((Object)GitClient.ResetType.SOFT)) {
                            List<String> relativePaths;
                            TreeWalk treeWalk = new TreeWalk(repository);
                            DirCacheBuilder builder = cache.builder();
                            if (!this.moveHead && !(relativePaths = Utils.getRelativePaths(repository.getWorkTree(), this.roots)).isEmpty()) {
                                treeWalk.setFilter(PathFilterGroup.createFromStrings(relativePaths));
                            }
                            treeWalk.setRecursive(true);
                            treeWalk.reset();
                            treeWalk.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
                            treeWalk.addTree((AnyObjectId)commit.getTree());
                            LinkedList<File> toDelete = new LinkedList<File>();
                            String lastAddedPath = null;
                            while (treeWalk.next() && !this.monitor.isCanceled()) {
                                DirCacheEntry e;
                                File path = new File(repository.getWorkTree(), treeWalk.getPathString());
                                int modeCache = treeWalk.getFileMode(0).getBits();
                                int modeRev = treeWalk.getFileMode(1).getBits();
                                ObjectId objIdRev = treeWalk.getObjectId(1);
                                ObjectId objIdCache = treeWalk.getObjectId(0);
                                if (treeWalk.getPathString().equals(lastAddedPath)) continue;
                                lastAddedPath = treeWalk.getPathString();
                                if (!this.recursively && !this.directChild(this.roots, repository.getWorkTree(), path)) {
                                    e = ((DirCacheBuildIterator)treeWalk.getTree(0, DirCacheBuildIterator.class)).getDirCacheEntry();
                                    builder.add(e);
                                    continue;
                                }
                                if (modeRev == FileMode.MISSING.getBits()) {
                                    this.listener.notifyFile(path, treeWalk.getPathString());
                                    toDelete.add(path);
                                    continue;
                                }
                                if (modeRev != FileMode.MISSING.getBits() && modeCache != FileMode.MISSING.getBits() && !objIdCache.equals((AnyObjectId)objIdRev) || modeCache == FileMode.MISSING.getBits()) {
                                    this.listener.notifyFile(path, treeWalk.getPathString());
                                    e = new DirCacheEntry(treeWalk.getPathString());
                                    AbstractTreeIterator it = treeWalk.getTree(1, AbstractTreeIterator.class);
                                    e.setFileMode(it.getEntryFileMode());
                                    e.setLastModified(System.currentTimeMillis());
                                    e.setObjectId((AnyObjectId)it.getEntryObjectId());
                                    e.smudgeRacilyClean();
                                    builder.add(e);
                                    continue;
                                }
                                e = ((DirCacheBuildIterator)treeWalk.getTree(0, DirCacheBuildIterator.class)).getDirCacheEntry();
                                builder.add(e);
                            }
                            if (!this.monitor.isCanceled()) {
                                finished = true;
                                if (this.resetType.equals((Object)GitClient.ResetType.HARD)) {
                                    builder.finish();
                                    for (File file : toDelete) {
                                        File[] fileArray;
                                        if (this.roots.length > 0) {
                                            fileArray = this.roots;
                                        } else {
                                            File[] fileArray2 = new File[1];
                                            fileArray = fileArray2;
                                            fileArray2[0] = repository.getWorkTree();
                                        }
                                        this.deleteFile(file, fileArray);
                                    }
                                    try {
                                        new CheckoutIndex(repository, cache, this.roots, true, this.listener, this.monitor, false).checkout();
                                    }
                                    finally {
                                        builder.commit();
                                    }
                                } else {
                                    builder.commit();
                                }
                                repository.writeMergeHeads(null);
                                repository.writeMergeCommitMsg(null);
                                repository.writeCherryPickHead(null);
                            }
                        }
                        if (this.moveHead && !this.monitor.isCanceled()) {
                            RefUpdate u = repository.updateRef("HEAD");
                            u.setNewObjectId((AnyObjectId)commit);
                            if (u.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                                throw new GitException.RefUpdateException(MessageFormat.format(Utils.getBundle(ResetCommand.class).getString("MSG_Exception_CannotUpdateHead"), this.revisionStr), GitRefUpdateResult.valueOf(RefUpdate.Result.LOCK_FAILURE.name()));
                            }
                        }
                    }
                    finally {
                        cache.unlock();
                    }
                }
                catch (IOException ex) {
                    throw new GitException(ex);
                }
            }
            finally {
                if (started && !finished) {
                    backup.lock();
                    try {
                        backup.write();
                    }
                    finally {
                        backup.unlock();
                    }
                }
            }
        }
        catch (NoWorkTreeException ex) {
            throw new GitException(ex);
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    private void deleteFile(File file, File[] roots) {
        File[] children;
        HashSet<File> rootFiles = new HashSet<File>(Arrays.asList(roots));
        while (!(file == null || rootFiles.contains(file) || (children = file.listFiles()) != null && children.length != 0)) {
            if (!file.delete()) {
                this.monitor.notifyWarning("Cannot delete " + file.getAbsolutePath());
            }
            file = file.getParentFile();
        }
    }

    private boolean directChild(File[] roots, File workTree, File path) {
        if (roots.length == 0) {
            roots = new File[]{workTree};
        }
        for (File parent : roots) {
            if (!parent.equals(path) && !parent.equals(path.getParentFile())) continue;
            return true;
        }
        return false;
    }
}

