/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import com.jcraft.jsch.JSchException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

abstract class TransportCommand
extends GitCommand {
    private static final String PROP_ENV_GIT_SSH = "GIT_SSH";
    private static final String PROP_GIT_SSH_SYSTEM_CLIENT = "versioning.git.library.useSystemSSHClient";
    private CredentialsProvider credentialsProvider;
    private final String remote;
    private static final Logger LOG = Logger.getLogger(TransportCommand.class.getName());

    public TransportCommand(Repository repository, GitClassFactory gitFactory, String remote, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.remote = remote;
    }

    protected final URIish getUri(boolean pushUri) throws URISyntaxException {
        List uris;
        RemoteConfig config = this.getRemoteConfig();
        if (config == null) {
            uris = Collections.emptyList();
        } else if (pushUri) {
            uris = config.getPushURIs();
            if (uris.isEmpty()) {
                uris = config.getURIs();
            }
        } else {
            uris = config.getURIs();
        }
        if (uris.isEmpty()) {
            return new URIish(this.remote);
        }
        return (URIish)uris.get(0);
    }

    protected final URIish getUriWithUsername(boolean pushUri) throws URISyntaxException {
        URIish uri = this.getUri(pushUri);
        if (this.credentialsProvider != null) {
            CredentialItem.Username itm = new CredentialItem.Username();
            this.credentialsProvider.get(uri, new CredentialItem[]{itm});
            if (itm.getValue() != null) {
                uri = itm.getValue().isEmpty() ? uri.setUser(null) : uri.setUser(itm.getValue());
            }
        }
        return uri;
    }

    public final void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() throws GitException {
        boolean replace;
        SystemReader original = SystemReader.getInstance();
        String externalTool = original.getenv(PROP_ENV_GIT_SSH);
        boolean bl = replace = externalTool != null;
        if ("true".equals(System.getProperty(PROP_GIT_SSH_SYSTEM_CLIENT, "false"))) {
            replace = false;
        }
        try {
            if (replace) {
                LOG.log(Level.WARNING, "{0} set to {1}, ignoring and using the default implementation via JSch", new Object[]{PROP_ENV_GIT_SSH, externalTool});
                SystemReader.setInstance((SystemReader)new DelegatingSystemReader(original));
            }
            this.runTransportCommand();
        }
        finally {
            if (replace) {
                SystemReader.setInstance((SystemReader)original);
            }
        }
    }

    protected final CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected final RemoteConfig getRemoteConfig() throws URISyntaxException {
        RemoteConfig config = new RemoteConfig((Config)this.getRepository().getConfig(), this.remote);
        if (config.getURIs().isEmpty() && config.getPushURIs().isEmpty()) {
            return null;
        }
        return config;
    }

    protected Transport openTransport(boolean openPush) throws URISyntaxException, NotSupportedException, TransportException {
        URIish uri = this.getUriWithUsername(openPush);
        for (TransportProtocol proto : Transport.getTransportProtocols()) {
            if (!proto.getSchemes().contains("ftp")) continue;
            Transport.unregister((TransportProtocol)proto);
        }
        Transport transport = Transport.open((Repository)this.getRepository(), (URIish)uri);
        RemoteConfig config = this.getRemoteConfig();
        if (config != null) {
            transport.applyConfig(config);
        }
        if (transport.getTimeout() <= 0) {
            transport.setTimeout(45);
        }
        transport.setCredentialsProvider(this.getCredentialsProvider());
        return transport;
    }

    protected final void handleException(TransportException e, URIish uri) throws GitException.AuthorizationException, GitException {
        String message = e.getMessage();
        if (message == null) {
            throw new GitException(e);
        }
        int pos = message.indexOf(": not authorized");
        if (pos != -1) {
            String repositoryUrl = message.substring(0, pos);
            throw new GitException.AuthorizationException(repositoryUrl, message, e);
        }
        pos = message.indexOf(": 401 ");
        if (pos != -1) {
            String repositoryUrl = message.substring(0, pos);
            throw new GitException.AuthorizationException(repositoryUrl, message, e);
        }
        if (message.contains("not authorized")) {
            throw new GitException.AuthorizationException(uri.toString(), message, e);
        }
        pos = message.toLowerCase().indexOf(": auth cancel");
        if (pos != -1) {
            String repositoryUrl = message.substring(0, pos);
            throw new GitException.AuthorizationException(repositoryUrl, message, e);
        }
        if (e.getCause() instanceof JSchException) {
            if (message.contains("timeout:")) {
                throw new GitException(message, e);
            }
            throw new GitException.AuthorizationException(uri.toString(), message, e);
        }
        throw new GitException(message, e);
    }

    protected abstract void runTransportCommand() throws GitException;

    private static class DelegatingSystemReader
    extends SystemReader {
        private final SystemReader instance;

        public DelegatingSystemReader(SystemReader sr) {
            this.instance = sr;
        }

        public String getHostname() {
            return this.instance.getHostname();
        }

        public String getenv(String string) {
            if (TransportCommand.PROP_ENV_GIT_SSH.equals(string)) {
                return null;
            }
            return this.instance.getenv(string);
        }

        public String getProperty(String string) {
            return this.instance.getProperty(string);
        }

        public FileBasedConfig openUserConfig(Config config, FS fs) {
            return this.instance.openUserConfig(config, fs);
        }

        public FileBasedConfig openSystemConfig(Config config, FS fs) {
            return this.instance.openSystemConfig(config, fs);
        }

        public long getCurrentTime() {
            return this.instance.getCurrentTime();
        }

        public int getTimezone(long l) {
            return this.instance.getTimezone(l);
        }
    }
}

