/*
 * Decompiled with CFR 0.152.
 */
package ice.dom.css;

import ice.dom.css.CSSStyleDeclarationImpl;
import ice.dom.css.CSSValueImpl;
import ice.dom.css.RGBColorImpl;
import ice.storm.DynEnv;
import java.awt.Color;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSPrimitiveValueImpl
extends CSSValueImpl
implements CSSPrimitiveValue {
    short primitiveType;
    Object value;
    private static final int[] oldTypes = new int[]{0, -14, -4, -5, -6, -7, -9, -10, -8, -11, -12, -15, -15, -15, -15, -15, -15, -15, -15, -1, -1, 0, 0, 0, 0, -2};
    private static final int Method_getCounterValue = -1;
    private static final int Method_getFloatValue = -2;
    private static final int Method_getRectValue = -3;
    private static final int Method_getRGBColorValue = -4;
    private static final int Method_getStringValue = -5;
    private static final int Method_setFloatValue = -6;
    private static final int Method_setStringValue = -7;

    private int convertNewTypeToOld(short newType) {
        short index = newType;
        if (index > 25) {
            return 0;
        }
        return oldTypes[index];
    }

    private float convertFloat(short oldType, short newType) {
        float old;
        if (!(this.value instanceof Float)) {
            return 0.0f;
        }
        float PI = 3.141529f;
        float rtrn = old = ((Float)this.value).floatValue();
        block0 : switch (oldType) {
            case 11: {
                switch (newType) {
                    case 13: {
                        rtrn = old * 100.0f / 90.0f;
                        break;
                    }
                    case 12: {
                        rtrn = old * PI / 180.0f;
                    }
                }
                break;
            }
            case 13: {
                switch (newType) {
                    case 11: {
                        rtrn = old * 90.0f / 100.0f;
                        break;
                    }
                    case 12: {
                        rtrn = old * PI / 200.0f;
                    }
                }
                break;
            }
            case 12: {
                switch (newType) {
                    case 11: {
                        rtrn = old * 180.0f / PI;
                        break block0;
                    }
                    case 13: {
                        rtrn = old * 200.0f / PI;
                    }
                }
            }
        }
        return rtrn;
    }

    static CSSValueImpl createIdent(CSSStyleDeclarationImpl styleDecl, String property, String propValue) {
        CSSPrimitiveValueImpl rtrn = new CSSPrimitiveValueImpl(styleDecl, property);
        rtrn.value = propValue;
        rtrn.primitiveType = (short)21;
        rtrn.valueType = 1;
        return rtrn;
    }

    static CSSValueImpl createCSSPrimitiveValue(CSSStyleDeclarationImpl styleDecl, String property, int type, Object theValue) {
        if (theValue == null) {
            return null;
        }
        CSSPrimitiveValueImpl rtrn = new CSSPrimitiveValueImpl(styleDecl, property);
        rtrn.valueType = 1;
        if (type == -2) {
            rtrn.value = new RGBColorImpl((Color)theValue);
            rtrn.primitiveType = (short)25;
        } else {
            rtrn.value = theValue;
            switch (type) {
                case -9: {
                    rtrn.primitiveType = (short)6;
                    break;
                }
                case -5: {
                    rtrn.primitiveType = (short)3;
                    break;
                }
                case -6: {
                    rtrn.primitiveType = (short)4;
                    break;
                }
                case -8: {
                    rtrn.primitiveType = (short)8;
                    break;
                }
                case -10: {
                    rtrn.primitiveType = (short)7;
                    break;
                }
                case -12: {
                    rtrn.primitiveType = (short)10;
                    break;
                }
                case -11: {
                    rtrn.primitiveType = (short)9;
                    break;
                }
                case -7: {
                    rtrn.primitiveType = (short)5;
                    break;
                }
                case -4: {
                    rtrn.primitiveType = (short)2;
                    break;
                }
                case -1: {
                    rtrn.primitiveType = (short)19;
                    break;
                }
                case -3: {
                    rtrn.primitiveType = (short)20;
                    break;
                }
                case -14: {
                    rtrn.primitiveType = 1;
                    break;
                }
                default: {
                    rtrn.primitiveType = theValue instanceof String ? (short)19 : (theValue instanceof Float ? (short)18 : (short)0);
                }
            }
        }
        return rtrn;
    }

    public short getPrimitiveType() {
        return this.primitiveType;
    }

    public void setFloatValue(short unitType, float floatValue) {
        this.primitiveType = unitType;
        this.value = new Float(floatValue);
        this.styleDecl.updateCorrespondingCSSDecl(this.property, this.value, this.convertNewTypeToOld(this.primitiveType));
    }

    public float getFloatValue(short unitType) {
        if (unitType != this.primitiveType) {
            return this.convertFloat(this.primitiveType, unitType);
        }
        return this.value instanceof Float ? ((Float)this.value).floatValue() : 0.0f;
    }

    public void setStringValue(short stringType, String stringValue) {
        this.primitiveType = stringType;
        this.value = stringValue;
        this.styleDecl.updateCorrespondingCSSDecl(this.property, this.value, this.convertNewTypeToOld(this.primitiveType));
    }

    public String getStringValue() {
        return this.value instanceof String ? (String)this.value : null;
    }

    public Counter getCounterValue() {
        return null;
    }

    public Rect getRectValue() {
        return null;
    }

    public RGBColor getRGBColorValue() {
        return this.value instanceof RGBColor ? (RGBColor)this.value : null;
    }

    CSSPrimitiveValueImpl(CSSStyleDeclarationImpl styleDecl, String property) {
        super(styleDecl, property);
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = CSSPrimitiveValueImpl.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = CSSPrimitiveValueImpl.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = CSSPrimitiveValueImpl.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                return this.getCounterValue();
            }
            case -2: {
                short unitType = env.toShort(args, 0);
                return env.wrapDouble(this.getFloatValue(unitType));
            }
            case -3: {
                return this.getRectValue();
            }
            case -4: {
                return this.getRGBColorValue();
            }
            case -5: {
                return this.getStringValue();
            }
            case -6: {
                short unitType = (short)env.toInt(args, 0);
                float floatValue = (float)env.toDouble(args, 1);
                this.setFloatValue(unitType, floatValue);
                break;
            }
            case -7: {
                short unitType = (short)env.toInt(args, 0);
                this.setStringValue(unitType, env.toStr(args, 1));
                break;
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 12: {
                guess = "getRectValue";
                id = -3;
                break;
            }
            case 13: {
                char c = s.charAt(0);
                if (c == 'g') {
                    guess = "getFloatValue";
                    id = -2;
                    break;
                }
                if (c != 's') break;
                guess = "setFloatValue";
                id = -6;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'g') {
                    guess = "getStringValue";
                    id = -5;
                    break;
                }
                if (c != 's') break;
                guess = "setStringValue";
                id = -7;
                break;
            }
            case 15: {
                guess = "getCounterValue";
                id = -1;
                break;
            }
            case 16: {
                guess = "getRGBColorValue";
                id = -4;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

