/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.FunctionNode;
import ice.mozilla.javascript.NativeGlobal;
import ice.mozilla.javascript.Node;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.TokenStream;

public class IRFactory {
    private TokenStream ts;
    private Scriptable scope;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;

    public IRFactory(TokenStream ts, Scriptable scope) {
        this.ts = ts;
        this.scope = scope;
    }

    public Object createScript(Object body, String sourceName, int baseLineno, int endLineno, Object source) {
        Node result = Node.newString(146, sourceName);
        Node children = ((Node)body).getFirstChild();
        if (children != null) {
            result.addChildrenToBack(children);
        }
        result.putProp(16, sourceName);
        result.putIntProp(28, baseLineno);
        result.putIntProp(29, endLineno);
        if (source != null) {
            result.putProp(17, source);
        }
        return result;
    }

    public Object createLeaf(int nodeType) {
        return new Node(nodeType);
    }

    public Object createLeaf(int nodeType, int nodeOp) {
        return new Node(nodeType, nodeOp);
    }

    public int getLeafType(Object leaf) {
        Node n = (Node)leaf;
        return n.getType();
    }

    public Object createSwitch(int lineno) {
        return new Node(115, lineno);
    }

    public Object createVariables(int lineno) {
        return new Node(123, lineno);
    }

    public Object createExprStatement(Object expr, int lineno) {
        return new Node(140, (Node)expr, lineno);
    }

    public Object createName(String name) {
        return Node.newString(44, name);
    }

    public Object createString(String string) {
        return Node.newString(string);
    }

    public Object createNumber(double number) {
        return Node.newNumber(number);
    }

    public Object createCatch(String varName, Object catchCond, Object stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new Node(109, 52);
        }
        return new Node(125, (Node)this.createName(varName), (Node)catchCond, (Node)stmts, lineno);
    }

    public Object createThrow(Object expr, int lineno) {
        return new Node(62, (Node)expr, lineno);
    }

    public Object createReturn(Object expr, int lineno) {
        return expr == null ? new Node(5, lineno) : new Node(5, (Node)expr, lineno);
    }

    public Object createLabel(String label, int lineno) {
        Node result = new Node(136, lineno);
        Node name = Node.newString(44, label);
        result.addChildToBack(name);
        return result;
    }

    public Object createBreak(String label, int lineno) {
        Node result = new Node(121, lineno);
        if (label == null) {
            return result;
        }
        Node name = Node.newString(44, label);
        result.addChildToBack(name);
        return result;
    }

    public Object createContinue(String label, int lineno) {
        Node result = new Node(122, lineno);
        if (label == null) {
            return result;
        }
        Node name = Node.newString(44, label);
        result.addChildToBack(name);
        return result;
    }

    public Object createBlock(int lineno) {
        return new Node(133, lineno);
    }

    public Object createFunctionNode(String name, Object args, Object statements) {
        if (name == null) {
            name = "";
        }
        return new FunctionNode(name, (Node)args, (Node)statements);
    }

    public Object createFunction(String name, Object args, Object statements, String sourceName, int baseLineno, int endLineno, Object source, boolean isExpr) {
        FunctionNode f = (FunctionNode)this.createFunctionNode(name, args, statements);
        f.setFunctionType(isExpr ? 2 : 1);
        f.putProp(16, sourceName);
        f.putIntProp(28, baseLineno);
        f.putIntProp(29, endLineno);
        if (source != null) {
            f.putProp(17, source);
        }
        Node result = Node.newString(110, name);
        result.putProp(5, f);
        return result;
    }

    public void setFunctionExpressionStatement(Object o) {
        Node n = (Node)o;
        FunctionNode f = (FunctionNode)n.getProp(5);
        f.setFunctionType(3);
    }

    public void addChildToBack(Object parent, Object child) {
        ((Node)parent).addChildToBack((Node)child);
    }

    public Object createWhile(Object cond, Object body, int lineno) {
        return this.createLoop(1, (Node)body, (Node)cond, null, null, lineno);
    }

    public Object createDoWhile(Object body, Object cond, int lineno) {
        return this.createLoop(0, (Node)body, (Node)cond, null, null, lineno);
    }

    public Object createFor(Object init, Object test, Object incr, Object body, int lineno) {
        return this.createLoop(2, (Node)body, (Node)test, (Node)init, (Node)incr, lineno);
    }

    private Node createLoop(int loopType, Node body, Node cond, Node init, Node incr, int lineno) {
        Node bodyTarget = new Node(137);
        Node condTarget = new Node(137);
        if (loopType == 2 && cond.getType() == 132) {
            cond = new Node(109, 52);
        }
        Node IFEQ = new Node(7, cond);
        IFEQ.putProp(1, bodyTarget);
        Node breakTarget = new Node(137);
        Node result = new Node(138, lineno);
        result.addChildToBack(bodyTarget);
        result.addChildrenToBack(body);
        result.addChildToBack(condTarget);
        result.addChildToBack(IFEQ);
        result.addChildToBack(breakTarget);
        result.putProp(2, breakTarget);
        Node continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            Node GOTO = new Node(6);
            GOTO.putProp(1, condTarget);
            result.addChildToFront(GOTO);
            if (loopType == 2) {
                if (init.getType() != 132) {
                    if (init.getType() != 123) {
                        init = new Node(57, init);
                    }
                    result.addChildToFront(init);
                }
                Node incrTarget = new Node(137);
                result.addChildAfter(incrTarget, body);
                if (incr.getType() != 132) {
                    incr = (Node)this.createUnary(57, incr);
                    result.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        result.putProp(3, continueTarget);
        return result;
    }

    public Object createForIn(Object lhs, Object obj, Object body, int lineno) {
        Node lhsNode = (Node)lhs;
        Node objNode = (Node)obj;
        int type = lhsNode.getType();
        Node lvalue = lhsNode;
        switch (type) {
            case 39: 
            case 41: 
            case 44: {
                break;
            }
            case 123: {
                Node lastChild = lhsNode.getLastChild();
                if (lhsNode.getFirstChild() != lastChild) {
                    this.reportError("msg.mult.index");
                }
                lvalue = Node.newString(44, lastChild.getString());
                break;
            }
            default: {
                this.reportError("msg.bad.for.in.lhs");
                return objNode;
            }
        }
        Node init = new Node(79, objNode);
        Node next = new Node(80);
        next.putProp(4, init);
        Node temp = this.createNewTemp(next);
        Node cond = new Node(102, 15);
        cond.addChildToBack(temp);
        cond.addChildToBack(new Node(109, 49));
        Node newBody = new Node(133);
        Node assign = (Node)this.createAssignment(128, lvalue, this.createUseTemp(temp), null, false);
        newBody.addChildToBack(new Node(57, assign));
        newBody.addChildToBack((Node)body);
        Node result = (Node)this.createWhile(cond, newBody, lineno);
        result.addChildToFront(init);
        if (type == 123) {
            result.addChildToFront(lhsNode);
        }
        Node done = new Node(139);
        done.putProp(4, init);
        result.addChildToBack(done);
        return result;
    }

    public Object createTryCatchFinally(Object tryblock, Object catchblocks, Object finallyblock, int lineno) {
        Node trynode = (Node)tryblock;
        if (trynode.getType() == 133 && !trynode.hasChildren()) {
            return trynode;
        }
        Node pn = new Node(75, trynode, lineno);
        Node catchNodes = (Node)catchblocks;
        boolean hasCatch = catchNodes.hasChildren();
        boolean hasFinally = false;
        Node finallyNode = null;
        Node finallyTarget = null;
        if (finallyblock != null) {
            finallyNode = (Node)finallyblock;
            boolean bl = hasFinally = finallyNode.getType() != 133 || finallyNode.hasChildren();
            if (hasFinally) {
                finallyTarget = new Node(137);
                pn.putProp(21, finallyTarget);
                Node jsrFinally = new Node(143);
                jsrFinally.putProp(1, finallyTarget);
                pn.addChildToBack(jsrFinally);
            }
        }
        if (!hasFinally && !hasCatch) {
            return trynode;
        }
        Node endTarget = new Node(137);
        Node GOTOToEnd = new Node(6);
        GOTOToEnd.putProp(1, endTarget);
        pn.addChildToBack(GOTOToEnd);
        if (hasCatch) {
            Node catchTarget = new Node(137);
            pn.putProp(1, catchTarget);
            pn.addChildToBack(catchTarget);
            Node exn = this.createNewLocal(new Node(132));
            pn.addChildToBack(new Node(57, exn));
            Node endCatch = new Node(137);
            for (Node cb = catchNodes.getFirstChild(); cb != null; cb = cb.getNext()) {
                Node catchStmt = new Node(133);
                int catchLineNo = cb.getLineno();
                Node name = cb.getFirstChild();
                Node cond = name.getNext();
                Node catchBlock = cond.getNext();
                cb.removeChild(name);
                cb.removeChild(cond);
                cb.removeChild(catchBlock);
                Node newScope = this.createNewLocal(new Node(77));
                Node initScope = new Node(40, newScope, Node.newString(name.getString()), this.createUseLocal(exn));
                catchStmt.addChildToBack(new Node(57, initScope));
                catchBlock.addChildToBack(new Node(4));
                Node GOTOToEndCatch = new Node(6);
                GOTOToEndCatch.putProp(1, endCatch);
                catchBlock.addChildToBack(GOTOToEndCatch);
                Node ifStmt = (Node)this.createIf(cond, catchBlock, null, catchLineNo);
                Node withStmt = (Node)this.createWith(this.createUseLocal(newScope), ifStmt, catchLineNo);
                catchStmt.addChildToBack(withStmt);
                pn.addChildToBack(catchStmt);
            }
            Node rethrow = new Node(62, this.createUseLocal(exn));
            pn.addChildToBack(rethrow);
            pn.addChildToBack(endCatch);
            if (hasFinally) {
                Node jsrFinally = new Node(143);
                jsrFinally.putProp(1, finallyTarget);
                pn.addChildToBack(jsrFinally);
                Node GOTO = new Node(6);
                GOTO.putProp(1, endTarget);
                pn.addChildToBack(GOTO);
            }
        }
        if (hasFinally) {
            pn.addChildToBack(finallyTarget);
            Node returnTemp = this.createNewLocal(new Node(132));
            Node popAndMake = new Node(57, returnTemp);
            pn.addChildToBack(popAndMake);
            pn.addChildToBack(finallyNode);
            Node ret = this.createUseLocal(returnTemp);
            ret.putProp(1, Boolean.TRUE);
            pn.addChildToBack(ret);
        }
        pn.addChildToBack(endTarget);
        return pn;
    }

    public Object createWith(Object obj, Object body, int lineno) {
        Node result = new Node(133, lineno);
        result.addChildToBack(new Node(3, (Node)obj));
        Node bodyNode = new Node(124, (Node)body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(4));
        return result;
    }

    public Object createArrayLiteral(Object obj) {
        Node array = new Node(30, Node.newString(44, "Array"));
        Node temp = this.createNewTemp(array);
        Node elem = null;
        int i = 0;
        Node comma = new Node(96, temp);
        for (Node cursor = ((Node)obj).getFirstChild(); cursor != null; cursor = cursor.getNext()) {
            elem = cursor;
            if (elem.getType() == 109 && elem.getOperation() == 74) {
                ++i;
                continue;
            }
            Node addelem = new Node(42, this.createUseTemp(temp), Node.newNumber(i), elem);
            ++i;
            comma.addChildToBack(addelem);
        }
        if (Context.getContext().getLanguageVersion() == 120) {
            if (elem != null && elem.getType() == 109 && elem.getOperation() == 74) {
                Node setlength = new Node(40, this.createUseTemp(temp), Node.newString("length"), Node.newNumber(i));
                comma.addChildToBack(setlength);
            }
        } else {
            array.addChildToBack(Node.newNumber(i));
        }
        comma.addChildToBack(this.createUseTemp(temp));
        return comma;
    }

    public Object createObjectLiteral(Object obj) {
        Node result = new Node(30, Node.newString(44, "Object"));
        Node temp = this.createNewTemp(result);
        Node comma = new Node(96, temp);
        for (Node cursor = ((Node)obj).getFirstChild(); cursor != null; cursor = cursor.getNext()) {
            Node n = cursor;
            cursor = cursor.getNext();
            int op = n.getType() == 44 ? 40 : 42;
            Node next = cursor;
            Node addelem = new Node(op, this.createUseTemp(temp), n, next);
            comma.addChildToBack(addelem);
        }
        comma.addChildToBack(this.createUseTemp(temp));
        return comma;
    }

    public Object createRegExp(String string, String flags) {
        return flags.length() == 0 ? new Node(56, Node.newString(string)) : new Node(56, Node.newString(string), Node.newString(flags));
    }

    public Object createIf(Object cond, Object ifTrue, Object ifFalse, int lineno) {
        Node result = new Node(133, lineno);
        Node ifNotTarget = new Node(137);
        Node IFNE = new Node(8, (Node)cond);
        IFNE.putProp(1, ifNotTarget);
        result.addChildToBack(IFNE);
        result.addChildrenToBack((Node)ifTrue);
        if (ifFalse != null) {
            Node GOTOToEnd = new Node(6);
            Node endTarget = new Node(137);
            GOTOToEnd.putProp(1, endTarget);
            result.addChildToBack(GOTOToEnd);
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack((Node)ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    public Object createTernary(Object cond, Object ifTrue, Object ifFalse) {
        return this.createIf(cond, ifTrue, ifFalse, -1);
    }

    public Object createUnary(int nodeType, Object child) {
        Node childNode = (Node)child;
        if (nodeType == 31) {
            Node right;
            Node left;
            int childType = childNode.getType();
            if (childType == 44) {
                childNode.setType(61);
                left = childNode;
                right = childNode.cloneNode();
                right.setType(46);
            } else if (childType == 39 || childType == 41) {
                left = childNode.getFirstChild();
                right = childNode.getLastChild();
                childNode.removeChild(left);
                childNode.removeChild(right);
            } else {
                return new Node(109, 52);
            }
            return new Node(nodeType, left, right);
        }
        return new Node(nodeType, childNode);
    }

    public Object createUnary(int nodeType, int nodeOp, Object child) {
        Node childNode = (Node)child;
        int childType = childNode.getType();
        if (nodeOp == 32 && childType == 44) {
            childNode.setType(32);
            return childNode;
        }
        if (nodeType == 106 || nodeType == 107) {
            if (!(IRFactory.hasSideEffects(childNode) || nodeOp != 131 || childType != 44 && childType != 39 && childType != 41)) {
                return new Node(nodeType, childNode);
            }
            Node rhs = (Node)this.createNumber(1.0);
            return this.createAssignment(nodeType == 106 ? 23 : 24, childNode, rhs, ScriptRuntime.NumberClass, nodeOp == 131);
        }
        Node result = new Node(nodeType, nodeOp);
        result.addChildToBack((Node)child);
        return result;
    }

    public Object createBinary(int nodeType, Object left, Object right) {
        switch (nodeType) {
            case 108: {
                nodeType = 39;
                Node idNode = (Node)right;
                idNode.setType(46);
                String id = idNode.getString();
                if (!id.equals("__proto__") && !id.equals("__parent__")) break;
                Node result = new Node(nodeType, (Node)left);
                result.putProp(19, id);
                return result;
            }
            case 90: {
                nodeType = 41;
            }
        }
        return new Node(nodeType, (Node)left, (Node)right);
    }

    public Object createBinary(int nodeType, int nodeOp, Object left, Object right) {
        if (nodeType == 97) {
            return this.createAssignment(nodeOp, (Node)left, (Node)right, null, false);
        }
        return new Node(nodeType, (Node)left, (Node)right, nodeOp);
    }

    public Object createAssignment(int nodeOp, Node left, Node right, Class convert, boolean postfix) {
        int nodeType = left.getType();
        Node id = null;
        switch (nodeType) {
            case 44: {
                return this.createSetName(nodeOp, left, right, convert, postfix);
            }
            case 39: {
                String idString = (String)left.getProp(19);
                if (idString != null) {
                    id = Node.newString(idString);
                }
            }
            case 41: {
                if (id == null) {
                    id = left.getLastChild();
                }
                return this.createSetProp(nodeType, nodeOp, left.getFirstChild(), id, right, convert, postfix);
            }
        }
        this.reportError("msg.bad.lhs.assign");
        return left;
    }

    private Node createConvert(Class toType, Node expr) {
        if (toType == null) {
            return expr;
        }
        Node result = new Node(142, expr);
        result.putProp(18, ScriptRuntime.NumberClass);
        return result;
    }

    private Object createSetName(int nodeOp, Node left, Node right, Class convert, boolean postfix) {
        if (nodeOp == 128) {
            left.setType(61);
            return new Node(10, left, right);
        }
        String s = left.getString();
        if (s.equals("__proto__") || s.equals("__parent__")) {
            Node result = new Node(40, left, right);
            result.putProp(19, s);
            return result;
        }
        Node opLeft = Node.newString(44, s);
        if (convert != null) {
            opLeft = this.createConvert(convert, opLeft);
        }
        if (postfix) {
            opLeft = this.createNewTemp(opLeft);
        }
        Node op = new Node(nodeOp, opLeft, right);
        Node lvalueLeft = Node.newString(61, s);
        Node result = new Node(10, lvalueLeft, op);
        if (postfix) {
            result = new Node(96, result, this.createUseTemp(opLeft));
        }
        return result;
    }

    public Node createNewTemp(Node n) {
        int type = n.getType();
        if (type == 46 || type == 45) {
            return n;
        }
        Node result = new Node(69, n);
        return result;
    }

    public Node createUseTemp(Node newTemp) {
        int type = newTemp.getType();
        if (type == 69) {
            Node result = new Node(70);
            result.putProp(6, newTemp);
            int n = newTemp.getIntProp(11, 0);
            if (n != Integer.MAX_VALUE) {
                newTemp.putIntProp(11, n + 1);
            }
            return result;
        }
        return newTemp.cloneNode();
    }

    public Node createNewLocal(Node n) {
        Node result = new Node(144, n);
        return result;
    }

    public Node createUseLocal(Node newLocal) {
        int type = newLocal.getType();
        if (type == 144) {
            Node result = new Node(145);
            result.putProp(7, newLocal);
            return result;
        }
        return newLocal.cloneNode();
    }

    public static boolean hasSideEffects(Node exprTree) {
        switch (exprTree.getType()) {
            case 10: 
            case 30: 
            case 40: 
            case 42: 
            case 43: 
            case 106: 
            case 107: {
                return true;
            }
        }
        for (Node child = exprTree.getFirstChild(); child != null; child = child.getNext()) {
            if (!IRFactory.hasSideEffects(child)) continue;
            return true;
        }
        return false;
    }

    private Node createSetProp(int nodeType, int nodeOp, Node obj, Node id, Node expr, Class convert, boolean postfix) {
        Node opLeft;
        Node tmp2;
        Node tmp1;
        String s;
        int type;
        int n = type = nodeType == 39 ? 40 : 42;
        if (type == 40 && ((s = id.getString()) != null && s.equals("__proto__") || s.equals("__parent__"))) {
            Node result = new Node(type, obj, expr);
            result.putProp(19, s);
            return result;
        }
        if (nodeOp == 128) {
            return new Node(type, obj, id, expr);
        }
        if (obj.getType() != 44 || id.hasChildren() || IRFactory.hasSideEffects(expr) || IRFactory.hasSideEffects(id)) {
            tmp1 = this.createNewTemp(obj);
            Node useTmp1 = this.createUseTemp(tmp1);
            tmp2 = this.createNewTemp(id);
            Node useTmp2 = this.createUseTemp(tmp2);
            opLeft = new Node(nodeType, useTmp1, useTmp2);
        } else {
            tmp1 = obj.cloneNode();
            tmp2 = id.cloneNode();
            opLeft = new Node(nodeType, obj, id);
        }
        if (convert != null) {
            opLeft = this.createConvert(convert, opLeft);
        }
        if (postfix) {
            opLeft = this.createNewTemp(opLeft);
        }
        Node op = new Node(nodeOp, opLeft, expr);
        Node result = new Node(type, tmp1, tmp2, op);
        if (postfix) {
            result = new Node(96, result, this.createUseTemp(opLeft));
        }
        return result;
    }

    private void reportError(String msgResource) {
        if (this.scope != null) {
            throw NativeGlobal.constructError(Context.getContext(), "SyntaxError", ScriptRuntime.getMessage0(msgResource), this.scope, this.ts.getSourceName(), this.ts.getLineno(), this.ts.getOffset(), this.ts.getLine());
        }
        String message = Context.getMessage0(msgResource);
        Context.reportError(message, this.ts.getSourceName(), this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }
}

