/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ExternalCSSBoxAssist;
import ice.pilots.html4.ImageObjectPainter;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class ObjectBox
extends CSSBox {
    private ObjectPainter painter;
    private boolean breakBefore = true;
    private boolean breakAfter = false;
    private int width = 0;
    private int height = 0;
    private int dy = 0;
    private DAreaElement focusedArea = null;
    private static ExternalCSSBoxAssist runtimeExtension;

    public boolean checkIfVisible() {
        CSSBox b = this;
        boolean visible = true;
        while (b != null) {
            if ((b.css.misc & 1) == 0) {
                visible = false;
                break;
            }
            b = b.parentBox;
        }
        if (visible && doCompleteZIndexTest) {
            visible = this.isZOrderVisible(b);
        }
        if (visible) {
            int highest = 0;
            b = ((InlineBox)this.parentBox).first;
            while (b != null) {
                highest = Math.max(highest, b.css.z_index);
                b = b.next;
            }
            if (highest > this.css.z_index) {
                visible = false;
            }
        }
        return visible;
    }

    private boolean isZOrderVisible(CSSBox b) {
        boolean visible = true;
        int compare_z = 0;
        if (visible) {
            b = this;
            while (b != null) {
                if (b.css.position == 126) {
                    compare_z = Math.max(compare_z, 1);
                } else if (b.css.position == 125) {
                    compare_z = Math.max(compare_z, 2);
                } else if (b.css.position == 6) {
                    compare_z = Math.max(compare_z, 3);
                }
                b = b.parentBox;
            }
            if (this.cssLayout == null) {
                return false;
            }
            Rectangle r = new Rectangle();
            this.findBoundingBox(r);
            Point p = new Point();
            b = this.cssLayout.getBoxAt(r.x, r.y + 1, 0, 0, p);
            if (b != null && b != this) {
                visible = this.isVisibleAtLocation(b, compare_z);
            }
            p.x = 0;
            p.y = 0;
            if (visible && (b = this.cssLayout.getBoxAt(r.x + r.width - 1, r.y + r.height - 1, 0, 0, p)) != null && b != this) {
                visible = this.isVisibleAtLocation(b, compare_z);
            }
            p.x = 0;
            p.y = 0;
            if (visible && (b = this.cssLayout.getBoxAt(r.x + r.width - 1, r.y, 0, 0, p)) != null && b != this) {
                visible = this.isVisibleAtLocation(b, compare_z);
            }
            p.x = 0;
            p.y = 0;
            if (visible && (b = this.cssLayout.getBoxAt(r.x, r.y + r.height - 1, 0, 0, p)) != null && b != this) {
                visible = this.isVisibleAtLocation(b, compare_z);
            }
        }
        return visible;
    }

    private boolean isVisibleAtLocation(CSSBox b, int compareZ) {
        int highest = 0;
        int positioned_z = 0;
        boolean visible = true;
        if (b != null && b != this) {
            while (b != null) {
                highest = Math.max(highest, b.css.z_index);
                if (b.css.position == 126) {
                    positioned_z = Math.max(positioned_z, 1);
                } else if (b.css.position == 125) {
                    positioned_z = Math.max(positioned_z, 2);
                } else if (b.css.position == 6) {
                    positioned_z = Math.max(positioned_z, 3);
                }
                b = b.parentBox;
            }
            if (highest > this.css.z_index) {
                visible = false;
            }
            if (positioned_z > compareZ) {
                visible = false;
            }
        }
        return visible;
    }

    ObjectBox(ObjectPainter painter, CSSLayout cssLayout) {
        super(cssLayout);
        this.painter = painter;
    }

    void setParentBox(CSSBox b) {
        super.setParentBox(b);
        this.css = b.css;
        Color c = b.css.color;
        if (c != null) {
            this.painter.setForeground(c);
        }
        if ((c = b.css.background_color) != null) {
            this.painter.setBackground(c);
        }
    }

    void updatePainterColors() {
        Color c = this.getForegroundColor();
        if (c != null) {
            this.painter.setForeground(c);
        }
        if ((c = this.getBackgroundColor()) != null) {
            this.painter.setBackground(c);
        }
    }

    public Color getBackgroundColor() {
        Color c = this.css.background_color;
        CSSBox b = this.parentBox;
        while (b != null && c == null && b.css.background_image == null) {
            c = b.css.background_color;
            b = b.parentBox;
        }
        return c;
    }

    private Color getForegroundColor() {
        Color c;
        CSSBox b = this;
        while ((c = b.css.color) == null && (b = b.parentBox) != null) {
        }
        return c;
    }

    void onBoxFocusChange(DNode node, int eventId) {
        if (node instanceof DAreaElement) {
            if (eventId == 22) {
                this.focusedArea = null;
                this.reqRepaint();
            } else if (eventId == 21) {
                this.focusedArea = (DAreaElement)node;
                this.reqRepaint();
            }
        }
    }

    DMapElement getUsemap() {
        DElement e;
        String mapname;
        DNode n = this.getDomNode();
        if (n instanceof DElement && (mapname = (e = (DElement)n).getAttribute(112)) != null && mapname.length() > 1) {
            int pos = mapname.indexOf("#");
            mapname = pos > 0 ? mapname.substring(pos + 1) : mapname.substring(1);
            DMapElement me = null;
            try {
                me = (DMapElement)e.doc.getMaps().namedItem(mapname);
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            return me;
        }
        return null;
    }

    DNode getDomNode() {
        if (this.parentBox == null) {
            return null;
        }
        return this.parentBox.getDomNode();
    }

    DNode getDomNode(int x, int y) {
        DMapElement map = this.getUsemap();
        if (map != null) {
            for (int i = 0; i < map.getAreas().getLength(); ++i) {
                DAreaElement tmp = (DAreaElement)map.getAreas().item(i);
                if (!tmp.isInside(x, y, this.width, this.height)) continue;
                return tmp;
            }
        }
        return this.getDomNode();
    }

    public void findAbsolutePosition(Point p) {
        if (this.painter instanceof EmbeddedObject) {
            p.y += this.css.padding_top;
        } else {
            p.x -= this.css.padding_left;
        }
        p.y += this.css.border_top_width + this.css.margin_top;
        p.y += this.dy;
        if (this.parentBox != null) {
            this.parentBox.findAbsolutePosition(p);
        }
    }

    void findBoundingBox(Rectangle r) {
        Point p = new Point();
        this.findAbsolutePosition(p);
        r.x = p.x;
        r.y = p.y;
        r.width = this.width;
        r.height = this.height;
    }

    CSSBox getBoxAt(int x, int y, Point rv) {
        rv.x = x;
        rv.y = y - this.css.padding_top;
        return this;
    }

    void dispose() {
        super.dispose();
        this.focusedArea = null;
        if (this.painter != null && this.painter.getBox() == this) {
            this.painter.setBox(null);
            this.painter = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    int calcBreaks() {
        block18: {
            block17: {
                block16: {
                    block15: {
                        if (this.css.border_top_style != 8 && this.css.border_bottom_style != 8 && this.css.border_left_style != 8 && this.css.border_right_style != 8) {
                            this.painter.setBorderVisible(false);
                        }
                        this.painter.setBox(this);
                        this.painter.setFontHints(this.css);
                        block = this.parentBox;
                        while (block != null && !(block instanceof BlockBox)) {
                            block = block.parentBox;
                        }
                        w = this.painter.getPrefWidth();
                        h = this.painter.getPrefHeight();
                        if (this.css.width < 0) break block15;
                        if (block == null) ** GOTO lbl-1000
                        if ((this.css.percentage_flag & 0x100000) != 0) {
                            this.totalWidth = this.width = this.css.width * block.width / 100;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.totalWidth = this.width = this.css.width;
                        }
                        break block16;
                    }
                    if (w > 0) {
                        this.totalWidth = this.painter instanceof ImageObjectPainter ? (this.width = w * this.cssLayout.zoom >> 8) : (this.width = w);
                    } else {
                        this.width = 50;
                        this.totalWidth = 50;
                    }
                }
                if (this.css.height < 0) break block17;
                if (block == null) ** GOTO lbl-1000
                if ((this.css.percentage_flag & 8) != 0) {
                    this.height = block.height >= 0 ? this.css.height * block.height / 100 : (h > 0 ? (this.painter instanceof ImageObjectPainter ? h * this.cssLayout.zoom >> 8 : h) : 10);
                } else lbl-1000:
                // 2 sources

                {
                    this.height = this.css.height;
                }
                break block18;
            }
            this.height = h > 0 ? (this.painter instanceof ImageObjectPainter ? h * this.cssLayout.zoom >> 8 : h) : 50;
        }
        if (this.painter instanceof ImageObjectPainter) {
            if (this.css.height >= 0 && this.css.width < 0 && h != 0) {
                this.totalWidth = this.width = this.height * w / h;
            } else if (this.css.width >= 0 && this.css.height < 0 && w != 0) {
                this.height = this.width * h / w;
            }
        }
        this.painter.setPainterSize(this.width, this.height);
        this.numBreaks = 0;
        if ((this.css.misc & 4) != 0) {
            this.breakAfter = false;
            this.breakBefore = false;
        }
        if (this.breakBefore) {
            ++this.numBreaks;
        }
        if (this.breakAfter) {
            ++this.numBreaks;
        }
        return this.numBreaks;
    }

    int getBreaks(int[] breaks, int idx) {
        if (this.breakBefore) {
            breaks[idx++] = 0;
        }
        if (this.breakAfter) {
            breaks[idx++] = this.width;
        }
        return this.numBreaks;
    }

    long getChunkDescentAscent(int x, int w, LineBox aLineMetrics) {
        int ascent = this.css.margin_top + this.css.border_top_width + this.height;
        int descent = this.css.margin_bottom + this.css.border_bottom_width;
        if (this.painter instanceof ImageObjectPainter) {
            ascent += this.css.padding_top;
            descent += this.css.padding_bottom;
        } else if (this.painter instanceof EmbeddedObject) {
            ascent += this.css.padding_top + this.css.padding_bottom;
        }
        return ObjectBox.wrapDescentAscent(descent, ascent, descent + ascent);
    }

    void paintChunk(Graphics g, int x, int w, LineBox aLineMetrics, int aBoxId) {
        CSSAttribs inlineCss = this.parentBox.css;
        if ((inlineCss.misc & 1) == 0) {
            return;
        }
        if (aLineMetrics != null && !(this.painter instanceof ImageObjectPainter)) {
            this.dy = aLineMetrics.getYDeflectionOfChunk(aBoxId);
        }
        int vadj = this.css.border_top_width + this.css.border_bottom_width;
        int hadj = this.css.border_left_width + this.css.border_right_width;
        if (this.painter instanceof ImageObjectPainter) {
            vadj += this.css.padding_top + this.css.padding_bottom;
            hadj += this.css.padding_left + this.css.padding_right;
        }
        if (this.parentBox.getType() != 1) {
            if (this.painter instanceof ImageObjectPainter) {
                this.paintBorders(g, g.getClipBounds(), x - this.css.border_left_width - this.css.padding_left, this.css.margin_top, w + hadj, this.height + vadj, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8 && x == 0, this.css.border_right_width > 0 && this.css.border_right_style != 8 && x + w == this.totalWidth);
            } else {
                this.paintBorders(g, g.getClipBounds(), x - this.css.border_left_width - this.css.padding_left, this.css.margin_top, w + hadj, this.height + vadj, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8 && x == 0, this.css.border_right_width > 0 && this.css.border_right_style != 8 && x + w == this.totalWidth);
            }
        }
        Graphics gg = null;
        gg = this.painter instanceof ImageObjectPainter || this.painter instanceof EmbeddedObject ? g.create(x, this.dy + this.css.padding_top + this.css.margin_top + this.css.border_top_width, this.width, this.height) : g.create(x - this.css.padding_left, this.css.margin_top + this.css.border_top_width, this.width, this.height);
        this.cssLayout.paintCallback(gg, this.painter);
        if (this.focusedArea != null) {
            this.drawUsemapArea(gg, this.focusedArea);
        }
        gg.dispose();
        if ((inlineCss.misc & 2) != 0) {
            this.cssLayout.outlinePainter.addRectangle(this, x, this.dy + this.css.border_top_width + this.css.padding_top + this.css.margin_top, this.width, this.height);
        }
        if (runtimeExtension != null) {
            runtimeExtension.addonImageProcessing(g, this);
        }
    }

    public void invalidate() {
        super.invalidate();
    }

    public void reqReflow() {
        super.reqReflow();
    }

    public void reqRepaint() {
        Point p = new Point();
        this.findAbsolutePosition(p);
        if (this.cssLayout != null && this.cssLayout.docPane != null) {
            int delta = this.cssLayout.maxOutlineWidth;
            this.cssLayout.docPane.reqRepaint(p.x - delta, p.y - delta, this.width + 2 * delta, this.height + 2 * delta);
        }
    }

    public ScrollBox getAncestorScrollBox() {
        CSSBox b = this.parentBox;
        if (b != null) {
            b = b.parentBox;
        }
        while (b != null) {
            if (b instanceof ScrollBox) {
                return (ScrollBox)b;
            }
            b = b.parentBox;
        }
        return null;
    }

    public ScrollBox getScrollBox() {
        CSSBox b = this.parentBox;
        if (b instanceof ScrollBox) {
            return (ScrollBox)b;
        }
        return null;
    }

    public ObjectPainter getObjectPainter() {
        return this.painter;
    }

    private void drawUsemapArea(Graphics g, DAreaElement e) {
        if (!e.checkCoords()) {
            return;
        }
        int[] coords = e.coords;
        String shape = e.getShape();
        g.setColor(Color.red);
        if (shape == null || shape.equalsIgnoreCase("rect")) {
            int y2;
            int x2;
            int y1;
            int x1 = coords[0];
            if (x1 < 0) {
                x1 = -x1 * this.width / 100;
            }
            if ((y1 = coords[1]) < 0) {
                y1 = -y1 * this.height / 100;
            }
            if ((x2 = coords[2]) < 0) {
                x2 = -x2 * this.width / 100;
            }
            if ((y2 = coords[3]) < 0) {
                y2 = -y2 * this.height / 100;
            }
            g.drawRect(x1, y1, x2 - x1, y2 - y1);
        } else if (shape.equalsIgnoreCase("circle")) {
            int r;
            int y1;
            int x1 = coords[0];
            if (x1 < 0) {
                x1 = -x1 * this.width / 100;
            }
            if ((y1 = coords[1]) < 0) {
                y1 = -y1 * this.height / 100;
            }
            if ((r = coords[2]) < 0) {
                r = this.width < this.height ? -r * this.width / 100 : -r * this.width / 100;
            }
            g.drawOval(x1 - r, y1 - r, r * 2, r * 2);
        } else if (shape.equalsIgnoreCase("poly")) {
            int y0;
            int x0;
            int i = 0;
            if ((x0 = coords[i++]) < 0) {
                x0 = -x0 * this.width / 100;
            }
            if ((y0 = coords[i++]) < 0) {
                y0 = -y0 * this.height / 100;
            }
            int x1 = x0;
            int y1 = y0;
            while (i < coords.length) {
                int y2;
                int x2;
                if ((x2 = coords[i++]) < 0) {
                    x2 = -x2 * this.width / 100;
                }
                if ((y2 = coords[i++]) < 0) {
                    y2 = -y2 * this.height / 100;
                }
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
            g.drawLine(x1, y1, x0, y0);
        }
        if (runtimeExtension != null) {
            runtimeExtension.addonImageProcessing(g, this);
        }
    }

    protected void findAbsolutePosition(Rectangle rec) {
        this.findBoundingBox(rec);
    }

    void findBoundingBox(Rectangle rect, DAreaElement node) {
        if (!node.checkCoords()) {
            return;
        }
        String s = node.getShape();
        if (s == null || s.equalsIgnoreCase("rect")) {
            int y2;
            int x2;
            int y1;
            int x1 = node.coords[0];
            if (x1 < 0) {
                x1 = -x1 * this.width / 100;
            }
            if ((y1 = node.coords[1]) < 0) {
                y1 = -y1 * this.height / 100;
            }
            if ((x2 = node.coords[2]) < 0) {
                x2 = -x2 * this.width / 100;
            }
            if ((y2 = node.coords[3]) < 0) {
                y2 = -y2 * this.height / 100;
            }
            this.findBoundingBox(rect);
            rect.x += x1;
            rect.y += y1;
            rect.width = x2 - x1;
            rect.height = y2 - y1;
        } else if (s.equalsIgnoreCase("circle")) {
            int r;
            int y1;
            int x1 = node.coords[0];
            if (x1 < 0) {
                x1 = -x1 * this.width / 100;
            }
            if ((y1 = node.coords[1]) < 0) {
                y1 = -y1 * this.height / 100;
            }
            if ((r = node.coords[2]) < 0) {
                r = this.width < this.height ? -r * this.width / 100 : -r * this.height / 100;
            }
            this.findBoundingBox(rect);
            rect.x += x1 - r;
            rect.y += y1 - r;
            rect.width = 2 * r;
            rect.height = 2 * r;
        } else if (s.equalsIgnoreCase("poly") || s.equalsIgnoreCase("polygon")) {
            int maxy;
            int maxx;
            int y0;
            int x0;
            int i = 0;
            if ((x0 = node.coords[i++]) < 0) {
                x0 = -x0 * this.width / 100;
            }
            if ((y0 = node.coords[i++]) < 0) {
                y0 = -y0 * this.height / 100;
            }
            int minx = maxx = x0;
            int miny = maxy = y0;
            while (i < node.coords.length) {
                if ((x0 = node.coords[i++]) < 0) {
                    x0 = -x0 * this.width / 100;
                }
                if ((y0 = node.coords[i++]) < 0) {
                    y0 = -y0 * this.height / 100;
                }
                if (x0 < minx) {
                    minx = x0;
                } else if (x0 > maxx) {
                    maxx = x0;
                }
                if (y0 < miny) {
                    miny = y0;
                    continue;
                }
                if (y0 <= maxy) continue;
                maxy = y0;
            }
            this.findBoundingBox(rect);
            rect.x += minx;
            rect.y += miny;
            rect.width = maxx - minx;
            rect.height = maxy - miny;
        }
    }

    static {
        String extensionClass = Defs.property("ice.pilots.html4.GraphicExtension");
        if (extensionClass != null) {
            try {
                Class<?> addon = Class.forName(extensionClass);
                runtimeExtension = (ExternalCSSBoxAssist)addon.newInstance();
            }
            catch (Exception e) {
                Debug.p("Exception occured loading graphic extension class:" + e);
            }
        }
    }
}

