/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.FloatBox;
import ice.pilots.html4.HighlightRange;
import ice.pilots.html4.TextBox;
import java.util.Vector;

public class Search {
    private DDocument doc;
    private CSSLayout cssLayout;
    private int mutation = 0;
    private char[] searchText;
    private char[] lowerCaseSearchText;
    private boolean caseSensitive = false;
    private boolean wholeWordSearch = false;
    private char[] allChars;
    private int numChars;
    private int[] charIndex;
    private DTextNode[] nodes;
    private int numNodes;
    private String searchString;
    private boolean highlightSearch;
    private Vector searchMatches;
    private int matchIndex;
    private boolean searchWrapping;
    private boolean searchVectorValid;
    private final int MAX_COUNT = 10000;
    private final int WHOLE_MAX_COUNT = 500;
    private final int INITIAL_VECTOR_SIZE = 30;
    private final int VECTOR_INC = 200;

    Search(DDocument doc, CSSLayout cssLayout) {
        this.doc = doc;
        this.cssLayout = cssLayout;
        this.searchMatches = new Vector(30, 200);
        this.record();
    }

    public void dispose() {
        this.cssLayout.clearSelection();
        this.cssLayout.clearHighlights();
        this.matchIndex = 0;
        this.searchMatches.removeAllElements();
        this.searchWrapping = false;
    }

    public void setSearchPosToStart() {
        this.matchIndex = 0;
        if (this.searchMatches.size() > 0) {
            this.select(0);
        }
        this.searchWrapping = false;
    }

    public void setWholeWordSearch(boolean flag) {
        if (flag != this.wholeWordSearch) {
            this.searchVectorValid = false;
        }
        this.wholeWordSearch = flag;
    }

    public boolean getWholeWordSearch() {
        return this.wholeWordSearch;
    }

    public void setHightlightSearches(boolean highlightSearch) {
        this.highlightSearch = highlightSearch;
    }

    public boolean isHighlightSearches() {
        return this.highlightSearch;
    }

    public void setSearchText(String str) {
        if (str != null && !str.equals(this.searchString)) {
            this.searchVectorValid = false;
            this.searchString = str;
            this.searchText = str.toCharArray();
            this.lowerCaseSearchText = str.toLowerCase().toCharArray();
        }
    }

    public String getSearchText() {
        return this.searchString;
    }

    public void setMatchCase(boolean flag) {
        if (flag != this.caseSensitive) {
            this.searchVectorValid = false;
        }
        this.caseSensitive = flag;
    }

    public boolean getMatchCase() {
        return this.caseSensitive;
    }

    public int searchDocument() {
        return this.searchDocument(true);
    }

    public int searchDocument(boolean selectFirst) {
        if (this.searchText == null) {
            return 0;
        }
        if (!this.searchVectorValid) {
            this.dispose();
            if (this.wholeWordSearch) {
                this.findWholeWords();
            } else {
                this.find();
            }
        }
        if (this.searchMatches.size() > 0 && selectFirst) {
            this.select(this.matchIndex);
        }
        this.highlightMatches();
        return this.searchMatches.size();
    }

    public boolean findNext() {
        if (!this.searchVectorValid) {
            return this.searchDocument() > 0;
        }
        if (this.searchMatches.size() > 0) {
            if (this.searchWrapping) {
                this.matchIndex = -1;
                this.searchWrapping = false;
            }
            if (this.matchIndex < this.searchMatches.size() - 1) {
                this.select(++this.matchIndex);
                return true;
            }
            this.searchWrapping = true;
            this.cssLayout.clearSelection();
            return false;
        }
        return false;
    }

    public boolean findPrevious() {
        if (!this.searchVectorValid) {
            int count = this.searchDocument(false);
            if (count > 0) {
                this.matchIndex = count - 1;
                this.select(this.matchIndex);
            }
            return count > 0;
        }
        if (this.searchMatches.size() > 0) {
            if (this.searchWrapping) {
                this.matchIndex = this.searchMatches.size();
                this.searchWrapping = false;
            }
            if (this.matchIndex > 0) {
                this.select(--this.matchIndex);
                return true;
            }
            this.searchWrapping = true;
            this.cssLayout.clearSelection();
            return false;
        }
        return false;
    }

    private void find() {
        if (this.searchText.length == 0) {
            return;
        }
        if (this.doc.getMutation() != this.mutation) {
            this.record();
        }
        int i = 0;
        int j = 0;
        for (i = 0; i <= this.numChars - this.searchText.length; ++i) {
            if (this.caseSensitive) {
                for (j = 0; j < this.searchText.length && this.allChars[i + j] == this.searchText[j]; ++j) {
                }
            } else {
                for (j = 0; j < this.searchText.length; ++j) {
                    char c1 = this.allChars[i + j];
                    if ((c1 = Character.toLowerCase(c1)) == this.lowerCaseSearchText[j]) {
                        continue;
                    }
                    break;
                }
            }
            if (j != this.searchText.length) continue;
            HighlightRange match = new HighlightRange(i, i + this.searchText.length);
            this.searchMatches.addElement(match);
            if (this.searchMatches.size() >= 10000) break;
        }
        this.searchVectorValid = true;
    }

    private void findWholeWords() {
        String searchStr;
        if (this.doc.getMutation() != this.mutation) {
            this.record();
        }
        if (!(searchStr = new String(this.searchText).trim()).equals("")) {
            int count = this.cssLayout.getCount(2);
            String word = null;
            AccessPosition pos = new AccessPosition();
            for (int idx = 0; idx < count; ++idx) {
                char stripChr;
                word = this.cssLayout.getText(2, idx, pos, true).trim();
                while (word.length() > 0 && this.isStrippable(stripChr = word.charAt(word.length() - 1))) {
                    word = word.substring(0, word.length() - 1);
                }
                while (word.length() > 0 && this.isStrippable(stripChr = word.charAt(0))) {
                    word = word.substring(1, word.length());
                    ++pos._characterInDoc;
                }
                if ((this.caseSensitive || !word.equalsIgnoreCase(searchStr)) && (!this.caseSensitive || !word.equals(searchStr))) continue;
                HighlightRange hr = new HighlightRange(pos._characterInDoc, pos._characterInDoc + word.length());
                this.searchMatches.addElement(hr);
                if (this.searchMatches.size() >= 500) break;
            }
            this.searchVectorValid = true;
        }
    }

    private void highlightMatches() {
        if (this.highlightSearch) {
            int len = this.searchMatches.size();
            for (int idx = 0; idx < len; ++idx) {
                HighlightRange hr = (HighlightRange)this.searchMatches.elementAt(idx);
                this.cssLayout.defineHighlight(hr.getHighlightStart(), hr.getHighlightEnd());
            }
        } else {
            this.cssLayout.clearHighlights();
        }
    }

    private boolean isStrippable(char stripChr) {
        return stripChr == '.' || stripChr == '\"' || stripChr == ',' || stripChr == '!' || stripChr == '?' || stripChr == '&' || stripChr == '/' || stripChr == '|' || stripChr == ';' || stripChr == '-' || stripChr == '_' || stripChr == '+' || stripChr == '=' || stripChr == '~' || stripChr == '*' || stripChr == '+' || stripChr == '@' || stripChr == '#' || stripChr == '$' || stripChr == '^' || stripChr == '`' || stripChr == '%' || stripChr == '(' || stripChr == '{' || stripChr == '[' || stripChr == '}' || stripChr == ']' || stripChr == ')';
    }

    public final void selectAll() {
        this.select(0, this.numChars - 1);
    }

    private void select(int index) {
        if (index < this.searchMatches.size()) {
            HighlightRange hr = (HighlightRange)this.searchMatches.elementAt(index);
            this.select(hr.getHighlightStart(), hr.getHighlightEnd());
        }
    }

    private final void select(int idx1, int idx2) {
        DTextNode node1 = null;
        DTextNode node2 = null;
        int pos1 = 0;
        int pos2 = 0;
        for (int i = 0; i < this.numNodes; ++i) {
            DTextNode n = this.nodes[i];
            int offset = this.charIndex[i];
            if (idx1 >= offset && idx1 < offset + n.text.length) {
                node1 = n;
                pos1 = idx1 - offset;
            }
            if (idx2 < offset || idx2 > offset + n.text.length) continue;
            node2 = n;
            pos2 = idx2 - offset;
        }
        if (node1 != null && node2 != null) {
            this.cssLayout.select(node1, pos1, node2, pos2);
        }
    }

    private final void record() {
        CSSBox topBox;
        this.mutation = this.doc.getMutation();
        this.allChars = new char[1024];
        this.numChars = 0;
        this.charIndex = new int[16];
        this.nodes = new DTextNode[16];
        this.numNodes = 0;
        DNode topNode = (DNode)((Object)this.doc.getDocumentElement());
        if (topNode != null && (topBox = this.cssLayout.findCSSBox(topNode)) != null) {
            this.record_r(topBox);
        }
    }

    private final void record_r(CSSBox cssBox) {
        if (cssBox instanceof TextBox) {
            if ((cssBox.css.misc & 1) != 0) {
                if (this.numNodes >= this.nodes.length) {
                    DTextNode[] tmp1 = new DTextNode[this.nodes.length * 2];
                    System.arraycopy(this.nodes, 0, tmp1, 0, this.numNodes);
                    this.nodes = tmp1;
                    int[] tmp2 = new int[this.nodes.length * 2];
                    System.arraycopy(this.charIndex, 0, tmp2, 0, this.numNodes);
                    this.charIndex = tmp2;
                }
                TextBox textBox = (TextBox)cssBox;
                this.nodes[this.numNodes] = (DTextNode)textBox.getDomNode();
                this.charIndex[this.numNodes] = this.numChars;
                ++this.numNodes;
                char[] tt = textBox.getText();
                if (this.numChars + tt.length >= this.allChars.length) {
                    int len;
                    for (len = this.allChars.length * 2; this.numChars + tt.length >= len; len *= 2) {
                    }
                    char[] tmp2 = new char[len];
                    System.arraycopy(this.allChars, 0, tmp2, 0, this.allChars.length);
                    this.allChars = tmp2;
                }
                System.arraycopy(tt, 0, this.allChars, this.numChars, tt.length);
                this.numChars += tt.length;
            }
        } else {
            CSSBox aBox = cssBox.getFirstChild();
            while (aBox != null) {
                this.record_r(aBox);
                if (cssBox instanceof FloatBox) break;
                aBox = aBox.next;
            }
        }
    }
}

