/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.Console;
import ice.ri.swing.WindowManager;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.SwingUtilities;

final class ConsoleOutputStream
extends OutputStream
implements Runnable {
    private static final int MAX_CONSOLE_BYTE_COUNT = 10000;
    private WindowManager windowManager;
    private byte[] data;
    private int storedSize;
    private OutputStream streamCopy;
    private final Object lock = new Object();

    public ConsoleOutputStream(WindowManager windowManager, OutputStream streamCopy) {
        this.windowManager = windowManager;
        this.streamCopy = streamCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        if (this.streamCopy != null) {
            this.streamCopy.write(b);
        }
        Object object = this.lock;
        synchronized (object) {
            this.getBufferRoom(1);
            this.data[this.storedSize++] = (byte)b;
        }
        Console console = this.windowManager.console;
        if (console != null && console.isVisible()) {
            SwingUtilities.invokeLater(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null && off == 0 && len == 0) {
            return;
        }
        if (len < 0 || off < 0 || b == null || b.length < off || b.length - off < len) {
            throw new IllegalArgumentException();
        }
        if (this.streamCopy != null) {
            this.streamCopy.write(b, off, len);
        }
        Object object = this.lock;
        synchronized (object) {
            int copyLen = this.getBufferRoom(len);
            System.arraycopy(b, off + len - copyLen, this.data, this.storedSize, copyLen);
            this.storedSize += copyLen;
        }
        Console console = this.windowManager.console;
        if (console != null && console.isVisible()) {
            SwingUtilities.invokeLater(this);
        }
    }

    private int getBufferRoom(int size) {
        int capacity;
        int newSize = this.storedSize + size;
        int n = capacity = this.data == null ? 0 : this.data.length;
        if (newSize > capacity) {
            if (capacity < 10000) {
                int newCapacity = 1000 + newSize * 2;
                if (newCapacity > 10000) {
                    newCapacity = 10000;
                }
                byte[] tmp = new byte[newCapacity];
                if (this.data != null) {
                    System.arraycopy(this.data, 0, tmp, 0, this.storedSize);
                }
                this.data = tmp;
                capacity = newCapacity;
            }
            if (newSize > capacity) {
                int threshold = capacity / 2;
                if (size > threshold) {
                    this.storedSize = 0;
                    if (size > capacity) {
                        size = capacity;
                    }
                } else {
                    int n2 = threshold - size;
                    System.arraycopy(this.data, this.storedSize - n2, this.data, 0, n2);
                    this.storedSize = n2;
                }
            }
        }
        return size;
    }

    public void run() {
        Console console = this.windowManager.console;
        if (console != null && console.isVisible() && this.storedSize != 0) {
            console.setData(new String(this.data, 0, this.storedSize));
        }
    }

    String getBufferAsText() {
        return this.storedSize == 0 ? "" : new String(this.data, 0, this.storedSize);
    }
}

