/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.UIDBAccessSafe;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.repository.RepositoryManager;
import oracle.dbtools.unit_test.runner.UtRunnerArb;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.DatabaseConnections;

public class UtRepositoryManager {
    protected static final Logger LOGGER = Logger.getLogger(RepositoryManager.class.getName());
    private String m_privateName;
    private Connection m_connection;
    private String m_name;
    private ConnectionListener m_connListener = new ConnectionListener(){

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
            String string;
            String string2 = connectionEvent.getOldName();
            if (ModelUtil.areDifferent((Object)string2, (Object)(string = connectionEvent.getConnectionName()))) {
                this.processConnectionRename(string2, string);
            }
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionRenamed(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getOldName();
            String string2 = connectionEvent.getConnectionName();
            this.processConnectionRename(string, string2);
        }

        private void processConnectionRename(String string, String string2) {
            String string3 = UtRepositoryManager.this.getName();
            if (ModelUtil.areEqual((Object)string, (Object)string3)) {
                UtRepositoryManager.this.setName(string2);
                UtAddin.getConfig().setRepository(string2);
            }
        }

        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }
    };
    private boolean taskInProgress = false;

    protected static void warn(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected static void severe(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.SEVERE, string, throwable);
    }

    public void initialize() {
        String string = UtAddin.getConfig().getRepository();
        if (string != null && !string.equals("")) {
            String string2 = Connections.getDisplayName((String)string);
            DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
            try {
                Properties properties = databaseConnections.getProperties(string2);
                if (properties == null || !Boolean.parseBoolean(properties.getProperty("SavePassword"))) {
                    UtAddin.getConfig().setRepository("");
                }
            }
            catch (Exception exception) {
                UtRepositoryManager.severe(exception);
            }
        }
    }

    public boolean isConnected() {
        if (this.m_name == null) {
            return false;
        }
        return this.m_connection != null;
    }

    public Connection getConnection() {
        this.verifyConnection();
        return this.m_connection;
    }

    @UIDBAccessSafe
    public boolean isReposPingable() {
        boolean bl = false;
        if (this.m_connection != null) {
            OracleConnection oracleConnection = (OracleConnection)this.m_connection;
            try {
                if (oracleConnection.pingDatabase() == 0) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                UtRepositoryManager.warn(sQLException);
            }
        }
        return bl;
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String string) {
        this.m_name = string;
    }

    public void closeConnection() {
        try {
            if (this.m_connection != null && !this.m_connection.isClosed()) {
                this.m_connection.commit();
            }
        }
        catch (SQLException sQLException) {
            UtRepositoryManager.warn(sQLException);
        }
        if (this.m_privateName != null && !this.m_privateName.equals("")) {
            Connections.getInstance().closeConnection(this.m_privateName);
        }
        this.m_privateName = null;
        this.m_connection = null;
        this.afterCloseConnection();
    }

    public boolean openConnectionWithChecks(String string) {
        try {
            if (this.isConnected()) {
                if (this.getName().equals(string)) {
                    return true;
                }
                this.closeConnection();
            }
            this.setPrivateConnection(string);
            if (!RepositoryManager.doesRepositoryExist(this.m_connection)) {
                if (this.m_connection != null && !this.m_connection.isClosed()) {
                    Connections.getInstance().closeConnection(this.m_privateName);
                }
                this.m_privateName = null;
                this.m_connection = null;
                String string2 = UtAddinArb.getString("ERROR");
                String string3 = UtAddinArb.getString("NO_REPO");
                if (!Ide.getIdeArgs().getCreateUI()) {
                    throw new RuntimeException(string2 + ": " + string3);
                }
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string2, (String)"f1_reponoexist_html");
                return false;
            }
            if (!RepositoryManager.isCurrentVersion(this.m_connection)) {
                if (this.m_connection != null && !this.m_connection.isClosed()) {
                    Connections.getInstance().closeConnection(this.m_privateName);
                }
                this.m_privateName = null;
                this.m_connection = null;
                String string4 = UtAddinArb.getString("ERROR");
                String string5 = UtAddinArb.getString("BAD_VERSION");
                if (!Ide.getIdeArgs().getCreateUI()) {
                    throw new RuntimeException(string4 + ": " + string5);
                }
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)string4, (String)"f1_badrepoversion_html");
                return false;
            }
            this.afterOpenConnection(string);
            return true;
        }
        catch (Exception exception) {
            UtRepositoryManager.severe(exception);
            return false;
        }
    }

    public boolean openConnectionNoChecks(String string) {
        try {
            if (this.isConnected()) {
                if (this.getName().equals(string)) {
                    return true;
                }
                this.closeConnection();
            }
            this.setPrivateConnection(string);
            if (this.m_connection == null) {
                return false;
            }
            this.afterOpenConnection(string);
            return true;
        }
        catch (Exception exception) {
            UtRepositoryManager.severe(exception);
            return false;
        }
    }

    private void verifyConnection() {
        if (this.m_connection != null && !this.isReposPingable()) {
            boolean bl = false;
            if (Ide.getIdeArgs().getCreateUI()) {
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONNECTION_LOST"), (String)UtAddinArb.getString("ERROR"), (String)"f1_reponoexist_html")) {
                    try {
                        this.m_connection.close();
                    }
                    catch (SQLException sQLException) {
                        UtRepositoryManager.severe(sQLException);
                    }
                    String string = this.m_privateName;
                    this.setPrivateConnection(this.m_name);
                    this.initializeConnection();
                    Connections.getInstance().closeConnection(string);
                    if (this.m_connection == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_CONNECTION"), (String)UtAddinArb.getString("ERROR"), null);
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Ide.getIdeArgs().getCreateUI()) {
                            UtAddin.closeAllUnitTestUI();
                        }
                        UtRepositoryManager.this.closeConnection();
                    }
                });
                throw new RuntimeException("Repository connection lost: closing unit test navigator");
            }
        }
    }

    private void setPrivateConnection(String string) {
        try {
            this.m_privateName = null;
            this.m_connection = null;
            String string2 = Connections.getInstance().createPrivateConnection(string);
            Connection connection = Connections.getInstance().getConnection(string2);
            this.m_privateName = string2;
            this.m_connection = connection;
        }
        catch (Exception exception) {
            UtRepositoryManager.severe(exception);
        }
    }

    public void initializeConnection() {
        if (this.m_connection != null) {
            try {
                this.m_connection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                UtRepositoryManager.severe(sQLException);
            }
            DBUtil.getInstance((Connection)this.m_connection).execute("declare     role_list varchar2(512); begin     dbms_application_info.set_module('SQL Developer Unit Testing','Repository connection');     for r in (select granted_role from user_role_privs where granted_role in ('RESOURCE','DBA','SELECT_CATALOG_ROLE','UT_REPO_USER','UT_REPO_ADMINISTRATOR'))     loop         if role_list is null         then             role_list := r.granted_role;         else             role_list := role_list || ',' || r.granted_role;         end if;     end loop;     if role_list is not null     then         execute immediate 'set role ' || role_list;     end if; end;", (List)null);
        }
        RootFolder.getInstance().reset();
    }

    protected void afterOpenConnection(String string) {
        this.initializeConnection();
        this.setName(string);
        UtAddin.getConfig().setRepository(string);
        Connections.getInstance().addConnectionListener(this.m_connListener);
    }

    protected void afterCloseConnection() {
        Connections.getInstance().removeConnectionListener(this.m_connListener);
        this.setName(null);
        UtAddin.getConfig().setRepository("");
    }

    public boolean isTaskInProgress() {
        return this.taskInProgress;
    }

    public void runTask(RaptorTask<Void> raptorTask) {
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new SchemaTaskListener(this));
        this.taskInProgress = true;
        RaptorTaskManager.getInstance().addTask(raptorTask);
    }

    static class SchemaTaskListener
    extends RaptorTaskAdapter {
        private UtRepositoryManager _reposMgr;

        SchemaTaskListener(UtRepositoryManager utRepositoryManager) {
            this._reposMgr = utRepositoryManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            try {
                String string = UtRunnerArb.format("UT_TASK_FAIL", raptorTaskEvent.getTaskDescriptor().getName(), raptorTaskEvent.getTaskDescriptor().getMessage());
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string);
                this.doneDialog(true, raptorTaskEvent.getTaskDescriptor().getMessage(), UtAddinArb.getString("ERROR"));
            }
            finally {
                this._reposMgr.taskInProgress = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            try {
                String string = UtRunnerArb.format("UT_TASK_FAIL", raptorTaskEvent.getTaskDescriptor().getName(), raptorTaskEvent.getTaskDescriptor().getMessage());
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string);
            }
            finally {
                this._reposMgr.taskInProgress = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            try {
                if (raptorTaskEvent.getTaskDescriptor().getMessage() != null) {
                    this.doneDialog(false, raptorTaskEvent.getTaskDescriptor().getMessage(), UtAddinArb.getString("SUCCESS"));
                }
            }
            finally {
                this._reposMgr.taskInProgress = false;
            }
        }

        private void doneDialog(final boolean bl, final String string, final String string2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, null);
                    } else {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)string2, null);
                    }
                }
            });
        }
    }
}

