/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.codehook;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.dbtools.unit_test.codehook.CodeHookDefaults;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;

public abstract class CodeHook
implements ICodeHook {
    private UtLibraryRef _libRef = null;
    private String _ownerId = null;
    private Component _component = null;
    private boolean _isEditable = true;
    private boolean _enabled = true;
    private PropertyChangeSupport _propChangeSupport;
    private DocumentListener _documentChangeListener;
    private KeyListener _keyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            CodeHook.this.fireChangeListeners();
        }
    };

    public CodeHook() {
        this._propChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public CodeHookDefaults getDefaults() {
        return new CodeHookDefaults();
    }

    @Override
    public boolean canGetComponent() {
        return true;
    }

    @Override
    public Component getComponent(CodeHookDefaults codeHookDefaults) {
        if (this._component == null) {
            this._component = this.createComponent();
        }
        this.applyDefaults(codeHookDefaults);
        return this._component;
    }

    protected abstract Component createComponent();

    protected void applyDefaults(CodeHookDefaults codeHookDefaults) {
    }

    @Override
    public String getOwnerId() {
        return this._ownerId;
    }

    @Override
    public void setOwnerId(String string) {
        this._ownerId = string;
        this.fireChangeListeners();
    }

    @Override
    public XMLElement getXmlElement() {
        XMLElement xMLElement = null;
        String string = this.getXml();
        if (string != null && !string.equals("")) {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            try {
                dOMParser.parse((Reader)new StringReader(string));
            }
            catch (Exception exception) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            XMLDocument xMLDocument = dOMParser.getDocument();
            xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        }
        return xMLElement;
    }

    @Override
    public void loadFromXmlElement(XMLElement xMLElement) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            xMLElement.print(printWriter);
            String string = stringWriter.toString();
            this.loadFromXml(string);
        }
        catch (Exception exception) {
            Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public UtLibraryRef getLibraryRef() {
        return this._libRef;
    }

    @Override
    public String getDisplayName() {
        return null == this._libRef ? this.getHookName() : this._libRef.getName();
    }

    @Override
    public void setLibraryRef(UtLibraryRef utLibraryRef) {
        this._libRef = utLibraryRef;
        this.fireChangeListeners();
        this.onChangeEditability();
    }

    @Override
    public boolean isEditable() {
        return this._isEditable && this._libRef == null;
    }

    @Override
    public void setEditable(boolean bl) {
        this._isEditable = bl;
        this.onChangeEditability();
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public boolean isEnablable() {
        return false;
    }

    @Override
    public void setEnabled(boolean bl) {
        this._enabled = bl;
        this.fireChangeListeners();
    }

    protected abstract void onChangeEditability();

    @Override
    public void addChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removeChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removeAllChangeListeners() {
        for (PropertyChangeListener propertyChangeListener : this._propChangeSupport.getPropertyChangeListeners()) {
            this._propChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void fireChangeListeners() {
        this._propChangeSupport.firePropertyChange(null, null, null);
    }

    private DocumentListener getDocumentChangeListener() {
        if (null == this._documentChangeListener) {
            this._documentChangeListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    CodeHook.this.fireChangeListeners();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    CodeHook.this.fireChangeListeners();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    CodeHook.this.fireChangeListeners();
                }
            };
        }
        return this._documentChangeListener;
    }

    protected void setUpChangeListener(JTextComponent jTextComponent) {
        if (null != jTextComponent) {
            jTextComponent.getDocument().addDocumentListener(this.getDocumentChangeListener());
        }
    }
}

