/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.codehook.CodeHook;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.codehook.PLSQLCodeEditor;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.utils.UtUtils;

public class DynamicValueQuery
extends CodeHook {
    private PLSQLCodeEditor _codeEditor = new PLSQLCodeEditor();

    public DynamicValueQuery() {
        this.onChangeEditability();
    }

    @Override
    public String getTitle() {
        return UiArb.getString("DVQ_LABEL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UtLibraryRef[] getCandidateLibraryRefs() {
        UtLibraryRef[] utLibraryRefArray;
        ArrayList<UtLibraryRef> arrayList = new ArrayList<UtLibraryRef>();
        ResultSetWrapper resultSetWrapper = null;
        HashMap hashMap = new HashMap();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                utLibraryRefArray = DBUtil.getInstance((Connection)connection);
                utLibraryRefArray.setRaiseError(false);
                String string = UtUtils.getQuery("dynQueryLibRefs");
                resultSetWrapper = utLibraryRefArray.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("LIB_DYN_QUERY_ID");
                        String string3 = resultSet.getString("LIB_DYN_QUERY_NAME");
                        arrayList.add(new UtLibraryRef(string2, string3));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        utLibraryRefArray = new UtLibraryRef[arrayList.size()];
        arrayList.toArray(utLibraryRefArray);
        return utLibraryRefArray;
    }

    @Override
    public List<String> getHookSubtypeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UiArb.getString("DVQ_NAME"));
        return arrayList;
    }

    @Override
    public ICodeHook getInstanceFor(String string) {
        return this;
    }

    @Override
    public String getHookName() {
        return UiArb.getString("DVQ_NAME");
    }

    @Override
    public String getDescription() {
        return this._codeEditor.getCode();
    }

    @Override
    protected Component createComponent() {
        return this._codeEditor.createEditorPanel(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DynamicValueQuery.this.fireChangeListeners();
            }
        });
    }

    @Override
    public String getXml() {
        String string = this._codeEditor.getCode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<dvq>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + UiArb.getString("DVQ_NAME") + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + string + "]]></description>");
        stringBuilder.append("<code><![CDATA[" + string + "]]></code>");
        stringBuilder.append("</dvq>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = string != null ? UtUtils.getXmlValue(string, "dvq", "code") : "";
        this._codeEditor.setCode(string2);
        this._codeEditor.setReadOnly(!this.isEditable());
    }

    public void setTemplateCode(String string) {
        this._codeEditor.setCode(string);
    }

    public static String getQueryFromXml(String string) {
        String string2 = null;
        if (string != null && (string2 = UtUtils.getXmlValue(string, "dvq", "code")) != null) {
            string2 = UtUtils.removeTrailingSemiColons(string2);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @Override
    protected void onChangeEditability() {
        this._codeEditor.setReadOnly(!this.isEditable());
    }
}

