/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.unit_test.editor.ListTableModel;

public class ListTablePanel<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ListTableModel<T> _tableModel;
    private JButton _addBtn;
    private JButton _removeBtn;
    private JButton _firstBtn;
    private JButton _prevBtn;
    private JButton _nextBtn;
    private JButton _lastBtn;
    private JTable _table;
    private List<Action> _actions = new ArrayList<Action>();

    public ListTablePanel(ListTableModel<T> listTableModel) {
        this.setName("ListTablePanel");
        this._tableModel = listTableModel;
        this.jbInit();
        this.initializeData();
        this.updateView();
    }

    public ListTableModel<T> getListTableModel() {
        return this._tableModel;
    }

    public void setListTableModel(ListTableModel<T> listTableModel) {
        if (null == listTableModel) {
            throw new NullPointerException();
        }
        if (this._tableModel != listTableModel) {
            this._tableModel = listTableModel;
            this.initializeData();
            this.updateView();
        }
    }

    private void jbInit() {
        this._addBtn = new JButton();
        this._removeBtn = new JButton();
        this._firstBtn = new JButton();
        this._prevBtn = new JButton();
        this._nextBtn = new JButton();
        this._lastBtn = new JButton();
        this._table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        this._table.setName("ListTable");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("ListTablePane");
        jScrollPane.setViewportView(this._table);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this._addBtn).addComponent(this._removeBtn).addComponent(this._firstBtn).addComponent(this._prevBtn).addComponent(this._nextBtn).addComponent(this._lastBtn)).addComponent(jScrollPane, -2, -2, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._addBtn).addComponent(this._removeBtn).addComponent(this._firstBtn).addComponent(this._prevBtn).addComponent(this._nextBtn).addComponent(this._lastBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addComponent(jScrollPane));
        this.initializeListeners();
    }

    private void initializeListeners() {
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListTablePanel.this.updateView();
            }
        });
    }

    private void initializeData() {
        this._table.setModel(this._tableModel);
        this._tableModel.setTable(this._table);
        AbstractAction abstractAction = this._tableModel.getAddAfterSelectedAction();
        this._addBtn.setAction(abstractAction);
        this._addBtn.setName("ListTable.Add");
        this._actions.add(abstractAction);
        abstractAction = this._tableModel.getRemoveSelectedAction();
        this._removeBtn.setAction(abstractAction);
        this._removeBtn.setName("ListTable.Remove");
        this._actions.add(abstractAction);
        abstractAction = this._tableModel.getMoveSelectedFirstAction();
        this._firstBtn.setAction(abstractAction);
        this._firstBtn.setName("ListTable.First");
        this._actions.add(abstractAction);
        abstractAction = this._tableModel.getMoveSelectedPreviousAction();
        this._prevBtn.setAction(abstractAction);
        this._prevBtn.setName("ListTable.Previous");
        this._actions.add(abstractAction);
        abstractAction = this._tableModel.getMoveSelectedNextAction();
        this._nextBtn.setAction(abstractAction);
        this._nextBtn.setName("ListTable.Next");
        this._actions.add(abstractAction);
        abstractAction = this._tableModel.getMoveSelectedLastAction();
        this._lastBtn.setAction(abstractAction);
        this._lastBtn.setName("ListTable.Last");
        this._actions.add(abstractAction);
    }

    private void updateView() {
        for (Action action : this._actions) {
            action.setEnabled(action.isEnabled());
        }
    }

    public void setEditable(boolean bl) {
        if (this.isEditable() != bl) {
            this._tableModel.setEditable(bl);
            if (!bl && null != this._table && null != this._table.getCellEditor()) {
                this._table.getCellEditor().cancelCellEditing();
            }
            this.updateView();
        }
    }

    void stopEditing() {
        boolean bl = true;
        if (null != this._table && null != this._table.getCellEditor()) {
            bl = this._table.getCellEditor().stopCellEditing();
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isEditable() {
        return this._tableModel.isEditable();
    }

    public JTable getTable() {
        return this._table;
    }
}

