/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.xml.XMLUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLookupItem;
import oracle.dbtools.unit_test.utils.UtUtils;

class LookupDetailTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int VALUE = 0;
    protected ArrayList<Object> columnNames = new ArrayList();
    protected Vector<UtLookupItem> dataVector = new Vector();
    private String _category;
    private String _datatype;
    private boolean _tableEditable;

    public void addColumn(Object object) {
        this.columnNames.add(object);
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n).toString();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    public UtLookupItem getRow(int n) {
        return this.dataVector.get(n);
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    public void addRow(UtLookupItem utLookupItem) {
        this.dataVector.add(utLookupItem);
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        if (n != -1) {
            this.dataVector.remove(n);
            this.fireTableDataChanged();
        }
    }

    public void clear() {
        this.columnNames = new ArrayList();
        this.dataVector = new Vector();
    }

    void setTableEditable(boolean bl) {
        this._tableEditable = bl;
    }

    boolean isTableEditable() {
        return this._tableEditable;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isTableEditable()) {
            return false;
        }
        UtLookupItem utLookupItem = this.getRow(n);
        if (null == utLookupItem) {
            return false;
        }
        DataType dataType = utLookupItem.getValue().getDataType();
        return dataType.isSupported();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        DataValue dataValue;
        DataValue dataValue2;
        UtLookupItem utLookupItem = this.dataVector.get(n);
        if (null != utLookupItem && !(dataValue2 = (dataValue = utLookupItem.getValue()).getDataType().getDataValue(object)).equals(dataValue)) {
            utLookupItem.setValue(dataValue2);
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DataValue dataValue = null;
        UtLookupItem utLookupItem = this.dataVector.get(n);
        if (null != utLookupItem) {
            dataValue = utLookupItem.getValue();
        }
        return dataValue;
    }

    public void loadTableModel(String string, String string2) {
        this.clear();
        this.dataVector = UtUtils.getLookupValues(string, string2);
        this.addColumn("Value");
        this._category = string;
        this._datatype = string2;
        this.fireTableDataChanged();
    }

    public void saveTableModel() throws ObjectUpdateException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            Savepoint savepoint = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                savepoint = connection.setSavepoint();
                String string = UtUtils.getQuery("deleteLookupValues");
                hashMap.clear();
                hashMap.put("CATEGORY", this._category);
                hashMap.put("DATATYPE", this._datatype);
                dBUtil.setRaiseError(false);
                dBUtil.executeUpdate(string, hashMap);
                string = UtUtils.getQuery("mergeLookupValues");
                for (UtLookupItem utLookupItem : this.dataVector) {
                    hashMap.clear();
                    hashMap.put("ID", utLookupItem.getId());
                    hashMap.put("DATA_ID", utLookupItem.getDataId());
                    hashMap.put("VALUE", XMLUtil.marshallDataValue((Connection)connection, (DataValue)utLookupItem.getValue()));
                    dBUtil.setRaiseError(true);
                    int n = dBUtil.executeUpdate(string, hashMap);
                    if (0 != n) continue;
                    connection.rollback(savepoint);
                    throw new ObjectUpdateException();
                }
                connection.commit();
            }
            catch (ObjectUpdateException objectUpdateException) {
                throw objectUpdateException;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                if (savepoint != null) {
                    try {
                        connection.rollback(savepoint);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                }
                throw new ObjectUpdateException(exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

