/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.controls.celleditor.PairElement;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.unit_test.config.UtConfig;
import oracle.dbtools.unit_test.editor.CodeHookEditor;
import oracle.dbtools.unit_test.editor.DynamicValueQuery;
import oracle.dbtools.unit_test.editor.TestDetailTableModel;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.testObjects.DetailTableObject;
import oracle.dbtools.unit_test.testObjects.UtArguments;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.testObjects.UtTestImplArgs;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.javatools.icons.OracleIcons;

public class ParamPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UtTestImpl _testImpl;
    private TestDetailTableModel _model;
    private boolean _editable;
    private boolean _initialized;
    private JLabel _categoryLabel;
    private JComboBox _categoryCombo;
    private Container _queryUI;
    private JLabel _queryLabel;
    private JTextArea _query;
    private JTable _table;
    private boolean _tableHeaderTooltips;
    private JComboBox _stat = null;
    private JTextField _errCode = null;
    private JLabel _errLabel = null;
    private Component _parameterTableUI;
    private Container _expectedResultUI;
    private JLabel _expectedResultLabel;
    private static boolean DEBUG_LAYOUT = false;
    private JButton _editBtn;

    public ParamPanel() {
        this.setName("ParamPanel");
    }

    public ParamPanel(boolean bl) {
        this();
        this._tableHeaderTooltips = bl;
    }

    public void updateUI(UtTestImpl utTestImpl) {
        this._testImpl = utTestImpl;
        this.setInitialized(false);
        this.removeAll();
        this.invalidate();
        this.setLayout(new BorderLayout());
        this.updateParamPanel();
        this.validate();
        this.repaint();
        this.setInitialized(true);
    }

    private void updateParamPanel() {
        this.removeAll();
        this.invalidate();
        this.initializeCategoryUI();
        this.initializeCategoryData();
        this.getDynamicValueQueryUI();
        this.initializeDynamicValueQueryData();
        this.getParameterTableUI();
        this.initializeParameterTableData();
        this.getExpectedResultUI();
        this.initializeExpectedResultData();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(4));
        jPanel.add(this._categoryLabel);
        jPanel.add(this._categoryCombo);
        this.redBorder(jPanel);
        this.add((Component)jPanel, "North");
        this.redBorder((JComponent)this._parameterTableUI);
        this.add(this._parameterTableUI, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        this.orangeBorder(this._queryLabel);
        this.orangeBorder((JComponent)this._queryUI);
        this.orangeBorder(this._expectedResultLabel);
        this.orangeBorder((JComponent)this._expectedResultUI);
        jPanel2.add((Component)this._queryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel2.add((Component)this._queryUI, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        Insets insets2 = new Insets(8, 0, 0, 0);
        jPanel2.add((Component)this._expectedResultLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, insets2, 0, 0));
        jPanel2.add((Component)this._expectedResultUI, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.5, 10, 1, insets, 0, 0));
        Component component = Box.createGlue();
        jPanel2.add(component, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        this.orangeBorder((JComponent)component);
        this.redBorder(jPanel2);
        this.add((Component)jPanel2, "South");
        this.validate();
    }

    private void initializeCategoryUI() {
        if (null == this._categoryCombo) {
            this._categoryLabel = new JLabel(UiArb.getString("PARAM_PANEL_LOOKUP_CATEGORY"));
            List<PairElement> list = UtUtils.getLookupCategories(null);
            this._categoryCombo = new JComboBox<Object>(list.toArray());
            PairElement pairElement = UtConfig.getInstance().getPairElement("LOOKUP_CATEGORY");
            this._categoryCombo.setSelectedItem(pairElement);
            this._categoryLabel.setLabelFor(this._categoryCombo);
        }
    }

    private void initializeCategoryData() {
    }

    private Container getDynamicValueQueryUI() {
        if (null == this._queryUI) {
            this._editBtn = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
            this._editBtn.setName("DynamicValueQuery.EditButton");
            this._editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ParamPanel.this.runEditDialog();
                }
            });
            this.yellowBorder(this._editBtn);
            this._query = new JTextArea();
            this._query.setBorder(BorderFactory.createEmptyBorder());
            this._query.setLineWrap(true);
            this._query.setWrapStyleWord(true);
            this._query.setEditable(false);
            this._query.setOpaque(false);
            this.yellowBorder(this._query);
            this._queryLabel = new JLabel(UiArb.getString("PARAM_PANEL_DYNAMIC_VALUE_QUERY"));
            this._queryLabel.setLabelFor(this._query);
            this.yellowBorder(this._queryLabel);
            this._queryUI = new JPanel(new BorderLayout());
            this._queryUI.setName("queryUI");
            this._queryUI.add((Component)this._editBtn, "West");
            this._queryUI.add((Component)this._query, "Center");
        }
        return this._queryUI;
    }

    protected void runEditDialog() {
        CodeHookEditor codeHookEditor;
        boolean bl;
        DynamicValueQuery dynamicValueQuery = new DynamicValueQuery();
        String string = this._testImpl.getDynamicQuery();
        UtLibraryRef utLibraryRef = this._testImpl.getDynamicQueryLibRef();
        if (string != null) {
            dynamicValueQuery.loadFromXml(string);
        } else if (utLibraryRef == null) {
            dynamicValueQuery.setTemplateCode(this._testImpl.getTemplateDynamicQuery());
        }
        if (utLibraryRef != null) {
            dynamicValueQuery.setLibraryRef(utLibraryRef);
        }
        if (bl = (codeHookEditor = new CodeHookEditor(dynamicValueQuery, null)).runDialog()) {
            String string2 = dynamicValueQuery.getDescription();
            String string3 = dynamicValueQuery.getXml();
            if (string == null || !string.equals(string3) || string2 == null || string2.length() == 0) {
                if (string3.length() == 0 || string2 == null || string2.length() == 0) {
                    string3 = null;
                }
                if (string != null || string3 != null) {
                    this._testImpl.setDynamicQuery(string3);
                    this.initializeDynamicValueQueryData();
                    this.firePropertyChange();
                }
            }
            UtLibraryRef utLibraryRef2 = dynamicValueQuery.getLibraryRef();
            if (utLibraryRef == null && utLibraryRef2 != null || utLibraryRef != null && !utLibraryRef.equals(utLibraryRef2)) {
                this._testImpl.setDynamicQueryLibRef(utLibraryRef2);
                if (this.isInitialized()) {
                    this.firePropertyChange();
                }
            }
        }
    }

    private void initializeDynamicValueQueryData() {
        if (this._testImpl != null) {
            if (null == this._testImpl.getDynamicQuery()) {
                this._query.setText("");
            } else {
                DynamicValueQuery dynamicValueQuery = new DynamicValueQuery();
                dynamicValueQuery.loadFromXml(this._testImpl.getDynamicQuery());
                this._query.setText(dynamicValueQuery.getDescription());
            }
        }
    }

    private boolean isDynamic() {
        return null != this._testImpl && null != this._testImpl.getDynamicQuery();
    }

    private Component getParameterTableUI() {
        this._model = new TestDetailTableModel();
        this._model.setColumn(0, UiArb.getString("PARAM_PANEL_PARAMETER"));
        this._model.setColumn(1, UiArb.getString("PARAM_PANEL_DATATYPES"));
        this._model.setColumn(2, UiArb.getString("PARAM_PANEL_INOUT"));
        this._model.setColumn(3, UiArb.getString("PARAM_PANEL_INPUT"));
        this._model.setColumn(4, UiArb.getString("PARAM_PANEL_RESULT"));
        this._model.setColumn(5, UiArb.getString("PARAM_PANEL_TESTOUT"));
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                ParamPanel.this.firePropertyChange();
            }
        });
        this._table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public TableCellEditor getCellEditor(int n, int n2) {
                TableCellEditor tableCellEditor = null;
                UtTestImplArgs utTestImplArgs = this.getArgs(n);
                if (null != utTestImplArgs && ParamPanel.this._model.isDataValueColumn(n2)) {
                    DataValue dataValue = (DataValue)ParamPanel.this._model.getValueAt(n, n2);
                    if (null == dataValue) {
                        dataValue = utTestImplArgs.getDataType().getDataValue(null);
                    }
                    String string = ParamPanel.this._categoryCombo.getSelectedItem().toString();
                    tableCellEditor = UiUtils.getTableCellEditor(dataValue, utTestImplArgs.getChoices(string));
                }
                if (null == tableCellEditor) {
                    tableCellEditor = super.getCellEditor(n, n2);
                }
                return tableCellEditor;
            }

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                TableCellRenderer tableCellRenderer = null;
                final UtTestImplArgs utTestImplArgs = this.getArgs(n);
                if (null != utTestImplArgs) {
                    Object object;
                    if (ParamPanel.this.isDynamic() && ParamPanel.this._model.isDataValueColumn(n2)) {
                        return new DefaultTableCellRenderer(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                                Object object2;
                                if (!"".equals(object)) {
                                    object2 = ParamPanel.this._model.getValueSelector(n2);
                                    String string = utTestImplArgs.getName();
                                    if (BindingMode.RETURN == utTestImplArgs.getMode()) {
                                        string = "RETURNS";
                                    }
                                    if (UtTestImplArgs.ValueSelector.result == object2) {
                                        string = string + "$";
                                    }
                                    object = string;
                                }
                                object2 = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                                ((Component)object2).setEnabled(false);
                                return object2;
                            }
                        };
                    }
                    if (ParamPanel.this._model.isDataValueColumn(n2) && (object = ParamPanel.this._model.getValueAt(n, n2)) instanceof DataValue) {
                        DataValue dataValue = (DataValue)object;
                        tableCellRenderer = UiUtils.getTableCellRenderer(dataValue);
                    }
                }
                if (null == tableCellRenderer) {
                    tableCellRenderer = super.getCellRenderer(n, n2);
                }
                return tableCellRenderer;
            }

            private UtTestImplArgs getArgs(int n) {
                DetailTableObject detailTableObject = ParamPanel.this._model.getRow(n);
                if (detailTableObject == null) {
                    return null;
                }
                UtTestImplArgs utTestImplArgs = detailTableObject.getParm();
                DataType dataType = utTestImplArgs.getDataType();
                if (!dataType.isSupported()) {
                    // empty if block
                }
                return utTestImplArgs;
            }
        };
        if (this._tableHeaderTooltips) {
            this._table.setTableHeader(new JTableHeader(this._table.getTableHeader().getColumnModel()){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    return (String)this.getColumnModel().getColumn(this.columnAtPoint(mouseEvent.getPoint())).getHeaderValue();
                }
            });
        }
        this._table.setModel(this._model);
        this._table.setColumnSelectionAllowed(true);
        this._table.setRowSelectionAllowed(true);
        this._table.setSelectionMode(0);
        this._table.setName("parameterTable");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this._table);
        this._parameterTableUI = jScrollPane;
        this._parameterTableUI.setName("parameterTableUI");
        return this._parameterTableUI;
    }

    private void initializeParameterTableData() {
        this._model.clear();
        if (this._testImpl != null) {
            UtTest utTest = this._testImpl.getTest();
            for (UtArguments utArguments : utTest.getCallableArgumentsSorted()) {
                UtTestImplArgs utTestImplArgs = this._testImpl.getParameters().get(utArguments.getArgId());
                this._model.addRow(new DetailTableObject(utArguments, utTestImplArgs));
            }
        }
    }

    private Component getExpectedResultUI() {
        if (null == this._expectedResultUI) {
            this._stat = new JComboBox();
            this._expectedResultLabel = new JLabel(UiArb.getString("UT_RESULT"));
            this._expectedResultLabel.setLabelFor(this._stat);
            this.yellowBorder(this._expectedResultLabel);
            this._stat.addItem(UiArb.getString("SUCCESS"));
            this._stat.addItem(UiArb.getString("EXCEPTION"));
            this._stat.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ParamPanel.this.firePropertyChange();
                    ParamPanel.this.updateExpectedResultUI();
                }
            });
            this.yellowBorder(this._stat);
            this._errCode = new JTextField(8);
            if (this._testImpl != null) {
                this._errCode.setText(this._testImpl.getExpectedErrorCode());
            }
            this._errCode.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    ParamPanel.this.firePropertyChange();
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this._errCode.setName("ErrorCode");
            this.yellowBorder(this._errCode);
            this._errLabel = new JLabel(UiArb.getString("ERROR_MESSAGE"));
            this.yellowBorder(this._errLabel);
            this._expectedResultUI = new JPanel(new FlowLayout(3));
            this._expectedResultUI.add(this._stat);
            this._expectedResultUI.add(this._errCode);
            this._expectedResultUI.add(this._errLabel);
            this._expectedResultUI.setName("expectedResultUI");
        }
        return this._expectedResultUI;
    }

    private void initializeExpectedResultData() {
        if (this._testImpl != null) {
            if (this._testImpl.getExpectedStatus() == null || this._testImpl.getExpectedStatus().equals("")) {
                this._stat.setSelectedItem(UiArb.getString("SUCCESS"));
            } else {
                this._stat.setSelectedItem(this._testImpl.getExpectedStatus());
            }
            if (this._testImpl.getExpectedErrorCode() == null || this._testImpl.getExpectedErrorCode().equals("")) {
                this._errCode.setText(UiArb.getString("ANY"));
            } else {
                this._errCode.setText(this._testImpl.getExpectedErrorCode());
            }
        }
        this.updateExpectedResultUI();
    }

    private void updateExpectedResultUI() {
        if (this._editable && this._stat.getSelectedItem().toString().equals(UiArb.getString("EXCEPTION"))) {
            this._errCode.setEnabled(true);
            this._errLabel.setEnabled(true);
        } else {
            this._errCode.setEnabled(false);
            this._errLabel.setEnabled(false);
        }
    }

    public String getExpectedStatus() {
        return this._stat.getSelectedItem().toString();
    }

    public String getExpectedErrorCode() {
        return this._errCode.getText();
    }

    public HashMap<String, Object> getInputValues() {
        int n = this._model.getRowCount();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        for (int i = 0; i < n; ++i) {
            DetailTableObject detailTableObject = this._model.getRow(i);
            UtTestImplArgs utTestImplArgs = detailTableObject.getParm();
            hashMap.put(utTestImplArgs.getName(), utTestImplArgs.getInput());
        }
        return hashMap;
    }

    public HashMap<String, Object> getResultValues() {
        int n = this._model.getRowCount();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        for (int i = 0; i < n; ++i) {
            DetailTableObject detailTableObject = this._model.getRow(i);
            UtTestImplArgs utTestImplArgs = detailTableObject.getParm();
            hashMap.put(utTestImplArgs.getName(), utTestImplArgs.getResult());
        }
        return hashMap;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
        if (null != this._model) {
            this._model.setTableEditable(bl);
            this._model.setDynamic(this.isDynamic());
        }
        if (null != this._stat) {
            this._stat.setEnabled(bl);
            this._queryLabel.setEnabled(bl);
            this._editBtn.setEnabled(bl);
            this._categoryCombo.setEnabled(bl);
            this.updateExpectedResultUI();
        }
        if (!bl && null != this._table && null != this._table.getCellEditor()) {
            this._table.getCellEditor().cancelCellEditing();
        }
    }

    void stopEditing() {
        boolean bl = true;
        if (null != this._table && null != this._table.getCellEditor()) {
            bl = this._table.getCellEditor().stopCellEditing();
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    private boolean isInitialized() {
        return this._initialized;
    }

    private void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    private void firePropertyChange() {
        if (this.isInitialized()) {
            this.firePropertyChange("PARAMS", null, this);
        }
    }

    private void redBorder(JComponent jComponent) {
        if (DEBUG_LAYOUT) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), jComponent.getBorder()));
        }
    }

    private void orangeBorder(JComponent jComponent) {
        if (DEBUG_LAYOUT) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.orange), jComponent.getBorder()));
        }
    }

    private void yellowBorder(JComponent jComponent) {
        if (DEBUG_LAYOUT) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.yellow), jComponent.getBorder()));
        }
    }
}

