/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.editor.ResultsTreeNode;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;

public class ResultsTreeTableModel
extends AbstractTreeTableModel {
    public static final int TEST_RUN = 0;
    public static final int STATUS = 1;
    public static final int DURATION = 2;
    public static final int MESSAGE = 3;
    private static final String[] _columnNames = new String[]{UiArb.getString("RESULTS_TEST_RUN"), UiArb.getString("RESULTS_STATUS"), UiArb.getString("RESULTS_DURATION"), UiArb.getString("RESULTS_MESSAGE")};
    private static final Class[] _columnClasses = new Class[]{TreeTableModel.class, String.class, Double.class, String.class};
    private ResultsTreeNode l_root = new ResultsTreeNode("ROOT", null, null, true);
    private UtTest _test;
    private UtSuite _suite;

    public ResultsTreeTableModel() {
        super((Object)new ResultsTreeNode("Loading...", null, null, true));
        this.invokeStructureChanged();
    }

    private void invokeStructureChanged() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ResultsTreeTableModel.this.fireTreeStructureChanged((Object)ResultsTreeTableModel.this, new TreeNode[]{(TreeNode)ResultsTreeTableModel.this.root}, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void updateContent(UtTest utTest) {
        this.l_root = new ResultsTreeNode(utTest.getTestName(), null, null, true);
        this.loadTestRuns(this.l_root, utTest.getId());
        this.root = this.l_root;
        this._test = utTest;
        this.invokeStructureChanged();
    }

    public void updateContent(UtSuite utSuite) {
        this.l_root = new ResultsTreeNode(utSuite.getSuiteName(), null, null, true);
        this.loadSuiteRuns(this.l_root, utSuite.getSid());
        this.root = this.l_root;
        this._suite = utSuite;
        this.invokeStructureChanged();
    }

    public void updateContent() {
        if (this._test != null) {
            this.updateContent(this._test);
        } else if (this._suite != null) {
            this.updateContent(this._suite);
        }
    }

    public int getColumnCount() {
        return _columnNames.length;
    }

    public Class getColumnClass(int n) {
        return _columnClasses[n];
    }

    public String getColumnName(int n) {
        return _columnNames[n];
    }

    public Object getValueAt(Object object, int n) {
        ResultsTreeNode resultsTreeNode = (ResultsTreeNode)object;
        switch (n) {
            case 0: {
                return resultsTreeNode.getName();
            }
            case 1: {
                return resultsTreeNode.getStatusDisplayValue();
            }
            case 2: {
                return resultsTreeNode.getRolledUpDuration();
            }
            case 3: {
                return resultsTreeNode.getMessage();
            }
        }
        return null;
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestRuns(ResultsTreeNode resultsTreeNode, String string) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = "select utr_id from ut_test_results where ut_id = :ID order by run_date desc";
                hashMap.put("ID", string);
                resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        this.loadTestRun(resultsTreeNode, string3, true);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSuiteRuns(ResultsTreeNode resultsTreeNode, String string) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = "select utsr_id from ut_suite_results where ut_sid = :UT_SID order by run_date desc";
                hashMap.put("UT_SID", string);
                resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        this.loadSuiteRun(resultsTreeNode, string3, true);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestRun(ResultsTreeNode resultsTreeNode, String string, boolean bl) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = "select name, status, message, run_date,coverage,test_user_name from ut_test_results where utr_id = :ID";
                hashMap.put("ID", string);
                resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        String string4 = resultSet.getString(2);
                        String string5 = resultSet.getString(3);
                        String string6 = resultSet.getTimestamp(4).toString();
                        boolean bl2 = resultSet.getBoolean(5);
                        String string7 = resultSet.getString(6);
                        String string8 = null;
                        string8 = string7 != null && !string7.equals("") ? string7 + ": " : "";
                        ResultsTreeNode resultsTreeNode2 = new ResultsTreeNode(string8 + (bl ? UiArb.format(bl2 ? "COVERAGE_RUN_ON" : "RUN_ON", string6) : string3), string4, string5);
                        resultsTreeNode2.setTestResultId(string);
                        resultsTreeNode.add(resultsTreeNode2);
                        resultsTreeNode2.setParent(resultsTreeNode);
                        this.loadTestImpls(string, resultsTreeNode2, connection);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSuiteRun(ResultsTreeNode resultsTreeNode, String string, boolean bl) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = "select name, status, message, run_date,startup_status, startup_message, startup_duration, teardown_status, teardown_message,teardown_duration,coverage from ut_suite_results where utsr_id = :UT_SRID";
                hashMap.put("UT_SRID", string);
                resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        ResultsTreeNode resultsTreeNode2;
                        String string3 = resultSet.getString(1);
                        String string4 = resultSet.getString(2);
                        String string5 = resultSet.getString(3);
                        String string6 = resultSet.getTimestamp(4).toString();
                        String string7 = resultSet.getString(5);
                        String string8 = resultSet.getString(6);
                        double d = resultSet.getDouble(7);
                        String string9 = resultSet.getString(8);
                        String string10 = resultSet.getString(9);
                        double d2 = resultSet.getDouble(10);
                        boolean bl2 = resultSet.getBoolean(11);
                        ResultsTreeNode resultsTreeNode3 = new ResultsTreeNode(bl ? UiArb.format(bl2 ? "COVERAGE_RUN_ON" : "RUN_ON", string6) : string3, string4, string5);
                        resultsTreeNode3.setSuiteResultId(string);
                        resultsTreeNode.add(resultsTreeNode3);
                        resultsTreeNode3.setParent(resultsTreeNode);
                        if (string7 != null && !string7.equals("")) {
                            resultsTreeNode2 = new ResultsTreeNode(UiArb.getString("STARTUPS"), string7, string8, d);
                            resultsTreeNode3.add(resultsTreeNode2);
                            resultsTreeNode2.setParent(resultsTreeNode3);
                        }
                        this.loadSuiteItemRuns(resultsTreeNode3, string);
                        if (string9 == null || string9.equals("")) continue;
                        resultsTreeNode2 = new ResultsTreeNode(UiArb.getString("TEARDOWNS"), string9, string10, d2);
                        resultsTreeNode3.add(resultsTreeNode2);
                        resultsTreeNode2.setParent(resultsTreeNode3);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSuiteItemRuns(ResultsTreeNode resultsTreeNode, String string) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = "select UTR_ID,UTR_NSID from UT_SUITE_ITEM_RESULTS where UTSR_ID = :ID order by SEQUENCE asc";
                hashMap.put("ID", string);
                resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        if (string3 != null) {
                            this.loadTestRun(resultsTreeNode, string3, false);
                            continue;
                        }
                        String string4 = resultSet.getString(2);
                        this.loadSuiteRun(resultsTreeNode, string4, false);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestImpls(String string, ResultsTreeNode resultsTreeNode, Connection connection) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string2 = "select utir_id,name,status,message,duration,startup_status, startup_message, startup_duration, op_call_status, op_call_message, op_call_duration, teardown_status, teardown_message, teardown_duration from ut_test_impl_results where utr_id = :UTR_ID order by run_date asc";
            hashMap.put("UTR_ID", string);
            resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
            if (resultSetWrapper != null) {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    ResultsTreeNode resultsTreeNode2;
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    String string6 = resultSet.getString(4);
                    double d = resultSet.getDouble(5);
                    String string7 = resultSet.getString(6);
                    String string8 = resultSet.getString(7);
                    double d2 = resultSet.getDouble(8);
                    String string9 = resultSet.getString(9);
                    String string10 = resultSet.getString(10);
                    double d3 = resultSet.getDouble(11);
                    String string11 = resultSet.getString(12);
                    String string12 = resultSet.getString(13);
                    double d4 = resultSet.getDouble(14);
                    ResultsTreeNode resultsTreeNode3 = new ResultsTreeNode(UiArb.format("IMPLEMENTATION", string4), string5, string6);
                    resultsTreeNode.add(resultsTreeNode3);
                    resultsTreeNode3.setParent(resultsTreeNode);
                    if (string7 != null && !string7.equals("")) {
                        resultsTreeNode2 = new ResultsTreeNode(UiArb.getString("STARTUPS"), string7, string8, d2);
                        resultsTreeNode3.add(resultsTreeNode2);
                        resultsTreeNode2.setParent(resultsTreeNode3);
                    }
                    if (string9 != null && !string9.equals("")) {
                        resultsTreeNode2 = new ResultsTreeNode(UiArb.getString("OPERATION"), string9, string10, d3);
                        resultsTreeNode3.add(resultsTreeNode2);
                        resultsTreeNode2.setParent(resultsTreeNode3);
                        this.loadTestImplArgs(string3, resultsTreeNode2, connection);
                        this.loadValidationResults(string3, resultsTreeNode3, connection);
                    }
                    if (string11 == null || string11.equals("")) continue;
                    resultsTreeNode2 = new ResultsTreeNode(UiArb.getString("TEARDOWNS"), string11, string12, d4);
                    resultsTreeNode3.add(resultsTreeNode2);
                    resultsTreeNode2.setParent(resultsTreeNode3);
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTestImplArgs(String string, ResultsTreeNode resultsTreeNode, Connection connection) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string2 = "select r.name,r.status,r.message,a.position,a.in_out from ut_test_impl_arg_results r, ut_test_arguments a where r.arg_id = a.arg_id and r.utir_id = :UTIR_ID order by a.position asc, r.status asc";
            hashMap.put("UTIR_ID", string);
            resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
            if (resultSetWrapper != null) {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    String string6 = resultSet.getString(4);
                    String string7 = resultSet.getString(5);
                    String string8 = null;
                    string8 = null == string3 || 0 == string3.length() ? UtAddinArb.getString("RETURNS_ARG_NAME") : UiArb.format("PARAMETER", string7, string6, string3);
                    ResultsTreeNode resultsTreeNode2 = new ResultsTreeNode(string8, string4, string5);
                    resultsTreeNode.add(resultsTreeNode2);
                    resultsTreeNode2.setParent(resultsTreeNode);
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValidationResults(String string, ResultsTreeNode resultsTreeNode, Connection connection) {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string2 = "select lib_validation_name,status,message,val_duration,index_no,val_type from ut_test_impl_val_results r, ut_validations v, ut_lib_validations lv where r.utir_id = :UTIR_ID and v.validation_id=r.val_id and lv.lib_validation_id(+)=v.lib_validation_id order by index_no asc";
            hashMap.put("UTIR_ID", string);
            resultSetWrapper = dBUtil.executeQuery(string2, hashMap);
            if (resultSetWrapper != null) {
                ResultSet resultSet = resultSetWrapper.getResultSet();
                while (resultSet.next()) {
                    String string3;
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    String string6 = resultSet.getString(3);
                    double d = resultSet.getDouble(4);
                    int n = resultSet.getInt(5) + 1;
                    String string7 = string3 = resultSet.getString(6);
                    if (null == string4) {
                        string4 = ValidationArb.getString("LIB_LOCAL");
                    }
                    String string8 = ValidationArb.format("RESULTS_LABEL", n, string4, string7);
                    ResultsTreeNode resultsTreeNode2 = new ResultsTreeNode(UiArb.format("VALIDATION", string8), string5, string6, d);
                    resultsTreeNode.add(resultsTreeNode2);
                    resultsTreeNode2.setParent(resultsTreeNode);
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
    }
}

