/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator.tree;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.model.Element;

public abstract class UtNavigatorTreeNode<V extends Element>
extends AsynchronousNavigatorTreeNode {
    protected final RaptorTask<Collection<Element>> getLoadingTask() {
        NavigatorQueryTask navigatorQueryTask = new NavigatorQueryTask(UtNavigatorTreeNode.getTaskName(this.getUtElement()), UtAddin.getRepositoryConnectionName(), true){

            protected Collection<Element> doWorkImpl() throws TaskException {
                return UtNavigatorTreeNode.this.doLoadChildren();
            }
        };
        navigatorQueryTask.setMessage(navigatorQueryTask.getDescriptor().getName());
        return navigatorQueryTask;
    }

    protected final V getUtElement() {
        return (V)this.getElement();
    }

    protected abstract Collection<Element> doLoadChildren();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, String> loadTree(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string3 = this.getQuery(string);
                if (string2 != null) {
                    hashMap2.put("ID", string2);
                }
                if ((resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap2)) != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        hashMap.put(resultSet.getString(2), resultSet.getString(1));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return hashMap;
    }

    protected String getQuery(String string) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(UtAddin.class.getClassLoader(), "/oracle/dbtools/unit_test/navigator/NavSql.xml"));
        Query query = queryXMLSupport.getQuery(string, UtAddin.getRepositoryManager().getConnection());
        return query.getSql();
    }
}

