/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.teardown;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.codehook.CodeHookDefaults;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.Teardown;
import oracle.dbtools.unit_test.teardown.TeardownArb;
import oracle.dbtools.unit_test.utils.UtUtils;

public class TableDropTeardown
extends Teardown
implements ITeardown {
    private String _name = TeardownArb.getString("TABLE_DROP_TEARDOWN_NAME");
    private JTextField _targetTableField = new JTextField("", 30);
    private JButton _targetBrowseButton = new JButton(TeardownArb.getString("BROWSE_BUTTON_LABEL"));

    public TableDropTeardown() {
        this.onChangeEditability();
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._targetTableField.getText();
    }

    @Override
    public CodeHookDefaults getDefaults() {
        return new CodeHookDefaults(null, this._targetTableField.getText(), null);
    }

    @Override
    protected void applyDefaults(CodeHookDefaults codeHookDefaults) {
        String string;
        String string2 = this._targetTableField.getText();
        if ((string2 == null || string2.equals("")) && (string = codeHookDefaults.getTempTableName()) != null && !string.equals("")) {
            this._targetTableField.setText(string);
        }
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(TeardownArb.getString("TABLE_LABEL") + " ");
        Insets insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._targetTableField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._targetBrowseButton, new GridBagConstraints(2, 0, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this.setUpChangeListener(this._targetTableField);
        this._targetBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UtUtils.selectTableName();
                if (string != null) {
                    TableDropTeardown.this._targetTableField.setText(string);
                }
            }
        });
        return jPanel;
    }

    @Override
    public String getXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<teardown>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + this.getDescription() + "]]></description>");
        stringBuilder.append("<target><![CDATA[" + this._targetTableField.getText() + "]]></target>");
        stringBuilder.append("</teardown>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = "";
        if (string != null) {
            string2 = UtUtils.getXmlValue(string, "teardown", "target");
        }
        this._targetTableField.setText(string2);
    }

    @Override
    protected void onChangeEditability() {
        this._targetTableField.setEditable(this.isEditable());
        this._targetBrowseButton.setEnabled(this.isEditable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performWork(Connection connection, IStartup iStartup) throws Exception {
        if (Connections.getInstance().lock(connection)) {
            try {
                String string = "drop table " + this._targetTableField.getText();
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                try {
                    preparedStatement.execute();
                }
                finally {
                    preparedStatement.close();
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

