/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.teardown;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.codehook.CodeHookDefaults;
import oracle.dbtools.unit_test.codehook.PLSQLCodeEditor;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.TableCopyStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.Teardown;
import oracle.dbtools.unit_test.teardown.TeardownArb;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.jdbc.OraclePreparedStatement;

public class TableRestoreTeardown
extends Teardown
implements ITeardown {
    private static final String PRIMARY_KEY = "PRIMARY KEY";
    private static final String ROWID = "ROWID";
    private String _name = TeardownArb.getString("TABLE_RESTORE_TEARDOWN_NAME");
    private JTextField _sourceTableField = new JTextField("", 30);
    private JComboBox _sourceKeyCombo = new JComboBox<String>(new String[]{"PRIMARY KEY", "ROWID"});
    private JTextField _tempTableField = new JTextField("", 30);
    private JTextField _predicateField = new JTextField("", 30);
    private JButton _sourceBrowseButton = new JButton(TeardownArb.getString("BROWSE_BUTTON_LABEL"));
    private JButton _tempBrowseButton = new JButton(TeardownArb.getString("BROWSE_BUTTON_LABEL"));
    private JButton _predicateEditButton = new JButton(TeardownArb.getString("EDIT_BUTTON_LABEL"));
    private JCheckBox _dropTempTableCheck = new JCheckBox(TeardownArb.getString("DROP_TEMP_TABLE"), true);

    public TableRestoreTeardown() {
        this.onChangeEditability();
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._tempTableField.getText() + " -> " + this._sourceTableField.getText();
    }

    @Override
    public CodeHookDefaults getDefaults() {
        return new CodeHookDefaults(this._sourceTableField.getText(), this._tempTableField.getText(), null);
    }

    @Override
    protected void applyDefaults(CodeHookDefaults codeHookDefaults) {
        String string;
        String string2 = this._sourceTableField.getText();
        if ((string2 == null || string2.equals("")) && (string = codeHookDefaults.getTableName()) != null && !string.equals("")) {
            this._sourceTableField.setText(string);
        }
        if ((string = this._tempTableField.getText()) == null || string.equals("")) {
            String string3;
            String string4 = codeHookDefaults.getTempTableName();
            String string5 = null;
            string5 = string4 != null && !string4.equals("") ? string4 : ((string3 = codeHookDefaults.getOwnerName()) != null && !string3.equals("") ? (string3.length() > 26 ? "\"TMP$" + string3.substring(0, 26) + "\"" : "\"TMP$" + string3 + "\"") : "\"T$TEMP_TABLE\"");
            this._tempTableField.setText(string5);
        }
    }

    @Override
    protected Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(TeardownArb.getString("TARGET_TABLE_LABEL") + " ");
        JLabel jLabel2 = new JLabel(TeardownArb.getString("ROW_IDENTIFIER_LABEL") + " ");
        JLabel jLabel3 = new JLabel(TeardownArb.getString("SOURCE_TABLE_LABEL") + " ");
        JLabel jLabel4 = new JLabel(TeardownArb.getString("CONDITION_LABEL") + " ");
        Insets insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._sourceTableField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._sourceBrowseButton, new GridBagConstraints(2, 0, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._sourceKeyCombo, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._tempTableField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._tempBrowseButton, new GridBagConstraints(2, 2, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._predicateField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        jPanel.add((Component)this._predicateEditButton, new GridBagConstraints(2, 3, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        jPanel.add((Component)this._dropTempTableCheck, new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        this._dropTempTableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableRestoreTeardown.this.fireChangeListeners();
            }
        });
        this.setUpChangeListener(this._sourceTableField);
        this._sourceKeyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableRestoreTeardown.this.fireChangeListeners();
            }
        });
        this.setUpChangeListener(this._tempTableField);
        this.setUpChangeListener(this._predicateField);
        this._sourceBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UtUtils.selectTableName();
                if (string != null) {
                    TableRestoreTeardown.this._sourceTableField.setText(string);
                }
            }
        });
        this._tempBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = UtUtils.selectTableName();
                if (string != null) {
                    TableRestoreTeardown.this._tempTableField.setText(string);
                }
            }
        });
        this._predicateEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLSQLCodeEditor pLSQLCodeEditor = new PLSQLCodeEditor();
                pLSQLCodeEditor.setCode(TableRestoreTeardown.this._predicateField.getText());
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)pLSQLCodeEditor.createEditorPanel(), null, (String)TeardownArb.getString("EDIT_CONDITION_TITLE"), (int)3);
                jEWTDialog.setOKButtonEnabled(true);
                boolean bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                if (bl) {
                    String string = pLSQLCodeEditor.getCode();
                    TableRestoreTeardown.this._predicateField.setText(string);
                }
            }
        });
        return jPanel;
    }

    @Override
    public String getXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<teardown>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + this.getDescription() + "]]></description>");
        stringBuilder.append("<source><![CDATA[" + this._sourceTableField.getText() + "]]></source>");
        stringBuilder.append("<key><![CDATA[" + this._sourceKeyCombo.getSelectedItem() + "]]></key>");
        stringBuilder.append("<temp><![CDATA[" + this._tempTableField.getText() + "]]></temp>");
        stringBuilder.append("<predicate><![CDATA[" + this._predicateField.getText() + "]]></predicate>");
        stringBuilder.append("<dropTempTable><![CDATA[" + (this._dropTempTableCheck.isSelected() ? "yes" : "no") + "]]></dropTempTable>");
        stringBuilder.append("</teardown>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        if (string != null) {
            string2 = UtUtils.getXmlValue(string, "teardown", "source");
            string3 = UtUtils.getXmlValue(string, "teardown", "key");
            string4 = UtUtils.getXmlValue(string, "teardown", "temp");
            string5 = UtUtils.getXmlValue(string, "teardown", "predicate");
            String string6 = UtUtils.getXmlValue(string, "teardown", "dropTempTable");
            if (string6 != null && string6.equals("yes")) {
                bl = true;
            }
        }
        this._sourceTableField.setText(string2);
        this._sourceKeyCombo.setSelectedItem(string3);
        this._tempTableField.setText(string4);
        this._predicateField.setText(string5);
        this._dropTempTableCheck.setSelected(bl);
    }

    @Override
    protected void onChangeEditability() {
        this._sourceTableField.setEditable(this.isEditable());
        this._sourceKeyCombo.setEnabled(this.isEditable());
        this._tempTableField.setEditable(this.isEditable());
        this._sourceBrowseButton.setEnabled(this.isEditable());
        this._predicateField.setEditable(this.isEditable());
        this._predicateEditButton.setEnabled(this.isEditable());
        this._tempBrowseButton.setEnabled(this.isEditable());
        this._dropTempTableCheck.setEnabled(this.isEditable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performWork(Connection connection, IStartup iStartup) throws Exception {
        block12: {
            if (Connections.getInstance().lock(connection)) {
                try {
                    String string = UtUtils.getQuery("tableRestoreTeardown");
                    boolean bl = false;
                    if (iStartup != null && iStartup instanceof TableCopyStartup) {
                        bl = ((TableCopyStartup)iStartup).isCompleteTableCopy();
                    }
                    String string2 = this._predicateField.getText();
                    boolean bl2 = bl && (string2 == null || string2.equals(""));
                    String string3 = this.getUpdateSQL(connection, bl2);
                    OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string);
                    try {
                        oraclePreparedStatement.setStringAtName("SOURCE", this._sourceTableField.getText());
                        oraclePreparedStatement.setStringAtName("UPDATE_SQL", string3);
                        oraclePreparedStatement.execute();
                    }
                    finally {
                        oraclePreparedStatement.close();
                    }
                    if (!this._dropTempTableCheck.isSelected()) break block12;
                    String string4 = "drop table " + this._tempTableField.getText();
                    PreparedStatement preparedStatement = connection.prepareStatement(string4);
                    try {
                        preparedStatement.execute();
                    }
                    finally {
                        preparedStatement.close();
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    private String getUpdateSQL(Connection connection, boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.resolveTableName(connection, this._sourceTableField.getText());
        List<String> list = this.getColumnList(connection, stringArray[0], stringArray[1]);
        if (bl) {
            String string = this.getSQLColumnList(list);
            stringBuffer.append("BEGIN DELETE FROM ");
            stringBuffer.append(this._sourceTableField.getText());
            stringBuffer.append(";");
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(this._sourceTableField.getText());
            stringBuffer.append("(");
            stringBuffer.append(string);
            stringBuffer.append(")");
            stringBuffer.append(" SELECT ");
            stringBuffer.append(string);
            stringBuffer.append(" FROM ");
            stringBuffer.append(this._tempTableField.getText());
            stringBuffer.append("; end;");
        } else {
            List<String> list2 = null;
            if (this._sourceKeyCombo.getSelectedItem().equals(PRIMARY_KEY)) {
                this.getKeyList(connection, stringArray[0], stringArray[1], this._sourceKeyCombo.getSelectedItem().toString());
            }
            stringBuffer.append("MERGE INTO ");
            stringBuffer.append(this._sourceTableField.getText());
            stringBuffer.append(" P USING (SELECT SRC$ROWID, ");
            stringBuffer.append(this.getSQLColumnList(list));
            stringBuffer.append(" FROM ");
            stringBuffer.append(this._tempTableField.getText());
            String string = this._predicateField.getText();
            if (string != null && !string.equals("")) {
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string);
            }
            stringBuffer.append(") T ON (");
            stringBuffer.append(this.getMatchPredicate(list2));
            stringBuffer.append(") WHEN MATCHED THEN UPDATE SET ");
            stringBuffer.append(this.getUpdateList(list, list2));
            stringBuffer.append(" WHEN NOT MATCHED THEN INSERT (");
            stringBuffer.append(this.getSQLColumnList(list));
            stringBuffer.append(") VALUES (");
            stringBuffer.append(this.getSQLColumnList(list, "t."));
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] resolveTableName(Connection connection, String string) throws Exception {
        String[] stringArray = new String[2];
        String string2 = "{ call dbms_utility.name_resolve(?, 2, ?, ?, ?, ?, ?, ?) }";
        CallableStatement callableStatement = connection.prepareCall(string2);
        try {
            callableStatement.setString(1, string);
            callableStatement.registerOutParameter(2, 12);
            callableStatement.registerOutParameter(3, 12);
            callableStatement.registerOutParameter(4, 12);
            callableStatement.registerOutParameter(5, 12);
            callableStatement.registerOutParameter(6, 12);
            callableStatement.registerOutParameter(7, 12);
            callableStatement.execute();
            stringArray[0] = callableStatement.getString(2);
            stringArray[1] = callableStatement.getString(3);
        }
        finally {
            callableStatement.close();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getColumnList(Connection connection, String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = "select column_name from all_tab_columns where owner = ? and table_name = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        finally {
            preparedStatement.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getKeyList(Connection connection, String string, String string2, String string3) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string3.equals(PRIMARY_KEY)) {
            String string4 = "select cc.column_name from all_constraints c, all_cons_columns cc where c.owner = cc.owner and c.table_name = cc.table_name and c.constraint_name = cc.constraint_name and constraint_type = 'P' and cc.owner = ? and cc.table_name = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(string4);
            try {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
            }
            finally {
                preparedStatement.close();
            }
        } else {
            arrayList.add("SRC$ROWID");
        }
        if (arrayList.size() == 0) {
            throw new Exception(TeardownArb.getString("NO_PRIMARY_KEY"));
        }
        return arrayList;
    }

    private String getSQLColumnList(List<String> list) {
        return this.getSQLColumnList(list, "");
    }

    private String getSQLColumnList(List<String> list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string2 : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            stringBuffer.append('\"');
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    private String getMatchPredicate(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list != null) {
            boolean bl = true;
            for (String string : list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append("p.");
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append("t.");
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append("p.ROWID = t.SRC$ROWID");
        }
        return stringBuffer.toString();
    }

    private String getUpdateList(List<String> list, List<String> list2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : list) {
            boolean bl2 = false;
            if (list2 != null) {
                for (String string2 : list2) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            stringBuffer.append("=t.");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

