/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.testObjects.UtStartup;
import oracle.dbtools.unit_test.testObjects.UtTeardown;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.xml.parser.v2.XMLElement;

public class UtSuite {
    private String _utSid;
    private String _suiteName;
    private boolean _coverage;
    private List<UtStartup> _startups = new ArrayList<UtStartup>();
    private HashSet<String> _savedStartupIdSet = new HashSet();
    private List<UtTeardown> _teardowns = new ArrayList<UtTeardown>();
    private HashSet<String> _savedTeardownIdSet = new HashSet();
    private String _sourceConName;
    private List<SuiteItem> _items = new LinkedList<SuiteItem>();
    private boolean dirty = false;
    private static final String YES = "Y";
    private static final String NO = "N";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSuiteImplsCount(String string) {
        int n = 0;
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string2 = UtUtils.getQuery("GetSuiteImplsCount");
                hashMap.put("SID", string);
                resultSetWrapper = dBUtil.executeOracleQuery(string2, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    resultSetWrapper.close();
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return n;
    }

    public UtSuite(String string) {
        this._utSid = string;
        this.loadData();
    }

    public UtSuite(ImportContext importContext) {
        List<XMLElement> list;
        String string;
        String string2;
        XMLElement xMLElement = importContext.getImportedElement();
        this._utSid = xMLElement.getAttribute("id");
        if (this._utSid == null || this._utSid.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        this._suiteName = xMLElement.getAttribute("name");
        if (this._suiteName == null || this._suiteName.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        if ((string2 = UtUtils.existingSuiteID(this._utSid, this._suiteName)) != null) {
            switch (importContext.conflictOption()) {
                case OVERWRITE: {
                    UtUtils.deleteSuite(string2, false);
                    break;
                }
                case SKIP: {
                    importContext.objectSkipped();
                    return;
                }
            }
        }
        this._coverage = (string = xMLElement.getAttribute("coverage")) != null ? Boolean.parseBoolean(string) : false;
        List<XMLElement> list2 = importContext.getNestedElements(xMLElement, "startup");
        for (XMLElement object22 : list2) {
            list = new UtStartup(object22, null, this, importContext);
            this._startups.add((UtStartup)((Object)list));
        }
        List<XMLElement> list3 = importContext.getNestedElements(xMLElement, "teardown");
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            list = (XMLElement)iterator.next();
            Object object = new UtTeardown((XMLElement)list, null, this, importContext);
            this._teardowns.add((UtTeardown)object);
        }
        List<XMLElement> list4 = importContext.getNestedElements(xMLElement, "suite_item");
        for (Object object : list4) {
            SuiteItem suiteItem = new SuiteItem((XMLElement)object, importContext);
            this._items.add(suiteItem);
        }
        list = importContext.getNestedElements(xMLElement, "suite_test");
        for (XMLElement xMLElement2 : list) {
            SuiteItem suiteItem = new SuiteItem(xMLElement2, importContext);
            this._items.add(suiteItem);
        }
    }

    public void export(ExportContext exportContext) {
        this.exportRelated(exportContext);
        XMLElement xMLElement = exportContext.createExportedElement("suite");
        xMLElement.setAttribute("id", this._utSid);
        xMLElement.setAttribute("name", this._suiteName);
        xMLElement.setAttribute("coverage", Boolean.toString(this._coverage));
        for (UtStartup object : this._startups) {
            object.exportFields(xMLElement, exportContext);
        }
        for (UtTeardown utTeardown : this._teardowns) {
            utTeardown.exportFields(xMLElement, exportContext);
        }
        xMLElement.setAttribute("source_conn_name", this._sourceConName);
        for (SuiteItem suiteItem : this._items) {
            suiteItem.exportFields(xMLElement, exportContext);
        }
    }

    private void exportRelated(ExportContext exportContext) {
        for (UtStartup object : this._startups) {
            object.exportRelated(exportContext);
        }
        for (UtTeardown utTeardown : this._teardowns) {
            utTeardown.exportRelated(exportContext);
        }
        for (SuiteItem suiteItem : this._items) {
            String string;
            String string2 = suiteItem.getUtId();
            if (string2 != null) {
                exportContext.exportRelatedTest(string2);
            }
            if ((string = suiteItem.getUtNsid()) == null) continue;
            exportContext.exportRelatedSuite(string);
        }
    }

    public List<SuiteItem> getItems() {
        return this._items;
    }

    public void setItems(List<SuiteItem> list) {
        this._items = list;
        this.dirty = true;
    }

    public void addItem(SuiteItem suiteItem) {
        this._items.add(suiteItem);
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getSid() {
        return this._utSid;
    }

    public String getSuiteName() {
        return this._suiteName;
    }

    public void setSuiteName(String string) {
        this._suiteName = string;
        this.dirty = true;
    }

    public boolean getCoverage() {
        return this._coverage;
    }

    public void setCoverage(boolean bl) {
        this._coverage = bl;
    }

    public void setStartupCodeHooks(List<IStartup> list) {
        ArrayList<UtStartup> arrayList = new ArrayList<UtStartup>();
        HashMap<String, UtStartup> hashMap = new HashMap<String, UtStartup>();
        for (UtStartup object : this._startups) {
            hashMap.put(object.getStartupId(), object);
        }
        if (list != null) {
            for (IStartup iStartup : list) {
                if (null == iStartup.getXml()) continue;
                UtStartup utStartup = (UtStartup)hashMap.get(iStartup.getOwnerId());
                if (utStartup == null) {
                    utStartup = new UtStartup(null, this, null, -1, null, null, true);
                }
                utStartup.setStartupCodeHook(iStartup);
                arrayList.add(utStartup);
            }
        }
        this._startups = arrayList;
    }

    public void setTeardownCodeHooks(List<ITeardown> list) {
        ArrayList<UtTeardown> arrayList = new ArrayList<UtTeardown>();
        HashMap<String, UtTeardown> hashMap = new HashMap<String, UtTeardown>();
        for (UtTeardown object : this._teardowns) {
            hashMap.put(object.getTeardownId(), object);
        }
        if (list != null) {
            for (ITeardown iTeardown : list) {
                if (null == iTeardown.getXml()) continue;
                UtTeardown utTeardown = (UtTeardown)hashMap.get(iTeardown.getOwnerId());
                if (utTeardown == null) {
                    utTeardown = new UtTeardown(null, this, null, -1, null, null, true);
                }
                utTeardown.setTeardownCodeHook(iTeardown);
                arrayList.add(utTeardown);
            }
        }
        this._teardowns = arrayList;
    }

    public List<UtStartup> getStartups() {
        return this._startups;
    }

    public List<IStartup> getStartupCodeHooks() {
        ArrayList<IStartup> arrayList = new ArrayList<IStartup>();
        for (UtStartup utStartup : this._startups) {
            arrayList.add(utStartup.getStartupCodeHook());
        }
        return arrayList;
    }

    public List<UtTeardown> getTeardowns() {
        return this._teardowns;
    }

    public List<ITeardown> getTeardownCodeHooks() {
        ArrayList<ITeardown> arrayList = new ArrayList<ITeardown>();
        for (UtTeardown utTeardown : this._teardowns) {
            arrayList.add(utTeardown.getTeardownCodeHook());
        }
        return arrayList;
    }

    public String getSourceConName() {
        return this._sourceConName;
    }

    public void setSourceConName(String string) {
        this._sourceConName = string;
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStartups() {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string = UtUtils.getQuery("loadSuiteStartups");
                hashMap.put("UT_SID", this._utSid);
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("STARTUP_ID");
                        int n = resultSet.getInt("INDEX_NO");
                        String string3 = null;
                        UtLibraryRef utLibraryRef = null;
                        String string4 = resultSet.getString("LIB_STARTUP_ID");
                        if (string4 != null) {
                            utLibraryRef = new UtLibraryRef(string4, resultSet.getString("LIB_STARTUP_NAME"));
                            string3 = resultSet.getString("LIB_STARTUP");
                        } else {
                            utLibraryRef = null;
                            string3 = resultSet.getString("STARTUP");
                        }
                        UtStartup utStartup = new UtStartup(null, this, string2, n, utLibraryRef, string3, false);
                        this._startups.add(utStartup);
                        this._savedStartupIdSet.add(utStartup.getStartupId());
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTeardowns() {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string = UtUtils.getQuery("loadSuiteTeardowns");
                hashMap.put("UT_SID", this._utSid);
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("TEARDOWN_ID");
                        int n = resultSet.getInt("INDEX_NO");
                        String string3 = null;
                        UtLibraryRef utLibraryRef = null;
                        String string4 = resultSet.getString("LIB_TEARDOWN_ID");
                        if (string4 != null) {
                            utLibraryRef = new UtLibraryRef(string4, resultSet.getString("LIB_TEARDOWN_NAME"));
                            string3 = resultSet.getString("LIB_TEARDOWN");
                        } else {
                            utLibraryRef = null;
                            string3 = resultSet.getString("TEARDOWN");
                        }
                        UtTeardown utTeardown = new UtTeardown(null, this, string2, n, utLibraryRef, string3, false);
                        this._teardowns.add(utTeardown);
                        this._savedTeardownIdSet.add(utTeardown.getTeardownId());
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                ResultSet resultSet;
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string = UtUtils.getQuery("suite");
                hashMap.put("ID", this._utSid);
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        this._suiteName = resultSet.getString("NAME");
                        this._coverage = resultSet.getBoolean("COVERAGE");
                    }
                    resultSetWrapper.close();
                }
                hashMap.clear();
                hashMap.put("ID", this._utSid);
                string = UtUtils.getQuery("suiteItems");
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        this._items.add(new SuiteItem(resultSet.getString("UT_ID"), resultSet.getString("UT_NSID"), YES.equals(resultSet.getString("RUN_START")), YES.equals(resultSet.getString("RUN_TEAR"))));
                    }
                    resultSetWrapper.close();
                }
                this.loadStartups();
                this.loadTeardowns();
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public void save(boolean bl) throws ObjectUpdateException {
        if (!bl && !this.dirty) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            Savepoint savepoint = null;
            try {
                int n;
                HashSet<String> hashSet;
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                savepoint = connection.setSavepoint();
                String string = UtUtils.getQuery("mergeSuite");
                hashMap.put("UT_SID", this._utSid);
                hashMap.put("NAME", this._suiteName);
                hashMap.put("COVERAGE", this._coverage ? 1 : 0);
                dBUtil.setRaiseError(true);
                int n2 = dBUtil.executeUpdate(string, hashMap);
                if (0 == n2) {
                    connection.rollback(savepoint);
                    throw new ObjectUpdateException();
                }
                try {
                    hashSet = new HashSet<String>();
                    for (int i = 0; i < this._startups.size(); ++i) {
                        UtStartup object2 = this._startups.get(i);
                        hashSet.add(object2.getStartupId());
                        object2.save(i, bl);
                    }
                    for (String string2 : this._savedStartupIdSet) {
                        if (hashSet.contains(string2)) continue;
                        dBUtil = DBUtil.getInstance((Connection)connection);
                        string = UtUtils.getQuery("deleteStartup");
                        hashMap.put("ID", string2);
                        dBUtil.setRaiseError(true);
                        n2 = dBUtil.executeUpdate(string, hashMap);
                        if (0 != n2) continue;
                        throw new ObjectUpdateException();
                    }
                    this._savedStartupIdSet = new HashSet(this._startups.size());
                    for (n = 0; n < this._startups.size(); ++n) {
                        UtStartup utStartup = this._startups.get(n);
                        this._savedStartupIdSet.add(utStartup.getStartupId());
                    }
                }
                catch (ObjectUpdateException objectUpdateException) {
                    connection.rollback(savepoint);
                    throw objectUpdateException;
                }
                try {
                    hashSet = new HashSet();
                    for (n = 0; n < this._teardowns.size(); ++n) {
                        UtTeardown utTeardown = this._teardowns.get(n);
                        hashSet.add(utTeardown.getTeardownId());
                        utTeardown.save(n, bl);
                    }
                    for (String string3 : this._savedTeardownIdSet) {
                        if (hashSet.contains(string3)) continue;
                        dBUtil = DBUtil.getInstance((Connection)connection);
                        string = UtUtils.getQuery("deleteTeardown");
                        hashMap.put("ID", string3);
                        dBUtil.setRaiseError(true);
                        n2 = dBUtil.executeUpdate(string, hashMap);
                        if (0 != n2) continue;
                        throw new ObjectUpdateException();
                    }
                    this._savedTeardownIdSet = new HashSet(this._teardowns.size());
                    for (int i = 0; i < this._teardowns.size(); ++i) {
                        UtTeardown utTeardown = this._teardowns.get(i);
                        this._savedTeardownIdSet.add(utTeardown.getTeardownId());
                    }
                }
                catch (ObjectUpdateException objectUpdateException) {
                    connection.rollback(savepoint);
                    throw objectUpdateException;
                }
                string = UtUtils.getQuery("deleteSuiteItems");
                hashMap.clear();
                hashMap.put("UT_SID", this._utSid);
                dBUtil.setRaiseError(false);
                dBUtil.executeUpdate(string, hashMap);
                int n3 = 0;
                for (SuiteItem suiteItem : this._items) {
                    string = UtUtils.getQuery("mergeSuiteItem");
                    hashMap.clear();
                    hashMap.put("UT_ID", suiteItem.getUtId());
                    hashMap.put("UT_NSID", suiteItem.getUtNsid());
                    hashMap.put("UT_SID", this._utSid);
                    hashMap.put("RUN_START", suiteItem.runStartup() ? YES : NO);
                    hashMap.put("RUN_TEAR", suiteItem.runTeardown() ? YES : NO);
                    hashMap.put("SEQUENCE", n3++);
                    dBUtil.setRaiseError(true);
                    n2 = dBUtil.executeUpdate(string, hashMap);
                    if (0 != n2) continue;
                    connection.rollback(savepoint);
                    throw new ObjectUpdateException();
                }
                this.dirty = false;
                connection.commit();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                if (savepoint != null) {
                    try {
                        connection.rollback(savepoint);
                    }
                    catch (SQLException sQLException2) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException2.getStackTrace()[0].toString(), sQLException2);
                    }
                }
                throw new ObjectUpdateException(sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public class SuiteItem {
        private String ut_id;
        private String ut_nsid;
        private boolean run_start;
        private boolean run_teardown;
        private UtTest test;
        private UtSuite suite;

        public SuiteItem(String string, String string2, boolean bl, boolean bl2) {
            this.ut_id = string;
            this.ut_nsid = string2;
            this.run_start = bl;
            this.run_teardown = bl2;
        }

        SuiteItem(XMLElement xMLElement, ImportContext importContext) {
            String string;
            this.ut_id = xMLElement.getAttribute("test_id");
            if (this.ut_id.equals("")) {
                this.ut_id = null;
            }
            this.ut_nsid = xMLElement.getAttribute("nested_suite_id");
            if (this.ut_nsid.equals("")) {
                this.ut_nsid = null;
            }
            if (this.ut_id == null && this.ut_nsid == null) {
                importContext.log(LoggerLevel.SEVERE, "unexpected null value");
            }
            this.run_start = (string = xMLElement.getAttribute("run_start")) != null ? Boolean.parseBoolean(string) : false;
            string = xMLElement.getAttribute("run_teardown");
            this.run_teardown = string != null ? Boolean.parseBoolean(string) : false;
        }

        void exportFields(XMLElement xMLElement, ExportContext exportContext) {
            XMLElement xMLElement2 = exportContext.createExportedElement(xMLElement, "suite_item");
            if (this.ut_id != null) {
                xMLElement2.setAttribute("test_id", this.ut_id);
            }
            if (this.ut_nsid != null) {
                xMLElement2.setAttribute("nested_suite_id", this.ut_nsid);
            }
            xMLElement2.setAttribute("run_start", Boolean.toString(this.run_start));
            xMLElement2.setAttribute("run_teardown", Boolean.toString(this.run_teardown));
        }

        public boolean runStartup() {
            return this.run_start;
        }

        public void setRunStartup(boolean bl) {
            this.run_start = bl;
        }

        public boolean runTeardown() {
            return this.run_teardown;
        }

        public void setRunTeardown(boolean bl) {
            this.run_teardown = bl;
        }

        public String getUtId() {
            return this.ut_id;
        }

        public String getUtNsid() {
            return this.ut_nsid;
        }

        public void setUtId(String string) {
            if (null != this.test && !this.test.getId().equals(string)) {
                this.test = null;
            }
            this.ut_id = string;
        }

        public UtTest getTest() {
            if (null == this.test && null != this.ut_id) {
                this.test = new UtTest(this.ut_id);
            }
            return this.test;
        }

        public void setUtNsid(String string) {
            if (null != this.suite && !this.suite.getSid().equals(string)) {
                this.suite = null;
            }
            this.ut_nsid = string;
        }

        public UtSuite getSuite() {
            if (null == this.suite && null != this.ut_nsid) {
                this.suite = new UtSuite(this.ut_nsid);
            }
            return this.suite;
        }

        public String getName() {
            String string = null;
            UtTest utTest = this.getTest();
            if (utTest != null) {
                string = utTest.getTestName();
            } else {
                UtSuite utSuite = this.getSuite();
                if (utSuite != null) {
                    string = utSuite.getSuiteName();
                }
            }
            return string;
        }

        public int getTestCaseCount() {
            int n = 0;
            UtTest utTest = this.getTest();
            if (utTest != null) {
                n = this.getTest().getImpls().size();
            } else if (this.ut_nsid != null) {
                n = UtSuite.this.getSuiteImplsCount(this.ut_nsid);
            }
            return n;
        }
    }
}

