/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.DB2CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.DB2OnlineCapturer;

public abstract class DB2Capturer
extends AbstractOnlineCapturer {
    protected DB2OnlineCapturer m_db2CaptureObjectsOnlineCapturer = null;
    private static CaptureQueries s_captureQueries;
    protected String m_modelName;

    public DB2Capturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
        this.m_db2CaptureObjectsOnlineCapturer = this.getOnlineCapturer(migrationStorer, connection);
    }

    protected abstract DB2OnlineCapturer getOnlineCapturer(MigrationStorer var1, Connection var2);

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new DB2CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_db2CaptureObjectsOnlineCapturer.captureObjects(string, captureContext, migrationObjectFilter);
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData databaseMetaData = this.m_sourceConnection.getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                this.m_modelName = "\\\\" + stringArray[2] + "\\" + stringArray[3] + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                throw new CaptureException((Throwable)sQLException);
            }
        }
        return this.m_modelName;
    }
}

