/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.xdiffer;

import java.util.Vector;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.XMLDifferException;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BasicXMLDiffer {
    protected static final String SIDE1 = "1";
    protected static final String SIDE2 = "2";
    protected static final int OPTIONAL_TRUE = 1;
    protected static final int OPTIONAL_FALSE = 2;
    protected static final int OPTIONAL_UNKNOWN = 3;
    private static final String SRC = "src";
    private static final String VALUE1 = "value1";
    private XMLElement m_root1 = null;
    private XMLElement m_root2 = null;

    public BasicXMLDiffer(XMLElement e1, XMLElement e2) {
        this.m_root1 = e1;
        this.m_root2 = e2;
    }

    public void compare() throws XMLDifferException {
        this.initDiffer();
        this.compare((XMLNode)this.m_root1, (XMLNode)this.m_root2, null, null, null);
    }

    protected void initDiffer() throws XMLDifferException {
    }

    protected void compare(XMLNode n1, XMLNode n2, XMLElement n2Parent, XMLNode n2ParentNextChild, Object context) throws XMLDifferException {
        if (n1 == null && n2 == null) {
            return;
        }
        if (n1 == null) {
            this.markSideOnlyNode(n2, SIDE2);
            return;
        }
        if (n2 == null) {
            if (n2Parent != null) {
                this.attachNewNode(n1, (XMLNode)n2Parent, n2ParentNextChild, SIDE1);
            }
        } else {
            NodeList childrenList1 = n1.getChildNodes();
            NodeList childrenList2 = n2.getChildNodes();
            int length1 = 0;
            int length2 = 0;
            if (childrenList1 != null) {
                length1 = childrenList1.getLength();
            }
            if (childrenList2 != null) {
                length2 = childrenList2.getLength();
            }
            if (length1 == 0 && length2 == 0) {
                boolean leafMatched = this.matchLeafNodes(n1, n2, context);
                if (!leafMatched) {
                    this.modifyNode(n1, n2Parent);
                }
                return;
            }
            int idx1 = 0;
            int idx2 = 0;
            while (idx1 < length1 || idx2 < length2) {
                XMLNode child1 = null;
                XMLNode child2 = null;
                if (idx1 < length1) {
                    child1 = (XMLNode)childrenList1.item(idx1);
                }
                if (idx2 < length2) {
                    child2 = (XMLNode)childrenList2.item(idx2);
                }
                if (child1 != null && child2 != null) {
                    short type1 = child1.getNodeType();
                    short type2 = child2.getNodeType();
                    if (type1 == 1 && type2 == 1) {
                        this.compareSequences(n1, n2, childrenList1, childrenList2, idx1, idx2, length1, length2, context);
                        return;
                    }
                    if (type1 == 3 && type2 != 3) {
                        if (!"".equals(((Text)child1).getNodeValue().trim())) continue;
                        ++idx1;
                        continue;
                    }
                    if (type1 != 3 && type2 == 3) {
                        if (!"".equals(((Text)child2).getNodeValue().trim())) continue;
                        ++idx2;
                        continue;
                    }
                    this.compare(child1, child2, (XMLElement)n2, null, context);
                    ++idx1;
                    ++idx2;
                    continue;
                }
                if (child1 != null) {
                    if (child1.getNodeType() == 1) {
                        this.attachNewNode(child1, n2, null, SIDE1);
                    } else if (child1.getNodeType() == 3) {
                        this.modifyNode(child1, (XMLElement)n2);
                    }
                    ++idx1;
                }
                if (child2 == null) continue;
                if (child2.getNodeType() == 1) {
                    this.markSideOnlyNode(child2, SIDE2);
                } else if (child2.getNodeType() == 3) {
                    this.modifyNode("", (XMLElement)n2);
                }
                ++idx2;
            }
        }
    }

    protected void compareSequences(XMLNode n1, XMLNode n2, NodeList childrenList1, NodeList childrenList2, int idx1, int idx2, int length1, int length2, Object context) throws XMLDifferException {
        XMLNode child1 = null;
        XMLNode child2 = null;
        Vector<XMLElement> childrenVec2 = new Vector<XMLElement>(length2 - idx2);
        for (int i = idx2; i < length2; ++i) {
            XMLNode chld = (XMLNode)childrenList2.item(i);
            if (chld.getNodeType() != 1) {
                BasicXMLDiffer.assertDifferException("Expected ELEMENT_NODE in compareSequences(), got " + chld.getNodeType());
            }
            childrenVec2.add((XMLElement)chld);
        }
        int vIdx2 = 0;
        int vLength2 = childrenVec2.size();
        while (idx1 < length1 && vIdx2 < vLength2) {
            int newVIdx2;
            child1 = (XMLNode)childrenList1.item(idx1);
            if (child1.getNodeType() != 1) {
                BasicXMLDiffer.assertDifferException("Expected ELEMENT_NODE in compareSequences(), got " + child1.getNodeType());
            }
            if ((newVIdx2 = this.findMatch((XMLElement)child1, childrenVec2, vLength2, vIdx2, context)) >= vIdx2) {
                if (newVIdx2 > vIdx2) {
                    while (vIdx2 < newVIdx2) {
                        XMLElement side2OnlyNode = childrenVec2.elementAt(vIdx2);
                        this.markSideOnlyNode((XMLNode)side2OnlyNode, SIDE2);
                        ++vIdx2;
                    }
                }
                child2 = (XMLNode)childrenVec2.elementAt(vIdx2);
                this.compare(child1, child2, (XMLElement)n2, (XMLNode)child2.getNextSibling(), context);
                ++idx1;
                ++vIdx2;
                continue;
            }
            this.attachNewNode(child1, n2, (XMLNode)childrenVec2.elementAt(vIdx2), SIDE1);
            ++idx1;
        }
        XMLNode insBeforeNode = null;
        if (vIdx2 < vLength2) {
            insBeforeNode = (XMLNode)childrenVec2.elementAt(vIdx2);
        }
        while (idx1 < length1) {
            child1 = (XMLNode)childrenList1.item(idx1);
            this.attachNewNode(child1, n2, insBeforeNode, SIDE1);
            ++idx1;
        }
        while (vIdx2 < vLength2) {
            child2 = (XMLNode)childrenVec2.elementAt(vIdx2);
            this.markSideOnlyNode(child2, SIDE2);
            ++vIdx2;
        }
    }

    private boolean matchLeafNodes(XMLNode ln1, XMLNode ln2, Object context) throws XMLDifferException {
        boolean matches = false;
        matches = ln1.getNodeType() == 3 && ln2.getNodeType() == 3 ? this.matchTextNodes((XMLText)ln1, (XMLText)ln2, context) : this.matchNonTextLeafNodes(ln1, ln2);
        return matches;
    }

    protected boolean matchTextNodes(XMLText tn1, XMLText tn2, Object context) throws XMLDifferException {
        boolean matches = tn1.getNodeValue().equals(tn2.getNodeValue());
        return matches;
    }

    private boolean matchNonTextLeafNodes(XMLNode n1, XMLNode n2) {
        boolean matches = false;
        if (n1.getNodeType() == 1 && n2.getNodeType() == 1) {
            matches = this.sameElement((XMLElement)n1, (XMLElement)n2);
        }
        return matches;
    }

    private int findMatch(XMLElement child1, Vector<XMLElement> childrenVec2, int length2, int idx2, Object context) throws XMLDifferException {
        int matchIndex = -1;
        for (int i = idx2; i < length2; ++i) {
            XMLElement child2 = childrenVec2.elementAt(i);
            if (this.sameElement(child1, child2)) {
                matchIndex = i;
                break;
            }
            int child1Optional = this.isOptionalElement(child1, context);
            if (child1Optional == 3 || this.isOptionalElement(child2, context) != 2) continue;
            if (child1Optional == 1) break;
            BasicXMLDiffer.assertDifferException("Required element <" + child1.getTagName() + "> not found on side 2");
        }
        return matchIndex;
    }

    protected int isOptionalElement(XMLElement e, Object context) throws XMLDifferException {
        return 3;
    }

    private boolean sameElement(XMLElement e1, XMLElement e2) {
        return e1.getTagName().equals(e2.getTagName());
    }

    protected void markSideOnlyNode(XMLNode n, String whichSide) throws XMLDifferException {
        if (n.getNodeType() != 1) {
            BasicXMLDiffer.assertDifferException("Attempt to set src attribute on non-element node");
        }
        ((XMLElement)n).setAttribute(SRC, whichSide);
    }

    private void modifyNode(XMLNode n1, XMLElement n2Parent) throws XMLDifferException {
        if (n1.getNodeType() != 3) {
            BasicXMLDiffer.assertDifferException("Attempt to set value1 from non-text node of type " + n1.getNodeType());
        }
        if (n2Parent != null) {
            this.modifyNode(((XMLText)n1).getNodeValue(), n2Parent);
        } else {
            BasicXMLDiffer.assertDifferException("Attempt to modify null node");
        }
    }

    private void modifyNode(String newValue, XMLElement node) {
        node.setAttribute(VALUE1, newValue);
    }

    protected void attachNewNode(XMLNode newNode, XMLNode parent, XMLNode insertBeforeNode, String markAsSide) throws XMLDifferException {
        XMLNode newNodeClone = (XMLNode)parent.getOwnerDocument().importNode((Node)newNode, true);
        this.markSideOnlyNode(newNodeClone, markAsSide);
        if (insertBeforeNode != null) {
            parent.insertBefore((Node)newNodeClone, (Node)insertBeforeNode);
        } else {
            parent.appendChild((Node)newNodeClone);
        }
    }

    protected static void assertDifferException(String msg) throws XMLDifferException {
        BasicXMLDiffer.assertDifferException(msg, null);
    }

    protected static void assertDifferException(String msg, Exception e) throws XMLDifferException {
        throw new XMLDifferException(msg, e);
    }
}

