/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.Messages;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;

public class Query {
    private static final Logger logger = Logger.getLogger(Query.class.getName());
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private String q = "";
    private List<String> binds = new ArrayList<String>();
    private String tablespaceName = null;
    private boolean isDba = false;
    private static final String OBJ_LIKE_CRITERIA = " and object_name like :object_name ";
    private static final String DATABASE_LINK_LIKE_CRITERIA = " and db_link like :db_link ";
    private static final String OBJ_CRITERIA = " and object_name = :object_name ";
    private static final String OBJECT_TYPE_CRITERIA = " and object_type = :object_type ";
    private static final String OBJECT_TYPES_CRITERIA_START = " and object_type in (";
    private static final String QUESTION_MARK = " :";
    private static final String NEXT = ",";
    private static final String END = " )";
    private static final String OWNER_CRITERIA = " and owner = :owner ";
    private static final String OWNER_CRITERIA_START = " and owner in (";
    private static final String O_OWNER_CRITERIA_START = " and o.owner in (";
    private static final String LOG_OWNER_CRITERIA_START = " and log_owner in (";
    private static final String TBLSPACE_OWNER_CRITERIA = " and obj.owner = :owner ";
    private static final String OBJ_LIKE_CRITERIA_MAT_VIEW_LOG = " and master like :master ";
    private final String QUERY_ALL_COLUMNS = "select c.column_name name, -1 LINE, -1 COL, null USAGE, 'COLUMN' TYPE, c.OWNER, o.object_type OBJECT_TYPE, c.table_NAME OBJECT_NAME \n from sys.all_tab_columns c, all_objects o \n where c.table_name=o.object_name and c.owner = o.owner and rownum <= " + this.limit();
    private static final String COL_LIKE_CRITERIA = " and c.column_name like :colname ";
    private final String QUERY_ALL_IDENTIFIERS = "select name, LINE, COL, USAGE, TYPE, OWNER, OBJECT_TYPE, OBJECT_NAME \n from sys.all_identifiers where rownum <= " + this.limit();
    private static final String NAME_LIKE_CRITERIA = " and name like :name ";
    private static final String USAGE_CRITERIA_START = " and usage in (";
    private static final String TYPE_CRITERIA_START = " and type in (";
    private final String QUERY_ALL_SOURCE = "select text name, LINE, instr(upper(text),upper(:text)) COL, null USAGE, TYPE, OWNER, type OBJECT_TYPE, name OBJECT_NAME \n from sys.all_source where rownum <= " + this.limit() + " \n" + " and upper(text) like upper(:text1) and name not like 'BIN$%' \n" + " and (instr(text,'--')<=0 or instr(text,'--')>instr(upper(text),upper(:text2))) \n" + " and (instr(text,'/*')<=0 or instr(text,'/*')>instr(upper(text),upper(:text3)))";
    private static final String NAME_CRITERIA = " and name = :name ";
    private final String QUERY_ALL_PROCEDURES = "select null name, -1 LINE, -1 COL, null USAGE, object_type TYPE, OWNER, object_type OBJECT_TYPE, OBJECT_NAME \n from sys.all_procedures where rownum < " + this.limit();
    private static final String PKG_NAME = " and object_name = :oname ";
    private static final String PROC_NAME = " and procedure_name = :procname ";
    private int pos = 1;
    private static final String PLSQL_OBJ_TYPES = " and object_type in ('PROCEDURE','FUNCTION','PACKAGE') ";
    boolean prepareAllIdCalled = false;
    PreparedStatement ps = null;

    public Query(String string, String string2) {
        this.connectionName = string;
        this.checkDbaAccess(string);
    }

    public Query(String string, String string2, String string3) {
        this.connectionName = string;
        this.tablespaceName = string3;
        this.checkDbaAccess(string);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDbaAccess(String string) {
        String string2 = "select 1 from DBA_OBJECTS where 1=2";
        Statement statement = null;
        try {
            Connection connection = ChameleonConnection.getConnection((String)string);
            if (connection != null) {
                statement = connection.createStatement();
                statement.execute(string2);
            }
            this.isDba = true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 942) {
                logger.severe(this.query.toString());
                logger.severe(sQLException.getMessage());
            }
        }
        catch (DBException dBException) {
            logger.severe(dBException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.severe(classNotFoundException.getMessage());
        }
        catch (ConnectionException connectionException) {
            logger.severe(connectionException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int limit() {
        return 500;
    }

    public String QUERY_ALL_OBJECTS() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \ncase when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \nOWNER, case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \nobj.OBJECT_NAME \n from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'";
    }

    public final String QUERY_ALL_OBJECTS_TBLSPACE() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \ncase when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \nobj.OWNER, case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \nobj.OBJECT_NAME \n from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj, sys.dba_segments seg where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'" + " and obj.object_name = seg.segment_name" + " and obj.owner = seg.owner" + " and seg.tablespace_name = '" + this.tablespaceName + "'" + " union " + "select null name, -1 LINE, -1 COL, null USAGE, \n" + "case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \n" + "obj.OWNER, " + "case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \n" + "obj.OBJECT_NAME \n" + " from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj, sys.dba_segments seg where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'" + " and obj.owner = seg.owner" + " and NOT obj.object_type in (select distinct segment_type from sys.dba_segments where tablespace_name = '" + this.tablespaceName + "')";
    }

    public final String QUERY_ALL_OBJECTS_TBLSPACE1() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \ncase when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \nobj.OWNER, case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \nobj.OBJECT_NAME \n from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj, sys.dba_segments seg where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'" + " and obj.object_name = seg.segment_name" + " and obj.owner = seg.owner" + " and seg.tablespace_name = '" + this.tablespaceName + "'";
    }

    public final String QUERY_ALL_OBJECTS_TBLSPACE2() {
        return " union select null name, -1 LINE, -1 COL, null USAGE, \ncase when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \nobj.OWNER, case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \nobj.OBJECT_NAME \n from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj, sys.dba_segments seg where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'" + " and obj.owner = seg.owner" + " and NOT obj.object_type in (select distinct segment_type from sys.dba_segments where tablespace_name = '" + this.tablespaceName + "')";
    }

    public final String QUERY_MAT_VIEW_LOG_OBJECTS() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \n 'MATERIALIZED VIEW LOG' TYPE, log_owner OWNER, \n 'MATERIALIZED VIEW LOG' OBJECT_TYPE, master||'('||LOG_TABLE||')' OBJECT_NAME \n from all_snapshot_logs where rownum <= " + this.limit();
    }

    public final String QUERY_DATABASE_LINK() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \n 'DATABASE LINK' TYPE, owner OWNER, \n 'DATABASE LINK' OBJECT_TYPE, db_link OBJECT_NAME \n from " + (this.isDba ? "dba_db_links" : "all_db_links") + " where rownum <= " + this.limit();
    }

    public void prepareAllObjects(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.q = this.tablespaceName == null ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE1();
        String string3 = "";
        if (string != null && !"".equals(string) && string.indexOf(46) > 0) {
            string3 = string.substring(0, string.indexOf(46));
            string = string.substring(string.indexOf(46) + 1);
            this.qappendOwner(string3);
        }
        this.qappendObjName(string);
        this.qappendType(string2);
        if (this.tablespaceName != null) {
            this.q = this.q + "\n" + this.QUERY_ALL_OBJECTS_TBLSPACE2();
            if (string.indexOf(46) > 0) {
                this.qappendOwner(string3);
            }
            this.qappendObjName(string);
            this.qappendType(string2);
        }
        this.query.append(this.q);
    }

    private String conditionalUpperCase(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && c == '\"') {
                if (string.endsWith("%")) {
                    return string.substring(1, string.length() - 2) + "%";
                }
                return string.substring(1, string.length() - 1);
            }
            if ('A' <= c && c <= 'Z') {
                bl2 = true;
            }
            if ('a' <= c && c <= 'z') {
                bl3 = true;
            }
            if (!bl2 || !bl3) continue;
            bl = true;
            break;
        }
        return bl ? string : string.toUpperCase();
    }

    public void prepareAllObjects(String string, String string2, String string3) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.q = this.tablespaceName == null ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE1();
        this.qappendObjName(string);
        this.qappendType(string2);
        this.qappendOwner(string3);
        if (this.tablespaceName != null) {
            this.q = this.q + "\n" + this.QUERY_ALL_OBJECTS_TBLSPACE2();
            this.qappendObjName(string);
            this.qappendType(string2);
            this.qappendOwner(string3);
        }
        this.query.append(this.q);
    }

    private void qappendObjName(String string) {
        if (string != null && !"".equals(string)) {
            this.q = this.q + OBJ_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
    }

    private void qappendType(String string) {
        if (!(string == null || "ALL".equals(string) || "ALL OBJECTS".equals(string) || "".equals(string))) {
            this.q = this.q + OBJECT_TYPE_CRITERIA;
            this.binds.add(string.toUpperCase());
        }
    }

    private void qappendOwner(String string) {
        if (string != null && !"".equals(string)) {
            this.q = this.q + (this.tablespaceName == null ? OWNER_CRITERIA : TBLSPACE_OWNER_CRITERIA);
            this.binds.add(string.toUpperCase());
        }
    }

    public void prepareAllObjects(String string, String[] stringArray, String[] stringArray2) {
        String string2;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = stringArray == null || stringArray.length == 0;
        this.q = this.tablespaceName == null ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE1();
        this.qappendObjName(string);
        if (stringArray != null && stringArray.length > 0) {
            this.q = this.q + OBJECT_TYPES_CRITERIA_START;
            string2 = "";
            for (String string3 : stringArray) {
                this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(string3.toUpperCase());
                string2 = NEXT;
                if (string3.equals("MATERIALIZED VIEW LOG")) {
                    bl = true;
                    continue;
                }
                if (string3.equals("DATABASE LINK")) {
                    bl2 = true;
                    continue;
                }
                bl3 = true;
            }
            this.q = this.q + END;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            if (this.tablespaceName != null) {
                this.q = this.q + TBLSPACE_OWNER_CRITERIA;
                this.binds.add(this.conditionalUpperCase(stringArray2[0]));
            } else {
                this.q = this.q + OWNER_CRITERIA_START;
                string2 = "";
                for (String string3 : stringArray2) {
                    this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                    this.binds.add(this.conditionalUpperCase(string3));
                    string2 = NEXT;
                }
                this.q = this.q + END;
            }
        }
        if (!bl3) {
            this.q = "";
            this.binds.clear();
            this.pos = 1;
        }
        if (bl) {
            if (bl3) {
                this.q = this.q + "\n union all \n";
            }
            this.q = this.q + this.QUERY_MAT_VIEW_LOG_OBJECTS();
            if (stringArray2 != null && stringArray2.length > 0) {
                this.q = this.q + LOG_OWNER_CRITERIA_START;
                string2 = "";
                for (String string3 : stringArray2) {
                    this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                    this.binds.add(this.conditionalUpperCase(string3));
                    string2 = NEXT;
                }
                this.q = this.q + END;
            }
            if (string != null && !"".equals(string)) {
                this.q = this.q + OBJ_LIKE_CRITERIA_MAT_VIEW_LOG;
                this.binds.add(string.toUpperCase());
            }
        }
        if (bl2) {
            if (bl3 || bl) {
                this.q = this.q + "\n union \n";
            }
            this.q = this.q + this.QUERY_DATABASE_LINK();
            if (stringArray2 != null && stringArray2.length > 0) {
                this.q = this.q + OWNER_CRITERIA_START;
                string2 = "";
                for (String string3 : stringArray2) {
                    this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                    this.binds.add(this.conditionalUpperCase(string3));
                    string2 = NEXT;
                }
                this.q = this.q + END;
            }
            if (string != null && !"".equals(string)) {
                this.q = this.q + DATABASE_LINK_LIKE_CRITERIA;
                this.binds.add(string.toUpperCase());
            }
        }
        this.query.append(this.q);
    }

    public void prepareObject(String string, String string2, String string3) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string4 = this.q = this.tablespaceName == null ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE();
        if (string != null && !"".equals(string)) {
            this.q = this.q + OBJ_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (string2 != null && !"ALL".equals(string2) && !"".equals(string2)) {
            this.q = this.q + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        if (string3 != null && !"".equals(string3)) {
            this.q = this.q + (this.tablespaceName == null ? OWNER_CRITERIA : TBLSPACE_OWNER_CRITERIA);
            this.binds.add(this.conditionalUpperCase(string3));
        }
        this.query.append(this.q);
    }

    public void prepareProcedure(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.q = this.QUERY_ALL_OBJECTS();
        if (string2 != null && !"".equals(string2)) {
            this.q = this.q + OBJ_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string2));
        }
        this.q = this.q + PLSQL_OBJ_TYPES;
        if (string != null && !"".equals(string)) {
            this.q = this.q + OWNER_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        this.query.append(this.q);
        this.query.append("\n union all \n");
        this.q = this.QUERY_ALL_PROCEDURES;
        if (string2 != null && !"".equals(string2)) {
            this.q = this.q + PROC_NAME;
            this.binds.add(this.conditionalUpperCase(string2));
        }
        if (string != null && !"".equals(string)) {
            this.q = this.q + PKG_NAME;
            this.binds.add(this.conditionalUpperCase(string));
        }
        this.query.append(this.q);
    }

    public void prepareAllColumns(String string, String[] stringArray) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.q = this.QUERY_ALL_COLUMNS;
        if (string != null && !"".equals(string)) {
            this.q = this.q + COL_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (stringArray != null && stringArray.length > 0) {
            this.q = this.q + O_OWNER_CRITERIA_START;
            String string2 = "";
            for (String string3 : stringArray) {
                this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(this.conditionalUpperCase(string3));
                string2 = NEXT;
            }
            this.q = this.q + END;
        }
        this.query.append(this.q);
    }

    public void prepareDatabaseLink(String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union \n");
        }
        this.q = this.QUERY_DATABASE_LINK();
        if (string != null && !"".equals(string)) {
            this.q = this.q + DATABASE_LINK_LIKE_CRITERIA;
            this.binds.add(string);
        }
        this.query.append(this.q);
    }

    public void prepareAllIdentifiers(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        String string2;
        if (this.prepareAllIdCalled) {
            return;
        }
        this.prepareAllIdCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.q = this.QUERY_ALL_IDENTIFIERS;
        if (string != null && !"".equals(string)) {
            if (string.indexOf(46) > 0) {
                string2 = string.substring(0, string.indexOf(46));
                string = string.substring(string.indexOf(46) + 1);
                this.q = this.q + OBJ_CRITERIA;
                this.binds.add(this.conditionalUpperCase(string2));
            }
            this.q = this.q + NAME_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (stringArray != null && stringArray.length > 0) {
            this.q = this.q + TYPE_CRITERIA_START;
            string2 = "";
            for (String string3 : stringArray) {
                this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(string3.toUpperCase());
                string2 = NEXT;
            }
            this.q = this.q + END;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            this.q = this.q + USAGE_CRITERIA_START;
            string2 = "";
            for (String string3 : stringArray2) {
                this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(string3.toUpperCase());
                string2 = NEXT;
            }
            this.q = this.q + END;
        }
        if (stringArray3 != null && stringArray3.length > 0) {
            this.q = this.q + OWNER_CRITERIA_START;
            string2 = "";
            for (String string3 : stringArray3) {
                this.q = this.q + string2 + QUESTION_MARK + this.pos++;
                this.binds.add(this.conditionalUpperCase(string3));
                string2 = NEXT;
            }
            this.q = this.q + END;
        }
        this.query.append(this.q);
    }

    public void prepareAllSource(String string, String[] stringArray, boolean bl) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_ALL_SOURCE);
        this.binds.add(string);
        String string2 = bl ? "%" : "";
        this.binds.add(string2 + string + string2);
        this.binds.add(string);
        this.binds.add(string);
        if (stringArray != null && stringArray.length > 0) {
            this.query.append(OWNER_CRITERIA_START);
            String string3 = "";
            for (String string4 : stringArray) {
                this.query.append(string3 + QUESTION_MARK + this.pos++);
                this.binds.add(this.conditionalUpperCase(string4));
                string3 = NEXT;
            }
            this.query.append(END);
        }
    }

    public void prepareAllSource(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_ALL_SOURCE);
        this.binds.add(string2);
        this.binds.add("%" + string2 + "%");
        this.binds.add(string2);
        this.binds.add(string2);
        if (string != null && !"".equals(string)) {
            this.query.append(OWNER_CRITERIA);
            this.binds.add(this.conditionalUpperCase(string));
        }
    }

    public void prepareAllSource(String string, String string2, String string3) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append("select * from (" + this.QUERY_ALL_SOURCE);
        this.query.append("\n and type like 'PACKAGE%'");
        this.query.append(NAME_CRITERIA);
        this.query.append("\n) where col = 1 or substr(name/*text*/,col-1,1)=' '");
        this.query.append("\n order by type, line");
        this.binds.add(string3);
        this.binds.add("%" + string3 + "%");
        this.binds.add(string3);
        this.binds.add(string3);
        this.binds.add(string2.toUpperCase());
        if (string != null && !"".equals(string)) {
            this.query.append(OWNER_CRITERIA);
            this.binds.add(this.conditionalUpperCase(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Item> fetch(String string) {
        long l = System.currentTimeMillis();
        ArrayList<Item> arrayList = new ArrayList<Item>();
        ResultSet resultSet = null;
        try {
            Connection connection = ChameleonConnection.getConnection((String)this.connectionName);
            this.ps = connection.prepareStatement(this.getSql());
            for (int i = 1; i <= this.binds.size(); ++i) {
                this.ps.setObject(i, this.binds.get(i - 1));
            }
            resultSet = this.ps.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getRow() >= this.limit()) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("Query.0"), this.limit()), (String)Messages.getString("Query.1"), null);
                }
                Item item = null;
                int n = resultSet.getInt("LINE");
                int n2 = resultSet.getInt("COL");
                String string2 = resultSet.getString("USAGE");
                String string3 = resultSet.getString("TYPE");
                String string4 = resultSet.getString("NAME");
                if (n2 <= 0 && string4 != null) {
                    n2 = string4.toUpperCase().indexOf(string.toUpperCase()) + 1;
                }
                item = new Item(string4, resultSet.getString("OBJECT_NAME"), string3, resultSet.getString("OBJECT_TYPE"), resultSet.getString("OWNER"), string2, n, n2);
                arrayList.add(item);
            }
        }
        catch (DBException dBException) {
            logger.severe(this.query.toString());
            logger.severe(dBException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.severe(this.query.toString());
            logger.severe(sQLException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.severe(classNotFoundException.getMessage());
        }
        catch (ConnectionException connectionException) {
            logger.severe(connectionException.getMessage());
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException sQLException) {}
            }
            this.ps = null;
        }
        long l2 = System.currentTimeMillis();
        return arrayList;
    }

    private String getSql() {
        String string = "select NULL ENTRY, inner.* from ( \n" + this.query.toString() + "\n ) inner \n" + "where rownum <= " + this.limit() + "\n order by owner, type, name, CASE WHEN USAGE = 'DECLARATION' OR " + "USAGE = 'DEFINITION' THEN 0 ELSE 1 END, usage, object_name, line, col";
        return string;
    }

    public List<String> getBinds() {
        return this.binds;
    }

    public ArrayList<URL> fetch() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Item item : this.fetch(null)) {
            URL uRL = null;
            if (item.colName != null) {
                item.objName = item.objName + "." + item.colName;
            }
            uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this.connectionName, null, item.owner, item.objType), item.objName);
            arrayList.add(uRL);
        }
        return arrayList;
    }

    public void cancel() {
        if (this.ps != null) {
            try {
                this.ps.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:xe", "hr", "hr");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CURSOR(select 1 from dual)FROM dual", 1004, 1007);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Object object = resultSet.getObject(1);
        ResultSet resultSet2 = (ResultSet)object;
        resultSet2.next();
        System.out.println(resultSet2.getObject(1));
    }
}

