/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionResolver;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.insight.SynonymsCache;
import oracle.javatools.db.DBException;
import oracle.javatools.parser.plsql.SqlKeywords;
import oracle.javatools.util.Pair;

public class TabCol {
    public static String host = "jdbc:oracle:thin:@adc2180670:1521:x112";
    public static String user = "scott";
    public static String pwd = "tiger";
    private String connName;
    private boolean _noCols = false;
    public List<String> colTypesToExclude = null;
    public List<String> colNamesToExclude = null;
    public IResultSetTableModel resultSet = null;
    private SynonymsCache synonyms = null;
    static int where_clause = -1;
    static int subquery = -1;
    static int scalar_subquery_expression = -1;
    static int query_table_expression = -1;
    static int table_reference = -1;
    static int as = -1;
    static int select_term = -1;
    static int expr = -1;
    static int identifier = -1;
    static int dot = -1;
    static int star = -1;
    static int mult_op = -1;
    static int select = -1;
    static int select_list = -1;
    static int query_block = -1;
    static int subquery_factoring_clause = -1;
    private String _input = null;
    private List<LexerToken> _src;
    private Set<SuggestedItem> dbColumns;
    private Map<String, String> _tblAliases;
    private Map<ParseNode, String> _tables;
    private String _prefix;
    private String _suffix;
    static Integer indAll;
    static Integer indWhenever;
    private boolean excludedColumns = false;

    public static void main(String[] stringArray) throws Exception {
        DBUtil.setConnectionResolver((ConnectionResolver)new DefaultConnectionResolver());
        boolean bl = true;
        TabCol tabCol = new TabCol(host + "," + user + "," + pwd);
        ArrayList<Column> arrayList = tabCol.fetchColumns("select * from dept");
        boolean bl2 = tabCol.disambiguate(arrayList, new String[]{"X", "Y"}).startsWith("select X \"X\", Y \"Y\",");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("*** TEST#-1: extra columns *** ---> " + bl2);
        String string = null;
        System.out.println("---------- output ----------");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList2.add("NUMBER");
        arrayList3.add("ENAME");
        arrayList3.add("DNAME");
        string = "select * from emp";
        bl2 = TabCol.test(string, null, null).startsWith("select EMPNO EMPNO, ENAME ENAME, JOB JOB, MGR MGR, HIREDATE HIREDATE, SAL SAL, COMM COMM, DEPTNO DEPTNO");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("*** TEST#0: column ordering *** ---> " + bl2);
        string = "select hiredate, job, emp.job, sal, emp.sal  from emp";
        bl2 = TabCol.test(string, arrayList2, arrayList3).startsWith("select hiredate HIREDATE, job JOB, emp.job JOB_0 ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("*** TEST#2: *** ---> " + bl2);
        string = "select e.hiredate, e.*, dept.*  from emp e, dept";
        bl2 = TabCol.test(string, arrayList2, arrayList3).startsWith("select e.hiredate HIREDATE, e.JOB JOB, e.HIREDATE HIREDATE_0, dept.LOC LOC ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("*** TEST#3: aliasing duplicates *** ---> " + bl2);
        string = "select * from (select * from emp)";
        bl2 = TabCol.test(string, arrayList2, arrayList3).startsWith("select JOB JOB, HIREDATE HIREDATE ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("*** TEST#4: inline view *** ---> " + bl2);
        string = "select * from emp e, dept d where e.deptno = d.deptno";
        bl2 = TabCol.test(string, null, null).startsWith("select e.EMPNO EMPNO, e.ENAME ENAME, e.JOB JOB, e.MGR MGR, e.HIREDATE HIREDATE, e.SAL SAL, e.COMM COMM, e.DEPTNO DEPTNO, d.DEPTNO DEPTNO_0, d.DNAME DNAME, d.LOC LOC ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("*** TEST#5: aliasing duplicates; no excludes *** ---> " + bl2);
        string = "select t.table_name, t.num_rows, t.status,\n (select count(*) from sys.all_tab_columns c where t.table_name = c.table_name and t.owner = c.owner) columns \nfrom all_tables t,sys.all_objects ao\nwhere ao.owner = user and ao.owner = t.owner and ao.object_name = t.table_name";
        bl2 = TabCol.test(string, null, null).startsWith("select t.table_name TABLE_NAME, t.num_rows NUM_ROWS, t.status STATUS, (select count(*) from sys.all_tab_columns c where t.table_name = c.table_name and t.owner = c.owner) COLUMNS ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#6: subquery in the select clause ---> " + bl2);
        string = "select 1 a, 1.1 B, 1*1 c, count(*) c from dua";
        bl2 = TabCol.test(string, null, null).startsWith("select 1 A, 1.1 B, 1*1 C, count(*) C_0 from dua");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#7: short circuit ---> " + bl2);
        string = "select * from dual d where exists (select 1 from emp du where du.ename = d.dummy)";
        bl2 = TabCol.test(string, null, null).startsWith("select d.DUMMY DUMMY from dual d where exists");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#8: subquery ---> " + bl2);
        string = "select table_name, (select table_name from user_tables where rownum < 2), cluster_owner from user_tables";
        bl2 = TabCol.test(string, null, null).startsWith("select table_name TABLE_NAME, (select table_name from user_tables where rownum < 2) COL, cluster_owner CLUSTER_OWNER from");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#9: http://forums.oracle.com/forums/thread.jspa?threadID=837862 ---> " + bl2);
        string = "select rownum from Table(Integers) where rownum < 10;";
        bl2 = TabCol.test(string, null, null).startsWith("select rownum from");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#10: 7689463 ---> " + bl2);
        string = "select * from \"SCOTT\".\"student\";";
        bl2 = TabCol.test(string, null, null).startsWith("select \"Sage\" \"Sage\", \"Student_Name\" \"Student_Name\", \"Student_No\" \"Student_No\" ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#11: 7656516 ---> " + bl2);
        string = "select * from countries";
        bl2 = TabCol.test(string, host + ",hr,hr").startsWith("select COUNTRY_ID COUNTRY_ID, COUNTRY_NAME COUNTRY_NAME, REGION_ID REGION_ID ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#12: 7453434  ---> " + bl2);
        string = "SELECT last_name \"Employee\", CONNECT_BY_ROOT last_name \"Manager\", LEVEL-1 \"Pathlen\", SYS_CONNECT_BY_PATH(last_name, '/') \"Path\"  FROM employees \nWHERE LEVEL > 1 and department_id = 110    CONNECT BY PRIOR employee_id =\nmanager_id    ORDER BY \"Employee\", \"Manager\", \"Pathlen\", \"Path\"; ";
        bl2 = TabCol.test(string, host + ",hr,hr").startsWith("SELECT last_name \"Employee\", CONNECT_BY_ROOT last_name \"Manager\", LEVEL-1 \"Pathlen\", SYS_CONNECT_BY_PATH(last_name, '/') \"Path\" ");
        if (!bl2) {
            bl = bl2;
        }
        System.out.println("TEST#13: 7667785  ---> " + bl2);
        if (bl) {
            System.out.println("*** ALL TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> ");
        }
    }

    public TabCol(String string) {
        this.connName = string;
        if (string.startsWith("jdbc:oracle:thin:@")) {
            this.synonyms = SynonymsCache.fillIn(string);
        }
    }

    public static String test(String string, List<String> list, List<String> list2) throws Exception {
        return TabCol.test(string, list, list2, null);
    }

    private static String test(String string, List<String> list, List<String> list2, IResultSetTableModel iResultSetTableModel) throws Exception {
        TabCol tabCol = new TabCol(host + "," + user + "," + pwd);
        tabCol.resultSet = iResultSetTableModel;
        ArrayList<Column> arrayList = tabCol.fetchColumns(string);
        tabCol.colNamesToExclude = list2;
        tabCol.colTypesToExclude = list;
        return tabCol.disambiguate(arrayList);
    }

    private static String test(String string, String string2) throws Exception {
        TabCol tabCol = new TabCol(string2);
        ArrayList<Column> arrayList = tabCol.fetchColumns(string);
        return tabCol.disambiguate(arrayList);
    }

    private static List<LexerToken> lex(String string) {
        return LexerToken.parse((String)string);
    }

    private static ParseNode parse(List<LexerToken> list) {
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(list, matrix);
        return sqlEarley.forest(list, matrix);
    }

    public Map<ParseNode, String> tblNames(ParseNode parseNode, List<LexerToken> list) {
        TreeMap<ParseNode, String> treeMap = new TreeMap<ParseNode, String>();
        Iterator<ParseNode> iterator = TabCol.getTableNodes(parseNode).iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Object object;
            ParseNode parseNode2;
            ParseNode parseNode3 = parseNode2 = iterator.next();
            String string3 = parseNode3.content(list);
            Pair<ParseNode, ParseNode> pair = TabCol.findTableAlias(parseNode3);
            if (pair != null) {
                ParseNode parseNode4;
                string3 = ((ParseNode)pair.getSecond()).content(list);
                parseNode3 = (ParseNode)pair.getFirst();
                object = parseNode.descendant(parseNode3.from, parseNode3.to, scalar_subquery_expression);
                string2 = parseNode.descendant(parseNode3.from, parseNode3.to, query_table_expression);
                string = null;
                if (object == null && string2 != null) {
                    string = string2;
                } else if (object != null && string2 == null) {
                    string = object;
                } else if (object != null && string2 != null && object.from <= ((ParseNode)string2).from) {
                    string = string2;
                } else if (object != null && string2 != null && object.from >= ((ParseNode)string2).from) {
                    string = object;
                }
                if (string != null && (parseNode4 = parseNode.parent(((ParseNode)string).from, ((ParseNode)string).to)).contains(table_reference)) {
                    for (ParseNode parseNode5 : parseNode4.children()) {
                        if (!parseNode5.contains(identifier)) continue;
                        parseNode3 = parseNode5;
                    }
                }
            }
            if (this.synonyms != null) {
                object = null;
                string2 = string3;
                if (string2.indexOf(46) > 0) {
                    object = string2.substring(0, string2.indexOf(46));
                    string2 = string2.substring(string2.indexOf(46) + 1);
                }
                if ((string = this.synonyms.getTable((String)object, string2)) != null) {
                    string3 = string;
                }
            }
            treeMap.put(parseNode3, string3);
        }
        return treeMap;
    }

    private static List<ParseNode> getTableNodes(ParseNode parseNode) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(table_reference) && parseNode2.to - parseNode2.from < 5) {
                linkedList.add(parseNode2);
                continue;
            }
            if (parseNode2.contains(where_clause)) continue;
            linkedList.addAll(TabCol.getTableNodes(parseNode2));
        }
        return linkedList;
    }

    public static Map<String, ParseNode> getInlineViewNodes(ParseNode parseNode, List<LexerToken> list) {
        TreeMap<String, ParseNode> treeMap = new TreeMap<String, ParseNode>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(select_list) && (parseNode2.contains(query_table_expression) || parseNode2.contains(scalar_subquery_expression))) {
                for (ParseNode parseNode3 : parseNode2.children()) {
                    if (!parseNode3.contains(subquery)) continue;
                    String string = list.get((int)(parseNode2.from - 1)).content;
                    if ("as".equalsIgnoreCase(string)) {
                        treeMap.put(list.get((int)(parseNode2.from - 2)).content.toLowerCase(), parseNode3);
                        continue;
                    }
                    treeMap.put("inline subquery", parseNode3);
                }
                continue;
            }
            if (parseNode2.contains(where_clause) || parseNode2.contains(select_list)) continue;
            treeMap.putAll(TabCol.getInlineViewNodes(parseNode2, list));
        }
        return treeMap;
    }

    public ArrayList<Column> fetchColumns(String string) throws Exception {
        return this.fetchColumns(string, true);
    }

    public ArrayList<Column> fetchColumns(String string, boolean bl) throws Exception {
        Map<String, ParseNode> map;
        this._input = string;
        this._src = TabCol.lex(string);
        ParseNode parseNode = TabCol.parse(this._src);
        this._tables = this.tblNames(parseNode, this._src);
        ParseNode parseNode2 = TabCol.getSelectList(TabCol.getMainQueryBlock(parseNode));
        if (parseNode2 == null) {
            return null;
        }
        int n = this._src.get((int)parseNode2.from).begin;
        int n2 = this._src.get((int)(parseNode2.to - 1)).end;
        this._prefix = string.substring(0, n);
        this._suffix = string.substring(n2);
        ArrayList<Column> arrayList = TabCol.extractColumns(parseNode2, this._src, bl, this.excludeCondition());
        if ("*".equals(parseNode2.content(this._src)) && (map = TabCol.getInlineViewNodes(parseNode, this._src)).size() > 0) {
            ParseNode parseNode3 = map.get("inline subquery");
            if (parseNode3 == null) {
                parseNode3 = map.get(this._src.get((int)(parseNode2.to + 1)).content.toLowerCase());
            }
            ParseNode parseNode4 = TabCol.getSelectList(parseNode3);
            ArrayList<Column> arrayList2 = TabCol.extractColumns(parseNode4, this._src, false, this.excludeCondition());
            if ("*".equals(parseNode4.content(this._src))) {
                this.fetchDbCols();
                return arrayList;
            }
            this.dbColumns = new TreeSet<SuggestedItem>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Object object;
                Column column = arrayList2.get(i);
                String string2 = column.alias;
                if (string2 == null) {
                    object = column.colExpr;
                    if (object == null) {
                        throw new Exception("cExpr == null");
                    }
                    if (object.to - object.from == 3 || object.to - object.from == 1) {
                        string2 = this._src.get((int)(object.to - 1)).content;
                    } else {
                        throw new Exception("unexpected cExpr");
                    }
                }
                object = new SuggestedItem("COLUMN", null, string2, i);
                this.dbColumns.add((SuggestedItem)object);
            }
            this._tblAliases = new TreeMap<String, String>();
            this._tblAliases.put("anonymous!@#$^&*", "anonymous!@#$^&*");
            return arrayList;
        }
        this.fetchDbCols();
        return arrayList;
    }

    public static ArrayList<Column> extractColumns(ParseNode parseNode, List<LexerToken> list, boolean bl, boolean bl2) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        if (TabCol.starPosition(parseNode, list) > 0) {
            bl = false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ParseNode parseNode2 : TabCol.getColumnNodes(parseNode)) {
            String string;
            Set set = parseNode2.children();
            if (set.size() == 0) {
                string = list.get((int)parseNode2.from).content;
                arrayList.add(new Column(parseNode2, string));
                if (hashSet.contains(string)) {
                    bl = false;
                }
                hashSet.add(string);
                continue;
            }
            if (parseNode2.contains(expr)) {
                arrayList.add(new Column(parseNode2, null));
                bl = false;
                continue;
            }
            string = null;
            String string2 = null;
            int n = -1;
            for (ParseNode parseNode3 : set) {
                if (++n == 0) {
                    if (parseNode3.contains(expr)) {
                        string = parseNode3;
                    } else if (parseNode2.contains(select_term)) {
                        string = parseNode2;
                        bl = false;
                        break;
                    }
                }
                if (n != 1) continue;
                string2 = list.get((int)(parseNode3.to - 1)).content;
                break;
            }
            if (string2 == null || hashSet.contains(string2)) {
                bl = false;
            }
            arrayList.add(new Column((ParseNode)string, string2));
            hashSet.add(string2);
        }
        if (bl && bl2) {
            return null;
        }
        return arrayList;
    }

    private boolean excludeCondition() {
        return !(this.colNamesToExclude != null && this.colNamesToExclude.size() != 0 || this.colTypesToExclude != null && this.colTypesToExclude.size() != 0);
    }

    /*
     * WARNING - void declaration
     */
    private void fetchDbCols() throws SQLException, Exception, DBException, ClassNotFoundException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        for (LexerToken object2 : this._src) {
            if (".".equals(object2.content)) {
                bl2 = true;
                continue;
            }
            if (bl2 && "*".equals(object2.content)) {
                bl = true;
                continue;
            }
            bl2 = false;
        }
        this._tblAliases = new TreeMap<String, String>();
        for (ParseNode parseNode : this._tables.keySet()) {
            this._tblAliases.put(parseNode.content(this._src), this._tables.get(parseNode));
        }
        this.dbColumns = null;
        if (this._tables.size() == 1 && !bl && this.resultSet != null) {
            void var4_8;
            this.dbColumns = new TreeSet<SuggestedItem>();
            object = this.resultSet.getResultSetMetaData();
            boolean bl3 = false;
            while (var4_8 < this.resultSet.getColumnCount()) {
                String string = this.resultSet.getColumnName((int)var4_8);
                String string2 = null;
                for (int i = 1; i <= object.getColumnCount(); ++i) {
                    if (!string.equalsIgnoreCase(object.getColumnName(i))) continue;
                    string2 = object.getColumnTypeName(i);
                    break;
                }
                if (string2 != null) {
                    SuggestedItem suggestedItem = new SuggestedItem("COLUMN", null, string, (int)var4_8);
                    suggestedItem.columnType = string2;
                    this.dbColumns.add(suggestedItem);
                }
                ++var4_8;
            }
        } else {
            object = new InsightableOracleDatabase(this.connName, false);
            ((InsightableOracleDatabase)object).limit = 999;
            ((InsightableOracleDatabase)object).setTableAliases(this._tblAliases);
            for (String string : this._tblAliases.keySet()) {
                ((InsightableOracleDatabase)object).prepareColumns(this._tblAliases.get(string), null);
            }
            this.dbColumns = ((InsightableOracleDatabase)object).fetch();
            if (SuggestedItem.countOwners(this.dbColumns) > 1) {
                String string;
                TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
                string = ((InsightableOracleDatabase)object).getConnection().getMetaData().getUserName().toUpperCase();
                for (SuggestedItem suggestedItem : this.dbColumns) {
                    if (!string.equals(suggestedItem.getOwner())) continue;
                    treeSet.add(suggestedItem);
                }
                this.dbColumns = treeSet;
            }
        }
    }

    public int tableCount() {
        return this._tables.size();
    }

    public String disambiguate(ArrayList<Column> arrayList, String[] stringArray) throws Exception {
        if (arrayList == null) {
            return this._input;
        }
        return this._prefix + this.expandColumns(arrayList, stringArray, ", ", false) + this._suffix;
    }

    /*
     * WARNING - void declaration
     */
    public String expandColumns(ArrayList<Column> arrayList, String[] stringArray, String string, boolean bl) throws Exception {
        Object object4;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Column object32 : arrayList) {
            String string2;
            boolean stringBuffer = TabCol.starPosition(object32.colExpr, this._src) > 0;
            Object object2 = "";
            String string3 = "";
            for (ParseNode parseNode : object32.colExpr.children()) {
                if (parseNode.contains(dot)) {
                    void var10_13;
                    object2 = var10_13;
                    break;
                }
                String column = this._src.get((int)parseNode.from).content.toUpperCase() + ".";
            }
            if (!((String)object2).startsWith("\"")) {
                object2 = ((String)object2).toUpperCase();
            }
            if (object32.colExpr.to - object32.colExpr.from > 3 || object32.colExpr.to - object32.colExpr.from == 3 && !this._src.get((int)(object32.colExpr.from + 1)).content.equals(".")) {
                arrayList2.add(new Column(object32.colExpr, object32.alias == null ? "col" : object32.alias));
                continue;
            }
            if (stringBuffer) {
                for (ParseNode parseNode : this._tables.keySet()) {
                    object4 = parseNode.content(this._src);
                    if (!((String)object4).startsWith("\"")) {
                        object4 = ((String)object4).toUpperCase();
                    }
                    if (((String)object2).length() > 0 && !((String)object2).equals((String)object4 + ".")) continue;
                    for (SuggestedItem suggestedItem : this.dbColumns) {
                        Object object3;
                        string2 = suggestedItem.getName();
                        int n = string2.indexOf(46);
                        if (n > 0 && ((String)(object3 = string2.substring(0, n))).startsWith("\"") && !((String)object3).endsWith("\"")) {
                            n = -1;
                        }
                        if (n >= 0 && !string2.startsWith((String)object4 + ".") && !string2.toUpperCase().startsWith((String)object4 + ".") || this.isExcluded(suggestedItem) || arrayList2.contains(object3 = new Column(null, string2))) continue;
                        arrayList2.add(object3);
                    }
                }
                continue;
            }
            if (object32.colExpr == null) continue;
            boolean string6 = true;
            for (Object object4 : this.dbColumns) {
                Object object5 = object32.colExpr.content(this._src);
                int n = ((String)object5).indexOf(46);
                if (n > 0 && (string2 = ((String)object5).substring(0, n)).startsWith("\"") && !string2.endsWith("\"")) {
                    n = -1;
                }
                if (n >= 0) {
                    object5 = ((String)object5).substring(n + 1);
                }
                if (((String)object5).charAt(0) == '\"') {
                    object5 = DBUtil.addDoubleQuote((String)((String)object5).substring(1, ((String)object5).length() - 1));
                }
                if ((((String)object5).charAt(0) == '\"' || !((SuggestedItem)object4).getName().endsWith(((String)object5).toUpperCase()) || !this.isExcluded((SuggestedItem)object4)) && (((String)object5).charAt(0) != '\"' || !((SuggestedItem)object4).getName().endsWith((String)object5) || !this.isExcluded((SuggestedItem)object4))) continue;
                string6 = false;
                break;
            }
            if (!string6) continue;
            arrayList2.add(new Column(object32.colExpr, object32.alias));
        }
        int n = 0;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string4 : stringArray) {
            object4 = stringBuffer.length() == 0 ? "" : ", ";
            stringBuffer.append((String)object4 + string4 + " \"" + string4 + "\"");
        }
        for (Column column : arrayList2) {
            void var12_34;
            void var12_32;
            String string5;
            String string6;
            int n2;
            String string7 = stringBuffer.length() == 0 ? "" : string;
            String string8 = "";
            object4 = column.alias;
            if (column.colExpr == null) {
                String string9 = object4;
            } else {
                n2 = this._src.get((int)column.colExpr.from).begin;
                int n3 = this._src.get((int)(column.colExpr.to - 1)).end;
                String string10 = this._input.substring(n2, n3);
            }
            if (object4 == null) {
                object4 = this._src.get((int)(column.colExpr.to - 1)).content;
            }
            if (((String)object4).startsWith("'")) {
                object4 = "col";
            }
            if ('0' <= ((String)object4).charAt(0) && ((String)object4).charAt(0) < '9') {
                object4 = "\"" + (String)object4 + "\"";
            }
            if ((n2 = ((String)object4).indexOf(46)) > 0 && (string6 = ((String)object4).substring(0, n2)).startsWith("\"") && !string6.endsWith("\"")) {
                n2 = -1;
            }
            if (n2 >= 0) {
                object4 = ((String)object4).substring(n2 + 1);
            }
            if ((n2 = ((String)object4).indexOf(46)) > 0 && (string5 = ((String)object4).substring(0, n2)).startsWith("\"") && !string5.endsWith("\"")) {
                n2 = -1;
            }
            if (n2 >= 0) {
                object4 = ((String)object4).substring(n2 + 1);
            }
            if (!((String)object4).startsWith("\"")) {
                object4 = ((String)object4).toUpperCase();
            }
            for (String string2 : treeSet) {
                if (!string2.equals(object4)) continue;
                object4 = (String)object4 + "_" + n++;
                break;
            }
            treeSet.add(object4);
            if (TabCol.isKeyword((String)object4)) {
                object4 = "\"" + (String)object4 + "\"";
            }
            if (TabCol.isKeyword((String)var12_32)) {
                String string11 = "\"" + (String)var12_32 + "\"";
            }
            if (bl) {
                object4 = "";
            }
            stringBuffer.append(string7 + (String)var12_34 + " " + (String)object4);
        }
        this._noCols = stringBuffer.toString().equals("");
        return stringBuffer.toString();
    }

    public String disambiguate(ArrayList<Column> arrayList) throws Exception {
        return this.disambiguate(arrayList, new String[0]);
    }

    private static boolean isKeyword(String string) {
        int n;
        if (indAll == null) {
            for (n = 0; n < SqlKeywords.KW_words.length; ++n) {
                if ("all".equalsIgnoreCase(SqlKeywords.KW_words[n])) {
                    indAll = n;
                    continue;
                }
                if (!"whenever".equalsIgnoreCase(SqlKeywords.KW_words[n])) continue;
                indWhenever = n;
            }
        }
        for (n = indAll.intValue(); n <= indWhenever; ++n) {
            if (!SqlKeywords.KW_words[n].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(SuggestedItem suggestedItem) {
        if (this.colNamesToExclude != null) {
            for (String string : this.colNamesToExclude) {
                if (!string.equals(suggestedItem.getName()) && !suggestedItem.getName().endsWith("." + string)) continue;
                this.excludedColumns = true;
                return true;
            }
        }
        if (this.colTypesToExclude != null) {
            for (String string : this.colTypesToExclude) {
                if (!string.equalsIgnoreCase(suggestedItem.columnType)) continue;
                this.excludedColumns = true;
                return true;
            }
        }
        return false;
    }

    private static Pair<ParseNode, ParseNode> findTableAlias(ParseNode parseNode) {
        if (!parseNode.contains(table_reference)) {
            return null;
        }
        Pair pair = null;
        if (parseNode.children().size() == 0 || parseNode.children().size() == 3) {
            pair = new Pair((Object)parseNode, (Object)parseNode);
        } else if (parseNode.children().size() == 2) {
            ParseNode parseNode2 = null;
            ParseNode parseNode3 = null;
            for (ParseNode parseNode4 : parseNode.children()) {
                if (parseNode4.contains(query_table_expression)) {
                    parseNode3 = parseNode4;
                    continue;
                }
                if (!parseNode4.contains(identifier)) continue;
                parseNode2 = parseNode4;
            }
            if (parseNode2 != null && parseNode3 != null) {
                pair = new Pair(parseNode2, parseNode3);
            }
        }
        return pair;
    }

    public static ParseNode getMainQueryBlock(ParseNode parseNode) {
        if (parseNode == null) {
            return null;
        }
        if (parseNode.contains(query_block)) {
            return parseNode;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(subquery) && !parseNode2.contains(query_block)) continue;
            return TabCol.getMainQueryBlock(parseNode2);
        }
        return null;
    }

    public static ParseNode getSelectList(ParseNode parseNode) {
        if (parseNode == null) {
            return null;
        }
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (!parseNode2.contains(select_list)) continue;
            return parseNode2;
        }
        return null;
    }

    public static List<ParseNode> getColumnNodes(ParseNode parseNode) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        if (parseNode.contains(select_term) || parseNode.contains(select_list) && parseNode.contains(star)) {
            linkedList.add(parseNode);
            return linkedList;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            linkedList.addAll(TabCol.getColumnNodes(parseNode2));
        }
        return linkedList;
    }

    public boolean isEmptySelect() {
        return this._noCols;
    }

    public boolean excludedColumns() {
        return this.excludedColumns;
    }

    public static int starPosition(ParseNode parseNode, List<LexerToken> list) {
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (parseNode2.from + 1 != parseNode2.to || !"*".equals(list.get((int)parseNode2.from).content) || parseNode2.contains(mult_op)) continue;
            return parseNode2.from;
        }
        return -1;
    }

    static {
        SqlEarley sqlEarley = SqlEarley.getInstance();
        where_clause = sqlEarley.getSymbol("where_clause");
        subquery = sqlEarley.getSymbol("subquery");
        scalar_subquery_expression = sqlEarley.getSymbol("scalar_subquery_expression");
        query_table_expression = sqlEarley.getSymbol("query_table_expression");
        table_reference = sqlEarley.getSymbol("table_reference");
        as = sqlEarley.getSymbol("'AS'");
        select_term = sqlEarley.getSymbol("select_term");
        expr = sqlEarley.getSymbol("expr");
        identifier = sqlEarley.getSymbol("identifier");
        dot = sqlEarley.getSymbol("'.'");
        star = sqlEarley.getSymbol("'*'");
        mult_op = sqlEarley.getSymbol("mult_op");
        select = sqlEarley.getSymbol("select");
        select_list = sqlEarley.getSymbol("select_list");
        query_block = sqlEarley.getSymbol("query_block");
        subquery_factoring_clause = sqlEarley.getSymbol("subquery_factoring_clause");
        indAll = null;
        indWhenever = null;
    }

    public static class Column
    implements Comparable {
        public ParseNode colExpr;
        public String alias;

        public Column(ParseNode parseNode, String string) {
            this.colExpr = parseNode;
            this.alias = string;
        }

        public int compareTo(Object object) {
            Column column = (Column)object;
            if (this.colExpr == null && column.colExpr != null) {
                return 1;
            }
            if (this.colExpr != null && column.colExpr == null) {
                return -1;
            }
            if (this.colExpr == null && column.colExpr == null) {
                return this.alias.compareTo(column.alias);
            }
            int n = this.colExpr.compareTo((Object)column.colExpr);
            if (n != 0) {
                return n;
            }
            return this.alias.compareTo(column.alias);
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public String toString() {
            return this.colExpr.toString() + " As " + this.alias;
        }
    }
}

