/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.proformatter.FormatterMenu;
import oracle.dbtools.proformatter.Messages;
import oracle.dbtools.proformatter.SQLFormatCommand;
import oracle.dbtools.proformatter.SQLFormatToPropertiesCommand;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.HelpSystem;

class FormatterController
implements Controller {
    FormatterController() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        WaitCursor waitCursor = Ide.getWaitCursor();
        int n = ideAction.getCommandId();
        if (FormatterMenu.FORMAT_ID == n) {
            waitCursor.show();
            this.executeCommand(context);
            waitCursor.hide();
            return true;
        }
        if (FormatterMenu.FORMAT_POPUP_ID == n) {
            waitCursor.show();
            this.executeCommandPopup(context);
            waitCursor.hide();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private boolean executeCommand(Context context) {
        SQLFormatCommand sQLFormatCommand = new SQLFormatCommand(context);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            if (commandProcessor.invoke((Command)sQLFormatCommand) == 1) {
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return true;
    }

    private boolean executeCommandPopup(Context context) {
        final Context context2 = context;
        final Boolean[] booleanArray = new Boolean[]{new Boolean(false)};
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{Messages.getString("EDITOR"), Messages.getString("CLIPBOARD")});
        final JComboBox<String> jComboBox2 = new JComboBox<String>(new String[]{Messages.getString("ConfigPanelData.3"), Messages.getString("ConfigPanelData.4"), Messages.getString("ConfigPanelData.5"), Messages.getString("ConfigPanelData.6"), Messages.getString("ConfigPanelData.7"), Messages.getString("ConfigPanelData.8"), Messages.getString("ConfigPanelData.9"), Messages.getString("ConfigPanelData.10"), Messages.getString("ConfigPanelData.11"), Messages.getString("ConfigPanelData.12"), Messages.getString("ConfigPanelData.13"), Messages.getString("ConfigPanelData.14"), Messages.getString("ConfigPanelData.15"), Messages.getString("ConfigPanelData.16"), Messages.getString("ConfigPanelData.17")});
        final JComboBox<String> jComboBox3 = new JComboBox<String>(new String[]{Messages.getString("NOT_ENCLOSED"), "\"", "'"});
        final JComboBox<String> jComboBox4 = new JComboBox<String>(new String[]{"\\", "\"", "'"});
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("OUTPUT_DESTINATION")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("OUTPUT_DESTINATION")));
        jLabel.setLabelFor(jComboBox);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("OUTPUT_TYPE")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("OUTPUT_TYPE")));
        jLabel2.setLabelFor(jComboBox2);
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("ENCLOSED_IN")));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("ENCLOSED_IN")));
        jLabel3.setLabelFor(jComboBox3);
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox3, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        JLabel jLabel4 = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("ESCAPED_BY")));
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("ESCAPED_BY")));
        jLabel4.setLabelFor(jComboBox4);
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox4, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        jPanel.setMinimumSize(new Dimension(400, 800));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_popupformatdialog_html");
        UIUtils.showPanelAsDialog((JPanel)jPanel, (String)Messages.getString("FORMAT_PROPERTIES"), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                SQLFormatToPropertiesCommand sQLFormatToPropertiesCommand = new SQLFormatToPropertiesCommand(context2, jComboBox.getSelectedIndex() == 0, jComboBox2.getSelectedIndex(), jComboBox3.getSelectedIndex(), jComboBox4.getSelectedIndex());
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                try {
                    if (commandProcessor.invoke((Command)sQLFormatToPropertiesCommand) == 1) {
                        booleanArray[0] = new Boolean(true);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
        return booleanArray[0];
    }
}

