/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences;

import SQLinForm_200.SQLForm;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.proformatter.treePreferences.SQLPreferences;
import oracle.dbtools.proformatter.treePreferences.SQLSourcePreferences;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptionsListener;
import oracle.dbtools.proformatter.treePreferences.style.preferences.CodingStylePreferencesPanel;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public class CodingStyleSQLProfile
extends HashStructureAdapter
implements CodingStyleSQLOptions,
Copyable,
SQLPreferences {
    public static final String DATA_KEY = "ProProfile";
    private static final String NAME = "profile.name";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"coding-style-SQL-profile");
    private static final String ROOT_TAG = "profile";
    private SQLSourcePreferences preferences;
    private boolean modified;
    private boolean disableEvents;
    private final CopyOnWriteArrayList<CodingStyleSQLOptionsListener> listeners = new CopyOnWriteArrayList();
    public static final String USE_TAB = "useTab";
    public static final String UPPERCASE = "uppercase";
    public static final String TARGET_SQL = "targetSql";
    public static final String FORCE_DIFFERENCE = "forceDifference";
    public static final String SUPPRESS_COMMENT = "suppressComment";
    public static final String SQL_SOURCE_ENCLOSED = "sqlSourceEnclosed";
    public static final String SQL_SOURCE_ESCAPE = "sqlSourceEscape";
    public static final String SOURCE_SQL = "sourceSql";
    public static final String SMALL_SQL = "smallSql";
    public static final String REPLACE_COMMENT = "replaceComment";
    public static final String QUOTE_CHAR = "quoteChar";
    public static final String NUM_SPACES = "numSpaces";
    public static final String NUM_COMMAS = "numCommas";
    public static final String BRACKET_SPACING = "bracketSpacing";
    public static final String BRACKET_SPACING_AND_OR_WHEN = "bracketSpacingAndOrWhen";
    public static final String COMMA_SPACING = "commaSpacing";
    public static final String OPERATOR_SPACING = "operatorSpacing";
    public static final String LINE_WIDTH = "lineWidth";
    public static final String LINE_NUM = "lineNum";
    public static final String BREAK_SELECT_BRACKET = "breakSelectBracket";
    public static final String BREAK_SCHEMA = "breakSchema";
    public static final String BREAK_KEYWORD = "breakKeyword";
    public static final String BREAK_JOIN = "breakJoin";
    public static final String BREAK_CASE_WHEN = "breakCaseWhen";
    public static final String BREAK_CASE_THEN = "breakCaseThen";
    public static final String BREAK_CASE_ELSE = "breakCaseElse";
    public static final String BREAK_CASE = "breakCase";
    public static final String BREAK_CASE_AND_OR = "breakCaseAndOr";
    public static final String BREAK_BEFORE_COMMENT = "breakBeforeComment";
    public static final String BREAK_BEFORE_CONCAT = "breakBeforeConcat";
    public static final String BREAK_BEFORE_COMMA = "breakBeforeComma";
    public static final String BREAK_BEFORE_AND = "breakBeforeAnd";
    public static final String BREAK_AFTER_CONCAT = "breakAfterConcat";
    public static final String BREAK_AFTER_COMMA = "breakAfterComma";
    public static final String BREAK_AFTER_AND = "breakAfterAnd";
    public static final String DBL_INDENT = "dblIndent";
    public static final String COLORED = "colored";
    public static final String INDENT_AND = "indentAnd";
    public static final String ALIGN_OPERATOR = "alignOperator";
    public static final String ALIGN_KEYWORD = "alignKeyword";
    public static final String ALIGN_EQUAL = "alignEqual";
    public static final String ALIGN_DECL = "alignDecl";
    public static final String ALIGN_CONCAT = "alignConcat";
    public static final String ALIGN_COMMENT = "alignComment";
    public static final String ALIGN_COMMA = "alignComma";
    public static final String ALIGN_AS = "alignAs";
    public static final String SQLSOURCE_COPIED = "sqlsourceCopied";
    public static final String MORE_NEWLINES = "moreNewlines";
    public static final String PRESERVE_NEWLINES = "preserveNewlines";
    public static final String KEY = "oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile";

    public CodingStyleSQLProfile() {
        this(HashStructure.newInstance());
    }

    public CodingStyleSQLProfile(HashStructure hashStructure) {
        super(hashStructure);
        this.preferences = new SQLSourcePreferences(hashStructure);
        hashStructure.addStructureChangeListener((StructureChangeListener)new ChangeListener());
    }

    @Override
    public void addCodingStyleOptionsListener(CodingStyleSQLOptionsListener codingStyleSQLOptionsListener) {
        if (codingStyleSQLOptionsListener != null) {
            this.listeners.addIfAbsent(codingStyleSQLOptionsListener);
        }
    }

    @Override
    public void removeCodingStyleOptionsListener(CodingStyleSQLOptionsListener codingStyleSQLOptionsListener) {
        if (codingStyleSQLOptionsListener != null) {
            this.listeners.remove(codingStyleSQLOptionsListener);
        }
    }

    public void exportTo(URL uRL) throws IOException {
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        hashStructureIO.save(uRL, (Object)this._hash);
    }

    public static CodingStyleSQLProfile importFrom(URL uRL) throws IOException {
        HashStructureIO hashStructureIO = new HashStructureIO(NAMESPACE_URI, ROOT_TAG);
        return new CodingStyleSQLProfile((HashStructure)hashStructureIO.load(uRL));
    }

    public boolean isModified() throws TransientMarker {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isDirty() throws TransientMarker {
        return this._hash.isDirty();
    }

    public void setDirty(boolean bl) {
        this._hash.markDirty(bl);
    }

    @Override
    public SQLSourcePreferences getSourcePreferences() {
        return this.preferences;
    }

    @Override
    public String getName() {
        return this._hash.getString(NAME);
    }

    @Override
    public void setName(String string) {
        this._hash.putString(NAME, string, true);
    }

    @Override
    public boolean getUseTab() {
        return this.preferences.getBoolean(0);
    }

    @Override
    public void setUseTab(boolean bl) {
        this.preferences.setBoolean(0, bl);
    }

    @Override
    public int getUppercase() {
        return this.preferences.getInt(1);
    }

    @Override
    public void setUppercase(int n) {
        this.preferences.setInt(1, n);
    }

    @Override
    public int getTargetSql() {
        return this.preferences.getInt(2);
    }

    @Override
    public void setTargetSql(int n) {
        this.preferences.setInt(2, n);
    }

    @Override
    public boolean getForceDifference() {
        return this.preferences.getBoolean(3);
    }

    @Override
    public void setForceDifference(boolean bl) {
        this.preferences.setBoolean(3, bl);
    }

    @Override
    public boolean getSuppressComment() {
        return this.preferences.getBoolean(4);
    }

    @Override
    public void setSuppressComment(boolean bl) {
        this.preferences.setBoolean(4, bl);
    }

    @Override
    public int getSqlSourceEnclosed() {
        return this.preferences.getInt(5);
    }

    @Override
    public void setSqlSourceEnclosed(int n) {
        this.preferences.setInt(5, n);
    }

    @Override
    public int getSqlSourceEscape() {
        return this.preferences.getInt(49);
    }

    @Override
    public void setSqlSourceEscape(int n) {
        this.preferences.setInt(49, n);
    }

    @Override
    public int getSourceSql() {
        return this.preferences.getInt(6);
    }

    @Override
    public void setSourceSql(int n) {
        this.preferences.setInt(6, n);
    }

    @Override
    public int getSmallSql() {
        return this.preferences.getInt(7);
    }

    @Override
    public void setSmallSql(int n) {
        this.preferences.setInt(7, n);
    }

    @Override
    public boolean getReplaceComment() {
        return this.preferences.getBoolean(45);
    }

    @Override
    public void setReplaceComment(boolean bl) {
        this.preferences.setBoolean(45, bl);
    }

    @Override
    public int getQuoteChar() {
        return this.preferences.getInt(8);
    }

    @Override
    public void setQuoteChar(int n) {
        this.preferences.setInt(8, n);
    }

    @Override
    public int getNumSpaces() {
        return this.preferences.getInt(9);
    }

    @Override
    public void setNumSpaces(int n) {
        this.preferences.setInt(9, n);
    }

    @Override
    public int getNumCommas() {
        return this.preferences.getInt(10);
    }

    @Override
    public void setNumCommas(int n) {
        this.preferences.setInt(10, n);
    }

    @Override
    public int getBracketSpacing() {
        return this.preferences.getInt(11);
    }

    @Override
    public void setBracketSpacing(int n) {
        this.preferences.setInt(11, n);
    }

    @Override
    public boolean getBracketSpacingAndOrWhen() {
        return this.preferences.getBoolean(46);
    }

    @Override
    public void setBracketSpacingAndOrWhen(boolean bl) {
        this.preferences.setBoolean(46, bl);
    }

    @Override
    public int getCommaSpacing() {
        return this.preferences.getInt(12);
    }

    @Override
    public void setCommaSpacing(int n) {
        this.preferences.setInt(12, n);
    }

    @Override
    public int getOperatorSpacing() {
        return this.preferences.getInt(13);
    }

    @Override
    public void setOperatorSpacing(int n) {
        this.preferences.setInt(13, n);
    }

    @Override
    public int getLineWidth() {
        return this.preferences.getInt(14);
    }

    @Override
    public void setLineWidth(int n) {
        this.preferences.setInt(14, n);
    }

    @Override
    public int getLineNum() {
        return this.preferences.getInt(15);
    }

    @Override
    public void setLineNum(int n) {
        this.preferences.setInt(15, n);
    }

    @Override
    public boolean getBreakSelectBracket() {
        return this.preferences.getBoolean(16);
    }

    @Override
    public void setBreakSelectBracket(boolean bl) {
        this.preferences.setBoolean(16, bl);
    }

    @Override
    public int getBreakSchema() {
        return this.preferences.getInt(17);
    }

    @Override
    public void setBreakSchema(int n) {
        this.preferences.setInt(17, n);
    }

    @Override
    public boolean getBreakKeyword() {
        return this.preferences.getBoolean(18);
    }

    @Override
    public void setBreakKeyword(boolean bl) {
        this.preferences.setBoolean(18, bl);
    }

    @Override
    public boolean getBreakJoin() {
        return this.preferences.getBoolean(19);
    }

    @Override
    public void setBreakJoin(boolean bl) {
        this.preferences.setBoolean(19, bl);
    }

    @Override
    public boolean getBreakCaseWhen() {
        return this.preferences.getBoolean(20);
    }

    @Override
    public void setBreakCaseWhen(boolean bl) {
        this.preferences.setBoolean(20, bl);
    }

    @Override
    public boolean getBreakCaseThen() {
        return this.preferences.getBoolean(21);
    }

    @Override
    public void setBreakCaseThen(boolean bl) {
        this.preferences.setBoolean(21, bl);
    }

    @Override
    public boolean getBreakCaseElse() {
        return this.preferences.getBoolean(22);
    }

    @Override
    public void setBreakCaseElse(boolean bl) {
        this.preferences.setBoolean(22, bl);
    }

    @Override
    public boolean getBreakCase() {
        return this.preferences.getBoolean(23);
    }

    @Override
    public void setBreakCase(boolean bl) {
        this.preferences.setBoolean(23, bl);
    }

    @Override
    public boolean getBreakCaseAndOr() {
        return this.preferences.getBoolean(24);
    }

    @Override
    public void setBreakCaseAndOr(boolean bl) {
        this.preferences.setBoolean(24, bl);
    }

    @Override
    public boolean getBreakBeforeComment() {
        return this.preferences.getBoolean(25);
    }

    @Override
    public void setBreakBeforeComment(boolean bl) {
        this.preferences.setBoolean(25, bl);
    }

    @Override
    public boolean getBreakBeforeConcat() {
        return this.preferences.getBoolean(26);
    }

    @Override
    public void setBreakBeforeConcat(boolean bl) {
        this.preferences.setBoolean(26, bl);
    }

    @Override
    public boolean getBreakBeforeComma() {
        return this.preferences.getBoolean(27);
    }

    @Override
    public void setBreakBeforeComma(boolean bl) {
        this.preferences.setBoolean(27, bl);
    }

    @Override
    public boolean getBreakBeforeAnd() {
        return this.preferences.getBoolean(28);
    }

    @Override
    public void setBreakBeforeAnd(boolean bl) {
        this.preferences.setBoolean(28, bl);
    }

    @Override
    public boolean getBreakAfterConcat() {
        return this.preferences.getBoolean(29);
    }

    @Override
    public void setBreakAfterConcat(boolean bl) {
        this.preferences.setBoolean(29, bl);
    }

    @Override
    public boolean getBreakAfterComma() {
        return this.preferences.getBoolean(30);
    }

    @Override
    public void setBreakAfterComma(boolean bl) {
        this.preferences.setBoolean(30, bl);
    }

    @Override
    public boolean getBreakAfterAnd() {
        return this.preferences.getBoolean(31);
    }

    @Override
    public void setBreakAfterAnd(boolean bl) {
        this.preferences.setBoolean(31, bl);
    }

    @Override
    public boolean getDblIndent() {
        return this.preferences.getBoolean(32);
    }

    @Override
    public void setDblIndent(boolean bl) {
        this.preferences.setBoolean(32, bl);
    }

    @Override
    public boolean getColored() {
        return this.preferences.getBoolean(33);
    }

    @Override
    public void setColored(boolean bl) {
        this.preferences.setBoolean(33, bl);
    }

    @Override
    public boolean getIndentAnd() {
        return this.preferences.getBoolean(34);
    }

    @Override
    public void setIndentAnd(boolean bl) {
        this.preferences.setBoolean(34, bl);
    }

    @Override
    public boolean getAlignOperator() {
        return this.preferences.getBoolean(35);
    }

    @Override
    public void setAlignOperator(boolean bl) {
        this.preferences.setBoolean(35, bl);
    }

    @Override
    public boolean getAlignKeyword() {
        return this.preferences.getBoolean(36);
    }

    @Override
    public void setAlignKeyword(boolean bl) {
        this.preferences.setBoolean(36, bl);
    }

    @Override
    public boolean getAlignEqual() {
        return this.preferences.getBoolean(37);
    }

    @Override
    public void setAlignEqual(boolean bl) {
        this.preferences.setBoolean(37, bl);
    }

    @Override
    public boolean getAlignDecl() {
        return this.preferences.getBoolean(38);
    }

    @Override
    public void setAlignDecl(boolean bl) {
        this.preferences.setBoolean(38, bl);
    }

    @Override
    public boolean getAlignConcat() {
        return this.preferences.getBoolean(39);
    }

    @Override
    public void setAlignConcat(boolean bl) {
        this.preferences.setBoolean(39, bl);
    }

    @Override
    public boolean getAlignComment() {
        return this.preferences.getBoolean(40);
    }

    @Override
    public void setAlignComment(boolean bl) {
        this.preferences.setBoolean(40, bl);
    }

    @Override
    public boolean getAlignComma() {
        return this.preferences.getBoolean(41);
    }

    @Override
    public void setAlignComma(boolean bl) {
        this.preferences.setBoolean(41, bl);
    }

    @Override
    public boolean getAlignAs() {
        return this.preferences.getBoolean(42);
    }

    @Override
    public void setAlignAs(boolean bl) {
        this.preferences.setBoolean(42, bl);
    }

    @Override
    public boolean getSqlsourceCopied() {
        return this.preferences.getBoolean(43);
    }

    @Override
    public void setSqlsourceCopied(boolean bl) {
        this.preferences.setBoolean(43, bl);
    }

    @Override
    public boolean getMoreNewlines() {
        return this.preferences.getBoolean(48);
    }

    @Override
    public void setMoreNewlines(boolean bl) {
        this.preferences.setBoolean(48, bl);
    }

    @Override
    public int getPreserveNewlines() {
        return this.preferences.getInt(50);
    }

    @Override
    public void setPreserveNewlines(int n) {
        this.preferences.setInt(50, n);
    }

    @Override
    public byte getMemberOrder(int n) {
        return this.preferences.getMemberOrder(n);
    }

    @Override
    public void setMemberOrder(int n, byte by) {
        this.preferences.setMemberOrder(n, by);
    }

    public HashStructure getMemberOrderHashStructure() {
        return this.preferences.getMemberOrderHashStructure();
    }

    public void setMemberOrderHashStructure(HashStructure hashStructure) {
        String string = PREFERENCES_keys[47];
        if (hashStructure != null) {
            hashStructure.copyTo(this._hash.getOrCreateHashStructure(string));
        } else {
            this._hash.remove(string);
        }
    }

    @Override
    public String format(String string) {
        int n;
        int n2;
        SQLForm sQLForm = new SQLForm();
        sQLForm.setCase(this.getUppercase() == 0, this.getUppercase() == 2);
        sQLForm.setLowerCase(this.getUppercase() == 3);
        sQLForm.setGraphLevel(false);
        sQLForm.setSuppressSpace(true);
        String string2 = "'";
        if (this.getQuoteChar() == 1) {
            string2 = "\"";
        }
        sQLForm.setQuoteCharacter(string2);
        sQLForm.setdoubleIndentionMasterKeyword(this.getDblIndent());
        sQLForm.setAndOrIndention(this.getIndentAnd());
        int n3 = this.getNumSpaces();
        int n4 = this.getNumCommas();
        sQLForm.setIndention(n3, this.getUseTab());
        sQLForm.setNumCommas(n4);
        sQLForm.setLinebreakBeforeLineComment(this.getBreakBeforeComment());
        sQLForm.setLinebreakBeforeConcat(this.getBreakBeforeConcat());
        sQLForm.setLinebreakAfterConcat(this.getBreakAfterConcat());
        sQLForm.setLineBreak(this.getBreakBeforeComma(), this.getBreakAfterComma(), this.getBreakBeforeAnd(), this.getBreakAfterAnd(), this.getBreakSelectBracket(), this.getBracketSpacingAndOrWhen());
        sQLForm.setVariableName(SQLFormatterArb.getString("CodingStyleSQLProfile_SQL"));
        String string3 = "SQL";
        if (this.getTargetSql() == 0) {
            string3 = "SQL";
        }
        if (this.getTargetSql() == 1) {
            string3 = "ASP StringBuilder";
        }
        if (this.getTargetSql() == 2) {
            string3 = "C# StringBuilder";
        }
        if (this.getTargetSql() == 3) {
            string3 = "Concatenated SQL";
        }
        if (this.getTargetSql() == 4) {
            string3 = "Java StringBuffer";
        }
        if (this.getTargetSql() == 5) {
            string3 = "Java String";
        }
        if (this.getTargetSql() == 6) {
            string3 = "Java String 2";
        }
        if (this.getTargetSql() == 7) {
            string3 = "MSSQL String";
        }
        if (this.getTargetSql() == 8) {
            string3 = "Pascal String";
        }
        if (this.getTargetSql() == 9) {
            string3 = "PHP String";
        }
        if (this.getTargetSql() == 10) {
            string3 = "VB String (1)";
        }
        if (this.getTargetSql() == 11) {
            string3 = "VB String (2)";
        }
        if (this.getTargetSql() == 12) {
            string3 = "VB String (3)";
        }
        if (this.getTargetSql() == 13) {
            string3 = "VB String (4)";
        }
        if (this.getTargetSql() == 14) {
            string3 = "VB StringBuilder";
        }
        if (this.getTargetSql() == 15) {
            string3 = "HTML code";
        }
        sQLForm.setVariableName("SQL");
        sQLForm.setFormatLanguage(string3);
        sQLForm.setOneLineSQL(this.getBreakSchema() == 3);
        String string4 = "'";
        if (this.getSqlSourceEnclosed() == 0) {
            string4 = "\"";
        }
        String string5 = "\\";
        if (this.getSqlSourceEscape() == 1) {
            string5 = "\"";
        }
        if (this.getSqlSourceEscape() == 2) {
            string5 = "'";
        }
        sQLForm.setSourceSQL(this.getSqlsourceCopied(), string4, string5);
        sQLForm.setti("Only for Administrator");
        sQLForm.setSourceSQLLanguage(CodingStylePreferencesPanel.dbToFormatter(this.getSourceSql()));
        int n5 = this.getLineWidth();
        if (n5 < 30) {
            n5 = 30;
        }
        sQLForm.setPageWidth(n5);
        sQLForm.setColor(false);
        sQLForm.setLineNumber(false);
        sQLForm.setLinebreakKeyword(this.getBreakKeyword());
        sQLForm.setLinebreakCase(this.getBreakCase());
        sQLForm.setLinebreakCaseThen(this.getBreakCaseThen());
        sQLForm.setLinebreakCaseWhen(this.getBreakCaseWhen());
        sQLForm.setLinebreakCaseAndOr(this.getBreakCaseAndOr());
        sQLForm.setLinebreakCaseElse(this.getBreakCaseElse());
        sQLForm.setLinebreakJoin(this.getBreakJoin());
        sQLForm.setLinebreakJoinJoin(false);
        sQLForm.setLinebreakJoinOn(false);
        sQLForm.setAlignmentEqual(this.getAlignEqual());
        sQLForm.setAlignmentOperator(this.getAlignOperator());
        sQLForm.setAlignmentAs(this.getAlignAs());
        sQLForm.setAlignmentComma(this.getAlignComma());
        sQLForm.setAlignmentComment(this.getAlignComment());
        sQLForm.setAlignmentConcat(this.getAlignConcat());
        sQLForm.setAlignmentDeclaration(this.getAlignDecl());
        sQLForm.setAlignmentKeyword(this.getAlignKeyword());
        sQLForm.setSuppressComment(this.getSuppressComment());
        sQLForm.setSuppressLinebreak(false);
        sQLForm.setReplaceComment(this.getReplaceComment());
        sQLForm.setSuppressEmptyLine(this.getMoreNewlines(), this.getPreserveNewlines());
        int n6 = this.getBracketSpacing();
        if (n6 == 0) {
            sQLForm.setBracketSpaces("unchangedSpaceInsideBracket");
        }
        if (n6 == 1) {
            sQLForm.setBracketSpaces("noSpacesAroundBracket");
        }
        if (n6 == 2) {
            sQLForm.setBracketSpaces("oneSpaceInsideBracket");
        }
        if (n6 == 3) {
            sQLForm.setBracketSpaces("oneSpaceOutsideBracket");
        }
        if (n6 == 4) {
            sQLForm.setBracketSpaces("oneSpaceAroundBracket");
        }
        if ((n2 = this.getCommaSpacing()) == 0) {
            sQLForm.setCommaSpaces("unchangedSpaceComma");
        }
        if (n2 == 1) {
            sQLForm.setCommaSpaces("noSpacesAroundComma");
        }
        if (n2 == 3) {
            sQLForm.setCommaSpaces("oneSpaceAfterComma");
        }
        if (n2 == 2) {
            sQLForm.setCommaSpaces("oneSpaceBeforeComma");
        }
        if (n2 == 4) {
            sQLForm.setCommaSpaces("oneSpaceAroundComma");
        }
        if ((n = this.getOperatorSpacing()) == 0) {
            sQLForm.setEqualSpaces("unchangedSpaceEqual");
        }
        if (n == 1) {
            sQLForm.setEqualSpaces("noSpacesAroundEqual");
        }
        if (n == 2) {
            sQLForm.setEqualSpaces("oneSpaceAroundEqual");
        }
        if ((n5 = this.getSmallSql()) < 0) {
            n5 = 80;
        }
        sQLForm.setSmallSQLWidth(n5);
        String string6 = sQLForm.formatSQLAsString(string);
        return string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object copyTo(Object object) {
        if (object == null) {
            object = new CodingStyleSQLProfile();
        }
        CodingStyleSQLProfile codingStyleSQLProfile = (CodingStyleSQLProfile)object;
        try {
            codingStyleSQLProfile.disableEvents();
            Object object2 = super.copyTo(object);
            return object2;
        }
        finally {
            codingStyleSQLProfile.enableEvents();
            codingStyleSQLProfile.fireOptionsChanged();
        }
    }

    private void disableEvents() {
        this.disableEvents = true;
    }

    private void enableEvents() {
        this.disableEvents = false;
    }

    private void fireOptionsChanged() {
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            CodingStyleSQLOptionsListener codingStyleSQLOptionsListener = (CodingStyleSQLOptionsListener)objectArray[i];
            codingStyleSQLOptionsListener.optionsChanged(this);
        }
    }

    private class ChangeListener
    extends StructureChangeListener {
        private ChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            if (!CodingStyleSQLProfile.this.disableEvents) {
                CodingStyleSQLProfile.this.fireOptionsChanged();
            }
        }
    }
}

