/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.RepaintManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.raptor.ISQLEditor;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.editors.ActiveViewStatusChanger;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.net.DBRecognizer;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.status.StatusEditorAddin;
import oracle.dbtools.raptor.utils.ClosedConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.IdeLogImpl;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.dbtools.util.CheckThreadViolationRepaintManager;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.EventDispatchThreadHangMonitor;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.Recognizer;
import oracle.ide.view.ActiveViewListener;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.editor.EditorProperties;
import oracle.jdbc.OracleConnection;

public class RaptorDBAddin
implements Addin {
    private static ISQLEditor m_iSqlEditor;
    private static boolean m_autoCommitWorking;

    public void initialize() {
        UIDefaults uIDefaults;
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new StatusEditorAddin());
        this.initNavigator();
        Recognizer.registerLowPriorityRecognizer((Recognizer)new DBRecognizer());
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)new ActiveViewStatusChanger());
        boolean bl = false;
        if (bl) {
            uIDefaults = UIManager.getLookAndFeelDefaults();
            uIDefaults.put("ProgressBarUI", "oracle.javatools.ui.plaf.theme.ThemedProgressBarUI");
            uIDefaults.put("TabbedPaneUI", "oracle.javatools.ui.plaf.theme.ThemedTabbedPaneUI");
            uIDefaults.put("ButtonUI", "oracle.javatools.ui.plaf.theme.ThemedButtonUI");
            uIDefaults.put("ToggleButtonUI", "oracle.javatools.ui.plaf.theme.ThemedToggleButtonUI");
        }
        Log.setLogImpl((Log.ILog)new IdeLogImpl());
        if (Debug.isDebugBuild() && RaptorExtensionConstants.isStandAlone()) {
            long l = -1L;
            String[] stringArray = Ide.getIdeArgs().getArgs();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("detect-hangs")) {
                    if (i >= stringArray.length) continue;
                    String string = stringArray[i + 1];
                    l = Long.valueOf(string);
                    continue;
                }
                if (!stringArray[i].equals("check-EDT-rule")) continue;
                RepaintManager.setCurrentManager((RepaintManager)new CheckThreadViolationRepaintManager());
            }
            if (l > -1L) {
                EventDispatchThreadHangMonitor.UNREASONABLE_DISPATCH_DURATION_MS = l;
                EventDispatchThreadHangMonitor.initMonitoring();
                EventDispatchThreadHangMonitor.INSTANCE.haveShownSomeComponent = true;
            }
        }
        uIDefaults = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)uIDefaults);
        this.initializeFormatter(dBConfig);
        SQLExceptionListenerRegistry.addListener((SQLExceptionListener)new ClosedConnectionListener());
        NLSProvider.setNLSSupplier((INLSSupplier)new INLSSupplier(){

            public DefaultNLSProvider getNLSProvider(Connection connection) {
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }

            public DefaultNLSProvider getNLSProvider(String string) {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }
        });
    }

    private void initializeFormatter(DBConfig dBConfig) {
        if (RaptorExtensionConstants.isStandAlone()) {
            int n = dBConfig.getInt("INDENT_CACHE_NUMBER");
            boolean bl = false;
            if (n == -1) {
                SQLFormatter.getInstance();
                bl = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions().getUseTab();
                n = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions().getNumSpaces();
                dBConfig.putBoolean("INDENT_CACHE_USE_TAB", bl);
                dBConfig.putInt("INDENT_CACHE_NUMBER", n);
            } else {
                bl = dBConfig.getBoolean("INDENT_CACHE_USE_TAB");
            }
            EditorProperties editorProperties = EditorProperties.getProperties();
            editorProperties.putIntegerProperty("indent-size", n);
            editorProperties.putBooleanProperty("use-tabs", bl);
            editorProperties.putIntegerProperty("tab-size", n);
        } else {
            SQLFormatter.getInstance();
        }
    }

    private void initNavigator() {
        IdeProperties ideProperties = Ide.getIdeProperties();
        ideProperties.setProperty("TreeAutoExpander.Enabled", Boolean.toString(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionPanel(String string) {
        URL uRL = RaptorDBAddin.class.getClassLoader().getResource(string);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                ++n;
                if (string2.length() <= 0) continue;
                int n2 = string2.indexOf(61);
                if (n2 < 0) {
                    throw new RuntimeException("Invalid INI file format at line " + n + " -- Expected key=value found " + string2);
                }
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1, string2.length()).trim();
                Class<IConnectionPanel> clazz = null;
                try {
                    clazz = Class.forName(string4).asSubclass(IConnectionPanel.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
                }
                ConnectionTypeRegistry.registerConnectionType(string3, clazz, null);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public static synchronized void registerSqlOpener(ISQLEditor iSQLEditor) {
        m_iSqlEditor = iSQLEditor;
    }

    public static ISQLEditor getSqlOpener() {
        return m_iSqlEditor;
    }

    public static void setAutoCommit(final boolean bl) {
        if (!m_autoCommitWorking) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("RaptorDBAddin.0"), true, IRaptorTaskRunMode.TASKVIEWER){

                protected Void doWork() throws TaskException {
                    m_autoCommitWorking = true;
                    OracleDatabaseFactory.setDefaultAutocommit((boolean)bl);
                    Connections connections = Connections.getInstance();
                    for (String string : connections.getConnNames()) {
                        try {
                            Connection connection;
                            ConnectionTypeDetails connectionTypeDetails;
                            if (!connections.isConnectionOpen(string) || (connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(string, connection = connections.getConnection(string))) == null || !connectionTypeDetails.isSupportsAutocommit()) continue;
                            int n = ((OracleConnection)connection).getDefaultRowPrefetch();
                            int n2 = DBConfig.getInstance().getInt("ARRAYFETCHSIZE");
                            if (Connections.getInstance().isOracle(string) && n != n2) {
                                ((OracleConnection)connection).setDefaultRowPrefetch(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
                            }
                            if (connection.getAutoCommit() == bl) continue;
                            connection.setAutoCommit(bl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_autoCommitWorking = false;
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }
}

