/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex;

import java.awt.Component;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.view.View;

public class ApexImporterContextMenu
implements ContextMenuListener,
Controller {
    public static final String APEX_IMPORT_CMD = "DatabaseNavigator.APEX_IMPORT_CMD";
    public static final int APEX_IMPORT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.APEX_IMPORT_CMD");
    public static final IdeAction APEX_IMPORT = IdeAction.find((int)APEX_IMPORT_CMD_ID);
    public static final String APEX_DEPLOY_CMD = "DatabaseNavigator.APEX_DEPLOY_CMD";
    public static final int APEX_DEPLOY_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.APEX_DEPLOY_CMD");
    public static final IdeAction APEX_DEPLOY = IdeAction.find((int)APEX_DEPLOY_CMD_ID);
    private boolean m_init;

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        String string;
        Element element;
        DBObject dBObject;
        String string2;
        Context context = contextMenu.getContext();
        if (context.getSelection().length == 0) {
            return;
        }
        if (!this.m_init) {
            APEX_IMPORT.addController((Controller)this);
            APEX_DEPLOY.addController((Controller)this);
            this.m_init = true;
        }
        if ((string2 = (dBObject = new DBObject(element = context.getSelection()[0])).getObjectFolderType()) != null && string2.toLowerCase().equals("apex")) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)APEX_IMPORT, 0.1f));
        }
        if ((string = dBObject.getObjectType()) != null && string.equals("APEX")) {
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)APEX_DEPLOY, 0.11f));
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == APEX_IMPORT_CMD_ID) {
            ApexImporter.showWizard(context);
            this.refreshNode(context);
            this.refreshParent(context);
            return true;
        }
        if (ideAction.getCommandId() == APEX_DEPLOY_CMD_ID) {
            ApexImporter.showDeployWizard(context);
            return true;
        }
        return false;
    }

    private void refreshNode(Context context) {
        View view;
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
        if (navigatorTreeNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            NavigatorTree navigatorTree = ((NavigatorWindow)view).getTree();
            navigatorTree.refresh(navigatorTreeNode);
        }
    }

    private void refreshParent(Context context) {
        View view;
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
        if (navigatorTreeNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            NavigatorTree navigatorTree = ((NavigatorWindow)view).getTree();
            navigatorTreeNode = navigatorTreeNode.findAncestorTreeNode(ObjectFolder.class, false);
            navigatorTree.refresh(navigatorTreeNode);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }
}

