/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class ApexImportIDPanel
extends DefaultTraversablePanel {
    private JComboBox _workspaces;
    private JComboBox _run;
    private JComboBox _id;
    private Map<String, String> _info;
    private String _filename;
    private GridBagConstraints _gbc;
    private JTextField _newId;
    private JTextField _newName;
    private JTextField _newAlias;
    private int _availId = -1;
    private JCheckBox _overwrite;
    private JLabel _appName;
    private String _username;
    private ApexImporter.ScriptStatus _scriptStatus;
    private JCheckBox _runScript;
    private List<Map<String, ?>> _workspaceList;
    private boolean _forward = true;
    private boolean _dirty = false;

    public ApexImportIDPanel() {
        this.setDefaultTitle(ApexImportArb.getString("ID_TITLE"));
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        final TraversableContext traversableContext2 = traversableContext;
        this._forward = traversableContext.getDirection() == 1;
        Context context = (Context)traversableContext2.get("CONTEXT");
        DBObject dBObject = (DBObject)context.getProperty("DB_OBJECT");
        final HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("APEX_DBO", dBObject);
        hashMap.put("p_id", traversableContext2.get("p_id"));
        hashMap.put("APEX_FROM_DEPLOY", traversableContext2.get("APEX_FROM_DEPLOY"));
        hashMap.put("connection", traversableContext2.get("connection"));
        hashMap.put("FILENAME", traversableContext.get("FILENAME"));
        hashMap.put("SCRIPT.ENCODING", traversableContext.get("SCRIPT.ENCODING"));
        hashMap.put("SCRIPT.STATUS", (Object)this._scriptStatus);
        hashMap.put("APEX_INFO", this._info);
        hashMap.put("APEX_AVAILID", this._availId);
        hashMap.put("APEX_WORKSPACELIST", this._workspaceList);
        hashMap.put("SEL", traversableContext.get("SEL"));
        hashMap.put("APEX_LOCKCONNNAME", dBObject.getConnectionName());
        final DatabaseQueryTask<String> databaseQueryTask = new DatabaseQueryTask<String>(ApexImportArb.getString("ID_TITLE"), IRaptorTaskRunMode.MODAL, false, true){
            private String connName;
            {
                super(string, iRaptorTaskRunMode, bl, bl2);
                this.connName = (String)hashMap.get("APEX_LOCKCONNNAME");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doWork() throws TaskException {
                String string = null;
                try {
                    String string2;
                    Connection connection = null;
                    Connection connection2 = null;
                    int n = (Integer)hashMap.get("APEX_AVAILID");
                    List list = (List)hashMap.get("APEX_WORKSPACELIST");
                    Map<String, String> map = (Map<String, String>)hashMap.get("APEX_INFO");
                    DBObject dBObject = (DBObject)hashMap.get("APEX_DBO");
                    Connection connection3 = Connections.getInstance().getConnection(dBObject.getConnectionName());
                    if (Connections.getInstance().lock(connection3)) {
                        try {
                            connection = dBObject.getConnection();
                        }
                        finally {
                            Connections.getInstance().unlock(connection3);
                        }
                    }
                    if (hashMap.get("APEX_FROM_DEPLOY") != null && ((Boolean)hashMap.get("APEX_FROM_DEPLOY")).booleanValue()) {
                        if (Connections.getInstance().lock(connection3)) {
                            try {
                                ApexImporter.saveToFile(dBObject, new File((String)hashMap.get("FILENAME")));
                            }
                            finally {
                                Connections.getInstance().unlock(connection3);
                            }
                        }
                        if (!ApexImporter.validateApexVersion((String)hashMap.get("connection"))) {
                            throw new TraversalException(ApexImportArb.getString("APEX_301_REQUIRED"));
                        }
                        int n2 = Integer.parseInt(DBUtil.getInstance((String)((String)hashMap.get("connection"))).executeReturnOneCol("select count(1) from APEX_WORKSPACE_SCHEMAS ", Collections.emptyList()));
                        if (n2 == 0) {
                            throw new TraversalException(ApexImportArb.getString("NO_WORKSPACE"));
                        }
                    }
                    if (hashMap.get("connection") == null) {
                        connection2 = connection;
                    } else {
                        try {
                            connection2 = Connections.getInstance().getConnection((String)hashMap.get("connection"));
                        }
                        catch (DBException dBException) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                        }
                    }
                    hashMap.put("APEX_USERNAME", null);
                    if (Connections.getInstance().lock(connection2)) {
                        try {
                            String string3 = null;
                            string3 = hashMap.get("connection") == null ? dBObject.getSchemaName() : DBUtil.getInstance((Connection)connection2).executeReturnOneCol("select USER from dual");
                            if (string3 == null || string3 == "") {
                                Logger.getLogger(ApexImportIDPanel.class.getClass().getName()).log(Level.SEVERE, "Schema name not found");
                            }
                            hashMap.put("APEX_USERNAME", string3);
                        }
                        finally {
                            Connections.getInstance().unlock(connection2);
                        }
                    }
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection2);
                    dBUtil.setRaiseError(false);
                    string = dBUtil.executeReturnOneCol("select workspace_id from APEX_WORKSPACE_SCHEMAS ", Collections.emptyList());
                    if (string == null) {
                        throw new TraversalException(ApexImportArb.getString("NO_WORKSPACE"));
                    }
                    list = dBUtil.executeReturnList("select workspace_name from  apex_workspace_schemas ws", null);
                    if (list == null || list.isEmpty()) {
                        throw new TraversalException(ApexImportArb.getString("NO_WORKSPACE"));
                    }
                    if (ApexImportIDPanel.this._filename == null || !ApexImportIDPanel.this._filename.equals(hashMap.get("FILENAME"))) {
                        string2 = (String)hashMap.get("FILENAME");
                        map = ApexImporter.getInfo(string2, (String)hashMap.get("SCRIPT.ENCODING"));
                        ApexImporter.ScriptStatus scriptStatus = ApexImporter.getScriptStatus(string2, (String)hashMap.get("SCRIPT.ENCODING"));
                        hashMap.put("SCRIPT.STATUS", scriptStatus);
                        n = ApexImporter.checkAvail(connection2, Long.parseLong(string), Long.parseLong(map.get("p_id")));
                        map.put("APP_NAME", ApexImporter.getAppName(connection, Long.parseLong(string), Long.parseLong(map.get("p_id"))));
                    }
                    if (!ApexImportIDPanel.this._forward) {
                        ApexImportIDPanel.this.noExceptionClearAppNameAndOverwrite();
                        string2 = (String)hashMap.get("SEL");
                        if (!string2.equals(ApexImportArb.getString("AUTO_NEW_ID"))) {
                            String string4 = (String)hashMap.get("p_id");
                            try {
                                Long.parseLong(string4);
                            }
                            catch (Exception exception) {
                                throw new TraversalException(ApexImportArb.getString("INVALID_ID"));
                            }
                            ApexImportIDPanel.this.validateId(connection2, connection, Long.parseLong(string), Long.parseLong((String)hashMap.get("p_id")));
                        }
                    }
                    hashMap.put("sgid", string);
                    hashMap.put("APEX_INFO", map);
                    hashMap.put("APEX_AVAILID", n);
                    hashMap.put("APEX_WORKSPACELIST", list);
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return string;
            }

            @Override
            public String getQuery() {
                return ApexImportArb.getString("ID_TITLE");
            }

            @Override
            public String getConnectionName() {
                return this.connName;
            }
        };
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup(true, false, null);
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                throwable = throwable2;
                if (throwable instanceof TraversalException) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ((TraversalException)throwable).showMessageDialog((Component)((Object)ApexImportIDPanel.this));
                        }
                    };
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(runnable);
                    } else {
                        runnable.run();
                    }
                } else {
                    ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                }
                this.cleanup(true, false, null);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                try {
                    this.cleanup(false, false, (String)databaseQueryTask.getResult());
                }
                catch (InterruptedException interruptedException) {
                    ExceptionHandler.handleException((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    ExceptionHandler.handleException((Throwable)executionException);
                }
            }

            private void cleanup(final boolean bl, final boolean bl2, final String string) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!bl && !bl2) {
                                traversableContext2.put("sgid", (Object)string);
                                ApexImportIDPanel.this._username = (String)hashMap.get("APEX_USERNAME");
                                ApexImportIDPanel.this._scriptStatus = (ApexImporter.ScriptStatus)((Object)hashMap.get("SCRIPT.STATUS"));
                                ApexImportIDPanel.this._availId = (Integer)hashMap.get("APEX_AVAILID");
                                ApexImportIDPanel.this._workspaceList = (List)hashMap.get("APEX_WORKSPACELIST");
                                traversableContext2.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                                ApexImportIDPanel.this._info = (Map)hashMap.get("APEX_INFO");
                                ApexImportIDPanel.this.onEntryAfterTask(traversableContext2);
                                ApexImportIDPanel.this._dirty = false;
                            } else if (bl) {
                                ApexImportIDPanel.this._dirty = true;
                                ApexImportIDPanel.this.removeAll();
                                ApexImportIDPanel.this.setLayout(new GridBagLayout());
                                ApexImportIDPanel.this.add(new JLabel(ApexImportArb.getString("CANCEL_LABEL")));
                            } else if (bl2) {
                                ApexImportIDPanel.this._dirty = true;
                                ApexImportIDPanel.this.removeAll();
                                ApexImportIDPanel.this.setLayout(new GridBagLayout());
                                traversableContext2.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                                ApexImportIDPanel.this.add(new JLabel(ApexImportArb.getString("BACK_OR_CANCEL_LABEL")));
                            }
                            if (ApexImportIDPanel.this._dirty) {
                                ApexImportIDPanel.this.revalidate();
                                ApexImportIDPanel.this.repaint();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
    }

    public void onEntryAfterTask(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        if (this._filename != null) {
            this._scriptStatus = ApexImporter.getScriptStatus(this._filename, (String)traversableContext.get("SCRIPT.ENCODING"));
        }
        traversableContext.put("SCRIPT.STATUS", (Object)this._scriptStatus);
        if (this._dirty || this._filename == null || !this._filename.equals(traversableContext.get("FILENAME"))) {
            this._filename = (String)traversableContext.get("FILENAME");
            this.removeAll();
            this.init(traversableContext);
            this.setModels();
            if (!this._forward) {
                this._id.setSelectedItem(traversableContext.get("SEL"));
                this._workspaces.setSelectedItem(traversableContext.get("workspace_name"));
                this._run.setSelectedItem(traversableContext.get("p_build_status"));
            }
            this.revalidate();
            this.repaint();
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put("ISOVERWRITE", (Object)this._overwrite.isSelected());
        if (traversableContext.getDirection() == 1) {
            String string = (String)this._id.getSelectedItem();
            traversableContext.put("SEL", (Object)string);
            if (string.equals(ApexImportArb.getString("CUSTOM_ID"))) {
                traversableContext.put("p_id", (Object)this._newId.getText());
                traversableContext.put("offset", (Object)Math.round(Math.random() * Math.pow(10.0, 10.0)));
            } else if (!string.equals(ApexImportArb.getString("AUTO_NEW_ID"))) {
                traversableContext.put("p_id", (Object)this._info.get("p_id"));
                traversableContext.put("offset", (Object)"0");
            }
            if (this._info.get("p_alias").equals(this._newAlias.getText())) {
                traversableContext.put("p_alias", (Object)this._newAlias.getText());
            } else {
                traversableContext.put("p_alias", (Object)this._newAlias.getText());
            }
            traversableContext.put("p_name", (Object)this._newName.getText());
            traversableContext.put("p_build_status", this._run.getSelectedItem());
            traversableContext.put("workspace_name", (Object)this._workspaces.getSelectedItem().toString());
            traversableContext.put("SCRIPT.RUN", (Object)this._runScript.isSelected());
        }
    }

    public void setModels() {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHEMA", this._username);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._workspaceList.size(); ++i) {
            object = this._workspaceList.get(i);
            arrayList.add((String)object.get("WORKSPACE_NAME"));
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(arrayList.toArray(new String[arrayList.size()]));
        defaultComboBoxModel.setSelectedItem(defaultComboBoxModel.getElementAt(0));
        this._workspaces.setModel(defaultComboBoxModel);
        object = new DefaultComboBoxModel();
        ((DefaultComboBoxModel)object).addElement("RUN_ONLY");
        ((DefaultComboBoxModel)object).addElement("RUN_AND_BUILD");
        this._run.setModel(object);
        if (this._info.get("p_build_status").equals("RUN_AND_BUILD")) {
            this._run.setSelectedIndex(1);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement(ApexImportArb.getString("AUTO_NEW_ID"));
        if (this._availId >= 0) {
            defaultComboBoxModel2.addElement(this._info.get("p_id"));
        }
        defaultComboBoxModel2.addElement(ApexImportArb.getString("CUSTOM_ID"));
        this._id.setModel(defaultComboBoxModel2);
    }

    public void addPair(String string, Object object, Component component) {
        ++this._gbc.gridy;
        this.add(new JLabel(string), this._gbc);
        ++this._gbc.gridx;
        if (component == null) {
            this._gbc.gridwidth = 2;
        }
        if (object instanceof String) {
            this.add(new JLabel(object.toString()), this._gbc);
        } else {
            this.add((Component)object, this._gbc);
        }
        ++this._gbc.gridx;
        if (component != null) {
            this.add(component, this._gbc);
        }
        this._gbc.gridwidth = 1;
        this._gbc.gridx = 0;
    }

    public void init(TraversableContext traversableContext) {
        this._gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        this._workspaces = new JComboBox();
        this.addPair(ApexImportArb.getString("WORKSPACE_PROMPT"), this._workspaces, null);
        this.addPair(ApexImportArb.getString("PARSE_AS"), this._username, null);
        this._newName = new JTextField(this._info.get("p_name"));
        this._newName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ApexImportIDPanel.this._newName.setSelectionStart(0);
                ApexImportIDPanel.this._newName.setSelectionEnd(ApexImportIDPanel.this._newName.getText().length());
            }
        });
        this.addPair(ApexImportArb.getString("APP_NAME"), this._info.get("p_name"), this._newName);
        this._newAlias = new JTextField(this._info.get("p_alias"));
        this._newAlias.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ApexImportIDPanel.this._newAlias.setSelectionStart(0);
                ApexImportIDPanel.this._newAlias.setSelectionEnd(ApexImportIDPanel.this._newAlias.getText().length());
            }
        });
        this.addPair(ApexImportArb.getString("ALIAS_NAME"), this._info.get("p_alias"), this._newAlias);
        this._run = new JComboBox();
        this.addPair(ApexImportArb.getString("RUN_OPTIONS"), this._info.get("p_build_status"), this._run);
        this._id = new JComboBox();
        this._newId = new JTextField();
        this._newId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ApexImportIDPanel.this._newId.setSelectionStart(0);
                ApexImportIDPanel.this._newId.setSelectionEnd(ApexImportIDPanel.this._newId.getText().length());
            }
        });
        this._newId.setEnabled(false);
        this.addPair(ApexImportArb.getString("ID_OPTIONS"), this._id, this._newId);
        this._newId.setEnabled(false);
        this._id.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && ApexImportIDPanel.this._id.getSelectedItem().equals(ApexImportArb.getString("CUSTOM_ID"))) {
                    ApexImportIDPanel.this._newId.setEnabled(true);
                } else {
                    ApexImportIDPanel.this._newId.setEnabled(false);
                }
                if (itemEvent.getStateChange() == 1 && ApexImportIDPanel.this._id.getSelectedItem().equals(ApexImportIDPanel.this._info.get("p_id"))) {
                    ApexImportIDPanel.this._overwrite.setEnabled(true);
                } else {
                    ApexImportIDPanel.this._overwrite.setEnabled(false);
                }
            }
        });
        if (this._forward) {
            this._overwrite = new JCheckBox(ApexImportArb.getString("OVERWRITE_ID"));
            this._overwrite.setSelected(false);
            this._overwrite.setEnabled(false);
            String string = this._info.get("APP_NAME");
            if (string == null) {
                string = "";
            }
            this._appName = new JLabel();
            this._appName.setText(string);
            String string2 = this._info.get("p_id");
            if (string2 == null) {
                string2 = "";
            }
            this._newId.setText(string2);
        }
        this.addPair(ApexImportArb.getString("CURRENT_APPLICATION"), this._appName, this._overwrite);
        this._runScript = new JCheckBox(ApexImportArb.getString("RUN_INSTALL"));
        if (this._scriptStatus == ApexImporter.ScriptStatus.NONCONDITIONAL) {
            this.addPair(ApexImportArb.getString("INSTALL_SCRIPT"), ApexImportArb.getString("CONTAINS_INSTALL_SCRIPT"), this._runScript);
        } else if (this._scriptStatus == ApexImporter.ScriptStatus.CONDTIONAL) {
            this.addPair(ApexImportArb.getString("INSTALL_SCRIPT"), ApexImportArb.getString("CONTAINS_CONDITIONAL_INSTALL_SCRIPT"), this._runScript);
        }
    }

    public void noExceptionClearAppNameAndOverwrite() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApexImportIDPanel.this._appName.setText("");
                ApexImportIDPanel.this._overwrite.setEnabled(false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public int validateId(Connection connection, Connection connection2, Long l, Long l2) {
        String string;
        final int n = ApexImporter.checkAvail(connection, l, l2);
        final String string2 = string = ApexImporter.getAppName(connection2, l, l2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (n == 1) {
                    ApexImportIDPanel.this._appName.setText(string2);
                    ApexImportIDPanel.this._overwrite.setEnabled(true);
                } else if (n == 0) {
                    ApexImportIDPanel.this._appName.setText("");
                    ApexImportIDPanel.this._overwrite.setEnabled(false);
                } else {
                    ApexImportIDPanel.this._appName.setText(ApexImportArb.getString("ID_UNAVAIL"));
                    ApexImportIDPanel.this._overwrite.setEnabled(false);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
        return n;
    }
}

