/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.auth.basic;

import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.raptor.cloud.auth.Authentication;
import oracle.dbtools.raptor.cloud.auth.AuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.auth.CloudProtocolException;
import oracle.dbtools.raptor.cloud.connection.Client;
import oracle.dbtools.raptor.cloud.connection.CloudHander;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.rt.json.JSONReader;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;

public class BasicAuthenticationHandler
extends CloudHander<Authentication> {
    private static final String RESPONSE_ERROR_DESCRIPTION = "error_description";
    private static final String RESPONSE_ERROR = "error";
    private static final String MESSAGE = "Expected token {0}, encountered {1}";
    private static final String MESSAGE2 = "Unexpected token {0} encountered";
    private StringBuilder m_builder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<String, String> parseErrorString(HttpResponse httpResponse) {
        String string = null;
        String string2 = null;
        Reader reader = null;
        try {
            reader = Client.createReader(httpResponse);
            Iterator iterator = JSONReader.read((Reader)reader);
            boolean bl = false;
            block20: while (iterator.hasNext()) {
                JSONEvent jSONEvent = (JSONEvent)iterator.next();
                switch (jSONEvent.type()) {
                    case START_OBJECT: {
                        if (bl) break;
                        bl = true;
                        continue block20;
                    }
                    case END_OBJECT: {
                        break;
                    }
                    case PROPERTY_NAME: {
                        if (bl) {
                            String string3 = jSONEvent.propertyName();
                            JSONEvent jSONEvent2 = (JSONEvent)iterator.next();
                            switch (jSONEvent2.type()) {
                                case NULL_VALUE: {
                                    break;
                                }
                                case STRING_VALUE: {
                                    String string4 = jSONEvent2.stringValue();
                                    if (RESPONSE_ERROR.equals(string3)) {
                                        string = string4;
                                        break;
                                    }
                                    if (!RESPONSE_ERROR_DESCRIPTION.equals(string3)) break;
                                    string2 = string4;
                                    break;
                                }
                            }
                            continue block20;
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        Logger.warn(BasicAuthenticationHandler.class, (String)MessageFormat.format("{0}: {1}", string, string2));
        return new Pair(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authentication parseAuthentication(HttpResponse httpResponse) throws IOException {
        Authentication authentication;
        block13: {
            authentication = new Authentication();
            Reader reader = null;
            try {
                this.startLog();
                this.log("JSON document:");
                reader = Client.createReader(httpResponse);
                Iterator iterator = JSONReader.read((Reader)reader);
                boolean bl = false;
                while (iterator.hasNext()) {
                    JSONEvent jSONEvent = (JSONEvent)iterator.next();
                    switch (jSONEvent.type()) {
                        case START_OBJECT: {
                            if (bl) {
                                throw new JSONFormatException(jSONEvent.type());
                            }
                            bl = true;
                            this.log("{\n");
                            break;
                        }
                        case END_OBJECT: {
                            if (!bl) {
                                throw new JSONFormatException(jSONEvent.type());
                            }
                            this.log("\n}");
                            break block13;
                        }
                        case PROPERTY_NAME: {
                            if (bl) {
                                Pair<String, String> pair = this.readProperty(iterator, jSONEvent);
                                authentication.putValue((String)pair.first(), (String)pair.second());
                                break;
                            }
                        }
                        default: {
                            throw new JSONFormatException(jSONEvent.type());
                        }
                    }
                }
            }
            finally {
                this.closeLog();
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return authentication;
    }

    private Pair<String, String> readProperty(Iterator<JSONEvent> iterator, JSONEvent jSONEvent) throws CloudProtocolException {
        String string;
        String string2 = jSONEvent.propertyName();
        JSONEvent jSONEvent2 = iterator.next();
        switch (jSONEvent2.type()) {
            case NULL_VALUE: {
                string = null;
                break;
            }
            case STRING_VALUE: {
                string = jSONEvent2.stringValue();
                break;
            }
            case NUMERIC_VALUE: {
                string = jSONEvent2.numberValue().toString();
                break;
            }
            case BOOLEAN_VALUE: {
                string = Boolean.toString(jSONEvent2.booleanValue());
                break;
            }
            default: {
                throw new JSONFormatException(jSONEvent2.type());
            }
        }
        if (RESPONSE_ERROR.equals(string2)) {
            throw new AuthenticationFailedException(string);
        }
        this.log("\n  <" + string2 + "=" + string + ">");
        return Pair.pair((Object)string2, (Object)string);
    }

    @Override
    protected Authentication handleSuccess(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        return this.parseAuthentication(httpResponse);
    }

    @Override
    protected IOException createInternalServerError(String string, String string2, String string3) {
        return new AuthenticationFailedException(string, string2, string3);
    }

    @Override
    protected Authentication handleError(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        switch (n) {
            case 400: {
                Pair<String, String> pair = BasicAuthenticationHandler.parseErrorString(httpResponse);
                if (pair == null) break;
                throw new AuthenticationFailedException((String)pair.first(), (String)pair.second());
            }
        }
        throw new IOException(statusLine.toString());
    }

    private void startLog() {
        this.m_builder = new StringBuilder();
    }

    private void log(String string) {
        if (this.m_builder != null) {
            this.m_builder.append(string);
        }
    }

    private void closeLog() {
        Logger.fine(AuthenticationEngine.class, (String)this.m_builder.toString());
        this.m_builder = null;
    }

    private static class JSONFormatException
    extends AuthenticationFailedException {
        private static final long serialVersionUID = 1L;

        JSONFormatException(JSONEvent.Type type, JSONEvent jSONEvent) {
            super(MessageFormat.format(BasicAuthenticationHandler.MESSAGE, type, jSONEvent));
        }

        JSONFormatException(JSONEvent.Type type) {
            super(MessageFormat.format(BasicAuthenticationHandler.MESSAGE2, type));
        }

        JSONFormatException(String string) {
            super(string);
        }
    }
}

