/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.auth.basic;

import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.auth.AuthenticationCanceledException;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.auth.basic.AuthenticationPanel;
import oracle.dbtools.raptor.cloud.auth.basic.BasicAuthenticationEngine;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.ide.Ide;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import org.apache.http.HttpEntity;

public class GUIBasicAuthenticationEngine
extends BasicAuthenticationEngine {
    @Override
    protected HttpEntity promptForAuthentication(final CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        char[] cArray = cConnectionInfo.getPassword();
        if (cArray != null && cArray.length > 0) {
            return this.authenticateHeadless(cConnectionInfo);
        }
        Callable<HttpEntity> callable = new Callable<HttpEntity>(){

            @Override
            public HttpEntity call() throws AuthenticationFailedException {
                AuthenticationPanel authenticationPanel = new AuthenticationPanel();
                Namespace namespace = new Namespace();
                namespace.put("AuthenticationConnection", (Object)cConnectionInfo);
                TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), CloudBrowserResources.getString("AUTHENTICATION_TITLE"), (Traversable)authenticationPanel, namespace);
                tDialogLauncher.setPackDialog(true);
                tDialogLauncher.initDialog().setInitialFocus(authenticationPanel.getInitialFocusComponent());
                if (!tDialogLauncher.showDialog()) {
                    throw new AuthenticationCanceledException();
                }
                String string = (String)namespace.get("AuthenticationUsername");
                char[] cArray = (char[])namespace.get("AuthenticationPassword");
                String string2 = new String(cArray);
                return GUIBasicAuthenticationEngine.this.createEntity(string, string2);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                return (HttpEntity)callable.call();
            }
            FutureTask<HttpEntity> futureTask = new FutureTask<HttpEntity>(callable);
            SwingUtilities.invokeAndWait(futureTask);
            return futureTask.get();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof AuthenticationFailedException) {
                throw (AuthenticationFailedException)((Object)throwable);
            }
            throw new AuthenticationFailedException(throwable);
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationFailedException) {
                throw (AuthenticationFailedException)((Object)exception);
            }
            throw new AuthenticationFailedException(exception);
        }
    }
}

