/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import oracle.dbtools.raptor.cloud.connection.CloudHander;
import oracle.dbtools.raptor.cloud.connection.JSONProtocolException;
import oracle.dbtools.rt.json.JSONEvent;
import oracle.dbtools.rt.json.JSONReader;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.util.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;

public abstract class JSONHandler<V>
extends CloudHander<V> {
    private String _entityTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V handleSuccess(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        Header header = httpResponse.getFirstHeader("Content-Type");
        if (header == null) {
            throw new IOException("Missing Content-Type");
        }
        ContentType contentType = ContentType.contentType((CharSequence)header.getValue());
        if (contentType == null || !contentType.matches(new ContentType[]{ContentTypes.JSON})) {
            throw new IOException("Unexpected Content-Type: " + contentType);
        }
        String string = contentType.parameter("charset");
        header = httpResponse.getFirstHeader("ETag");
        if (header != null) {
            this._entityTag = header.getValue();
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        Reader reader = null;
        try {
            Charset charset = null;
            if (string != null) {
                try {
                    charset = Charset.forName(string);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Logger.warn(JSONHandler.class, (String)("Unsupported charset: " + string));
                    charset = Charset.defaultCharset();
                }
            }
            if (charset == null) {
                try {
                    charset = Charset.forName("UTF-8");
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Logger.warn(JSONHandler.class, (String)"Unsupported charset: UTF-8!");
                    charset = Charset.defaultCharset();
                }
            }
            reader = new BufferedReader(new InputStreamReader(httpEntity.getContent(), charset));
            V v = this.build(JSONReader.read((Reader)reader));
            return v;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    protected IOException createInternalServerError(String string, String string2, String string3) {
        return new JSONProtocolException(string, string2, string3);
    }

    @Override
    protected V handleError(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        this.report500Error(httpResponse);
        return null;
    }

    protected abstract V build(Iterator<JSONEvent> var1) throws IOException;

    protected final void throwJSONFormatException(String string, String string2) throws JSONProtocolException {
        throw new JSONProtocolException(string, string2);
    }

    protected void checkJSONElement(Object object, String string) throws JSONProtocolException {
        if (object == null) {
            throw new JSONProtocolException(string);
        }
    }

    protected String getEntityTag() {
        return this._entityTag;
    }
}

