/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.ide.net.URIFactory;
import javax.xml.bind.DatatypeConverter;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

class Storage
extends HashStructureAdapter {
    private static final String KEY = "CLOUD_CONNECTIONS";
    private static final String CONNECTIONS = "ConnectionsList";
    private static final String ROOT = "RootURL";
    private static final String SERVICE_URL = "ServiceURL";
    private static final String USERNAME = "User";
    private static final String PWD = "Password";
    private static final String SFTP_DETAILS = "SftpDetails";
    private static final String SFTP_HOST = "SftpHost";
    private static final String SFTP_PORT = "SftpPort";
    private static final String ENCODING = "UTF-8";

    static Storage getInstance() {
        return new Storage(Storage.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)KEY));
    }

    private Storage(HashStructure hashStructure) {
        super(hashStructure);
    }

    String[] listConnections(String string) {
        HashStructure hashStructure = this.getConnectionsHash(string, false);
        if (hashStructure != null) {
            Set set = hashStructure.keySet();
            return set.toArray(new String[0]);
        }
        return new String[0];
    }

    private HashStructure getConnectionsHash(String string, boolean bl) {
        HashStructure hashStructure = null;
        if (bl) {
            HashStructure hashStructure2 = this._hash.getOrCreateHashStructure(CONNECTIONS);
            hashStructure = hashStructure2.getOrCreateHashStructure(string);
        } else {
            HashStructure hashStructure3 = this._hash.getHashStructure(CONNECTIONS);
            if (hashStructure3 != null) {
                hashStructure = hashStructure3.getHashStructure(string);
            }
        }
        return hashStructure;
    }

    CConnectionInfo getCloudConnection(CConnectionType cConnectionType, String string) {
        HashStructure hashStructure;
        CConnectionInfo cConnectionInfo = null;
        HashStructure hashStructure2 = this.getConnectionsHash(cConnectionType.getType(), false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            HashStructure hashStructure3;
            URI uRI = Storage.toURI(hashStructure.getURL(ROOT));
            URI uRI2 = Storage.toURI(hashStructure.getURL(SERVICE_URL));
            String string2 = hashStructure.getString(USERNAME);
            char[] cArray = null;
            String string3 = hashStructure.getString(PWD);
            if (string3 != null) {
                cArray = Wrapper.INSTANCE.decrypt(string3);
            }
            if ((hashStructure3 = hashStructure.getHashStructure(SFTP_DETAILS)) == null) {
                cConnectionInfo = new CConnectionInfo(string, uRI, uRI2, string2, cArray);
            } else {
                String string4 = hashStructure3.getString(USERNAME);
                String string5 = hashStructure3.getString(SFTP_HOST);
                int n = hashStructure3.getInt(SFTP_PORT);
                char[] cArray2 = null;
                String string6 = hashStructure3.getString(PWD);
                if (string6 != null) {
                    cArray2 = Wrapper.INSTANCE.decrypt(string6);
                }
                CConnectionInfo.SftpInfo sftpInfo = new CConnectionInfo.SftpInfo(string4, cArray2, string5, n);
                cConnectionInfo = new CConnectionInfo(string, uRI, uRI2, string2, cArray, sftpInfo);
            }
        }
        return cConnectionInfo;
    }

    private static URI toURI(URL uRL) {
        return uRL != null ? URIFactory.newURI((URL)uRL) : null;
    }

    private static URL toURL(URI uRI) {
        try {
            return uRI != null ? uRI.toURL() : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    void putCloudConnection(CConnectionType cConnectionType, CConnectionInfo cConnectionInfo) {
        Object object;
        HashStructure hashStructure = this.getConnectionsHash(cConnectionType.getType(), true);
        HashStructure hashStructure2 = HashStructure.newInstance();
        hashStructure2.putURL(ROOT, Storage.toURL(cConnectionInfo.getServerRoot()));
        hashStructure2.putURL(SERVICE_URL, Storage.toURL(cConnectionInfo.getServiceRoot()));
        hashStructure2.putString(USERNAME, cConnectionInfo.getUsername());
        if (cConnectionType.canSavePasswords()) {
            object = cConnectionInfo.getPassword();
            if (object != null) {
                hashStructure2.putString(PWD, Wrapper.INSTANCE.encrypt((char[])object));
            } else {
                hashStructure2.remove(PWD);
            }
        }
        if ((object = (Object)cConnectionInfo.getSftpInfo()) != null) {
            HashStructure hashStructure3 = HashStructure.newInstance();
            hashStructure3.putString(SFTP_HOST, object.getSftpHost());
            hashStructure3.putInt(SFTP_PORT, object.getSftpPort());
            hashStructure3.putString(USERNAME, object.getSftpUser());
            char[] cArray = object.getSftpPass();
            if (cArray != null) {
                hashStructure3.putString(PWD, Wrapper.INSTANCE.encrypt(cArray));
            } else {
                hashStructure3.remove(PWD);
            }
            hashStructure2.putHashStructure(SFTP_DETAILS, hashStructure3);
        }
        hashStructure.putHashStructure(cConnectionInfo.getName(), hashStructure2);
    }

    void removeCloudConnection(String string, String string2) {
        HashStructure hashStructure = this.getConnectionsHash(string, false);
        if (hashStructure != null) {
            hashStructure.remove(string2);
        }
    }

    private static final class Wrapper {
        static final Wrapper INSTANCE;
        private static final int ITERATION_COUNT = 42;
        private Cipher m_encoder;
        private Cipher m_decoder;
        private byte[] salt = new byte[]{5, 19, -103, 66, -109, 114, -24, -83};
        private AlgorithmParameterSpec m_paramSpec;
        private SecretKey key;
        private Charset m_charset;
        private CharsetEncoder m_charEnc;
        private CharsetDecoder m_charDec;

        Wrapper(String string) {
            try {
                PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), this.salt, 42);
                this.key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
                this.m_paramSpec = new PBEParameterSpec(this.salt, 42);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            this.m_charset = Charset.forName(Storage.ENCODING);
        }

        String encrypt(char[] cArray) {
            byte[] byArray = null;
            try {
                if (this.m_encoder == null) {
                    this.m_encoder = Cipher.getInstance(this.key.getAlgorithm());
                    this.m_encoder.init(1, (Key)this.key, this.m_paramSpec);
                }
                if (this.m_charEnc == null) {
                    this.m_charEnc = this.m_charset.newEncoder();
                }
                byte[] byArray2 = this.m_charEnc.encode(CharBuffer.wrap(cArray)).array();
                byArray = this.m_encoder.doFinal(byArray2);
                return DatatypeConverter.printBase64Binary((byte[])byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        char[] decrypt(String string) {
            try {
                if (this.m_decoder == null) {
                    this.m_decoder = Cipher.getInstance(this.key.getAlgorithm());
                    this.m_decoder.init(2, (Key)this.key, this.m_paramSpec);
                }
                byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
                byte[] byArray2 = this.m_decoder.doFinal(byArray);
                if (this.m_charDec == null) {
                    this.m_charDec = this.m_charset.newDecoder();
                }
                CharBuffer charBuffer = this.m_charDec.decode(ByteBuffer.wrap(byArray2));
                return charBuffer.array();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        static {
            HashStructure hashStructure = Preferences.getPreferences().getProperties();
            String string = hashStructure.getString("db.system.id");
            if (string == null) {
                string = UUID.randomUUID().toString();
                hashStructure.putString("db.system.id", string);
            }
            INSTANCE = new Wrapper(string);
        }
    }
}

