/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.ide.net.URIFactory;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.ui.BaseConnectionPanel;
import oracle.dbtools.raptor.cloud.connection.ui.PrivateHostPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.util.Logger;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

public final class CloudConnectionPanel
extends BaseConnectionPanel {
    private static final int DEFAULT_FTP_PORT = 22;
    private static final String DEFAULT_SERVICE_KEY = "_sqldev/";
    public static final String FTP_USERNAME_KEY = "Cloud.FTP.User";
    public static final String FTP_HOST_KEY = "Cloud.FTP.Host";
    public static final String FTP_PORT_KEY = "Cloud.FTP.Port";
    public static final String FTP_PWD_KEY = "Cloud.FTP.Password";
    private JTextField m_svcName = new JTextField();
    private JTextField m_user = new JTextField();
    private JPasswordField m_pwd = new JPasswordField();
    private JButton m_btnAdv = new JButton();
    private JTextField m_ftpHost = new JTextField();
    private WholeNumberField m_ftpPort = new WholeNumberField(5);
    private JTextField m_ftpUser = new JTextField();
    private JPasswordField m_ftpPwd = new JPasswordField();
    private String m_svcKey = "_sqldev/";

    @Override
    public String getCreateTitle() {
        return CloudBrowserResources.getString("NEW_CONN_TITLE");
    }

    @Override
    public String getEditTitle() {
        return CloudBrowserResources.getString("EDIT_CONN_TITLE");
    }

    public String getHelpID() {
        return "f1_cloudconnection_html";
    }

    @Override
    protected CConnectionInfo createConnectionInfo(Namespace namespace) {
        String string = (String)namespace.get("Cloud.ConnectionName");
        URI uRI = (URI)namespace.get("Cloud.Root");
        URI uRI2 = (URI)namespace.get("Cloud.ServiceURI");
        String string2 = (String)namespace.get("Cloud.Username");
        char[] cArray = (char[])namespace.get("Cloud.Password");
        String string3 = (String)namespace.get(FTP_HOST_KEY);
        Number number = (Number)namespace.get(FTP_PORT_KEY);
        int n = number != null ? number.intValue() : -1;
        String string4 = (String)namespace.get(FTP_USERNAME_KEY);
        char[] cArray2 = (char[])namespace.get(FTP_PWD_KEY);
        CConnectionInfo.SftpInfo sftpInfo = new CConnectionInfo.SftpInfo(string4, cArray2, string3, n);
        return new CConnectionInfo(string, uRI, uRI2, string2, cArray, sftpInfo);
    }

    @Override
    protected Namespace createNamespace(CConnectionInfo cConnectionInfo, String[] stringArray) {
        CConnectionInfo.SftpInfo sftpInfo;
        Namespace namespace = super.createNamespace(cConnectionInfo, stringArray);
        if (cConnectionInfo != null && (sftpInfo = cConnectionInfo.getSftpInfo()) != null) {
            namespace.put(FTP_USERNAME_KEY, (Object)sftpInfo.getSftpUser());
            namespace.put(FTP_PWD_KEY, (Object)sftpInfo.getSftpPass());
            namespace.put(FTP_HOST_KEY, (Object)sftpInfo.getSftpHost());
            int n = sftpInfo.getSftpPort();
            Integer n2 = n != -1 ? Integer.valueOf(n) : null;
            namespace.put(FTP_PORT_KEY, (Object)n2);
        }
        return namespace;
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        char[] cArray;
        Number number;
        char[] cArray2;
        super.onEntry(traversableContext);
        String string = (String)traversableContext.get("Cloud.Username");
        if (string != null) {
            this.m_user.setText(string);
        }
        if ((cArray2 = (char[])traversableContext.get("Cloud.Password")) != null && cArray2.length > 0) {
            this.m_pwd.setText(new String(cArray2));
        }
        this.updateServiceName((Namespace)traversableContext);
        String string2 = (String)traversableContext.get(FTP_HOST_KEY);
        if (string2 != null) {
            this.m_ftpHost.setText(string2);
        }
        if ((number = (Number)traversableContext.get(FTP_PORT_KEY)) != null) {
            this.m_ftpPort.setNumber(number);
        } else {
            this.m_ftpPort.setNumber((Number)22);
        }
        String string3 = (String)traversableContext.get(FTP_USERNAME_KEY);
        if (string3 != null) {
            this.m_ftpUser.setText(string3);
        }
        if ((cArray = (char[])traversableContext.get(FTP_PWD_KEY)) != null && cArray.length > 0) {
            this.m_ftpPwd.setText(new String(cArray));
        }
    }

    private void updateServiceName(Namespace namespace) {
        String string = null;
        URI uRI = (URI)namespace.get("Cloud.Root");
        if (uRI != null) {
            String string2;
            string = uRI.toString();
            URI uRI2 = (URI)namespace.get("Cloud.ServiceURI");
            if (uRI2 != null && (string2 = uRI2.getPath()).startsWith(string)) {
                String string3;
                this.m_svcKey = string3 = string2.substring(string.length());
            }
        }
        this.m_svcName.setText(string);
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.m_user.getText().trim();
        if (!ModelUtil.hasLength((String)string)) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_USERNAME"));
        }
        char[] cArray = this.m_pwd.getPassword();
        URI uRI = this.getServiceURI(this.m_svcName.getText());
        if (uRI == null) {
            throw new TraversalException(CloudBrowserResources.getString("NEW_CONN_MISSING_SERVICE_HOME"));
        }
        URI uRI2 = URIFactory.newURI((URI)uRI, (String)this.m_svcKey);
        traversableContext.put(FTP_USERNAME_KEY, (Object)this.m_ftpUser.getText());
        traversableContext.put(FTP_HOST_KEY, (Object)this.m_ftpHost.getText());
        traversableContext.put(FTP_PORT_KEY, (Object)this.m_ftpPort.getNumber());
        traversableContext.put(FTP_PWD_KEY, (Object)this.m_ftpPwd.getPassword());
        traversableContext.put("Cloud.Username", (Object)string);
        traversableContext.put("Cloud.Password", (Object)cArray);
        traversableContext.put("Cloud.Root", (Object)uRI);
        traversableContext.put("Cloud.ServiceURI", (Object)uRI2);
        super.onExit(traversableContext);
    }

    @Override
    protected final Component createComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_name, (String)CloudBrowserResources.getString("NEW_CONN_NAME"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)this.m_name, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_user, (String)CloudBrowserResources.getString("NEW_CONN_USERNAME"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel2.add((Component)this.m_user, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_pwd, (String)CloudBrowserResources.getString("NEW_CONN_PASSWORD"));
        this.m_pwd.setToolTipText(CloudBrowserResources.getString("AUTHENTICATION_PWD_TOOLTIP"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.m_pwd, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ++n;
        JComponent jComponent = new JLabel();
        ResourceUtils.resLabel((JLabel)jComponent, (Component)this.m_svcName, (String)CloudBrowserResources.getString("NEW_PUBLIC_CONN_SERVICE"));
        this.m_svcName.setColumns(30);
        this.m_btnAdv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudConnectionPanel.this.runAdvanced();
            }
        });
        ResourceUtils.resButton((AbstractButton)this.m_btnAdv, (String)CloudBrowserResources.getString("NEW_PUBLIC_CONN_ADVANCED"));
        jPanel2.add((Component)jComponent, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.m_svcName, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jPanel2.add((Component)this.m_btnAdv, LayoutControl.GBC.gbc(1, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.LAST_LINE_END));
        JPanel jPanel3 = LayoutControl.GBC.createTitledSubPanel(CloudBrowserResources.getString("NEW_PUBLIC_DB_LABEL"), jPanel2);
        jPanel.add((Component)jPanel3, LayoutControl.GBC.gbc(0, 1, 2, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.X, LayoutControl.GBC.Anchor.CENTER));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        int n2 = 0;
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_ftpUser, (String)CloudBrowserResources.getString("NEW_PUBLIC_FTP_USERNAME"));
        jPanel4.add((Component)jLabel, LayoutControl.GBC.gbc(0, n2, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel4.add((Component)this.m_ftpUser, LayoutControl.GBC.gbc(1, n2, 3, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_ftpPwd, (String)CloudBrowserResources.getString("NEW_PUBLIC_FTP_PASSWORD"));
        this.m_ftpPwd.setToolTipText(CloudBrowserResources.getString("AUTHENTICATION_PWD_TOOLTIP"));
        jPanel4.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel4.add((Component)this.m_ftpPwd, LayoutControl.GBC.gbc(1, n2, 3, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_ftpHost, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_HOSTNAME"));
        jPanel4.add((Component)jLabel, LayoutControl.GBC.gbc(0, ++n2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel4.add((Component)this.m_ftpHost, LayoutControl.GBC.gbc(1, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_ftpPort, (String)CloudBrowserResources.getString("NEW_PRIVATE_CONN_PORT"));
        jPanel4.add((Component)jLabel, LayoutControl.GBC.gbc(2, n2, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        jPanel4.add((Component)this.m_ftpPort, LayoutControl.GBC.gbc(3, n2, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jComponent = LayoutControl.GBC.createTitledSubPanel(CloudBrowserResources.getString("NEW_PUBLIC_FTP_LABEL"), jPanel4);
        jPanel.add((Component)jComponent, LayoutControl.GBC.gbc(0, 2, 2, 1, LayoutControl.GBC.Inset.NONE, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.X, LayoutControl.GBC.Anchor.CENTER));
        LayoutControl.GBC.addVSpring(jPanel, 1);
        return jPanel;
    }

    private URI getServiceURI(String string) {
        String string2;
        if (string != null && (string2 = string.trim()).length() > 0) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            try {
                return URIFactory.newURI((String)string2);
            }
            catch (Exception exception) {
                Logger.warn(CloudConnectionPanel.class, (Throwable)exception);
            }
        }
        return null;
    }

    private void runAdvanced() {
        Namespace namespace = new Namespace();
        URI uRI = this.getServiceURI(this.m_svcName.getText());
        URI uRI2 = uRI != null ? URIFactory.newURI((URI)uRI, (String)this.m_svcKey) : null;
        namespace.put("Cloud.Root", (Object)uRI);
        namespace.put("Cloud.ServiceURI", (Object)uRI2);
        PrivateHostPanel privateHostPanel = new PrivateHostPanel();
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)this.m_btnAdv, CloudBrowserResources.getString("NEW_PUBLIC_CONN_ADV_DIALOG"), (Traversable)privateHostPanel, namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog().setInitialFocus(privateHostPanel.getInitialFocusComponent());
        if (tDialogLauncher.showDialog()) {
            this.updateServiceName(namespace);
        }
    }
}

