/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.controls;

import java.awt.Component;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.ui.ConnectionEditor;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.util.SwingUtils;

public class CloudConnectionSelector
extends ConnectionPanelUI {
    private static final String LAST_CONN_KEY = "CloudConnectionSelector.LAST_CONNECTION";
    private final CConnectionType m_type;

    public CloudConnectionSelector(CConnectionType cConnectionType) {
        super(false, false, null);
        this.m_type = cConnectionType;
        this.resetConnections();
    }

    @Override
    protected String[] listConnections() {
        return CConnections.getInstance(this.m_type).listConnections();
    }

    @Override
    protected void checkConnection() {
        String string = this.getConnectionName();
        if (CConnections.getInstance(this.m_type).getConnectionInfo(string) != null) {
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
    }

    @Override
    protected String getSettingsKey() {
        return LAST_CONN_KEY;
    }

    @Override
    protected String runConnectionDialog(String string) {
        ConnectionEditor connectionEditor = ConnectionEditor.getInstance();
        return string != null ? connectionEditor.editConnection(string, this.m_type) : connectionEditor.createConnection(this.m_type);
    }

    public static String getConnection(String string, String string2, String string3, CConnectionType cConnectionType) {
        CloudConnectionSelector cloudConnectionSelector = new CloudConnectionSelector(cConnectionType){
            private JEWTDialog m_dlg;

            private JEWTDialog getParentDialog() {
                if (this.m_dlg == null) {
                    this.m_dlg = (JEWTDialog)SwingUtils.getAncestorDialog((Component)this);
                }
                return this.m_dlg;
            }

            @Override
            public boolean setConnectionName(String string) {
                if (super.setConnectionName(string)) {
                    JEWTDialog jEWTDialog = this.getParentDialog();
                    if (jEWTDialog != null) {
                        jEWTDialog.setOKButtonEnabled(string != null);
                    }
                    return true;
                }
                return false;
            }
        };
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)cloudConnectionSelector, (Component)cloudConnectionSelector.getDefaultFocusComponent(), (String)string);
        jEWTDialog.setOKButtonEnabled(cloudConnectionSelector.getConnectionCount() > 0);
        cloudConnectionSelector.setConnectionPrompt(string2);
        String string4 = null;
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            string4 = cloudConnectionSelector.getConnectionName();
        }
        return string4;
    }
}

