/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;

public final class EditorOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkBox_autopinEditors;
    private WholeNumberField maxOpenEditors;
    private JLabel maxEditorsLabel;
    private JCheckBox checkBox_readOnlyEditors;
    private JCheckBox checkBox_linkDbAndFileSources;
    private JCheckBox checkBox_autoIndent;
    private JCheckBox checkBox_useBlockOnSelection;
    private JCheckBox checkBox_useJumpScroll;
    private JCheckBox checkBox_useSmartHome;
    private JCheckBox checkBox_useSmartEnd;
    private JCheckBox checkBox_useCaseForWord;
    private JCheckBox checkBox_cutCopyLine;
    private JCheckBox checkBox_importsCopyPaste;
    private JCheckBox checkBox_indentCopyPaste;
    private JCheckBox checkBox_reformatCopyPaste;
    private JCheckBox checkBox_escapeStringPaste;
    private JCheckBox checkBox_supportedGutterNavigation;
    private JCheckBox checkBox_supportedQuickDocumentation;
    private JCheckBox checkBox_supportedSyncSpecAndBody;
    private JCheckBox checkBox_supportedTestQuery;

    public EditorOptionsPanel() {
        this.setHelpID("f1_idedideseteditor_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        EditorOptions editorOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(editorOptions);
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        Boolean bl = dBConfig.getBoolean("AUTOPINPLSQLEDITORS");
        this.checkBox_autopinEditors.setSelected(bl);
        int n = dBConfig.getInt("MAXOPENPLSQLEDITORS");
        this.maxOpenEditors.setValue(n);
        this.maxOpenEditors.setEnabled(this.checkBox_autopinEditors.isSelected());
        this.maxEditorsLabel.setEnabled(this.checkBox_autopinEditors.isSelected());
        this.checkBox_readOnlyEditors.setSelected(dBConfig.getBoolean("READONLYSQLEDITORS"));
        this.checkBox_linkDbAndFileSources.setSelected(dBConfig.getBoolean("LINKDBWITHFILESOURCES"));
        this.checkBox_supportedGutterNavigation.setSelected(dBConfig.getBoolean("SUPPORTEDGUTTERNAVIGATION"));
        this.checkBox_supportedQuickDocumentation.setSelected(dBConfig.getBoolean("SUPPORTEDQUICKDOCUMENTATION"));
        this.checkBox_supportedSyncSpecAndBody.setSelected(dBConfig.getBoolean("SUPPORTEDSYNKSPECANDBODY"));
        this.checkBox_supportedTestQuery.setSelected(dBConfig.getBoolean("SUPPORTEDTESTQUERY"));
    }

    public void onExit(TraversableContext traversableContext) {
        EditorOptions editorOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(editorOptions);
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("AUTOPINPLSQLEDITORS", this.checkBox_autopinEditors.isSelected());
        dBConfig.putInt("MAXOPENPLSQLEDITORS", this.maxOpenEditors.getValue());
        dBConfig.putBoolean("READONLYSQLEDITORS", this.checkBox_readOnlyEditors.isSelected());
        dBConfig.putBoolean("LINKDBWITHFILESOURCES", this.checkBox_linkDbAndFileSources.isSelected());
        dBConfig.putBoolean("SUPPORTEDGUTTERNAVIGATION", this.checkBox_supportedGutterNavigation.isSelected());
        dBConfig.putBoolean("SUPPORTEDQUICKDOCUMENTATION", this.checkBox_supportedQuickDocumentation.isSelected());
        dBConfig.putBoolean("SUPPORTEDSYNKSPECANDBODY", this.checkBox_supportedSyncSpecAndBody.isSelected());
        dBConfig.putBoolean("SUPPORTEDTESTQUERY", this.checkBox_supportedTestQuery.isSelected());
    }

    private EditorOptions findOptions(TraversableContext traversableContext) {
        return EditorOptions.getInstance((PropertyStorage)traversableContext.getPropertyStorage());
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        EditorOptions editorOptions = this.findOptions(traversableContext);
        EditorOptionsPanel.applyOptions(editorOptions);
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("AUTOPINPLSQLEDITORS", this.checkBox_autopinEditors.isSelected());
        dBConfig.putInt("MAXOPENPLSQLEDITORS", this.maxOpenEditors.getValue());
        dBConfig.putBoolean("READONLYSQLEDITORS", this.checkBox_readOnlyEditors.isSelected());
        dBConfig.putBoolean("LINKDBWITHFILESOURCES", this.checkBox_linkDbAndFileSources.isSelected());
        dBConfig.putBoolean("SUPPORTEDGUTTERNAVIGATION", this.checkBox_supportedGutterNavigation.isSelected());
        dBConfig.putBoolean("SUPPORTEDQUICKDOCUMENTATION", this.checkBox_supportedQuickDocumentation.isSelected());
        dBConfig.putBoolean("SUPPORTEDSYNKSPECANDBODY", this.checkBox_supportedSyncSpecAndBody.isSelected());
        dBConfig.putBoolean("SUPPORTEDTESTQUERY", this.checkBox_supportedTestQuery.isSelected());
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(EditorOptions editorOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = editorOptions.getAutoIndent();
        editorProperties.putBooleanProperty("use-auto-indent", bl);
        boolean bl2 = editorOptions.getUseBlockOnSelection();
        editorProperties.putBooleanProperty("do-block-indents-on-selection", bl2);
        boolean bl3 = editorOptions.getUseJumpScroll();
        editorProperties.putBooleanProperty("use-jump-scroll", bl3);
        boolean bl4 = editorOptions.getUseSmartHome();
        editorProperties.putBooleanProperty("use-smart-home", bl4);
        boolean bl5 = editorOptions.getUseSmartEnd();
        editorProperties.putBooleanProperty("use-smart-end", bl5);
        boolean bl6 = editorOptions.getUseCaseDelimitedWord();
        editorProperties.putBooleanProperty("word-boundary-use-case", bl6);
        boolean bl7 = editorOptions.getUseLineStartForWord();
        editorProperties.putBooleanProperty("word-boundary-use-line-start", bl7);
        boolean bl8 = editorOptions.getUseLineEndForWord();
        editorProperties.putBooleanProperty("word-boundary-use-line-end", bl8);
        boolean bl9 = editorOptions.getCutCopyLine();
        editorProperties.putBooleanProperty("cut-copy-line", bl9);
        boolean bl10 = editorOptions.getImportsCopyPaste();
        editorProperties.putBooleanProperty("smart-copy-paste", bl10);
        boolean bl11 = editorOptions.getIndentCopyPaste();
        editorProperties.putBooleanProperty("autoindent-copy-paste", bl11);
        boolean bl12 = editorOptions.getReformatCopyPaste();
        editorProperties.putBooleanProperty("autoreformat-copy-paste", bl12);
        boolean bl13 = editorOptions.getEscapeStringPaste();
        editorProperties.putBooleanProperty("escape-string-paste", bl13);
        boolean bl14 = editorOptions.getReuseUndoEvent();
        editorProperties.putBooleanProperty("reuse-undoable-edit", bl14);
        boolean bl15 = editorOptions.getReuseDocEvent();
        editorProperties.putBooleanProperty("reuse-document-event", bl15);
        boolean bl16 = editorOptions.getUseExpensivePasteChecking();
        editorProperties.putBooleanProperty("check-clipboard-for-paste", bl16);
    }

    void loadSettingsFrom(EditorOptions editorOptions) {
        boolean bl = editorOptions.getAutoIndent();
        boolean bl2 = editorOptions.getUseBlockOnSelection();
        boolean bl3 = editorOptions.getUseJumpScroll();
        boolean bl4 = editorOptions.getUseSmartHome();
        boolean bl5 = editorOptions.getUseSmartEnd();
        boolean bl6 = editorOptions.getUseCaseDelimitedWord();
        boolean bl7 = editorOptions.getCutCopyLine();
        boolean bl8 = editorOptions.getImportsCopyPaste();
        boolean bl9 = editorOptions.getIndentCopyPaste();
        boolean bl10 = editorOptions.getReformatCopyPaste();
        boolean bl11 = editorOptions.getEscapeStringPaste();
        this.checkBox_autoIndent.setSelected(bl);
        this.checkBox_useBlockOnSelection.setSelected(bl2);
        this.checkBox_useJumpScroll.setSelected(bl3);
        this.checkBox_useSmartHome.setSelected(bl4);
        this.checkBox_useSmartEnd.setSelected(bl5);
        this.checkBox_useCaseForWord.setSelected(bl6);
        this.checkBox_cutCopyLine.setSelected(bl7);
        this.checkBox_importsCopyPaste.setSelected(bl8);
        this.checkBox_indentCopyPaste.setSelected(bl9);
        this.checkBox_reformatCopyPaste.setSelected(bl10);
        this.checkBox_escapeStringPaste.setSelected(bl11);
    }

    void saveSettingsTo(EditorOptions editorOptions) {
        boolean bl = this.checkBox_autoIndent.isSelected();
        boolean bl2 = this.checkBox_useBlockOnSelection.isSelected();
        boolean bl3 = this.checkBox_useJumpScroll.isSelected();
        boolean bl4 = this.checkBox_useSmartHome.isSelected();
        boolean bl5 = this.checkBox_useSmartEnd.isSelected();
        boolean bl6 = this.checkBox_useCaseForWord.isSelected();
        boolean bl7 = this.checkBox_cutCopyLine.isSelected();
        boolean bl8 = this.checkBox_importsCopyPaste.isSelected();
        boolean bl9 = this.checkBox_indentCopyPaste.isSelected();
        boolean bl10 = this.checkBox_reformatCopyPaste.isSelected();
        boolean bl11 = this.checkBox_escapeStringPaste.isSelected();
        editorOptions.setAutoIndent(bl);
        editorOptions.setUseBlockOnSelection(bl2);
        editorOptions.setUseJumpScroll(bl3);
        editorOptions.setUseSmartHome(bl4);
        editorOptions.setUseSmartEnd(bl5);
        editorOptions.setUseCaseDelimitedWord(bl6);
        editorOptions.setCutCopyLine(bl7);
        editorOptions.setImportsCopyPaste(bl8);
        editorOptions.setIndentCopyPaste(bl9);
        editorOptions.setReformatCopyPaste(bl10);
        editorOptions.setEscapeStringPaste(bl11);
    }

    private void initializeComponent() {
        String string = Messages.getString("EditorOptionsPanel.1");
        this.checkBox_autopinEditors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_autopinEditors, (String)string);
        this.maxOpenEditors = new WholeNumberField(3);
        this.maxOpenEditors.setHorizontalAlignment(4);
        String string2 = Messages.getString("EditorOptionsPanel.2");
        this.maxEditorsLabel = new JLabel(PreferencesArb.getString("ARRAYFETCHSIZE"));
        ResourceUtils.resLabel((JLabel)this.maxEditorsLabel, (Component)this.maxOpenEditors, (String)string2);
        this.checkBox_autopinEditors.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                EditorOptionsPanel.this.maxOpenEditors.setEnabled(EditorOptionsPanel.this.checkBox_autopinEditors.isSelected());
                EditorOptionsPanel.this.maxEditorsLabel.setEnabled(EditorOptionsPanel.this.checkBox_autopinEditors.isSelected());
            }
        });
        this.checkBox_readOnlyEditors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_readOnlyEditors, (String)Messages.getString("EditorOptionsPanel.3"));
        this.checkBox_linkDbAndFileSources = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_linkDbAndFileSources, (String)Messages.getString("EditorOptionsPanel.linkDbAndFileSources"));
        String string3 = OptionsArb.getString((int)0);
        this.checkBox_autoIndent = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_autoIndent, (String)string3);
        String string4 = OptionsArb.getString((int)2);
        this.checkBox_useBlockOnSelection = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useBlockOnSelection, (String)string4);
        String string5 = OptionsArb.getString((int)3);
        this.checkBox_useJumpScroll = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useJumpScroll, (String)string5);
        String string6 = OptionsArb.getString((int)4);
        this.checkBox_useSmartHome = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useSmartHome, (String)string6);
        String string7 = OptionsArb.getString((int)5);
        this.checkBox_useSmartEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useSmartEnd, (String)string7);
        String string8 = OptionsArb.getString((int)6);
        this.checkBox_useCaseForWord = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_useCaseForWord, (String)string8);
        String string9 = OptionsArb.getString((int)7);
        this.checkBox_cutCopyLine = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_cutCopyLine, (String)string9);
        String string10 = OptionsArb.getString((int)8);
        this.checkBox_importsCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_importsCopyPaste, (String)string10);
        String string11 = OptionsArb.getString((int)9);
        this.checkBox_indentCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_indentCopyPaste, (String)string11);
        String string12 = OptionsArb.getString((int)10);
        this.checkBox_reformatCopyPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_reformatCopyPaste, (String)string12);
        String string13 = OptionsArb.getString((int)11);
        this.checkBox_escapeStringPaste = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_escapeStringPaste, (String)string13);
        this.checkBox_supportedGutterNavigation = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_supportedGutterNavigation, (String)Messages.getString("EditorOptionsPanel.supportedGutterNavigation"));
        this.checkBox_supportedQuickDocumentation = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_supportedQuickDocumentation, (String)Messages.getString("EditorOptionsPanel.supportedQuickDocumentation"));
        this.checkBox_supportedSyncSpecAndBody = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_supportedSyncSpecAndBody, (String)Messages.getString("EditorOptionsPanel.supportedSyncSpecAndBody"));
        this.checkBox_supportedTestQuery = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_supportedTestQuery, (String)Messages.getString("EditorOptionsPanel.supportedTestQuery"));
        Insets insets = new Insets(0, 5, 0, 5);
        Insets insets2 = new Insets(0, 23, 2, 5);
        Insets insets3 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkBox_autopinEditors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.maxEditorsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.maxOpenEditors, gridBagConstraints);
        int n = 0;
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_readOnlyEditors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_linkDbAndFileSources, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_autoIndent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_useBlockOnSelection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_useSmartHome, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_useSmartEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_useJumpScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_useCaseForWord, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_cutCopyLine, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_importsCopyPaste, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_indentCopyPaste, gridBagConstraints);
        boolean bl = Product.isRaptor();
        if (!bl) {
            gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
            this.add(this.checkBox_reformatCopyPaste, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_escapeStringPaste, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_supportedGutterNavigation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_supportedQuickDocumentation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_supportedSyncSpecAndBody, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkBox_supportedTestQuery, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalGlue(), gridBagConstraints);
    }
}

